/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHousePreparedStatement;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TableBasedPreparedStatement
extends ClickHouseStatementImpl
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(TableBasedPreparedStatement.class);
    private static final String ERROR_SET_TABLE = "Please use setObject(ClickHouseExternalTable) method instead";
    private final ClickHouseSqlStatement parsedStmt;
    private final List<String> tables;
    private final ClickHouseExternalTable[] values;
    private final List<List<ClickHouseExternalTable>> batch;

    protected TableBasedPreparedStatement(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, ClickHouseSqlStatement parsedStmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        Set<String> set;
        Set<String> set2 = set = parsedStmt != null ? parsedStmt.getTempTables() : null;
        if (set == null) {
            throw SqlExceptionUtils.clientError("Non-null table list is required");
        }
        this.parsedStmt = parsedStmt;
        int size = set.size();
        this.tables = new ArrayList<String>(size);
        this.tables.addAll(set);
        this.values = new ClickHouseExternalTable[size];
        this.batch = new LinkedList<List<ClickHouseExternalTable>>();
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            list.add(this.tables.get(i));
        }
        if (!list.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format("Missing table(s): %s", list));
        }
    }

    protected String getSql() {
        return this.getRequest().getStatements(false).get(0);
    }

    protected int toArrayIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.values.length) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format("Parameter index must between 1 and %d but we got %d", this.values.length, parameterIndex));
        }
        return parameterIndex - 1;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        ClickHouseSqlStatement stmt = new ClickHouseSqlStatement(this.getSql());
        return this.updateResult(this.parsedStmt, this.executeStatement(stmt, null, Arrays.asList(this.values), null));
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.ensureParams();
        try (ClickHouseResponse r = this.executeStatement(this.getSql(), null, Arrays.asList(this.values), null);){
            this.updateResult(this.parsedStmt, r);
            int n = this.getUpdateCount();
            return n;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        if (!(x instanceof ClickHouseExternalTable)) {
            throw SqlExceptionUtils.clientError("Only ClickHouseExternalTable is allowed");
        }
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx] = (ClickHouseExternalTable)x;
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        ClickHouseSqlStatement stmt = new ClickHouseSqlStatement(this.getSql());
        ClickHouseResponse r = this.executeStatement(stmt, null, Arrays.asList(this.values), null);
        return this.updateResult(this.parsedStmt, r) != null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("addBatch(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        this.ensureParams();
        ArrayList<ClickHouseExternalTable> list = new ArrayList<ClickHouseExternalTable>(this.values.length);
        for (ClickHouseExternalTable v : this.values) {
            list.add(v);
        }
        this.batch.add(Collections.unmodifiableList(list));
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureOpen();
        boolean continueOnError = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        int len = this.batch.size();
        int[] results = new int[len];
        int counter = 0;
        try {
            String sql = this.getSql();
            for (List<ClickHouseExternalTable> list : this.batch) {
                try (ClickHouseResponse r = this.executeStatement(sql, null, list, null);){
                    this.updateResult(this.parsedStmt, r);
                    int rows = this.getUpdateCount();
                    results[counter] = rows > 0 ? rows : 0;
                }
                catch (Exception e) {
                    if (!continueOnError) {
                        throw SqlExceptionUtils.handle(e);
                    }
                    results[counter] = -3;
                    log.error((Object)"Failed to execute batch insert at %d of %d", counter + 1, len, e);
                }
                ++counter;
            }
        }
        finally {
            this.clearBatch();
        }
        return results;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batch.clear();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_TABLE);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }
}

