/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseBoolValue
implements ClickHouseValue {
    private boolean isNull;
    private boolean value;

    public static ClickHouseBoolValue ofNull() {
        return ClickHouseBoolValue.ofNull(null);
    }

    public static ClickHouseBoolValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseBoolValue ? ((ClickHouseBoolValue)ref).set(true, false) : new ClickHouseBoolValue(true, false);
    }

    public static ClickHouseBoolValue of(boolean value) {
        return ClickHouseBoolValue.of(null, value);
    }

    public static ClickHouseBoolValue of(int value) {
        return ClickHouseBoolValue.of(null, value == 1);
    }

    public static ClickHouseBoolValue of(ClickHouseValue ref, boolean value) {
        return ref instanceof ClickHouseBoolValue ? ((ClickHouseBoolValue)ref).set(false, value) : new ClickHouseBoolValue(false, value);
    }

    protected ClickHouseBoolValue(boolean isNull, boolean value) {
        this.set(isNull, value);
    }

    protected ClickHouseBoolValue set(boolean isNull, boolean value) {
        this.isNull = isNull;
        this.value = !isNull && value;
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public ClickHouseBoolValue copy(boolean deep) {
        return new ClickHouseBoolValue(this.isNull, this.value);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return this.value ? (byte)1 : 0;
    }

    @Override
    public short asShort() {
        return this.value ? (short)1 : 0;
    }

    @Override
    public int asInteger() {
        return this.value ? 1 : 0;
    }

    @Override
    public long asLong() {
        return this.value ? 1L : 0L;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : (this.value ? BigInteger.ONE : BigInteger.ZERO);
    }

    @Override
    public float asFloat() {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public double asDouble() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNull ? null : (this.value ? BigDecimal.ONE : BigDecimal.ZERO);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Boolean.valueOf(this.value);
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNull) {
            return null;
        }
        String str = String.valueOf(this.value);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseBoolValue resetToNullOrEmpty() {
        return this.set(true, false);
    }

    @Override
    public String toSqlExpression() {
        return this.isNull ? "NULL" : String.valueOf(this.value ? 1 : 0);
    }

    @Override
    public ClickHouseBoolValue update(char value) {
        return this.set(false, value == '\u0001');
    }

    @Override
    public ClickHouseBoolValue update(byte value) {
        return this.set(false, value == 1);
    }

    @Override
    public ClickHouseBoolValue update(short value) {
        return this.set(false, value == 1);
    }

    @Override
    public ClickHouseBoolValue update(int value) {
        return this.set(false, value == 1);
    }

    @Override
    public ClickHouseBoolValue update(long value) {
        return this.set(false, value == 1L);
    }

    @Override
    public ClickHouseBoolValue update(float value) {
        return this.set(false, value == 1.0f);
    }

    @Override
    public ClickHouseBoolValue update(double value) {
        return this.set(false, value == 1.0);
    }

    @Override
    public ClickHouseBoolValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, BigInteger.ONE.equals(value));
    }

    @Override
    public ClickHouseBoolValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, BigDecimal.ONE.equals(value));
    }

    @Override
    public ClickHouseBoolValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.ordinal() == 1);
    }

    @Override
    public ClickHouseBoolValue update(String value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, Boolean.parseBoolean(value) || "1".equals(value));
    }

    @Override
    public ClickHouseBoolValue update(ClickHouseValue value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.asBoolean());
    }

    @Override
    public ClickHouseBoolValue update(Object value) {
        if (value instanceof Boolean) {
            return this.set(false, (Boolean)value);
        }
        if (value instanceof Number) {
            return this.set(false, ((Number)value).byteValue() == 0);
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asBoolean());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseBoolValue v = (ClickHouseBoolValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + (this.value ? 1231 : 1237);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

