/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.encoding.JsonQueryDataDecoder;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class QueryDataDecoders {
    private static final List<QueryDataDecoder.Factory> decoders = ImmutableList.of(new JsonQueryDataDecoder.Factory(), new JsonQueryDataDecoder.ZstdFactory(), new JsonQueryDataDecoder.Lz4Factory());
    private static final Map<String, QueryDataDecoder.Factory> encodingMap = QueryDataDecoders.factoriesMap();

    private QueryDataDecoders() {
    }

    public static QueryDataDecoder.Factory get(String encodingId) {
        if (!encodingMap.containsKey(encodingId)) {
            throw new IllegalArgumentException("Unknown encoding id: " + encodingId);
        }
        QueryDataDecoder.Factory factory2 = encodingMap.get(encodingId);
        Verify.verify(factory2.encodingId().equals(encodingId), "Factory has wrong encoding id, expected %s, got %s", (Object)encodingId, (Object)factory2.encodingId());
        return factory2;
    }

    private static Map<String, QueryDataDecoder.Factory> factoriesMap() {
        return decoders.stream().collect(ImmutableMap.toImmutableMap(QueryDataDecoder.Factory::encodingId, Function.identity()));
    }
}

