/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.QueryData;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.RawQueryData;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import io.trino.jdbc.$internal.client.spooling.InlineSegment;
import io.trino.jdbc.$internal.client.spooling.Segment;
import io.trino.jdbc.$internal.client.spooling.SegmentLoader;
import io.trino.jdbc.$internal.client.spooling.SpooledSegment;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EncodedQueryData
implements QueryData {
    private final String encodingId;
    private final DataAttributes metadata;
    private final List<Segment> segments;

    @.JsonCreator
    public EncodedQueryData(@.JsonProperty(value="encodingId") String encodingId, @.JsonProperty(value="metadata") Map<String, Object> metadata, @.JsonProperty(value="segments") List<Segment> segments) {
        this(encodingId, new DataAttributes(metadata), segments);
    }

    public EncodedQueryData(String encodingId, DataAttributes metadata, List<Segment> segments) {
        this.encodingId = Objects.requireNonNull(encodingId, "encodingId is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.segments = ImmutableList.copyOf((Collection)Objects.requireNonNull(segments, "segments is null"));
    }

    @.JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    @.JsonProperty(value="encodingId")
    public String getEncodingId() {
        return this.encodingId;
    }

    @.JsonInclude(value=.JsonInclude.Include.NON_EMPTY)
    @.JsonProperty(value="metadata")
    public Map<String, Object> getJsonMetadata() {
        return this.metadata.attributes;
    }

    @.JsonIgnore
    public DataAttributes getMetadata() {
        return this.metadata;
    }

    @Override
    public Iterable<List<Object>> getData() {
        throw new UnsupportedOperationException("EncodedQueryData required decoding via matching QueryDataDecoder");
    }

    public QueryData toRawData(QueryDataDecoder decoder, SegmentLoader segmentLoader) {
        if (!decoder.encodingId().equals(this.encodingId)) {
            throw new IllegalArgumentException(String.format("Invalid decoder supplied, expected %s, got %s", this.encodingId, decoder.encodingId()));
        }
        return RawQueryData.of(Iterables.unmodifiableIterable(Iterables.concat(Iterables.transform(this.segments, segment -> {
            if (segment instanceof InlineSegment) {
                InlineSegment inline = (InlineSegment)segment;
                try {
                    return decoder.decode(new ByteArrayInputStream(inline.getData()), inline.getMetadata());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (segment instanceof SpooledSegment) {
                Iterable<List<Object>> iterable;
                block12: {
                    SpooledSegment spooled = (SpooledSegment)segment;
                    InputStream stream = segmentLoader.load(spooled);
                    try {
                        iterable = decoder.decode(stream, segment.getMetadata());
                        if (stream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    stream.close();
                }
                return iterable;
            }
            throw new IllegalArgumentException("Unexpected segment type: " + segment.getClass().getSimpleName());
        }))));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("encodingId", this.encodingId).add("segments", this.segments).add("metadata", this.metadata.attributes.keySet()).toString();
    }

    public static Builder builder(String format) {
        return new Builder(format);
    }

    public static class Builder {
        private final String encodingId;
        private final ImmutableList.Builder<Segment> segments = ImmutableList.builder();
        private DataAttributes metadata = DataAttributes.empty();

        private Builder(String encodingId) {
            this.encodingId = Objects.requireNonNull(encodingId, "encodingId is null");
        }

        public Builder withSegment(Segment segment) {
            this.segments.add((Object)segment);
            return this;
        }

        public Builder withAttributes(DataAttributes attributes) {
            this.metadata = Objects.requireNonNull(attributes, "attributes is null");
            return this;
        }

        public EncodedQueryData build() {
            return new EncodedQueryData(this.encodingId, this.metadata, (List<Segment>)((Object)this.segments.build()));
        }
    }
}

