/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.common.block.RowBlock;
import com.facebook.presto.jdbc.internal.common.block.SingleRowBlock;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;

public abstract class AbstractRowBlock
implements Block {
    protected final int numFields;

    protected abstract Block[] getRawFieldBlocks();

    protected abstract int[] getFieldBlockOffsets();

    @Override
    public abstract int getOffsetBase();

    @Nullable
    protected abstract boolean[] getRowIsNull();

    protected final int getFieldBlockOffset(int position) {
        return this.getFieldBlockOffsets()[position + this.getOffsetBase()];
    }

    protected AbstractRowBlock(int numFields) {
        if (numFields <= 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        this.numFields = numFields;
    }

    @Override
    public String getEncodingName() {
        return "ROW";
    }

    @Override
    public final Block copyPositions(int[] positions, int offset, int length) {
        int position;
        int i;
        int fieldBlockPositionCount;
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        int[] fieldBlockPositions = new int[length];
        boolean[] newRowIsNull = null;
        if (this.mayHaveNull()) {
            newRowIsNull = new boolean[length];
            fieldBlockPositionCount = 0;
            for (i = 0; i < length; ++i) {
                newOffsets[i] = fieldBlockPositionCount;
                position = positions[offset + i];
                if (this.isNull(position)) {
                    newRowIsNull[i] = true;
                    continue;
                }
                fieldBlockPositions[fieldBlockPositionCount++] = this.getFieldBlockOffset(position);
            }
            newOffsets[length] = fieldBlockPositionCount;
            if (fieldBlockPositionCount == length) {
                newRowIsNull = null;
            }
        } else {
            fieldBlockPositionCount = fieldBlockPositions.length;
            for (i = 0; i < fieldBlockPositions.length; ++i) {
                newOffsets[i] = i;
                position = positions[offset + i];
                this.checkReadablePosition(position);
                fieldBlockPositions[i] = this.getFieldBlockOffset(position);
            }
            newOffsets[fieldBlockPositions.length] = fieldBlockPositions.length;
        }
        Block[] newBlocks = new Block[this.numFields];
        Block[] oldBlocks = this.getRawFieldBlocks();
        for (int i2 = 0; i2 < newBlocks.length; ++i2) {
            newBlocks[i2] = oldBlocks[i2].copyPositions(fieldBlockPositions, 0, fieldBlockPositionCount);
        }
        return RowBlock.createRowBlockInternal(0, length, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return RowBlock.createRowBlockInternal(position + this.getOffsetBase(), length, this.getRowIsNull(), this.getFieldBlockOffsets(), this.getRawFieldBlocks());
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long regionSizeInBytes = 5L * (long)length;
        for (int i = 0; i < this.numFields; ++i) {
            regionSizeInBytes += this.getRawFieldBlocks()[i].getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        return regionSizeInBytes;
    }

    @Override
    public long getRegionLogicalSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long regionLogicalSizeInBytes = 5L * (long)length;
        for (int i = 0; i < this.numFields; ++i) {
            regionLogicalSizeInBytes += this.getRawFieldBlocks()[i].getRegionLogicalSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        return regionLogicalSizeInBytes;
    }

    @Override
    public long getApproximateRegionLogicalSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int fieldBlockLength = this.getFieldBlockOffset(position + length) - startFieldBlockOffset;
        long approximateLogicalSizeInBytes = 5 * length;
        for (int i = 0; i < this.numFields; ++i) {
            approximateLogicalSizeInBytes += this.getRawFieldBlocks()[i].getApproximateRegionLogicalSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        return approximateLogicalSizeInBytes;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        BlockUtil.checkValidPositions(positions, this.getPositionCount());
        int usedPositionCount = 0;
        boolean[] fieldPositions = new boolean[this.getRawFieldBlocks()[0].getPositionCount()];
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            ++usedPositionCount;
            int startFieldBlockOffset = this.getFieldBlockOffset(i);
            int endFieldBlockOffset = this.getFieldBlockOffset(i + 1);
            for (int j = startFieldBlockOffset; j < endFieldBlockOffset; ++j) {
                fieldPositions[j] = true;
            }
        }
        long sizeInBytes = 0L;
        for (int j = 0; j < this.numFields; ++j) {
            sizeInBytes += this.getRawFieldBlocks()[j].getPositionsSizeInBytes(fieldPositions);
        }
        return sizeInBytes + 5L * (long)usedPositionCount;
    }

    @Override
    public Block copyRegion(int position, int length) {
        boolean[] newRowIsNull;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Object[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getRawFieldBlocks()[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        int[] newOffsets = BlockUtil.compactOffsets(this.getFieldBlockOffsets(), position + this.getOffsetBase(), length);
        boolean[] rowIsNull = this.getRowIsNull();
        boolean[] blArray = newRowIsNull = rowIsNull == null ? null : BlockUtil.compactArray(rowIsNull, position + this.getOffsetBase(), length);
        if (BlockUtil.arraySame(newBlocks, this.getRawFieldBlocks()) && newOffsets == this.getFieldBlockOffsets() && newRowIsNull == rowIsNull) {
            return this;
        }
        return RowBlock.createRowBlockInternal(0, length, newRowIsNull, newOffsets, (Block[])newBlocks);
    }

    @Override
    public Block getBlock(int position) {
        this.checkReadablePosition(position);
        return new SingleRowBlock(this.getFieldBlockOffset(position), this.getRawFieldBlocks());
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.appendStructureInternal(this, position);
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            int fieldBlockOffset = this.getFieldBlockOffset(position);
            Block[] fieldBlocks = this.getRawFieldBlocks();
            for (int i = 0; i < this.numFields; ++i) {
                fieldBlocks[i].writePositionTo(fieldBlockOffset, output);
            }
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        this.checkReadablePosition(position);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + 1);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Block[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getRawFieldBlocks()[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        boolean[] newRowIsNull = blArray;
        int[] newOffsets = new int[]{0, fieldBlockLength};
        return RowBlock.createRowBlockInternal(0, 1, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return 0L;
        }
        Block[] rawFieldBlocks = this.getRawFieldBlocks();
        long size = 0L;
        for (int i = 0; i < this.numFields; ++i) {
            size += rawFieldBlocks[i].getEstimatedDataSizeForStats(this.getFieldBlockOffset(position));
        }
        return size;
    }

    @Override
    public boolean mayHaveNull() {
        return this.getRowIsNull() != null;
    }

    protected final void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public Block getBlockUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return new SingleRowBlock(this.getFieldBlockOffsets()[internalPosition], this.getRawFieldBlocks());
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.getRowIsNull()[internalPosition];
    }

    @Override
    public Block appendNull() {
        boolean[] rowIsNull = BlockUtil.appendNullToIsNullArray(this.getRowIsNull(), this.getOffsetBase(), this.getPositionCount());
        int[] offsets = BlockUtil.appendNullToOffsetsArray(this.getFieldBlockOffsets(), this.getOffsetBase(), this.getPositionCount());
        return RowBlock.createRowBlockInternal(this.getOffsetBase(), this.getPositionCount() + 1, rowIsNull, offsets, this.getRawFieldBlocks());
    }
}

