/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.SybConnection;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.utils.LogUtil;
import com.sybase.jdbc4.utils.SybVersion;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybDatabaseMetaData
implements DatabaseMetaData {
    private Logger LOG = Logger.getLogger(SybDatabaseMetaData.class.getName());
    private static int _logIdCounter = 1;
    private AtomicLong _apiCounter = new AtomicLong(0L);
    protected String _logId = null;
    private SybConnection _conn;
    private MdaManager _mda;
    private int _outerJoinEscapeSupport;
    private int _isCaseSensitive;
    private int _dbMajorVersion = -1;
    private int _dbMinorVersion = -1;
    private int _jdbcMajorVersion = -1;
    private int _jdbcMinorVersion = -1;
    protected static final int UNKNOWN = -1;
    protected static final int NO = 0;
    protected static final int YES = 1;
    private static final String JAVA_OBJECT_NAME = "JAVA_OBJECT";
    private static final String STRUCT_NAME = "STRUCT";
    private static final String DISTINCT_NAME = "DISTINCT";
    private static final String TABLES = "TABLES";
    private static final String COLUMNS = "COLUMNS";
    private static final String ALLPROCSCALLABLE = "ALLPROCSCALLABLE";
    private static final String ALLTABLESSELECTABLE = "ALLTABLESSELECTABLE";
    private static final String ISREADONLY = "ISREADONLY";
    private static final String NULLSORTING = "NULLSORTING";
    private static final String USERNAME = "USERNAME";
    private static final String PRODUCTNAME = "PRODUCTNAME";
    private static final String GET_IDENTITY = "GET_IDENTITY";
    private static final String PRODUCTVERSION = "PRODUCTVERSION";
    private static final String FILEUSAGE = "FILEUSAGE";
    private static final String IDENTIFIERCASES = "IDENTIFIERCASES";
    private static final String IDENTIFIERQUOTE = "IDENTIFIERQUOTE";
    private static final String SQLKEYWORDS = "SQLKEYWORDS";
    private static final String NUMERICFUNCTIONLIST = "NUMERICFUNCTIONLIST";
    private static final String STRINGFUNCTIONLIST = "STRINGFUNCTIONLIST";
    private static final String SYSTEMFUNCTIONLIST = "SYSTEMFUNCTIONLIST";
    private static final String TIMEDATEFUNCTIONLIST = "TIMEDATEFUNCTIONLIST";
    private static final String SEARCHSTRING = "SEARCHSTRING";
    private static final String EXTRANAMECHARS = "EXTRANAMECHARS";
    private static final String ALTERTABLESUPPORT = "ALTERTABLESUPPORT";
    private static final String COLUMNALIASING = "COLUMNALIASING";
    private static final String NULLPLUSNONNULL = "NULLPLUSNONNULL";
    private static final String CONVERTSUPPORT = "CONVERTSUPPORT";
    private static final String CONVERTMAP = "CONVERTMAP";
    private static final String CORRELATIONNAMES = "CORRELATIONNAMES";
    private static final String ORDERBYSUPPORT = "ORDERBYSUPPORT";
    private static final String GROUPBYSUPPORT = "GROUPBYSUPPORT";
    private static final String LIKEESCAPECLAUSE = "LIKEESCAPECLAUSE";
    private static final String MULTIPLERESULTSETS = "MULTIPLERESULTSETS";
    private static final String MULTIPLETRANSACTIONS = "MULTIPLETRANSACTIONS";
    private static final String NONNULLABLECOLUMNS = "NONNULLABLECOLUMNS";
    private static final String SQLGRAMMAR = "SQLGRAMMAR";
    private static final String ANSI92LEVEL = "ANSI92LEVEL";
    private static final String INTEGRITYENHANCEMENT = "INTEGRITYENHANCEMENT";
    private static final String OUTERJOINS = "OUTERJOINS";
    private static final String SCHEMATERM = "SCHEMATERM";
    private static final String PROCEDURETERM = "PROCEDURETERM";
    private static final String CATALOGTERM = "CATALOGTERM";
    private static final String CATALOGSEPARATOR = "CATALOGSEPARATOR";
    private static final String CATALOGATSTART = "CATALOGATSTART";
    private static final String SCHEMASUPPORT = "SCHEMASUPPORT";
    private static final String CATALOGSUPPORT = "CATALOGSUPPORT";
    private static final String POSITIONEDDELETE = "POSITIONEDDELETE";
    private static final String POSITIONEDUPDATE = "POSITIONEDUPDATE";
    private static final String SELECTFORUPDATE = "SELECTFORUPDATE";
    private static final String STOREDPROCEDURES = "STOREDPROCEDURES";
    private static final String SUBQUERIES = "SUBQUERIES";
    private static final String UNIONSUPPORT = "UNIONSUPPORT";
    private static final String CURSORTRANSACTIONS = "CURSORTRANSACTIONS";
    private static final String STATEMENTTRANSACTIONS = "STATEMENTTRANSACTIONS";
    private static final String MAXBINARYLITERALLENGTH = "MAXBINARYLITERALLENGTH";
    private static final String MAXCHARLITERALLENGTH = "MAXCHARLITERALLENGTH";
    private static final String COLUMNINFO = "COLUMNINFO";
    private static final String MAXCONNECTIONS = "MAXCONNECTIONS";
    private static final String MAXINDEXLENGTH = "MAXINDEXLENGTH";
    private static final String MAXNAMELENGTHS = "MAXNAMELENGTHS";
    private static final String ROWINFO = "ROWINFO";
    private static final String STATEMENTINFO = "STATEMENTINFO";
    private static final String TABLEINFO = "TABLEINFO";
    private static final String TRANSACTIONSUPPORT = "TRANSACTIONSUPPORT";
    private static final String TRANSACTIONLEVELDEFAULT = "TRANSACTIONLEVELDEFAULT";
    private static final String TRANSACTIONLEVELS = "TRANSACTIONLEVELS";
    private static final String TRANSACTIONDATADEFINFO = "TRANSACTIONDATADEFINFO";
    private static final String PROCEDURES = "PROCEDURES";
    private static final String FUNCTIONS = "FUNCTIONS";
    private static final String PROCEDURECOLUMNS = "PROCEDURECOLUMNS";
    private static final String FUNCTIONCOLUMNS = "FUNCTIONCOLUMNS";
    private static final String SCHEMAS = "SCHEMAS";
    private static final String SCHEMAS_CTS = "SCHEMAS_CTS";
    private static final String CATALOGS = "CATALOGS";
    private static final String CATALOGS_CTS = "CATALOGS_CTS";
    private static final String TABLETYPES = "TABLETYPES";
    private static final String COLUMNPRIVILEGES = "COLUMNPRIVILEGES";
    private static final String TABLEPRIVILEGES = "TABLEPRIVILEGES";
    private static final String ROWIDENTIFIERS = "ROWIDENTIFIERS";
    private static final String VERSIONCOLUMNS = "VERSIONCOLUMNS";
    private static final String PRIMARYKEYS = "PRIMARYKEYS";
    private static final String IMPORTEDKEYS = "IMPORTEDKEYS";
    private static final String EXPORTEDKEYS = "EXPORTEDKEYS";
    private static final String KEYCROSSREFERENCE = "KEYCROSSREFERENCE";
    private static final String TYPEINFO = "TYPEINFO";
    private static final String TYPEINFO_CTS = "TYPEINFO_CTS";
    private static final String INDEXINFO = "INDEXINFO";
    private static final String OWNUPDATESAREVISIBLE = "OWNUPDATESAREVISIBLE";
    private static final String OWNDELETESAREVISIBLE = "OWNDELETESAREVISIBLE";
    private static final String OWNINSERTSAREVISIBLE = "OWNINSERTSAREVISIBLE";
    private static final String OTHERSUPDATESAREVISIBLE = "OTHERSUPDATESAREVISIBLE";
    private static final String OTHERSDELETESAREVISIBLE = "OTHERSDELETESAREVISIBLE";
    private static final String OTHERSINSERTSAREVISIBLE = "OTHERSINSERTSAREVISIBLE";
    private static final String UPDATESAREDETECTED = "UPDATESAREDETECTED";
    private static final String DELETESAREDETECTED = "DELETESAREDETECTED";
    private static final String INSERTSAREDETECTED = "INSERTSAREDETECTED";
    private static final String SUPPORTSBATCHUPDATES = "SUPPORTSBATCHUPDATES";
    private static final String SUPPORTSRESULTSETTYPE = "SUPPORTSRESULTSETTYPE";
    private static final String READONLYCONCURRENCY = "READONLYCONCURRENCY";
    private static final String UPDATABLECONCURRENCY = "UPDATABLECONCURRENCY";
    private static final String UDTS = "UDTS";
    private static final String SUPERTYPES = "SUPERTYPES";
    private static final String SUPERTABLES = "SUPERTABLES";
    private static final String ATTRIBUTES = "ATTRIBUTES";
    private static final String EXECBATCHUPDATESINLOOP = "EXECBATCHUPDATESINLOOP";
    private static final String EXECPARAMETERIZEDBATCHINLOOP = "EXECPARAMETERIZEDBATCHINLOOP";
    private static final String MAXBATCHPARAMS = "MAXBATCHPARAMS";
    private static final String ISCASESENSITIVE = "ISCASESENSITIVE";
    private static final String CLASSFORNAME = "CLASSFORNAME";
    private static final String JARFORCLASS = "JARFORCLASS";
    private static final String JARBYNAME = "JARBYNAME";
    private static final String CLASSESINJAR = "CLASSESINJAR";
    private static final String CANRETURNJARS = "CANRETURNJARS";
    private static final String XACOORDINATORTYPE = "XACOORDINATORTYPE";
    private static final String SAVEPOINTSUPPORT = "SAVEPOINTSUPPORT";
    private static final String JDBCMAJORVERSION = "JDBCMAJORVERSION";
    private static final String JDBCMINORVERSION = "JDBCMINORVERSION";
    public static final String IS_LOGGED_BCP_SUPPORTED = "IS_LOGGED_BCP_SUPPORTED";
    public static final String GETCLIENTINFOPROPERTIES = "GETCLIENTINFOPROPERTIES";
    private int _execBatchInLoop = -1;
    private int _execParameterizedBatchInLoop = -1;
    private int _batchSupport = -1;
    private int _maxParamsPerBatch = -1;
    private Boolean _isFastLoggedBCPSupported = null;

    SybDatabaseMetaData(String string, SybConnection sybConnection) throws SQLException {
        this._logId = string + "_Db" + _logIdCounter++;
        this._conn = sybConnection;
        this._mda = sybConnection.getMDA(null);
        this._outerJoinEscapeSupport = -1;
        this._isCaseSensitive = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ALLPROCSCALLABLE);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "allProceduresAreCallable", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ALLTABLESSELECTABLE);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "allTablesAreSelectable", null, null, l);
            }
        }
    }

    @Override
    public String getURL() throws SQLException {
        return this._conn._url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserName() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(USERNAME);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getUserName", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ISREADONLY);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "isReadOnly", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "nullsAreSortedHigh", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "nullsAreSortedLow", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "nullsAreSortedAtStart", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
            boolean bl2 = this.returnBoolean(preparedStatement, 4);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "nullsAreSortedAtEnd", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseProductName() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            Object object;
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            if (this._conn.getDatabaseProductName() == null) {
                object = this.getMetaDataAccessor(PRODUCTNAME);
                this._conn.setDatabaseProductName(this.returnString((PreparedStatement)object));
            }
            object = this._conn.getDatabaseProductName();
            return object;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getDatabaseProductName", null, null, l);
            }
        }
    }

    public String getIdentityQuery() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GET_IDENTITY);
        return this.returnString(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseProductVersion() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            Object object;
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            if (this._conn.getDatabaseProductVersion() == null) {
                object = this.getMetaDataAccessor(PRODUCTVERSION);
                this._conn.setDatabaseProductVersion(this.returnString((PreparedStatement)object));
            }
            object = this._conn.getDatabaseProductVersion();
            return object;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getDatabaseProductVersion", null, null, l);
            }
        }
    }

    @Override
    public String getDriverName() throws SQLException {
        return "jConnect (TM) for JDBC (TM)";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return SybVersion.VERSION_STRING;
    }

    @Override
    public int getDriverMajorVersion() {
        return SybVersion.MAJOR_VERSION;
    }

    public boolean execBatchUpdatesInLoop() throws SQLException {
        if (this._execBatchInLoop == -1) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(EXECBATCHUPDATESINLOOP);
                this._execBatchInLoop = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._execBatchInLoop = 0;
            }
        }
        return this._execBatchInLoop == 1;
    }

    public boolean execParameterizedBatchUpdatesInLoop() throws SQLException {
        if (this._execParameterizedBatchInLoop == -1) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(EXECPARAMETERIZEDBATCHINLOOP);
                this._execParameterizedBatchInLoop = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._execParameterizedBatchInLoop = 0;
            }
        }
        return this._execParameterizedBatchInLoop == 1;
    }

    protected boolean isFastLoggedBCPSupported() throws SQLException {
        if (this._isFastLoggedBCPSupported == null) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(IS_LOGGED_BCP_SUPPORTED);
                this._isFastLoggedBCPSupported = this.returnBoolean(preparedStatement, 1);
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._isFastLoggedBCPSupported = false;
            }
        }
        return this._isFastLoggedBCPSupported;
    }

    public int getMaxParamsPerBatch() throws SQLException {
        if (this._maxParamsPerBatch == -1) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXBATCHPARAMS);
                this._maxParamsPerBatch = this.returnInt(preparedStatement, 1);
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._maxParamsPerBatch = 255;
            }
        }
        return this._maxParamsPerBatch;
    }

    @Override
    public int getDriverMinorVersion() {
        return SybVersion.MINOR_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean usesLocalFiles() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(FILEUSAGE);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "usesLocalFiles", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(FILEUSAGE);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "usesLocalFilePerTable", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsMixedCaseIdentifiers", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "storesUpperCaseIdentifiers", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "storesLowerCaseIdentifiers", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
            boolean bl2 = this.returnBoolean(preparedStatement, 4);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "storesMixedCaseIdentifiers", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
            boolean bl2 = this.returnBoolean(preparedStatement, 5);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsMixedCaseQuotedIdentifiers", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
            boolean bl2 = this.returnBoolean(preparedStatement, 6);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "storesUpperCaseQuotedIdentifiers", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
            boolean bl2 = this.returnBoolean(preparedStatement, 7);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "storesLowerCaseQuotedIdentifiers", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
            boolean bl2 = this.returnBoolean(preparedStatement, 8);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "storesMixedCaseQuotedIdentifiers", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIdentifierQuoteString() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERQUOTE);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getIdentifierQuoteString", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLKeywords() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLKEYWORDS);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getSQLKeywords", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNumericFunctions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(NUMERICFUNCTIONLIST);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getNumericFunctions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringFunctions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(STRINGFUNCTIONLIST);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getStringFunctions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSystemFunctions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SYSTEMFUNCTIONLIST);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getSystemFunctions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTimeDateFunctions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TIMEDATEFUNCTIONLIST);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getTimeDateFunctions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSearchStringEscape() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SEARCHSTRING);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getSearchStringEscape", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getExtraNameCharacters() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(EXTRANAMECHARS);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getExtraNameCharacters", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ALTERTABLESUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsAlterTableWithAddColumn", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ALTERTABLESUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsAlterTableWithDropColumn", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNALIASING);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsColumnAliasing", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLPLUSNONNULL);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "nullPlusNonNullIsNull", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsConvert() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CONVERTSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsConvert", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CONVERTMAP);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.executeQuery();
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsConvert", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CORRELATIONNAMES);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsTableCorrelationNames", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CORRELATIONNAMES);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsDifferentTableCorrelationNames", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ORDERBYSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsExpressionsInOrderBy", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ORDERBYSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsOrderByUnrelated", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsGroupBy() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsGroupBy", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsGroupByUnrelated", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsGroupByBeyondSelect", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(LIKEESCAPECLAUSE);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsLikeEscapeClause", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MULTIPLERESULTSETS);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsMultipleResultSets", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MULTIPLETRANSACTIONS);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsMultipleTransactions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(NONNULLABLECOLUMNS);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsNonNullableColumns", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsMinimumSQLGrammar", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsCoreSQLGrammar", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsExtendedSQLGrammar", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsANSI92EntryLevelSQL", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsANSI92IntermediateSQL", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsANSI92FullSQL", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(INTEGRITYENHANCEMENT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsIntegrityEnhancementFacility", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOuterJoins() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            if (this._outerJoinEscapeSupport == -1) {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
                this._outerJoinEscapeSupport = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
            }
            boolean bl2 = this._outerJoinEscapeSupport == 1;
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsOuterJoins", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsFullOuterJoins", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsLimitedOuterJoins", null, null, l);
            }
        }
    }

    protected boolean supportsOuterJoinEscapeSyntax() throws SQLException {
        if (this._mda._version < 1) {
            return this.getDatabaseProductName().toLowerCase().indexOf("anywhere") != -1;
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaTerm() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMATERM);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getSchemaTerm", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProcedureTerm() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURETERM);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getProcedureTerm", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalogTerm() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGTERM);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getCatalogTerm", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCatalogAtStart() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGATSTART);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "isCatalogAtStart", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalogSeparator() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSEPARATOR);
            String string = this.returnString(preparedStatement);
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getCatalogSeparator", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSchemasInDataManipulation", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSchemasInProcedureCalls", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSchemasInTableDefinitions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 4);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSchemasInIndexDefinitions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 5);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSchemasInPrivilegeDefinitions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsCatalogsInDataManipulation", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsCatalogsInProcedureCalls", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsCatalogsInTableDefinitions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 4);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsCatalogsInIndexDefinitions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 5);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsCatalogsInPrivilegeDefinitions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(POSITIONEDDELETE);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsPositionedDelete", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(POSITIONEDUPDATE);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsPositionedUpdate", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SELECTFORUPDATE);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSelectForUpdate", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(STOREDPROCEDURES);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsStoredProcedures", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSubqueriesInComparisons", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSubqueriesInExists", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSubqueriesInIns", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
            boolean bl2 = this.returnBoolean(preparedStatement, 4);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSubqueriesInQuantifieds", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
            boolean bl2 = this.returnBoolean(preparedStatement, 5);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsCorrelatedSubqueries", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsUnion() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(UNIONSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsUnion", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsUnionAll() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(UNIONSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsUnionAll", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CURSORTRANSACTIONS);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsOpenCursorsAcrossCommit", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(CURSORTRANSACTIONS);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsOpenCursorsAcrossRollback", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsOpenStatementsAcrossCommit", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsOpenStatementsAcrossRollback", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXBINARYLITERALLENGTH);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxBinaryLiteralLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXCHARLITERALLENGTH);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "allTablesAreSelectable", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnNameLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxColumnNameLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
            int n = this.returnInt(preparedStatement, 2);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxColumnsInGroupBy", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
            int n = this.returnInt(preparedStatement, 3);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxColumnsInIndex", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
            int n = this.returnInt(preparedStatement, 4);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxColumnsInOrderBy", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
            int n = this.returnInt(preparedStatement, 5);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxColumnsInSelect", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInTable() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
            int n = this.returnInt(preparedStatement, 6);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxColumnsInTable", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxConnections() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXCONNECTIONS);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxConnections", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxIndexLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXINDEXLENGTH);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxIndexLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCursorNameLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxCursorNameLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxUserNameLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
            int n = this.returnInt(preparedStatement, 2);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxUserNameLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
            int n = this.returnInt(preparedStatement, 3);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxSchemaNameLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
            int n = this.returnInt(preparedStatement, 4);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxProcedureNameLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
            int n = this.returnInt(preparedStatement, 5);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxCatalogNameLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxRowSize() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWINFO);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxRowSize", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWINFO);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "doesMaxRowSizeIncludeBlobs", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxStatementLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTINFO);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxStatementLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxStatements() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTINFO);
            int n = this.returnInt(preparedStatement, 2);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxStatements", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxTableNameLength() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEINFO);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxTableNameLength", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxTablesInSelect() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEINFO);
            int n = this.returnInt(preparedStatement, 2);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getMaxTablesInSelect", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsTransactions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsTransactions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONLEVELDEFAULT);
            int n = this.returnInt(preparedStatement, 1);
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getDefaultTransactionIsolation", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            int n2;
            int n3;
            block12: {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONLEVELS);
                ResultSet resultSet = preparedStatement.executeQuery();
                n3 = 0;
                SQLException sQLException = null;
                try {
                    if (resultSet.next()) {
                        n2 = resultSet.getMetaData().getColumnCount();
                        for (int i = 1; i <= n2; ++i) {
                            if (resultSet.getInt(i) != n) continue;
                            n3 = 1;
                        }
                    }
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    return (boolean)sQLException;
                }
                finally {
                    resultSet.close();
                    preparedStatement.close();
                    if (sQLException == null) break block12;
                    throw sQLException;
                }
            }
            n2 = n3;
            return n2 != 0;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsTransactionIsolationLevel", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsDataDefinitionAndDataManipulationTransactions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
            boolean bl2 = this.returnBoolean(preparedStatement, 2);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsDataManipulationTransactionsOnly", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
            boolean bl2 = this.returnBoolean(preparedStatement, 3);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "dataDefinitionCausesTransactionCommit", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
            boolean bl2 = this.returnBoolean(preparedStatement, 4);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "dataDefinitionIgnoredInTransactions", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURES, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                if (((SybPreparedStatement)preparedStatement)._paramCount >= 4) {
                    preparedStatement.setInt(4, 4);
                }
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block5;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getProcedures", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getProcedures", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        SybResultSet sybResultSet;
        block6: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURECOLUMNS, string);
                int n = ((SybPreparedStatement)preparedStatement)._paramCount;
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                this.setStringParam(preparedStatement, string4, 4);
                if (n >= 5) {
                    preparedStatement.setInt(5, 0);
                }
                if (n >= 6) {
                    preparedStatement.setInt(6, 4);
                }
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block6;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getProcedures", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getProcedures", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        SybResultSet sybResultSet;
        block7: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                StringBuffer stringBuffer;
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                if (stringArray == null) {
                    stringBuffer = null;
                } else {
                    stringBuffer = new StringBuffer("\"");
                    for (int i = 0; i < stringArray.length && stringArray[i] != null && !stringArray[i].equals("null"); ++i) {
                        stringBuffer.append("'" + stringArray[i] + "'");
                    }
                    stringBuffer = stringBuffer.append("\"");
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLES, string);
                this.setStringParam(preparedStatement, string3, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string, 3);
                this.setStringParam(preparedStatement, stringBuffer == null ? null : stringBuffer.toString(), 4);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block7;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getTables", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getTables", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    public ResultSet getClassForName(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CLASSFORNAME);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getJarForClass(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(JARFORCLASS);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getJarByName(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(JARBYNAME);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getClassesInJar(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CLASSESINJAR);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public boolean canReturnJars() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CANRETURNJARS);
        return this.returnBoolean(preparedStatement, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas() throws SQLException {
        ResultSet resultSet;
        block7: {
            SybResultSet sybResultSet;
            long l;
            boolean bl;
            block5: {
                SybResultSet sybResultSet2;
                block6: {
                    bl = LogUtil.isLoggingEnabled(this.LOG);
                    l = bl ? this._apiCounter.incrementAndGet() : 0L;
                    sybResultSet = null;
                    try {
                        if (bl) {
                            LogUtil.logBegin(this.LOG, this._logId, l);
                        }
                        PreparedStatement preparedStatement = null;
                        if (!this._conn._props.getBoolean(64)) break block5;
                        preparedStatement = this.getMetaDataAccessor(SCHEMAS_CTS);
                        sybResultSet2 = sybResultSet = (SybResultSet)this.returnResults(preparedStatement);
                        if (!bl) break block6;
                        LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet != null ? sybResultSet._logId : "_", this._logId, "getSchemas", null, null, l);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet != null ? sybResultSet._logId : "_", this._logId, "getSchemas", null, null, l);
                        }
                        throw throwable;
                    }
                }
                return sybResultSet2;
            }
            resultSet = this.getSchemas(null, null);
            if (!bl) break block7;
            LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet != null ? sybResultSet._logId : "_", this._logId, "getSchemas", null, null, l);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = null;
                preparedStatement = this._conn._props.getBoolean(64) ? this.getMetaDataAccessor(CATALOGS_CTS) : this.getMetaDataAccessor(CATALOGS);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getCatalogs", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getCatalogs", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLETYPES);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getTableTypes", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getTableTypes", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        SybResultSet sybResultSet;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNS, string);
                this.setStringParam(preparedStatement, string3, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string, 3);
                this.setStringParam(preparedStatement, string4, 4);
                if (((SybPreparedStatement)preparedStatement)._paramCount >= 5) {
                    preparedStatement.setInt(5, 4);
                }
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block5;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getColumns", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getColumns", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNPRIVILEGES, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                this.setStringParam(preparedStatement, string4, 4);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getColumnPrivileges", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getColumnPrivileges", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEPRIVILEGES, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getTablePrivileges", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getTablePrivileges", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl2 ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl2) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWIDENTIFIERS, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                preparedStatement.setInt(4, n);
                preparedStatement.setBoolean(5, bl);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl2) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getProcedures", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getProcedures", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(VERSIONCOLUMNS, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getVersionColumns", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getVersionColumns", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(PRIMARYKEYS, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getPrimaryKeys", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getPrimaryKeys", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            SybResultSet sybResultSet2 = null;
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(IMPORTEDKEYS, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getImportedKeys", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getImportedKeys", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            SybResultSet sybResultSet2 = null;
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(EXPORTEDKEYS, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getExportedKeys", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getExportedKeys", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(KEYCROSSREFERENCE, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                this.setStringParam(preparedStatement, string4, 4);
                this.setStringParam(preparedStatement, string5, 5);
                this.setStringParam(preparedStatement, string6, 6);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getCrossReference", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getCrossReference", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            SybResultSet sybResultSet2 = null;
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = null;
                preparedStatement = this._conn._props.getBoolean(64) ? this.getMetaDataAccessor(TYPEINFO_CTS) : this.getMetaDataAccessor(TYPEINFO);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getTypeInfo", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getTypeInfo", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            SybResultSet sybResultSet2 = null;
            boolean bl3 = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl3 ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl3) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(INDEXINFO, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                preparedStatement.setBoolean(4, bl);
                preparedStatement.setBoolean(5, bl2);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl3) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getIndexInfo", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl3) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getIndexInfo", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    public boolean isCaseSensitive() throws SQLException {
        if (this._isCaseSensitive == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ISCASESENSITIVE);
            this._isCaseSensitive = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
        }
        return this._isCaseSensitive == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSavepoints() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SAVEPOINTSUPPORT);
            boolean bl2 = this.returnBoolean(preparedStatement, 1);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsSavepoints", null, null, l);
            }
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            SybResultSet sybResultSet2 = null;
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(SUPERTYPES, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getSuperTypes", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getSuperTypes", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(SUPERTABLES, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getSuperTables", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getSuperTables", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(ATTRIBUTES, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                this.setStringParam(preparedStatement, string4, 4);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getAttributes", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getAttributes", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        if (n != 1 && n != 2) {
            ErrorMessage.raiseError("JZ0SW", String.valueOf(n));
        }
        return true;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            int n;
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            if (this._dbMajorVersion == -1) {
                String string;
                String string2 = this.getDatabaseProductVersion();
                n = string2.indexOf("/");
                if (n == -1) {
                    string = string2;
                    string2 = string2.substring(0, string2.indexOf("."));
                    int n2 = (string = string.substring(string.indexOf(".") + 1, string.length())).indexOf(".");
                    if (n2 != -1) {
                        string = string.substring(0, n2);
                    }
                } else {
                    string = string2 = string2.substring(string2.indexOf("/") + 1, string2.indexOf("/", string2.indexOf("/") + 1));
                    string2 = string.split("[^0-9]")[0];
                    string = string.split("[^0-9]")[1];
                }
                this._dbMajorVersion = Integer.valueOf(string2);
                this._dbMinorVersion = Integer.valueOf(string);
            }
            n = this._dbMajorVersion;
            return n;
        }
        catch (Exception exception) {
            this._dbMajorVersion = 0;
            this._dbMinorVersion = 0;
            int n = this._dbMajorVersion;
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getDatabaseMajorVersion", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            if (this._dbMinorVersion == -1) {
                this.getDatabaseMajorVersion();
            }
            int n = this._dbMinorVersion;
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getDatabaseMinorVersion", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJDBCMajorVersion() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            if (this._jdbcMajorVersion == -1) {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(JDBCMAJORVERSION);
                this._jdbcMajorVersion = this.returnInt(preparedStatement, 1);
            }
            int n = this._jdbcMajorVersion;
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getJDBCMajorVersion", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJDBCMinorVersion() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            if (this._jdbcMinorVersion == -1) {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(JDBCMINORVERSION);
                this._jdbcMinorVersion = this.returnInt(preparedStatement, 1);
            }
            int n = this._jdbcMinorVersion;
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "getJDBCMinorVersion", null, null, l);
            }
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(SUPPORTSRESULTSETTYPE, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsResultSetType", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            switch (n2) {
                case 1007: {
                    boolean bl2 = this.supportForResultSetType(READONLYCONCURRENCY, n);
                    return bl2;
                }
                case 1008: {
                    boolean bl3 = this.supportForResultSetType(UPDATABLECONCURRENCY, n);
                    return bl3;
                }
            }
            ErrorMessage.raiseError("JZ0SO", "" + n2);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsResultSetConcurrency", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(OWNUPDATESAREVISIBLE, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "ownUpdatesAreVisible", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(OWNDELETESAREVISIBLE, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "ownDeletesAreVisible", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(OWNINSERTSAREVISIBLE, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "ownInsertsAreVisible", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(OTHERSUPDATESAREVISIBLE, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "othersUpdatesAreVisible", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(OTHERSDELETESAREVISIBLE, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "othersDeletesAreVisible", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(OTHERSINSERTSAREVISIBLE, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "othersInsertsAreVisible", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(UPDATESAREDETECTED, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "updatesAreDetected", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(DELETESAREDETECTED, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "deletesAreDetected", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            boolean bl2 = this.supportForResultSetType(INSERTSAREDETECTED, n);
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "insertsAreDetected", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(this.LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(this.LOG, this._logId, l);
            }
            if (this._batchSupport != 1) {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(SUPPORTSBATCHUPDATES);
                boolean bl2 = this.returnBoolean(preparedStatement, 1);
                if (!bl2) {
                    this._batchSupport = 0;
                    ErrorMessage.raiseError("JZ0BS");
                }
                this._batchSupport = 1;
            }
            boolean bl3 = this._batchSupport == 1;
            return bl3;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(this.LOG, null, null, this._logId, "supportsBatchUpdates", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        SybResultSet sybResultSet;
        block12: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                String string4 = null;
                if (nArray != null) {
                    string4 = "";
                    block7: for (int i = 0; i < nArray.length; ++i) {
                        if (i > 0) {
                            string4 = string4 + ",";
                        }
                        switch (nArray[i]) {
                            case 2000: {
                                string4 = string4 + JAVA_OBJECT_NAME;
                                continue block7;
                            }
                            case 2002: {
                                string4 = string4 + STRUCT_NAME;
                                continue block7;
                            }
                            case 2001: {
                                string4 = string4 + DISTINCT_NAME;
                                continue block7;
                            }
                            default: {
                                ErrorMessage.raiseError("JZ0SQ", "" + nArray[i]);
                            }
                        }
                    }
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(UDTS, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                this.setStringParam(preparedStatement, string4, 4);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block12;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getUDTs", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getUDTs", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    public ResultSet getXACoordinatorType() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(XACOORDINATORTYPE);
        return this.returnResults(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        SybConnection sybConnection;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                sybConnection = this._conn;
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "Connection", this._conn != null ? this._conn._logId : "_", this._logId, "getConnection", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "Connection", this._conn != null ? this._conn._logId : "_", this._logId, "getConnection", null, null, l);
                }
                throw throwable;
            }
        }
        return sybConnection;
    }

    public PreparedStatement getMetaDataAccessor(String string) throws SQLException {
        return this.getMetaDataAccessor(string, "", null);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2) throws SQLException {
        return this.getMetaDataAccessor(string, "", string2);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2, String string3) throws SQLException {
        return this._mda.getMetaDataAccessor(string, string2, string3, null);
    }

    private boolean supportForResultSetType(String string, int n) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = this.getMetaDataAccessor(string);
        switch (n) {
            case 1003: {
                bl = this.returnBoolean(preparedStatement, 1);
                break;
            }
            case 1004: {
                bl = this.returnBoolean(preparedStatement, 2);
                break;
            }
            case 1005: {
                bl = this.returnBoolean(preparedStatement, 3);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", "" + n);
            }
        }
        return bl;
    }

    private void setStringParam(PreparedStatement preparedStatement, String string, int n) throws SQLException {
        if (string == null) {
            preparedStatement.setNull(n, 12);
        } else {
            preparedStatement.setString(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet returnResults(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet;
        block6: {
            resultSet = null;
            SQLException sQLException = null;
            SQLWarning sQLWarning = null;
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                sQLWarning = preparedStatement.getWarnings();
                if (sQLWarning != null) {
                    this._conn.handleSQLE(sQLWarning);
                }
                preparedStatement.close();
            }
            finally {
                if (sQLException == null) break block6;
                throw sQLException;
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean returnBoolean(PreparedStatement preparedStatement, int n) throws SQLException {
        boolean bl;
        block5: {
            ResultSet resultSet = null;
            bl = false;
            SQLException sQLException = null;
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                bl = resultSet.getBoolean(n);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return (boolean)sQLException;
            }
            finally {
                preparedStatement.close();
                if (sQLException == null) break block5;
                throw sQLException;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int returnInt(PreparedStatement preparedStatement, int n) throws SQLException {
        int n2;
        block5: {
            ResultSet resultSet = null;
            n2 = -1;
            SQLException sQLException = null;
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                n2 = resultSet.getInt(n);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return (int)sQLException;
            }
            finally {
                preparedStatement.close();
                if (sQLException == null) break block5;
                throw sQLException;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String returnString(PreparedStatement preparedStatement) throws SQLException {
        String string;
        block5: {
            ResultSet resultSet = null;
            string = null;
            SQLException sQLException = null;
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                string = resultSet.getString(1);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return sQLException;
            }
            finally {
                preparedStatement.close();
                if (sQLException == null) break block5;
                throw sQLException;
            }
        }
        return string;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        SybResultSet sybResultSet;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(FUNCTIONS, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                if (((SybPreparedStatement)preparedStatement)._paramCount >= 5) {
                    preparedStatement.setInt(4, 4);
                    preparedStatement.setInt(5, 1);
                }
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block5;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getFunctions", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getFunctions", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(FUNCTIONCOLUMNS, string);
                this.setStringParam(preparedStatement, string, 1);
                this.setStringParam(preparedStatement, string2, 2);
                this.setStringParam(preparedStatement, string3, 3);
                this.setStringParam(preparedStatement, string4, 4);
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getFunctionColumns", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getFunctionColumns", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        SybResultSet sybResultSet;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = null;
                preparedStatement = this.getMetaDataAccessor(SCHEMAS);
                if (((SybPreparedStatement)preparedStatement)._paramCount >= 2) {
                    this.setStringParam(preparedStatement, string, 1);
                    this.setStringParam(preparedStatement, string2, 2);
                }
                sybResultSet = sybResultSet2 = (SybResultSet)this.returnResults(preparedStatement);
                if (!bl) break block5;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getSchemas", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getSchemas", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        SybResultSet sybResultSet;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(this.LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            SybResultSet sybResultSet2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(this.LOG, this._logId, l);
                }
                PreparedStatement preparedStatement = this.getMetaDataAccessor(GETCLIENTINFOPROPERTIES);
                preparedStatement.execute();
                sybResultSet = sybResultSet2 = (SybResultSet)preparedStatement.getResultSet();
                if (!bl) break block4;
                LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getClientInfoProperties", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(this.LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "getClientInfoProperties", null, null, l);
                }
                throw throwable;
            }
        }
        return sybResultSet;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName());
        }
        return t;
    }
}

