/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybConnection;
import com.sybase.jdbc4.jdbc.SybDriver;
import com.sybase.jdbc4.jdbc.SybObjectFactory;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.jdbc.SybUrlManager;
import com.sybase.jdbc4.jdbc.SybUrlProvider;
import com.sybase.jdbc4.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc4.utils.ASAUDPUtil;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.EncryptedValue;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class SybDataSource
extends SybDriver
implements com.sybase.jdbcx.SybDataSource {
    private static Logger LOG = Logger.getLogger(SybDataSource.class.getName());
    private static volatile long _logIdCounter = 0L;
    private AtomicLong _apiCount = new AtomicLong(0L);
    static final long serialVersionUID = -1964411659637713576L;
    static final String ADDRESS_LIST = "addressList";
    static final String SYB_PROPERTY = "sybProperty";
    static final String RM_NAME = "resourceManagerName";
    static final String RM_TYPE = "resourceManagerType";
    static final String OBJECT_FACTORY_NAME = SybObjectFactory.class.getName();
    private String _databaseName = null;
    private String _dataSourceName = null;
    private String _description = null;
    private String _networkProtocol = "Tds";
    private int _portNumber = -1;
    private String _serverName = null;
    private SybProperty _sybProperty = null;
    private String _resourceManagerName = null;
    private boolean _rmNameSetByMethod = false;
    private int _resourceManagerType = 0;
    private String _addressListStr = null;
    private Vector _addressList = null;
    private transient PrintWriter _logWriter = null;
    private int _loginTimeout = 0;
    private String _defaultUser = null;
    private char[] _defaultCred = null;
    private String _logId = "Ds" + _logIdCounter++;

    public SybDataSource() {
        this._sybProperty = new SybProperty(this._version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        SybConnection sybConnection;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            SybConnection sybConnection2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybConnection = sybConnection2 = (SybConnection)this.connect(this.createSybUrlProvider(), this.getLoginTimeout());
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "Connection", sybConnection2 != null ? sybConnection2._logId : "_", this._logId, "getConnection", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "Connection", sybConnection2 != null ? sybConnection2._logId : "_", this._logId, "getConnection", null, null, l);
                }
                throw throwable;
            }
        }
        return sybConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        SybConnection sybConnection;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            SybConnection sybConnection2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                SybUrlProvider sybUrlProvider = this.createSybUrlProvider();
                SybProperty sybProperty = sybUrlProvider.getSybProperty();
                sybProperty.setProperty(3, string, true);
                sybProperty.setProperty(4, string2, true);
                sybConnection = sybConnection2 = (SybConnection)this.connect(sybUrlProvider, this.getLoginTimeout());
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "Connection", sybConnection2 != null ? sybConnection2._logId : "_", this._logId, "getConnection", "String, String", new Object[]{string, string2}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "Connection", sybConnection2 != null ? sybConnection2._logId : "_", this._logId, "getConnection", "String, String", new Object[]{string, string2}, l);
                }
                throw throwable;
            }
        }
        return sybConnection;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), OBJECT_FACTORY_NAME, null);
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        reference.add(new StringRefAddr("description", this.getDescription()));
        reference.add(new StringRefAddr("networkProtocol", this.getNetworkProtocol()));
        reference.add(new StringRefAddr("portNumber", String.valueOf(this.getPortNumber())));
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr(RM_NAME, this.getResourceManagerName()));
        reference.add(new StringRefAddr(RM_TYPE, String.valueOf(this.getResourceManagerType())));
        reference.add(new StringRefAddr(ADDRESS_LIST, this.getAddressList()));
        String string = null;
        String string2 = null;
        Method method = null;
        for (int i = 0; i < 109; ++i) {
            string = SybProperty.PROPNAME[i].toUpperCase();
            if (string.equals("SEND_LONG_PARAMS_REGARDLESS_OF_CAPABILITIES")) continue;
            string2 = "get" + string;
            try {
                method = SybDataSource.class.getDeclaredMethod(string2, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reference.add(new StringRefAddr(string, (String)method.invoke((Object)this, null)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArrayOutputStream).writeObject(this.getSybProperty());
            reference.add(new BinaryRefAddr(SYB_PROPERTY, byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return reference;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._logWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this._logWriter = printWriter;
            Debug.setOutputWriter(printWriter);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setLogWriter", "PrintWriter", new Object[]{printWriter}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setLogWriter", "PrintWriter", new Object[]{printWriter}, l);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._loginTimeout;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this._loginTimeout = n;
    }

    @Override
    public String getServerName() {
        return this._serverName;
    }

    @Override
    public void setServerName(String string) {
        this._serverName = string;
    }

    @Override
    public String getDatabaseName() {
        return this._databaseName;
    }

    @Override
    public void setDatabaseName(String string) {
        this._databaseName = string;
    }

    @Override
    public String getDataSourceName() {
        return this._dataSourceName;
    }

    @Override
    public void setDataSourceName(String string) {
        this._dataSourceName = string;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String string) {
        this._description = string;
    }

    @Override
    public String getUser() {
        return this._defaultUser;
    }

    @Override
    public void setUser(String string) {
        this._defaultUser = string;
        this._sybProperty.setProperty(3, string, true);
    }

    @Override
    public String getPassword() {
        return this._defaultCred == null ? null : String.valueOf(this._defaultCred);
    }

    @Override
    public void setPassword(String string) {
        this._defaultCred = string == null ? null : string.toCharArray();
        this._sybProperty.setProperty(4, string, true);
    }

    @Override
    public String getNetworkProtocol() {
        return this._networkProtocol;
    }

    @Override
    public void setNetworkProtocol(String string) {
        if (string.equals("shm")) {
            this._sybProperty.setProperty(31, "com.sybase.shmem.ShmemSocketFactory", true);
            this._networkProtocol = "Tds";
        } else {
            this._networkProtocol = string;
        }
    }

    @Override
    public int getPortNumber() {
        return this._portNumber;
    }

    @Override
    public void setPortNumber(int n) {
        this._portNumber = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getConnectionProperty(String string) {
        Object object;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                object = this._sybProperty.getConnProperty(string);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getConnectionProperty", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getConnectionProperty", "String", new Object[]{string}, l);
        }
        return object;
    }

    @Override
    public void setConnectionProperties(Properties properties) throws SQLException {
        this._sybProperty.setProperties(properties);
        String string = properties.getProperty(SybProperty.PROPNAME[42]);
        if (string != null) {
            this._resourceManagerName = string;
        }
    }

    @Override
    public void setResourceManagerName(String string) {
        if (string != null) {
            this._resourceManagerName = string;
            this._rmNameSetByMethod = true;
        }
    }

    @Override
    public String getResourceManagerName() {
        return this._resourceManagerName;
    }

    @Override
    public void setResourceManagerType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
        }
        this._resourceManagerType = n;
    }

    @Override
    public int getResourceManagerType() {
        return this._resourceManagerType;
    }

    @Override
    public void setAddressList(String string) {
        this._addressListStr = string;
        if (this._addressListStr != null && this._addressListStr.trim().length() != 0) {
            String[] stringArray = this._addressListStr.split(",");
            Vector<String> vector = new Vector<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
            this.setAddressList(vector);
        }
    }

    @Override
    public String getAddressList() {
        return this._addressListStr;
    }

    public void setSERVICENAME(String string) {
        this.setPropValue(0, string);
    }

    public String getSERVICENAME() {
        return this.getPropValue(0);
    }

    public void setHOSTNAME(String string) {
        this.setPropValue(1, string);
    }

    public String getHOSTNAME() {
        return this.getPropValue(1);
    }

    public void setHOSTPROC(String string) {
        this.setPropValue(2, string);
    }

    public String getHOSTPROC() {
        return this.getPropValue(2);
    }

    public void setUSER(String string) {
        this._defaultUser = string;
        this.setPropValue(3, string);
    }

    public String getUSER() {
        return this.getPropValue(3);
    }

    public void setPASSWORD(String string) {
        this._defaultCred = string == null ? null : string.toCharArray();
        this.setPropValue(4, string);
    }

    public String getPASSWORD() {
        return this.getPropValue(4);
    }

    public void setAPPLICATIONNAME(String string) {
        this.setPropValue(5, string);
    }

    public String getAPPLICATIONNAME() {
        return this.getPropValue(5);
    }

    public void setUSE_METADATA(String string) {
        this.setPropValue(6, string);
    }

    public String getUSE_METADATA() {
        return this.getPropValue(6);
    }

    public void setLANGUAGE(String string) {
        this.setPropValue(7, string);
    }

    public String getLANGUAGE() {
        return this.getPropValue(7);
    }

    public void setCHARSET(String string) {
        this.setPropValue(8, string);
    }

    public String getCHARSET() {
        return this.getPropValue(8);
    }

    public void setJAVA_CHARSET_MAPPING(String string) {
        this.setPropValue(77, string);
    }

    public String getJAVA_CHARSET_MAPPING() {
        return this.getPropValue(77);
    }

    public void setREMOTEPWD(String string) {
        this.setPropValue(9, new EncryptedValue(string));
    }

    public String getREMOTEPWD() {
        return this.getPropValue(9);
    }

    public void setVERSIONSTRING(String string) {
        this.setPropValue(10, string);
    }

    public String getVERSIONSTRING() {
        return this.getPropValue(10);
    }

    public void setEXPIRESTRING(String string) {
        this.setPropValue(11, string);
    }

    public String getEXPIRESTRING() {
        return this.getPropValue(11);
    }

    public void setPACKETSIZE(String string) {
        this.setPropValue(12, string);
    }

    public String getPACKETSIZE() {
        return this.getPropValue(12);
    }

    public void setSTREAM_CACHE_SIZE(String string) {
        this.setPropValue(13, string);
    }

    public String getSTREAM_CACHE_SIZE() {
        return this.getPropValue(13);
    }

    public void setREPEAT_READ(String string) {
        this.setPropValue(14, string);
    }

    public String getREPEAT_READ() {
        return this.getPropValue(14);
    }

    public void setINTERNAL_READ_BUFFER_LIMIT(String string) {
        this.setPropValue(93, string);
    }

    public String getINTERNAL_READ_BUFFER_LIMIT() {
        return this.getPropValue(93);
    }

    public void setLITERAL_PARAMS(String string) {
        this.setPropValue(15, string);
    }

    public String getLITERAL_PARAMS() {
        return this.getPropValue(15);
    }

    public void setCURSOR_ROWS(String string) {
        this.setPropValue(16, string);
    }

    public String getCURSOR_ROWS() {
        return this.getPropValue(16);
    }

    public void setPROXY(String string) {
        this.setPropValue(17, string);
    }

    public String getPROXY() {
        return this.getPropValue(17);
    }

    public void setSQLINITSTRING(String string) {
        this.setPropValue(18, string);
    }

    public String getSQLINITSTRING() {
        return this.getPropValue(18);
    }

    public void setSESSION_TIMEOUT(String string) {
        this.setPropValue(19, string);
    }

    public String getSESSION_TIMEOUT() {
        return this.getPropValue(19);
    }

    public void setSESSION_ID(String string) {
        this.setPropValue(20, string);
    }

    public String getSESSION_ID() {
        return this.getPropValue(20);
    }

    public void setCHARSET_CONVERTER_CLASS(String string) {
        this.setPropValue(21, string);
    }

    public String getCHARSET_CONVERTER_CLASS() {
        return this.getPropValue(21);
    }

    public void setJCONNECT_VERSION(String string) {
        this.setPropValue(22, string);
    }

    public String getJCONNECT_VERSION() {
        return this.getPropValue(22);
    }

    public void setCANCEL_ALL(String string) {
        this.setPropValue(23, string);
    }

    public String getCANCEL_ALL() {
        return this.getPropValue(23);
    }

    public void setPROTOCOL_CAPTURE(String string) {
        this.setPropValue(24, string);
    }

    public String getPROTOCOL_CAPTURE() {
        return this.getPropValue(24);
    }

    public void setDYNAMIC_PREPARE(String string) {
        this.setPropValue(25, string);
    }

    public String getDYNAMIC_PREPARE() {
        return this.getPropValue(25);
    }

    public void setCONNECTION_FAILOVER(String string) {
        this.setPropValue(26, string);
    }

    public String getCONNECTION_FAILOVER() {
        return this.getPropValue(26);
    }

    public void setLANGUAGE_CURSOR(String string) {
        this.setPropValue(27, string);
    }

    public String getLANGUAGE_CURSOR() {
        return this.getPropValue(27);
    }

    public void setSERIALIZE_REQUESTS(String string) {
        this.setPropValue(29, string);
    }

    public String getSERIALIZE_REQUESTS() {
        return this.getPropValue(29);
    }

    public void setLSB_BYTE_ORDER(String string) {
        this.setPropValue(30, string);
    }

    public String getLSB_BYTE_ORDER() {
        return this.getPropValue(30);
    }

    public void setSYBSOCKET_FACTORY(String string) {
        this.setPropValue(31, string);
    }

    public String getSYBSOCKET_FACTORY() {
        return this.getPropValue(31);
    }

    public void setIGNORE_DONE_IN_PROC(String string) {
        this.setPropValue(32, string);
    }

    public String getIGNORE_DONE_IN_PROC() {
        return this.getPropValue(32);
    }

    public void setSELECT_OPENS_CURSOR(String string) {
        this.setPropValue(33, string);
    }

    public String getSELECT_OPENS_CURSOR() {
        return this.getPropValue(33);
    }

    public void setREQUEST_HA_SESSION(String string) {
        this.setPropValue(34, string);
    }

    public String getREQUEST_HA_SESSION() {
        return this.getPropValue(34);
    }

    public void setELIMINATE_010SM(String string) {
        this.setPropValue(35, string);
    }

    public String getELIMINATE_010SM() {
        return this.getPropValue(35);
    }

    public void setIS_CLOSED_TEST(String string) {
        this.setPropValue(36, string);
    }

    public String getIS_CLOSED_TEST() {
        return this.getPropValue(36);
    }

    public void setCLASS_LOADER(String string) {
    }

    public String getCLASS_LOADER() {
        return this.getPropValue(37);
    }

    public void setPRELOAD_JARS(String string) {
        this.setPropValue(38, string);
    }

    public String getPRELOAD_JARS() {
        return this.getPropValue(38);
    }

    public void setFAKE_METADATA(String string) {
        this.setPropValue(39, string);
    }

    public String getFAKE_METADATA() {
        return this.getPropValue(39);
    }

    public void setGET_BY_NAME_USES_COLUMN_LABEL(String string) {
        this.setPropValue(40, string);
    }

    public String getGET_BY_NAME_USES_COLUMN_LABEL() {
        return this.getPropValue(40);
    }

    public void setBE_AS_JDBC_COMPLIANT_AS_POSSIBLE(String string) {
        this.setPropValue(41, string);
    }

    public String getBE_AS_JDBC_COMPLIANT_AS_POSSIBLE() {
        return this.getPropValue(41);
    }

    public void setGET_COLUMN_LABEL_FOR_NAME(String string) {
        this.setPropValue(65, string);
    }

    public String getGET_COLUMN_LABEL_FOR_NAME() {
        return this.getPropValue(65);
    }

    public void setRMNAME(String string) {
        if (string != null) {
            this._resourceManagerName = string;
            this._rmNameSetByMethod = true;
            this.setPropValue(42, string);
        }
    }

    public String getRMNAME() {
        return this.getPropValue(42);
    }

    public void setDISABLE_UNPROCESSED_PARAM_WARNINGS(String string) {
        this.setPropValue(43, string);
    }

    public String getDISABLE_UNPROCESSED_PARAM_WARNINGS() {
        return this.getPropValue(43);
    }

    public void setDISABLE_UNICHAR_SENDING(String string) {
        this.setPropValue(44, string);
    }

    public String getDISABLE_UNICHAR_SENDING() {
        return this.getPropValue(44);
    }

    public void setSECONDARY_SERVER_HOSTPORT(String string) {
        this.setPropValue(45, string);
    }

    public String getSECONDARY_SERVER_HOSTPORT() {
        return this.getPropValue(45);
    }

    public void setESCAPE_PROCESSING_DEFAULT(String string) {
        this.setPropValue(46, string);
    }

    public String getESCAPE_PROCESSING_DEFAULT() {
        return this.getPropValue(46);
    }

    public void setIMPLICIT_CURSOR_FETCH_SIZE(String string) {
        this.setPropValue(47, string);
    }

    public String getIMPLICIT_CURSOR_FETCH_SIZE() {
        return this.getPropValue(47);
    }

    public void setREQUEST_KERBEROS_SESSION(String string) {
        this.setPropValue(48, string);
    }

    public String getREQUEST_KERBEROS_SESSION() {
        return this.getPropValue(48);
    }

    public void setSERVICE_PRINCIPAL_NAME(String string) {
        this.setPropValue(49, string);
    }

    public String getSERVICE_PRINCIPAL_NAME() {
        return this.getPropValue(49);
    }

    public void setGSSMANAGER_CLASS(String string) {
        this.setPropValue(50, string);
    }

    public String getGSSMANAGER_CLASS() {
        String string = this.getPropValue(50);
        if (string != null && !(string instanceof String)) {
            string = string.getClass().getName();
        }
        return string;
    }

    public void setQUERY_TIMEOUT_CANCELS_ALL(String string) {
        this.setPropValue(51, string);
    }

    public String getQUERY_TIMEOUT_CANCELS_ALL() {
        return this.getPropValue(51);
    }

    public void setCAPABILITY_TIME(String string) {
        this.setPropValue(52, string);
    }

    public String getCAPABILITY_TIME() {
        return this.getPropValue(52);
    }

    public void setSERVER_INITIATED_TRANSACTIONS(String string) {
        this.setPropValue(53, string);
    }

    public String getSERVER_INITIATED_TRANSACTIONS() {
        return this.getPropValue(53);
    }

    public void setENABLE_SERVER_PACKETSIZE(String string) {
        this.setPropValue(54, string);
    }

    public String getENABLE_SERVER_PACKETSIZE() {
        return this.getPropValue(54);
    }

    public void setENCRYPT_PASSWORD(String string) {
        this.setPropValue(55, string);
    }

    public String getENCRYPT_PASSWORD() {
        return this.getPropValue(55);
    }

    public void setTEXTSIZE(String string) {
        this.setPropValue(56, string);
    }

    public String getTEXTSIZE() {
        return this.getPropValue(56);
    }

    public void setSERVERTYPE(String string) {
        this.setPropValue(57, string);
    }

    public String getSERVERTYPE() {
        return this.getPropValue(57);
    }

    public void setCACHE_COLUMN_METADATA(String string) {
        this.setPropValue(58, string);
    }

    public String getCACHE_COLUMN_METADATA() {
        return this.getPropValue(58);
    }

    public void setCAPABILITY_WIDETABLE(String string) {
        this.setPropValue(59, string);
    }

    public String getCAPABILITY_WIDETABLE() {
        return this.getPropValue(59);
    }

    public void setDATABASE(String string) {
        this.setPropValue(60, string);
    }

    public String getDATABASE() {
        return this.getPropValue(60);
    }

    public void setINTERNAL_QUERY_TIMEOUT(String string) {
        this.setPropValue(61, string);
    }

    public String getINTERNAL_QUERY_TIMEOUT() {
        return this.getPropValue(61);
    }

    public void setDEFAULT_QUERY_TIMEOUT(String string) {
        this.setPropValue(62, string);
    }

    public String getDEFAULT_QUERY_TIMEOUT() {
        return this.getPropValue(62);
    }

    public void setCRC(String string) {
        this.setPropValue(63, string);
    }

    public String getCRC() {
        return this.getPropValue(63);
    }

    public void setJ2EE_TCK_COMPLIANT(String string) {
        this.setPropValue(64, string);
    }

    public String getJ2EE_TCK_COMPLIANT() {
        return this.getPropValue(64);
    }

    public void setJCE_PROVIDER_CLASS(String string) {
        this.setPropValue(66, string);
    }

    public String getJCE_PROVIDER_CLASS() {
        String string = this.getPropValue(66);
        if (string != null && !(string instanceof String)) {
            string = string.getClass().getName();
        }
        return string;
    }

    public void setRETRY_WITH_NO_ENCRYPTION(String string) {
        this.setPropValue(67, string);
    }

    public String getRETRY_WITH_NO_ENCRYPTION() {
        return this.getPropValue(67);
    }

    public void setENABLE_BULK_LOAD(String string) {
        this.setPropValue(68, string);
    }

    public String getENABLE_BULK_LOAD() {
        return this.getPropValue(68);
    }

    public void setNEWPASSWORD(String string) {
        this.setPropValue(69, string);
    }

    public String getNEWPASSWORD() {
        return this.getPropValue(69);
    }

    public void setPROMPT_FOR_NEWPASSWORD(String string) {
        this.setPropValue(70, string);
    }

    public String getPROMPT_FOR_NEWPASSWORD() {
        return this.getPropValue(70);
    }

    public void setALLOW_LOADBALANCING(String string) {
        this.setPropValue(71, string);
    }

    public String getALLOW_LOADBALANCING() {
        return this.getPropValue(71);
    }

    public void setALLOW_CONTEXT_MIGRATION(String string) {
        this.setPropValue(72, string);
    }

    public String getALLOW_CONTEXT_MIGRATION() {
        return this.getPropValue(72);
    }

    public void setALTERNATE_SERVER_NAME(String string) {
        this.setPropValue(73, string);
    }

    public String getALTERNATE_SERVER_NAME() {
        return this.getPropValue(73);
    }

    public void setIGNORE_WARNINGS(String string) {
        this.setPropValue(74, string);
    }

    public String getIGNORE_WARNINGS() {
        return this.getPropValue(74);
    }

    public void setOPTIMIZE_FOR_PERFORMANCE(String string) {
        this.setPropValue(75, string);
    }

    public String getOPTIMIZE_FOR_PERFORMANCE() {
        return this.getPropValue(75);
    }

    public void setDELETE_WARNINGS_FROM_EXCEPTION_CHAIN(String string) {
        this.setPropValue(76, string);
    }

    public String getDELETE_WARNINGS_FROM_EXCEPTION_CHAIN() {
        return this.getPropValue(76);
    }

    public void setENABLE_RAWBULK_INTERFACE(String string) {
        this.setPropValue(78, string);
    }

    public String getENABLE_RAWBULK_INTERFACE() {
        return this.getPropValue(78);
    }

    public void setENABLE_LOB_LOCATOR(String string) {
        this.setPropValue(79, string);
    }

    public String getENABLE_LOB_LOCATOR() {
        return this.getPropValue(79);
    }

    public void setEXECUTE_BATCH_PAST_ERRORS(String string) {
        this.setPropValue(80, string);
    }

    public String getEXECUTE_BATCH_PAST_ERRORS() {
        return this.getPropValue(80);
    }

    public void setSETMAXROWS_AFFECTS_SELECT_ONLY(String string) {
        this.setPropValue(81, string);
    }

    public String getSETMAXROWS_AFFECTS_SELECT_ONLY() {
        return this.getPropValue(81);
    }

    public void setRELEASE_LOCKS_ON_CURSOR_CLOSE(String string) {
        this.setPropValue(82, string);
    }

    public String getRELEASE_LOCKS_ON_CURSOR_CLOSE() {
        return this.getPropValue(82);
    }

    public void setSEND_BATCHPARAMS_IMMEDIATE(String string) {
        this.setPropValue(83, string);
    }

    public String getSEND_BATCHPARAMS_IMMEDIATE() {
        return this.getPropValue(83);
    }

    public void setHOMOGENEOUS_BATCH(String string) {
        this.setPropValue(84, string);
    }

    public String getHOMOGENEOUS_BATCH() {
        return this.getPropValue(84);
    }

    public void setEARLY_BATCH_READ_THRESHOLD(String string) {
        this.setPropValue(85, string);
    }

    public void setOPTIMIZE_STRING_CONVERSIONS(String string) {
        this.setPropValue(86, string);
    }

    public String getOPTIMIZE_STRING_CONVERSIONS() {
        return this.getPropValue(86);
    }

    public void setSUPPRESS_CONTROL_TOKEN(String string) {
        this.setPropValue(87, string);
    }

    public String getSUPPRESS_CONTROL_TOKEN() {
        return this.getPropValue(87);
    }

    public void setSUPPRESS_ROW_FORMAT2(String string) {
        this.setPropValue(88, string);
    }

    public String getSUPPRESS_ROW_FORMAT2() {
        return this.getPropValue(88);
    }

    public void setSUPPRESS_ROW_FORMAT(String string) {
        this.setPropValue(89, string);
    }

    public String getSUPPRESS_ROW_FORMAT() {
        return this.getPropValue(89);
    }

    public void setSUPPRESS_PARAM_FORMAT(String string) {
        this.setPropValue(90, string);
    }

    public String getCONNECTION_RETRY_COUNT() {
        return this.getPropValue(94);
    }

    public void setCONNECTION_RETRY_COUNT(String string) {
        this.setPropValue(94, string);
    }

    public String getCONNECTION_RETRY_DELAY() {
        return this.getPropValue(95);
    }

    public void setCONNECTION_RETRY_DELAY(String string) {
        this.setPropValue(95, string);
    }

    public String getHADR_MODE() {
        return this.getPropValue(96);
    }

    public void setHADR_MODE(String string) {
        this.setPropValue(96, string);
    }

    public String getCONNECT_READONLY() {
        return this.getPropValue(97);
    }

    public void setCONNECT_READONLY(String string) {
        this.setPropValue(97, string);
    }

    public String getENABLE_REDIRECTION() {
        return this.getPropValue(98);
    }

    public void setENABLE_REDIRECTION(String string) {
        this.setPropValue(98, string);
    }

    public String getSUPPRESS_PARAM_FORMAT() {
        return this.getPropValue(90);
    }

    public String getENABLE_FUNCTIONALITY_GROUP() {
        return this.getPropValue(91);
    }

    public void setENABLE_FUNCTIONALITY_GROUP(String string) {
        this.setPropValue(91, string);
    }

    public String getSTRIP_BLANKS() {
        return this.getPropValue(92);
    }

    public void setSTRIP_BLANKS(String string) {
        this.setPropValue(92, string);
    }

    public String getSET_ENCRYPTED_COLUMN_VALUES_AS_CIPHERTEXT() {
        return this.getPropValue(99);
    }

    public void setSET_ENCRYPTED_COLUMN_VALUES_AS_CIPHERTEXT(String string) {
        this.setPropValue(99, string);
    }

    public String getEARLY_BATCH_READ_THRESHOLD() {
        return this.getPropValue(85);
    }

    public String getENABLE_SSL() {
        return this.getPropValue(100);
    }

    public void setENABLE_SSL(String string) {
        this.setPropValue(100, string);
    }

    public String getSSL_HOSTNAME_IN_CERT() {
        return this.getPropValue(101);
    }

    public void setSSL_HOSTNAME_IN_CERT(String string) {
        this.setPropValue(101, string);
    }

    public String getSSL_TRUST_ALL_CERTS() {
        return this.getPropValue(102);
    }

    public void setSSL_TRUST_ALL_CERTS(String string) {
        this.setPropValue(102, string);
    }

    public String getPRE_CACHE_DATATYPE_INFO() {
        return this.getPropValue(103);
    }

    public void setPRE_CACHE_DATATYPE_INFO(String string) {
        this.setPropValue(103, string);
    }

    public String getENABLE_FIPS() {
        return this.getPropValue(104);
    }

    public void setENABLE_FIPS(String string) {
        this.setPropValue(104, string);
    }

    public void setRTRIM_FOR_ENABLE_BULK_LOAD(String string) {
        this.setPropValue(105, string);
    }

    public String getRTRIM_FOR_ENABLE_BULK_LOAD() {
        return this.getPropValue(105);
    }

    public String getALLOW_NONSPROC_IN_CALLABLESTMT() {
        return this.getPropValue(106);
    }

    public void setALLOW_NONSPROC_IN_CALLABLESTMT(String string) {
        this.setPropValue(106, string);
    }

    public String getISOLATION_MODE() {
        return this.getPropValue(107);
    }

    public void setISOLATION_MODE(String string) {
        this.setPropValue(107, string);
    }

    public String getPREPARE_FAILS_ON_ERROR() {
        return this.getPropValue(108);
    }

    public void setPREPARE_FAILS_ON_ERROR(String string) {
        this.setPropValue(108, string);
    }

    protected void setPortNumber(String string) {
        this.setPortNumber(Integer.parseInt(string));
    }

    public SybProperty getSybProperty() {
        return this._sybProperty;
    }

    protected void setSybProperty(SybProperty sybProperty) {
        this._sybProperty = sybProperty;
    }

    protected void setPropValue(int n, String string) {
        this._sybProperty.setProperty(n, string, true);
    }

    protected void setPropValue(int n, Object object) {
        this._sybProperty.setProperty(n, object, true);
    }

    protected String getPropValue(int n) {
        String string = null;
        String string2 = SybProperty.PROPNAME[n];
        Object object = this._sybProperty.getConnProperty(string2);
        switch (n) {
            case 37: {
                if (object == null) break;
                string = object.getClass().getName();
                break;
            }
            default: {
                if (object == null) break;
                string = object instanceof EncryptedValue ? ((EncryptedValue)object).getValue() : object.toString();
            }
        }
        return string;
    }

    protected synchronized void checkSybProps() {
        if (this._sybProperty == null) {
            this._sybProperty = new SybProperty(this._version);
        }
    }

    protected final void setAddressList(Vector vector) {
        this._addressList = vector;
        if (this._addressList != null) {
            String string = (String)this._addressList.elementAt(0);
            this._serverName = string.substring(0, string.indexOf(":"));
            this.setPortNumber(string.substring(string.indexOf(":") + 1));
        }
    }

    protected synchronized SybUrlProvider createSybUrlProvider() throws SQLException {
        return new UrlProvider();
    }

    @Override
    protected void registerWithDriverManager() {
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName());
        }
        return t;
    }

    class UrlProvider
    extends SybUrlProviderImplBase {
        UrlProvider() throws SQLException {
            String string;
            SybDataSource.this._sybProperty.verifyProps();
            this._sybProps = (SybProperty)SybDataSource.this._sybProperty.clone();
            this._protocol = SybUrlManager.loadProtocol(SybDataSource.this._networkProtocol);
            this._dbName = SybDataSource.this._databaseName;
            String string2 = null;
            try {
                string2 = SybDataSource.this._sybProperty.getString(42);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (SybDataSource.this._rmNameSetByMethod) {
                this._rmName = SybDataSource.this._resourceManagerName;
            } else if (string2 != null) {
                SybDataSource.this._resourceManagerName = string2;
                this._rmName = SybDataSource.this._resourceManagerName;
            } else {
                this._rmName = SybDataSource.this._resourceManagerName;
            }
            this._rmType = SybDataSource.this._resourceManagerType;
            if (SybDataSource.this._addressList == null) {
                this._hostportList = new Vector(1);
                this._hostportList.addElement(SybDataSource.this._serverName + ":" + SybDataSource.this._portNumber);
            } else {
                int n = SybDataSource.this._addressList.size();
                this._hostportList = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    this._hostportList.addElement(SybDataSource.this._addressList.elementAt(i));
                }
            }
            if (this._sybProps != null && (string = this._sybProps.getString(73)) != null) {
                ASAUDPUtil aSAUDPUtil = new ASAUDPUtil();
                String string3 = aSAUDPUtil.lookupServer(string);
                this._hostportList.clear();
                this._hostportList.addElement(string3);
            }
        }

        @Override
        public void init(String string, String string2, Properties properties, SybProperty sybProperty) {
        }

        @Override
        public Vector getSecondaryHostPortList() {
            return null;
        }
    }
}

