/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobClientInputStream;
import com.sybase.jdbc4.jdbc.LobClientOutputStream;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.utils.HexConverts;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybBinaryClientLob
extends SybLob
implements Blob {
    private static Logger LOG = Logger.getLogger(SybBinaryClientLob.class.getName());
    private static volatile long _logIdCounter = 0L;
    private AtomicLong _apiCount = new AtomicLong(0L);
    private byte[] data;

    public SybBinaryClientLob(String string, ProtocolContext protocolContext, byte[] byArray) throws SQLException {
        this._logId = string + "_Bc" + _logIdCounter++;
        this.data = byArray;
        this._lobType = SybLob.LOB_TYPE.IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkClientLOBValidity();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new LobClientInputStream(this, 1L, this.length()), 16384);
            return bufferedInputStream;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getBinaryStream", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        BufferedInputStream bufferedInputStream;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                this.checkClientLOBValidity();
                long l4 = this.length();
                if (l < 1L || l > l4 || l + l2 > l4 + 1L) {
                    ErrorMessage.raiseError("JZ037");
                }
                bufferedInputStream = new BufferedInputStream(new LobClientInputStream(this, l, l2), 16384);
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBinaryStream", "long, long", new Object[]{l, l2}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBinaryStream", "long, long", new Object[]{l, l2}, l3);
        }
        return bufferedInputStream;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.checkClientLOBValidity();
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        block14: {
            long l2;
            long l3;
            boolean bl;
            block12: {
                byte[] byArray2;
                block13: {
                    block10: {
                        byte[] byArray3;
                        block11: {
                            bl = LogUtil.isLoggingEnabled(LOG);
                            l3 = bl ? this._apiCount.incrementAndGet() : 0L;
                            try {
                                if (bl) {
                                    LogUtil.logBegin(LOG, this._logId, l3);
                                }
                                this.checkClientLOBValidity();
                                if (l < 1L) {
                                    ErrorMessage.raiseError("JZ037");
                                } else if (n < 0) {
                                    ErrorMessage.raiseError("JZ038");
                                }
                                l2 = this.length();
                                if (this.data != null && l <= l2) break block10;
                                byArray3 = null;
                                if (!bl) break block11;
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "long, int", new Object[]{l, n}, l3);
                                }
                                throw throwable;
                            }
                            LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "long, int", new Object[]{l, n}, l3);
                        }
                        return byArray3;
                    }
                    if (n != 0) break block12;
                    byArray2 = new byte[]{};
                    if (!bl) break block13;
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "long, int", new Object[]{l, n}, l3);
                }
                return byArray2;
            }
            if (l + (long)n - 1L > l2) {
                n = (int)(l2 - l + 1L);
            }
            byte[] byArray4 = new byte[n];
            System.arraycopy(this.data, (int)l - 1, byArray4, 0, n);
            byArray = byArray4;
            if (!bl) break block14;
            LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "long, int", new Object[]{l, n}, l3);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        long l2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                this.checkClientLOBValidity();
                int n = (int)this.indexOf(this.getBytes(l, (int)((long)this.data.length - l)), byArray);
                long l4 = l2 = n == -1 ? (long)n : (long)n + l;
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "position", "byte[], long", new Object[]{byArray, l}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "position", "byte[], long", new Object[]{byArray, l}, l3);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Blob blob, long l) throws SQLException {
        long l2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                this.checkClientLOBValidity();
                l2 = this.position(((SybBinaryClientLob)blob).getBytes(), l);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "position", "Blob, long", new Object[]{blob, l}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "position", "Blob, long", new Object[]{blob, l}, l3);
        }
        return l2;
    }

    @Override
    public long length() throws SQLException {
        this.checkClientLOBValidity();
        if (this.data == null) {
            return 0L;
        }
        return this.data.length;
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        this.checkClientLOBValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        if (byArray != null) {
            long l2 = this.length();
            if (l > l2 + 1L) {
                ErrorMessage.raiseError("JZ037");
            }
            if (l2 > l + (long)byArray.length) {
                for (int i = 0; i < byArray.length; ++i) {
                    this.data[i + (int)l - 1] = byArray[i];
                }
            } else {
                byte[] byArray2 = new byte[(int)(l + (long)byArray.length - 1L)];
                if (l2 > 0L) {
                    System.arraycopy(this.data, 0, byArray2, 0, (int)(l - 1L));
                }
                if (byArray.length > 0) {
                    System.arraycopy(byArray, 0, byArray2, (int)l - 1, byArray.length);
                }
                this.data = byArray2;
            }
            return byArray.length;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        block7: {
            long l2;
            boolean bl;
            block5: {
                int n4;
                block6: {
                    bl = LogUtil.isLoggingEnabled(LOG);
                    l2 = bl ? this._apiCount.incrementAndGet() : 0L;
                    try {
                        if (bl) {
                            LogUtil.logBegin(LOG, this._logId, l2);
                        }
                        this.checkClientLOBValidity();
                        byte[] byArray2 = null;
                        if (byArray == null) break block5;
                        byArray2 = new byte[n2];
                        System.arraycopy(byArray, n - 1, byArray2, 0, n2);
                        n4 = this.setBytes(l, byArray2);
                        if (!bl) break block6;
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "long, byte[], int, int", new Object[]{l, byArray, n, n2}, l2);
                        }
                        throw throwable;
                    }
                    LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "long, byte[], int, int", new Object[]{l, byArray, n, n2}, l2);
                }
                return n4;
            }
            n3 = 0;
            if (!bl) break block7;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "long, byte[], int, int", new Object[]{l, byArray, n, n2}, l2);
        }
        return n3;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        this.checkClientLOBValidity();
        if (l < 1L || l > this.length()) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedOutputStream(new LobClientOutputStream(this, l), 16384);
    }

    @Override
    public String getString() throws SQLException {
        this.checkClientLOBValidity();
        if (this.data != null) {
            return HexConverts.hexConvert(this.data);
        }
        return null;
    }

    @Override
    public void free() throws SQLException {
        if (!this._freeCalled) {
            this.data = null;
            this._freeCalled = true;
        }
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.checkClientLOBValidity();
        if (l < 0L) {
            ErrorMessage.raiseError("JZ038");
        }
        if (this.data == null) {
            ErrorMessage.raiseError("JZ036");
        } else {
            byte[] byArray = new byte[(int)l];
            System.arraycopy(this.data, 0, byArray, 0, (int)l);
            this.data = byArray;
        }
    }

    private void checkClientLOBValidity() throws SQLException {
        if (this._freeCalled) {
            ErrorMessage.raiseError("JZ036");
        }
    }

    public long indexOf(byte[] byArray, byte[] byArray2) {
        int[] nArray = this.computeFailure(byArray2);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            while (n > 0 && byArray2[n] != byArray[i]) {
                n = nArray[n - 1];
            }
            if (byArray2[n] == byArray[i]) {
                ++n;
            }
            if (n != byArray2.length) continue;
            return i - byArray2.length + 1;
        }
        return -1L;
    }

    private int[] computeFailure(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        for (int i = 1; i < byArray.length; ++i) {
            while (n > 0 && byArray[n] != byArray[i]) {
                n = nArray[n - 1];
            }
            if (byArray[n] == byArray[i]) {
                // empty if block
            }
            nArray[i] = ++n;
        }
        return nArray;
    }
}

