/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.Escape;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybStatement;
import java.sql.SQLException;

class EscapeTokenizer {
    static final int START = 1;
    static final int IN_SINGLE_QUOTES = 2;
    static final int IN_DOUBLE_QUOTES = 3;
    private StringBuffer _text;
    private char[] _textCharBuf;
    private int _nextIndex;
    private SybStatement _stmt;
    private int _mark;
    private boolean _openCursor = false;
    private static final String SQL_DELIMITERS = " %&'()*+,-./:;<=>?[|\t\n";

    EscapeTokenizer(SybStatement sybStatement, String string) {
        this.updateText(new StringBuffer(string));
        this._stmt = sybStatement;
        this._nextIndex = 0;
        this._stmt._type = 0;
        this._stmt._setEnd = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object next() throws SQLException {
        Object object;
        int n;
        int n2;
        int n3 = 1;
        if (this._nextIndex == 0) {
            String string = this.nextWord(0);
            if ("create".equalsIgnoreCase(string) && this._stmt instanceof SybPreparedStatement && ((SybPreparedStatement)this._stmt)._dynStmtName != null) {
                ErrorMessage.raiseError("XXXXX");
            }
            if ("exec".equalsIgnoreCase(string)) {
                this._nextIndex = this._text.length();
                this._stmt._type = 1;
                return new Escape(this._text.toString(), 1);
            }
            if ("select".equalsIgnoreCase(string)) {
                this._stmt._type = 2;
            } else if ("delete".equalsIgnoreCase(string)) {
                this._stmt._type = 4;
                string = this.nextWord(-1);
                if (string != null && string.equalsIgnoreCase("from")) {
                    string = this.nextWord(-1);
                }
                this._stmt._table = this.completeTableName(string);
            } else if ("update".equalsIgnoreCase(string)) {
                this._stmt._type = 8;
                string = this.nextWord(-1);
                if ((string = this.completeTableName(string)) != null) {
                    this._stmt._setStart = this._mark - 1;
                }
                this._stmt._table = string;
            } else if ("insert".equalsIgnoreCase(string)) {
                this._stmt._type = 16;
                string = this.nextWord(-1);
                if (string != null && string.equalsIgnoreCase("into")) {
                    string = this.nextWord(-1);
                }
                this._stmt._table = this.completeTableName(string);
                n2 = this._mark;
                string = this.nextWord(-1);
                if (string != null && string.equalsIgnoreCase("select")) {
                    this._stmt._type = 256;
                } else {
                    n = EscapeTokenizer.matchClosingChar(this._text.charAt(n2), this._text, this._mark);
                    string = this.nextWord(n);
                    if (string != null && string.equalsIgnoreCase("select")) {
                        this._stmt._type = 256;
                    }
                }
            }
        }
        if (this._nextIndex >= this._text.length()) {
            object = null;
        } else if (this._text.charAt(this._nextIndex) == '{') {
            int n4 = -1;
            block17: for (n2 = this._nextIndex + 1; n2 < this._text.length(); ++n2) {
                char c = this._text.charAt(n2);
                switch (c) {
                    case '\"': 
                    case '\'': {
                        n3 = EscapeTokenizer.nextState(n3, c);
                        break;
                    }
                    case '}': {
                        if (n3 != 1) break;
                        n4 = n2;
                        break block17;
                    }
                    case '{': {
                        if (n3 != 1) break;
                        n = EscapeTokenizer.matchClosingChar(c, this._text, n2) + 1;
                        if (n == 0) {
                            ErrorMessage.raiseError("JZ0S8", this._text.toString());
                        }
                        String string = this._stmt.processEscapes(new String(this._textCharBuf, n2, n - n2));
                        int n5 = string.length();
                        int n6 = n2 + n5 + this._textCharBuf.length - n;
                        StringBuffer stringBuffer = new StringBuffer(n6);
                        stringBuffer.append(this._textCharBuf, 0, n2);
                        stringBuffer.append(string);
                        stringBuffer.append(this._textCharBuf, n, this._textCharBuf.length - n);
                        n2 += n5 - 1;
                        this.updateText(stringBuffer);
                    }
                }
            }
            if (n4 == -1) {
                ErrorMessage.raiseError("JZ0S8", this._text.toString());
            }
            String string = new String(this._textCharBuf, this._nextIndex, n4 + 1 - this._nextIndex);
            Escape escape = new Escape(string);
            object = escape;
            this._stmt._setEnd -= string.length() - escape.getBody().length();
            switch (escape.getType()) {
                case 4: {
                    if (this._stmt._context._conn._props.getBoolean(52)) break;
                    this._stmt._setEnd += "1970-1-1 ".length();
                    break;
                }
                case 3: {
                    this._stmt._setEnd += "00:00:00 ".length();
                    break;
                }
                case 1: 
                case 2: {
                    this._stmt._type = 1;
                    break;
                }
            }
            this._nextIndex = n4 + 1;
        } else {
            int n7 = -1;
            block18: for (n2 = this._nextIndex; n2 < this._text.length(); ++n2) {
                char c = this._text.charAt(n2);
                switch (c) {
                    case '\"': 
                    case '\'': {
                        n3 = EscapeTokenizer.nextState(n3, c);
                        break;
                    }
                    case '{': {
                        if (n3 != 1) break;
                        n7 = n2;
                        break block18;
                    }
                    case 'F': 
                    case 'f': {
                        if (n3 != 1 || this._stmt._type != 2) break;
                        String string = this.nextWord(n2);
                        if ("from".equalsIgnoreCase(string)) {
                            string = this.nextWord(-1);
                            this._stmt._table = this.completeTableName(string);
                            if (this._stmt._cursor != null) {
                                this._stmt._cursor.setTable(this._stmt._table);
                            }
                            if (this._stmt._context._conn._props.getBoolean(33) && this._stmt._cursor == null) break;
                            this._stmt._type |= 0x1000;
                            break;
                        }
                        if (!this._stmt._context._conn._props.getBoolean(33) || !"for".equalsIgnoreCase(string)) break;
                        string = this.nextWord(-1);
                        if ("update".equalsIgnoreCase(string)) {
                            this._openCursor = true;
                        }
                        this._stmt._type |= 0x1000;
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        String string;
                        if (n3 != 1 || this._stmt._type != 2 || !"into".equalsIgnoreCase(string = this.nextWord(n2))) break;
                        if (this._stmt instanceof SybPreparedStatement && ((SybPreparedStatement)this._stmt)._dynStmtName != null && this.nextWord(-1).startsWith("#")) {
                            ErrorMessage.raiseError("XXXXX");
                            break;
                        }
                        this._stmt._type = 16;
                        break;
                    }
                    case 'W': 
                    case 'w': {
                        String string;
                        if (n3 != 1 || (this._stmt._type & 0xC) == 0 || !"where".equalsIgnoreCase(string = this.nextWord(n2)) || !"current".equalsIgnoreCase(string = this.nextWord(-1)) || !"of".equalsIgnoreCase(string = this.nextWord(-1))) break;
                        if (this._stmt instanceof SybPreparedStatement && ((SybPreparedStatement)this._stmt)._dynStmtName != null) {
                            ErrorMessage.raiseError("XXXXX");
                        }
                        this._stmt._type |= 0x1000;
                        this._stmt._setEnd += n2 - 1;
                    }
                }
            }
            if (n7 == -1) {
                n7 = this._text.length();
            }
            object = new String(this._textCharBuf, this._nextIndex, n7 - this._nextIndex);
            this._nextIndex = n7;
        }
        if (this._openCursor) {
            this._stmt.checkCursor(false, 1008);
            this._stmt._cursor.getName();
            this._openCursor = false;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int matchClosingChar(char c, StringBuffer stringBuffer, int n) {
        int n2 = 1;
        int n3 = -1;
        int n4 = n + 1;
        while (n4 < stringBuffer.length()) {
            char c2 = stringBuffer.charAt(n4);
            switch (c2) {
                case '\"': 
                case '\'': {
                    n2 = EscapeTokenizer.nextState(n2, c2);
                    break;
                }
                case ')': 
                case '}': {
                    if (n2 != 1) break;
                    if (c2 == '}') {
                        if (c == '{') return n4;
                    }
                    if (c2 != ')' || c != '(') break;
                    return n4;
                }
                case '(': 
                case '{': {
                    if (n2 != 1 || c2 != c) break;
                    n4 = EscapeTokenizer.matchClosingChar(c2, stringBuffer, n4);
                }
            }
            ++n4;
        }
        return n3;
    }

    protected static int nextState(int n, char c) {
        int n2 = n;
        switch (c) {
            case '\'': {
                if (n == 2) {
                    n2 = 1;
                    break;
                }
                if (n != 1) break;
                n2 = 2;
                break;
            }
            case '\"': {
                if (n == 3) {
                    n2 = 1;
                    break;
                }
                if (n != 1) break;
                n2 = 3;
                break;
            }
        }
        return n2;
    }

    private void updateText(StringBuffer stringBuffer) {
        this._text = stringBuffer;
        int n = stringBuffer.length();
        this._textCharBuf = new char[n];
        if (n > 0) {
            this._text.getChars(0, n, this._textCharBuf, 0);
        }
    }

    private String nextWord(int n) {
        if (n >= 0) {
            this._mark = n;
        }
        String string = null;
        int n2 = this._text.length();
        while (this._mark < n2 && SQL_DELIMITERS.indexOf(this._text.charAt(this._mark)) != -1) {
            ++this._mark;
        }
        if (this._mark >= n2) {
            string = null;
        } else {
            if (this._mark > 0 && this._text.charAt(this._mark) == '\"') {
                n2 = this._text.toString().indexOf(34, this._mark + 1) + 1;
            } else {
                for (int i = this._mark; i < n2; ++i) {
                    if (SQL_DELIMITERS.indexOf(this._text.charAt(i)) == -1) continue;
                    n2 = i;
                    break;
                }
            }
            if (n2 > this._mark) {
                string = String.copyValueOf(this._textCharBuf, this._mark, n2 - this._mark);
                this._mark = n2 + 1;
                n2 = this._text.length();
            }
        }
        return string;
    }

    private String completeTableName(String string) {
        String string2 = string;
        for (int i = 0; i < 2; ++i) {
            if (this._mark >= this._text.length()) continue;
            if (this._text.charAt(this._mark - 1) != '.') break;
            if (this._text.charAt(this._mark) == '.') {
                string2 = string2 + ".";
                ++i;
            }
            string2 = string2 + "." + this.nextWord(-1);
        }
        return string2;
    }
}

