/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.tds.TdsDataObject;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.tds.TdsResultSet;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class TdsScrollResultSet
extends TdsResultSet {
    protected static int UNDEFINED = -47;
    protected boolean _resultSetHasAtLeastOneRow = false;
    protected boolean _resultSetIsEmpty = false;

    protected TdsScrollResultSet(TdsProtocolContext tdsProtocolContext) throws SQLException {
        super(tdsProtocolContext);
        this._serverSideScrolling = true;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.quickEmptyResultSetCheck() || this.isBeforeFirst()) {
            return false;
        }
        boolean bl = false;
        if (this._rowIndex > 1) {
            --this._rowIndex;
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
            bl = true;
        } else {
            this.advanceColumnArray();
            int n = -1;
            int n2 = -1;
            int n3 = this._tpc._cursor.getFetchSize();
            int n4 = this.getRowNumberNoCurInfo();
            if (n4 == -1 && !this.isAfterLast()) {
                n4 = this.getRowNumber();
            }
            int n5 = this._tpc._cursor.getTotalRowCount();
            if (n4 != -1) {
                if (n4 == 1) {
                    n = 0;
                } else if (n4 <= n3) {
                    n = 1;
                    n2 = n4 - 1;
                } else {
                    n = n4 - n3;
                    n2 = n4 - 1;
                }
            } else if (n5 != -1) {
                n2 = n5;
                n = n5 < n3 ? 1 : n5 - n3 + 1;
            }
            if (n != -1) {
                this._tpc._cursor.fetch(2, 0, false);
                bl = this.next();
                for (int i = n; i < n2; ++i) {
                    bl = this.next();
                }
            } else {
                this._tpc._cursor.fetch(6, -1, false);
                bl = this.next();
            }
        }
        return bl;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = this._rowIndex + n - 1;
        if (this.quickEmptyResultSetCheck()) {
            return false;
        }
        int n3 = this.getRowNumberNoCurInfo();
        if (n3 != -1) {
            n3 = n3 + this._rowIndex - 1;
        }
        int n4 = this._tpc._cursor.getTotalRowCount();
        int n5 = this._tpc._cursor.getFetchSize();
        if (n < 0) {
            if (!this.isBeforeFirst()) {
                if (this._rowIndex + n > 0) {
                    this._rowIndex += n;
                    this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
                } else {
                    bl2 = true;
                    this.advanceColumnArray();
                }
            }
        } else if (n != 0 && !this.isAfterLast()) {
            if (this._rowIndex + n <= this._lastFetchSize) {
                if (n4 != -1 && n3 != -1 && n3 + n > n4) {
                    this.advanceColumnArray();
                    bl2 = true;
                }
                if (!bl2) {
                    for (int i = 0; i < n; ++i) {
                        if (this.next()) continue;
                        bl2 = true;
                        break;
                    }
                }
            } else {
                this.advanceColumnArray();
                bl2 = true;
            }
        }
        if (bl2) {
            if (this.isAfterLast() && n < 0) {
                if (n4 != -1) {
                    if (Math.abs(n) > n4 && Math.abs(n) <= n5) {
                        this.first();
                        this.previous();
                        return false;
                    }
                } else {
                    bl3 = true;
                }
            } else if (n < 0) {
                bl3 = true;
            }
            this._tpc._cursor.fetch(6, n2, bl3);
            bl = this.next();
        }
        return bl;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.quickEmptyResultSetCheck()) {
            return false;
        }
        boolean bl = false;
        int n = this.getRowNumberNoCurInfo();
        if (n != -1 && n - this._rowIndex == 0) {
            this._rowIndex = 1;
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
            return true;
        }
        this.advanceColumnArray();
        this._tpc._cursor.fetch(3, 0, false);
        bl = this.next();
        if (!bl) {
            this._resultSetIsEmpty = true;
        } else {
            this._tpc._cursor.setRowNum(1);
        }
        return bl;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.quickEmptyResultSetCheck()) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = this._tpc._cursor.getTotalRowCount();
        int n2 = this.getRowNumberNoCurInfo();
        int n3 = this._tpc._cursor.getFetchSize();
        if (n != -1 && n2 != -1) {
            if (n2 - this._rowIndex + this._lastFetchSize >= n) {
                for (int i = n2; i < n; ++i) {
                    this.next();
                }
                return true;
            }
        } else if (n == -1) {
            bl2 = true;
        }
        this.advanceColumnArray();
        this._tpc._cursor.fetch(4, 0, bl2);
        bl = this.next();
        if (n3 != 1 && !bl2) {
            if (n3 <= n) {
                int n4;
                for (int i = n4 = n - n3 + 1; i < n; ++i) {
                    bl = this.next();
                }
            } else {
                for (int i = 1; i < n; ++i) {
                    bl = this.next();
                }
            }
        }
        if (!bl) {
            this._resultSetIsEmpty = true;
        }
        return bl;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean bl = false;
        if (this._rowIndex == 0 && this._tpc._cursor.getRowNum() == 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isFirst() throws SQLException {
        boolean bl = false;
        if (this._rowIndex != 1) {
            bl = false;
        } else if (this._tpc._cursor.getRowNum() == 1) {
            bl = true;
        } else if (this.getRowNumber() == 1) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isLast() throws SQLException {
        boolean bl = false;
        int n = this._tpc._cursor.getTotalRowCount();
        int n2 = this.getRowNumberNoCurInfo();
        if (this._rowIndex == 0) {
            bl = false;
        } else if (n != -1 && n2 != -1) {
            if (n == n2) {
                bl = true;
            }
        } else {
            this._tpc._cursor.doCurInfo(2, 131);
            n = this._tpc._cursor.getTotalRowCount();
            n2 = this.getRowNumberNoCurInfo();
            if (n != -1 && n2 != -1) {
                if (n == n2) {
                    bl = true;
                }
            } else if (this.next()) {
                this.previous();
                bl = false;
            } else {
                this._tpc._cursor.fetch(1, 0, true);
                bl = !this.next();
                this.previous();
            }
        }
        return bl;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean bl = false;
        if (this._rowIndex == 0 && this._tpc._cursor.getRowNum() == -2) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        boolean bl = true;
        boolean bl2 = true;
        if (this.quickEmptyResultSetCheck()) {
            return false;
        }
        int n2 = this._tpc._cursor.getTotalRowCount();
        int n3 = this.getRowNumberNoCurInfo();
        if (n == 0) {
            bl2 = true;
        } else if (n2 != -1 && n3 != -1 && Math.abs(n) <= n2) {
            int n4 = n;
            if (n < 0) {
                n4 = n2 + 1 + n;
            }
            int n5 = n3 - this._rowIndex + this._lastFetchSize;
            int n6 = n3 - this._rowIndex + 1;
            if (n4 >= n3 && n4 <= n5) {
                for (int i = n3; i < n4; ++i) {
                    this.next();
                }
                bl2 = false;
            } else if (n4 < n3 && n4 >= n6) {
                for (int i = n3; i > n4; --i) {
                    this.previous();
                }
                bl2 = false;
            }
        }
        if (bl2) {
            this.advanceColumnArray();
            this._tpc._cursor.fetch(5, n, true);
            bl = this.next();
        }
        return bl;
    }

    @Override
    public boolean next() throws SQLException {
        if (this._rowIndex < this._cachedRows.size()) {
            ++this._rowIndex;
            this._columns = (TdsDataObject[])this._cachedRows.get(this._rowIndex - 1);
            return true;
        }
        if (this._dead) {
            return false;
        }
        this.advanceColumnArray();
        int n = this.nextResult();
        switch (n) {
            case 209: {
                ++this._rowCount;
                ++this._rowIndex;
                this.cacheCurrentRow();
                this._needNext = false;
                this._resultSetHasAtLeastOneRow = true;
                return true;
            }
            case 5: {
                this._rowCount = this._tpc._protocol.count(this._tpc);
                if (this._tpc._cursor != null) {
                    this._totalCursorRows += this._rowCount;
                }
                this.markDead();
                return false;
            }
        }
        this._tpc._protocol.ungetResult(this._tpc, n);
        this.markDead();
        return false;
    }

    private void advanceColumnArray() throws SQLException {
        if (!this._needNext) {
            this._tpc._lastResult = -1;
            try {
                this._columns = this._savedCols;
                for (int i = 0; i < this._totalColumns; ++i) {
                    this._columns[i].clear();
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    @Override
    protected void prepareForNextFetch() {
        this._needNext = true;
        this._rowIndex = 0;
        this._lastFetchSize = this._tpc._cursor.getFetchSizeForLastFetch();
        this._cachedRows = new Vector();
        this._dead = false;
    }

    @Override
    public boolean isResultSetEmpty() throws SQLException {
        boolean bl = false;
        if (this.quickEmptyResultSetCheck()) {
            bl = true;
        } else if (this._resultSetHasAtLeastOneRow) {
            bl = false;
        } else {
            int n = this._tpc._cursor.getFetchSize();
            if (n > 1) {
                this._tpc._cursor.setFetchSize(1);
            }
            this._tpc._cursor.fetch(1, 0, false);
            boolean bl2 = this.next();
            if (bl2) {
                this.previous();
            } else {
                bl = true;
            }
            if (n > 1) {
                this._tpc._cursor.setFetchSize(n);
            }
        }
        return bl;
    }

    private boolean quickEmptyResultSetCheck() {
        boolean bl = false;
        if (this._resultSetIsEmpty) {
            bl = true;
        } else if (this._resultSetHasAtLeastOneRow) {
            bl = false;
        } else if (this._tpc._cursor.getTotalRowCount() == 0) {
            this._resultSetIsEmpty = true;
            bl = true;
        } else if (this._tpc._cursor.getTotalRowCount() > 0) {
            this._resultSetHasAtLeastOneRow = true;
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int getRowNumber() throws SQLException {
        int n = -1;
        if (this._rowIndex != 0) {
            int n2 = this._tpc._cursor.getRowNum();
            if (n2 != -1) {
                n = n2 + this._rowIndex - 1;
            } else {
                this._tpc._cursor.doCurInfo(2, 131);
                n2 = this._tpc._cursor.getRowNum();
                if (n2 != -1) {
                    n = n2 + this._rowIndex - 1;
                }
            }
        }
        return n;
    }

    private int getRowNumberNoCurInfo() {
        int n = this._tpc._cursor.getRowNum();
        n = n > 0 ? n + this._rowIndex - 1 : -1;
        return n;
    }

    @Override
    protected void dump() {
    }
}

