/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.tds.HASessionContext;
import com.sybase.jdbc4.tds.Language;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.tds.Token;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.SybVersion;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.sql.SQLException;

public class LoginToken
extends Token {
    protected static final int MAX_NAMELEN = 30;
    protected static final int MAX_REMPWDLEN = 255;
    protected static final int MAX_PROGNLEN = 10;
    protected static final int MAX_PACKETSIZELEN = 6;
    protected String _hostName;
    protected String _user;
    protected String _password;
    protected String _hostProc;
    protected int _bufSize = 512;
    protected String _appName;
    protected String _serviceName;
    protected String _remPw;
    protected boolean _encPwd;
    protected int _lint2 = 2;
    protected int _lint4 = 0;
    protected int _lflt = 4;
    protected int _lflt4 = 12;
    protected int _ldate = 8;
    protected int _ldate4 = 16;
    protected static final byte[] TDSVERSION = new byte[]{5, 0, 0, 0};
    protected int _lseclogin = 0;
    private static final String PROGNAME = "jConnect";
    protected byte[] _progVers = new byte[]{1, 0, 0, 0};
    protected String _language;
    protected String _charset;
    protected String _packetSize;
    protected byte[] _lhasessionid = new byte[6];
    protected int _lhalogin;
    protected static final byte[] SPARE = new byte[]{0, 0, 0};
    protected static final byte[] OLDSECURE = new byte[]{0, 0};
    protected static final byte[] SECSPARE = new byte[]{0, 0};
    protected static final byte[] DUMMY = new byte[]{0, 0, 0, 0};

    protected LoginToken() {
    }

    public LoginToken(SybProperty sybProperty, TdsProtocolContext tdsProtocolContext, HASessionContext hASessionContext) throws SQLException {
        StackTraceElement[] stackTraceElementArray;
        if (sybProperty.getBoolean(48)) {
            this._user = "";
            this._password = "";
            this._lseclogin = 16;
        } else {
            this._user = sybProperty.getString(3);
            if (this._user == null) {
                ErrorMessage.raiseError("JZ004");
            }
            if (this._user.length() > 30) {
                ErrorMessage.raiseError("JZ001", this._user);
            }
            this._password = sybProperty.getString(4);
            if (this._password == null) {
                this._password = "";
            }
            if (this._password.length() > 30) {
                ErrorMessage.raiseError("JZ002", "");
            }
        }
        this._hostName = sybProperty.getString(1);
        if (this._hostName != null && this._hostName.length() > 30) {
            tdsProtocolContext._conn.chainWarnings(ErrorMessage.createWarning("010HT", this._hostName));
            this._hostName = this._hostName.substring(0, 30);
        }
        if (this._hostName == null) {
            try {
                this._hostName = InetAddress.getLocalHost().getHostName();
                if (this._hostName != null && this._hostName.length() > 30) {
                    tdsProtocolContext._conn.chainWarnings(ErrorMessage.createWarning("010HT", this._hostName));
                    this._hostName = this._hostName.substring(0, 30);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._hostProc = sybProperty.getString(2);
        if (this._hostProc == null || this._hostProc == "") {
            stackTraceElementArray = ManagementFactory.getRuntimeMXBean().getName();
            String[] stringArray = stackTraceElementArray.split("@");
            this._hostProc = stringArray[0];
        }
        this._appName = sybProperty.getString(5);
        if (this._appName == null) {
            stackTraceElementArray = new Throwable().getStackTrace();
            this._appName = stackTraceElementArray[stackTraceElementArray.length - 1].getClassName();
        }
        if (this._appName.length() > 30) {
            this._appName = this._appName.substring(0, 29);
        }
        this._serviceName = sybProperty.getString(0);
        this._remPw = sybProperty.getString(9);
        this._charset = sybProperty.getString(8);
        this._language = sybProperty.getString(7);
        if (this._language == null) {
            this._language = Language.defaultLanguage();
        }
        if (this._language != null) {
            sybProperty.setProperty(7, this._language);
            Language.setLocale(this._language);
        }
        this._packetSize = String.valueOf(sybProperty.getInteger(12));
        this._progVers[0] = SybVersion.MAJOR_VERSION;
        this._progVers[1] = SybVersion.MINOR_VERSION;
        this._progVers[2] = SybVersion.POINT_MINOR_VERSION;
        this._progVers[3] = (byte)(SybVersion.SP_NUMBER / 10);
        if (sybProperty.getBoolean(30)) {
            this._lint2 = 3;
            this._lint4 = 1;
            this._lflt = 10;
            this._lflt4 = 13;
            this._ldate = 9;
            this._ldate4 = 17;
        }
        this._lhalogin = hASessionContext.getLogin();
        System.arraycopy(hASessionContext.getSessionID(), 0, this._lhasessionid, 0, 6);
        this._encPwd = sybProperty.getBoolean(55);
        if (this._encPwd) {
            this._password = "";
            this._lseclogin = 161;
        }
    }

    @Override
    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        try {
            tdsOutputStream.writeStringLen(this._hostName, 30);
            tdsOutputStream.writeStringLen(this._user, 30);
            tdsOutputStream.writeStringLen(this._password, 30);
            tdsOutputStream.writeStringLen(this._hostProc, 30);
            tdsOutputStream.write(this._lint2);
            tdsOutputStream.write(this._lint4);
            tdsOutputStream.write(6);
            tdsOutputStream.write(this._lflt);
            tdsOutputStream.write(this._ldate);
            tdsOutputStream.write(1);
            tdsOutputStream.write(0);
            tdsOutputStream.write(0);
            tdsOutputStream.write(0);
            tdsOutputStream.writeInt(this._bufSize);
            tdsOutputStream.write(SPARE);
            tdsOutputStream.writeStringLen(this._appName, 30);
            tdsOutputStream.writeStringLen(this._serviceName, 30);
            this.prepareRemPwd(tdsOutputStream);
            tdsOutputStream.writeStringLen(this._remPw, 255);
            tdsOutputStream.write(TDSVERSION);
            tdsOutputStream.writeStringLen(PROGNAME, 10);
            tdsOutputStream.write(this._progVers);
            tdsOutputStream.write(0);
            tdsOutputStream.write(this._lflt4);
            tdsOutputStream.write(this._ldate4);
            tdsOutputStream.writeStringLen(this._language, 30);
            tdsOutputStream.write(0);
            tdsOutputStream.write(OLDSECURE);
            tdsOutputStream.write(this._lseclogin);
            tdsOutputStream.write(0);
            tdsOutputStream.write(this._lhalogin);
            tdsOutputStream.write(this._lhasessionid);
            tdsOutputStream.write(SECSPARE);
            tdsOutputStream.writeStringLen(this._charset, 30);
            tdsOutputStream.write(1);
            tdsOutputStream.writeStringLen(this._packetSize, 6);
            tdsOutputStream.write(DUMMY);
        }
        catch (IOException iOException) {
            LoginToken.writeSQE(iOException);
        }
    }

    protected void prepareRemPwd(TdsOutputStream tdsOutputStream) throws IOException {
        if (this._encPwd) {
            this._remPw = null;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._remPw == null) {
            stringBuffer.append('\u0000');
            stringBuffer.append((char)tdsOutputStream.getStringByteLen(this._password));
            stringBuffer.append(this._password);
        } else {
            char c = '\u0000';
            int n = 0;
            char[] cArray = new char[256];
            int n2 = this._remPw.length();
            char[] cArray2 = new char[n2];
            this._remPw.getChars(0, n2, cArray2, 0);
            while (n < n2 && (c = cArray2[n++]) != ',') {
                if (c != '\\') continue;
                ++n;
            }
            while (n < n2) {
                int n3 = 0;
                while ((c = cArray2[n++]) != ',') {
                    if (c == '\\') {
                        Debug.asrt(this, n < n2);
                        c = cArray2[n++];
                    }
                    cArray[n3++] = c;
                    if (n < n2) continue;
                }
                if (n3 == 0) {
                    stringBuffer.append('\u0000');
                } else {
                    String string = new String(cArray, 0, n3);
                    stringBuffer.append((char)tdsOutputStream.getStringByteLen(string));
                    stringBuffer.append(string);
                }
                if (cArray2[n - 1] != ',' || n < n2) continue;
                stringBuffer.append('\u0000');
            }
        }
        this._remPw = stringBuffer.toString();
    }
}

