/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.SecureRandom;

public class Base64Tools {
    private static char[] encoding = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static void encode(InputStream inputStream, Writer writer, boolean bl) throws IOException {
        int n;
        byte[] byArray = new byte[3];
        int n2 = 0;
        while ((n = Base64Tools.fillEncodeBuffer(byArray, inputStream)) != 0) {
            if (n2 >= 73 && bl) {
                writer.write(10);
                n2 = 0;
            }
            if (n == 3) {
                writer.write(Base64Tools.getEncoded1(byArray));
                writer.write(Base64Tools.getEncoded2(byArray));
                writer.write(Base64Tools.getEncoded3(byArray));
                writer.write(Base64Tools.getEncoded4(byArray));
            } else if (n == 2) {
                writer.write(Base64Tools.getEncoded1(byArray));
                writer.write(Base64Tools.getEncoded2(byArray));
                writer.write(Base64Tools.getEncoded3(byArray));
                writer.write(61);
            } else if (n == 1) {
                writer.write(Base64Tools.getEncoded1(byArray));
                writer.write(Base64Tools.getEncoded2(byArray));
                writer.write(61);
                writer.write(61);
            }
            n2 += 4;
        }
    }

    public static void encode(InputStream inputStream, Writer writer) throws IOException {
        Base64Tools.encode(inputStream, writer, true);
    }

    public static void decode(Reader reader, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4];
        int n2 = 0;
        while ((n = reader.read()) != -1) {
            int n3 = Base64Tools.getDecodedValue(n);
            if (n3 == -1) continue;
            byArray[n2] = (byte)n3;
            if (byArray.length != ++n2) continue;
            Base64Tools.writeDecodedBytes(byArray, n2, outputStream);
            n2 = 0;
        }
        Base64Tools.writeDecodedBytes(byArray, n2, outputStream);
    }

    public static void generateRandomData(SecureRandom secureRandom, StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(encoding[secureRandom.nextInt(62)]);
        }
    }

    private static final int fillEncodeBuffer(byte[] byArray, InputStream inputStream) throws IOException {
        int n = inputStream.read(byArray);
        if (n == -1) {
            n = 0;
        } else if (n < 3) {
            int n2;
            int n3;
            for (n3 = n; n3 < 3 && (n2 = inputStream.read()) != -1; ++n3) {
                byArray[n3] = (byte)n2;
                ++n;
            }
            for (n3 = n; n3 < 3; ++n3) {
                byArray[n3] = 0;
            }
        }
        return n;
    }

    private static final int getDecodedValue(int n) throws IOException {
        if (n == 61) {
            return -1;
        }
        for (int i = 0; i < encoding.length; ++i) {
            if (encoding[i] != n) continue;
            return i;
        }
        throw new IOException("Invalid base64 data");
    }

    private static final void writeDecodedBytes(byte[] byArray, int n, OutputStream outputStream) throws IOException {
        if (n == 4) {
            outputStream.write(Base64Tools.getDecoded1(byArray));
            outputStream.write(Base64Tools.getDecoded2(byArray));
            outputStream.write(Base64Tools.getDecoded3(byArray));
        } else if (n == 3) {
            outputStream.write(Base64Tools.getDecoded1(byArray));
            outputStream.write(Base64Tools.getDecoded2(byArray));
        } else if (n == 2) {
            outputStream.write(Base64Tools.getDecoded1(byArray));
        } else if (n == 1) {
            throw new IOException("Invalid base64 data");
        }
    }

    private static final byte getDecoded1(byte[] byArray) {
        return (byte)((byArray[0] & 0x3F) << 2 | (byArray[1] & 0x30) >>> 4);
    }

    private static final byte getDecoded2(byte[] byArray) {
        return (byte)((byArray[1] & 0xF) << 4 | (byArray[2] & 0x3C) >>> 2);
    }

    private static final byte getDecoded3(byte[] byArray) {
        return (byte)((byArray[2] & 3) << 6 | byArray[3] & 0x3F);
    }

    private static final char getEncoded1(byte[] byArray) {
        return encoding[(byArray[0] & 0xFC) >> 2];
    }

    private static final char getEncoded2(byte[] byArray) {
        return encoding[(byArray[0] & 3) << 4 | (byArray[1] & 0xF0) >>> 4];
    }

    private static final char getEncoded3(byte[] byArray) {
        return encoding[(byArray[1] & 0xF) << 2 | (byArray[2] & 0xC0) >>> 6];
    }

    private static final char getEncoded4(byte[] byArray) {
        return encoding[byArray[2] & 0x3F];
    }
}

