/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybCallableStatement;
import com.sybase.jdbc4.jdbc.SybUrlProvider;
import com.sybase.jdbc4.jdbc.SybXAConnection;
import com.sybase.jdbc4.jdbc.SybXADataSource;
import com.sybase.jdbc4.jdbc.SybXAResource11;
import com.sybase.jdbc4.jdbc.SybXid;
import com.sybase.jdbc4.utils.HexConverts;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SybXAResource
implements XAResource {
    private static final int MAX_SAFE_RM_NAME_LENGTH = 74;
    protected static final String RPC_PREFIX = "{?= call ";
    private static final String RPC_POSTFIX = " (?, ?, ?)}";
    private static final String COMMIT_RPC = "{?= call $commitSybDtmXact (?, ?, ?)}";
    private static final String ROLLBACK_RPC = "{?= call $rollbackSybDtmXact (?, ?, ?)}";
    private static final String FORGET_RPC = "{?= call $forgetSybDtmXact (?, ?, ?)}";
    private static final String PREPARE_RPC = "{?= call $prepareSybDtmXact (?, ?, ?)}";
    private static final String BEGIN_RPC = "{?= call $beginSybDtmXact (?, ?, ?, ?)}";
    private static final String END_RPC = "{?= call $endSybDtmXact (?, ?, ?)}";
    private static final String STATUS_RPC = "{?= call $statusSybDtmXact (?, ?, ?)}";
    private static final String ATTACH_RPC = "{?= call $attachSybDtmXact (?, ?, ?)}";
    private static final String DETACH_RPC = "{?= call $detachSybDtmXact (?, ?, ?)}";
    private static final String TRANSACTION_STATUS = "{?= call sp_transactions (?)}";
    private static final String ENCODING_MAP = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@#";
    private static final String ENCODED_XID_DELIMITER = "_";
    private static final String ENCODED_RM_NAME_DELIMITER = ":";
    protected int _transProtocolType = 196608;
    private int _timeout = 0;
    private final SybXADataSource _xaDataSource;
    protected final SybXAConnection _xaConn;
    protected final String _resourceManagerID;
    protected boolean _localTransactionOK = true;

    protected SybXAResource(String string, SybXAConnection sybXAConnection, SybXADataSource sybXADataSource, SybUrlProvider sybUrlProvider) {
        this._xaConn = sybXAConnection;
        this._xaDataSource = sybXADataSource;
        this._resourceManagerID = string;
    }

    public static SybXAResource createSybXAResource(int n, String string, SybXAConnection sybXAConnection, SybXADataSource sybXADataSource, SybUrlProvider sybUrlProvider) {
        SybXAResource sybXAResource = null;
        switch (n) {
            case 2: {
                sybXAResource = new SybXAResource(string, sybXAConnection, sybXADataSource, sybUrlProvider);
                break;
            }
            case 1: {
                sybXAResource = new SybXAResource11(string, sybXAConnection, sybXADataSource, sybUrlProvider);
                break;
            }
        }
        return sybXAResource;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        int n = 0;
        if (bl) {
            this.sendRPC(ATTACH_RPC, xid, 1, 2);
            this.sendRPC(END_RPC, xid, 2);
            n = 32;
        }
        this.sendRPC(COMMIT_RPC, xid, 100, n);
        this._localTransactionOK = true;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        if (this.isLocalTransactionOK()) {
            try {
                this._xaConn.endLocalTransaction();
                if (this._localTransactionOK) {
                    ErrorMessage.raiseWarning("01S08");
                }
            }
            catch (SQLException sQLException) {
                this._xaConn.chainWarnings(sQLException);
            }
            this._localTransactionOK = false;
        }
        if ((n & 0x8200000) == 0) {
            this.sendRPC(BEGIN_RPC, xid, 1, 16);
        } else {
            int n2 = this.sendRPC(ATTACH_RPC, xid, 1);
            if ((n & 0x8000000) != 0 && n2 != 3 || (n & 0x200000) != 0 && n2 == 101) {
                this.sendRPC(DETACH_RPC, xid, n2);
                throw new XAException(-6);
            }
        }
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        int n2 = 2;
        if ((n & 0x2000000) != 0) {
            n2 = 3;
        } else if ((n & 0x20000000) != 0) {
            n2 = 101;
        }
        this.sendRPC(DETACH_RPC, xid, n2);
        this._localTransactionOK = true;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.sendRPC(FORGET_RPC, xid, 102);
        this._localTransactionOK = true;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this._localTransactionOK = false;
        this.sendRPC(ATTACH_RPC, xid, 1, 2);
        this.sendRPC(DETACH_RPC, xid, 2, 4);
        int n = this.sendRPC(PREPARE_RPC, xid, 7);
        if (n == -256) {
            this._localTransactionOK = true;
        }
        return n == -256 ? 3 : 0;
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        Object object;
        Vector<SybXid> vector = new Vector<SybXid>();
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        if ((n & 0x1800000) == 0 && n != 0) {
            throw new XAException(-5);
        }
        boolean bl = false;
        if ((n & 0x1000000) != 0) {
            bl = true;
        }
        if (bl) {
            try {
                callableStatement = this._xaConn.prepareInternalCall(TRANSACTION_STATUS);
                callableStatement.setString(2, "xa_recover");
                resultSet = callableStatement.executeQuery();
                while (resultSet.next()) {
                    object = resultSet.getString("xactname");
                    vector.add(this.dtmDecode((String)object));
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(-3);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        object = new Xid[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.sendRPC(ROLLBACK_RPC, xid, 101);
        this._localTransactionOK = true;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = false;
        if (xAResource instanceof SybXAResource) {
            bl = this._resourceManagerID.equals(((SybXAResource)xAResource)._resourceManagerID);
        }
        return bl;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this._timeout;
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this._timeout = n;
        return false;
    }

    protected void close() {
    }

    protected boolean isLocalTransactionOK() {
        return this._localTransactionOK;
    }

    private int sendRPC(String string, Xid xid, int n) throws XAException {
        return this.sendRPC(string, xid, this._transProtocolType, n, 0);
    }

    private final int sendRPC(String string, Xid xid, int n, int n2) throws XAException {
        return this.sendRPC(string, xid, this._transProtocolType, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int sendRPC(String string, Xid xid, int n, int n2, int n3) throws XAException {
        int n4;
        block21: {
            n4 = 0;
            SybCallableStatement sybCallableStatement = null;
            SQLException sQLException = null;
            try {
                sybCallableStatement = (SybCallableStatement)this._xaConn.prepareInternalCall(string);
                sybCallableStatement.registerOutParameter(1, 4);
                sybCallableStatement.setString(2, this.dtmEncode(xid));
                sybCallableStatement.setParameterName(2, "@name");
                sybCallableStatement.setInt(3, n2);
                sybCallableStatement.setParameterName(3, "@status");
                sybCallableStatement.setInt(4, n3);
                sybCallableStatement.setParameterName(4, "@flags");
                if (string == BEGIN_RPC) {
                    sybCallableStatement.setInt(5, n);
                    sybCallableStatement.setParameterName(5, "@mode");
                }
                sybCallableStatement.execute();
                n4 = sybCallableStatement.getInt(1);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return (int)sQLException;
            }
            finally {
                try {
                    if (sybCallableStatement != null) {
                        sybCallableStatement.close();
                    }
                }
                catch (SQLException sQLException3) {
                    if (sQLException != null) {
                        throw new XAException(-3);
                    }
                }
                finally {
                    if (sQLException == null) break block21;
                    throw new XAException(-3);
                }
            }
        }
        this.verifyReturnCode(n4, n2);
        return n4;
    }

    private final void verifyReturnCode(int n, int n2) throws XAException {
        if (n < 0) {
            int n3 = 0;
            String string = null;
            boolean bl = true;
            switch (n) {
                case -1: {
                    n3 = -3;
                    break;
                }
                case -2: {
                    n3 = -4;
                    break;
                }
                case -3: {
                    n3 = -8;
                    break;
                }
                case -4: {
                    n3 = -7;
                    break;
                }
                case -5: {
                    n3 = -5;
                    break;
                }
                case -6: {
                    n3 = -6;
                    break;
                }
                case -128: {
                    if (n2 == 101) {
                        n3 = -4;
                        break;
                    }
                    n3 = -6;
                    break;
                }
                case -256: {
                    bl = false;
                    break;
                }
                default: {
                    string = "Unrecognized return code from server: " + n;
                }
            }
            if (bl) {
                if (string != null) {
                    throw new XAException(string);
                }
                throw new XAException(n3);
            }
        }
    }

    protected final String dtmEncode(Xid xid) throws XAException {
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        if (byArray.length > 64 || byArray2.length > 64) {
            throw new XAException(-4);
        }
        String string = "";
        string = string + HexConverts.hexConvert(xid.getFormatId(), 4) + ENCODED_XID_DELIMITER;
        string = string + SybXAResource.jjEncode(byArray) + ENCODED_XID_DELIMITER;
        string = string + SybXAResource.jjEncode(byArray2);
        return string;
    }

    protected final SybXid dtmDecode(String string) {
        int n = string.indexOf(ENCODED_XID_DELIMITER);
        int n2 = string.indexOf(ENCODED_XID_DELIMITER, n + 1);
        int n3 = string.indexOf(ENCODED_RM_NAME_DELIMITER, n2);
        SybXid sybXid = new SybXid(Integer.parseInt(string.substring(0, n), 16), SybXAResource.jjDecode(string.substring(n + 1, n2)), SybXAResource.jjDecode(string.substring(n2 + 1, string.length())));
        return sybXid;
    }

    private static final String jjEncode(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length * 4 / 3 + (byArray.length % 3 == 0 ? 0 : 1);
        char[] cArray = new char[n3];
        int n4 = 0;
        for (n2 = 0; n2 < byArray.length - 2; n2 += 3) {
            n = byArray[n2] >> 2 & 0x3F;
            cArray[n4++] = ENCODING_MAP.charAt(n);
            n = (byArray[n2] << 4 | byArray[n2 + 1] >> 4 & 0xF) & 0x3F;
            cArray[n4++] = ENCODING_MAP.charAt(n);
            n = (byArray[n2 + 1] << 2 | byArray[n2 + 2] >> 6 & 3) & 0x3F;
            cArray[n4++] = ENCODING_MAP.charAt(n);
            n = byArray[n2 + 2] & 0x3F;
            cArray[n4++] = ENCODING_MAP.charAt(n);
        }
        switch (byArray.length - n2) {
            case 2: {
                n = byArray[n2] >> 2 & 0x3F;
                cArray[n4++] = ENCODING_MAP.charAt(n);
                n = (byArray[n2] << 4 | byArray[n2 + 1] >> 4 & 0xF) & 0x3F;
                cArray[n4++] = ENCODING_MAP.charAt(n);
                n = byArray[n2 + 1] << 2 & 0x3F;
                cArray[n4] = ENCODING_MAP.charAt(n);
                break;
            }
            case 1: {
                n = byArray[n2] >> 2 & 0x3F;
                cArray[n4++] = ENCODING_MAP.charAt(n);
                n = byArray[n2] << 4 & 0x3F;
                cArray[n4] = ENCODING_MAP.charAt(n);
                break;
            }
            case 0: {
                --n4;
            }
        }
        return new String(cArray);
    }

    private static final byte[] jjDecode(String string) {
        int n;
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length * 3 / 4;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        for (n3 = 0; n3 < cArray.length - 3; n3 += 4) {
            n2 = ENCODING_MAP.indexOf(cArray[n3]) << 2;
            n = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
            byArray[n5++] = (byte)(n2 | n);
            n2 = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0xF) << 4;
            n = (ENCODING_MAP.indexOf(cArray[n3 + 2]) & 0x3E) >> 2;
            byArray[n5++] = (byte)(n2 | n);
            n2 = (ENCODING_MAP.indexOf(cArray[n3 + 2]) & 3) << 6;
            n = ENCODING_MAP.indexOf(cArray[n3 + 3]) & 0x3F;
            byArray[n5++] = (byte)(n2 | n);
        }
        switch (cArray.length - n3) {
            case 3: {
                n2 = (ENCODING_MAP.indexOf(cArray[n3]) & 0x3F) << 2;
                n = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
                byArray[n5++] = (byte)(n2 | n);
                n2 = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0xF) << 4;
                n = (ENCODING_MAP.indexOf(cArray[n3 + 2]) & 0x3E) >> 2;
                byArray[n5] = (byte)(n2 | n);
                break;
            }
            case 2: {
                n2 = (ENCODING_MAP.indexOf(cArray[n3]) & 0x3F) << 2;
                n = (ENCODING_MAP.indexOf(cArray[n3 + 1]) & 0x30) >> 4;
                byArray[n5] = (byte)(n2 | n);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                --n5;
            }
        }
        return byArray;
    }
}

