/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbcx.SybSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SybSSLSocketFactory
extends SSLSocketFactory
implements SybSocketFactory {
    private boolean _trustAllCert = true;
    private Object _sslJCEProvider = null;
    private String _hostnameVerifier = null;
    private String _protocol = "TLSv1";

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        try {
            this.initProvider();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SSLContext sSLContext = null;
        SSLSocket sSLSocket = null;
        if (this._trustAllCert) {
            try {
                sSLContext = SSLContext.getInstance(this._protocol);
                sSLContext.init(null, this.getTrustManager(), new SecureRandom());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (KeyManagementException keyManagementException) {
                // empty catch block
            }
            sSLSocket = (SSLSocket)sSLContext.getSocketFactory().createSocket(string, n);
        } else {
            sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string, n);
        }
        HttpsURLConnection.setDefaultHostnameVerifier(this.getHostnameVerifier());
        this.setProtocol(sSLSocket);
        sSLSocket.setSoTimeout(DriverManager.getLoginTimeout());
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    @Override
    public Socket createSocket(String string, int n, Properties properties) throws IOException, UnknownHostException {
        if (properties != null) {
            this._hostnameVerifier = properties.getProperty("SSL_HOSTNAME_IN_CERT");
            this._trustAllCert = new Boolean(properties.getProperty("SSL_TRUST_ALL_CERTS", "true"));
            this._sslJCEProvider = properties.getProperty("JCE_PROVIDER_CLASS");
        }
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        int n2 = 1;
        while (true) {
            if ((string2 = properties.getProperty("CIPHER_SUITES_" + n2++)) == null) {
                if (n2 > 2) break;
                return this.createSocket(string, n);
            }
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        try {
            this.initProvider();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SSLSocket sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string, n);
        sSLSocket.setEnabledCipherSuites((String[])objectArray);
        this.setProtocol(sSLSocket);
        sSLSocket.setSoTimeout(DriverManager.getLoginTimeout());
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    protected void setProtocol(SSLSocket sSLSocket) {
        String[] stringArray = new String[]{"TLSv1"};
        sSLSocket.setEnabledProtocols(stringArray);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        Debug.notImplemented(this, "getDefaultCipherSuites()");
        return null;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        Debug.notImplemented(this, "getSupportedCipherSuites()");
        return null;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) {
        Debug.notImplemented(this, "java.net.Socket createSocket(java.lang.String host, int port, java.net.InetAddress clientAddress, int clientPort)");
        return null;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) {
        Debug.notImplemented(this, "java.net.Socket createSocket(java.net.InetAddress host, int port");
        return null;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        Debug.notImplemented(this, "java.net.Socket createSocket(java.net.InetAddress host, int port, java.net.InetAddress clientAddress, int clientPort)");
        return null;
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) {
        Debug.notImplemented(this, "java.net.Socket createSocket(String host, int port, boolean autoClose");
        return null;
    }

    private void initProvider() throws SQLException {
        Provider provider = null;
        if (this._sslJCEProvider != null) {
            if (this._sslJCEProvider instanceof String) {
                try {
                    provider = (Provider)Class.forName((String)this._sslJCEProvider).newInstance();
                }
                catch (Exception exception) {
                    ErrorMessage.raiseError("JZ028");
                }
            } else {
                provider = (Provider)this._sslJCEProvider;
            }
            Security.addProvider(provider);
        }
    }

    private TrustManager[] getTrustManager() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        return trustManagerArray;
    }

    private HostnameVerifier getHostnameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return string.equalsIgnoreCase(sSLSession.getPeerHost());
            }
        };
        return hostnameVerifier;
    }
}

