/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.SybConnection;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.utils.LogUtil;
import com.sybase.jdbc4.utils.SybVersion;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybDatabaseMetaData
implements DatabaseMetaData {
    private static Logger LOG = Logger.getLogger(SybDatabaseMetaData.class.getName());
    private static volatile long _logIdCounter = 0L;
    private String _logId = null;
    private SybConnection _conn;
    private MdaManager _mda;
    private int _outerJoinEscapeSupport;
    private int _isCaseSensitive;
    private int _dbMajorVersion = -1;
    private int _dbMinorVersion = -1;
    private int _jdbcMajorVersion = -1;
    private int _jdbcMinorVersion = -1;
    protected static final int UNKNOWN = -1;
    protected static final int NO = 0;
    protected static final int YES = 1;
    private static final String JAVA_OBJECT_NAME = "JAVA_OBJECT";
    private static final String STRUCT_NAME = "STRUCT";
    private static final String DISTINCT_NAME = "DISTINCT";
    private static final String TABLES = "TABLES";
    private static final String COLUMNS = "COLUMNS";
    private static final String ALLPROCSCALLABLE = "ALLPROCSCALLABLE";
    private static final String ALLTABLESSELECTABLE = "ALLTABLESSELECTABLE";
    private static final String ISREADONLY = "ISREADONLY";
    private static final String NULLSORTING = "NULLSORTING";
    private static final String USERNAME = "USERNAME";
    private static final String PRODUCTNAME = "PRODUCTNAME";
    private static final String GET_IDENTITY = "GET_IDENTITY";
    private static final String PRODUCTVERSION = "PRODUCTVERSION";
    private static final String FILEUSAGE = "FILEUSAGE";
    private static final String IDENTIFIERCASES = "IDENTIFIERCASES";
    private static final String IDENTIFIERQUOTE = "IDENTIFIERQUOTE";
    private static final String SQLKEYWORDS = "SQLKEYWORDS";
    private static final String NUMERICFUNCTIONLIST = "NUMERICFUNCTIONLIST";
    private static final String STRINGFUNCTIONLIST = "STRINGFUNCTIONLIST";
    private static final String SYSTEMFUNCTIONLIST = "SYSTEMFUNCTIONLIST";
    private static final String TIMEDATEFUNCTIONLIST = "TIMEDATEFUNCTIONLIST";
    private static final String SEARCHSTRING = "SEARCHSTRING";
    private static final String EXTRANAMECHARS = "EXTRANAMECHARS";
    private static final String ALTERTABLESUPPORT = "ALTERTABLESUPPORT";
    private static final String COLUMNALIASING = "COLUMNALIASING";
    private static final String NULLPLUSNONNULL = "NULLPLUSNONNULL";
    private static final String CONVERTSUPPORT = "CONVERTSUPPORT";
    private static final String CONVERTMAP = "CONVERTMAP";
    private static final String CORRELATIONNAMES = "CORRELATIONNAMES";
    private static final String ORDERBYSUPPORT = "ORDERBYSUPPORT";
    private static final String GROUPBYSUPPORT = "GROUPBYSUPPORT";
    private static final String LIKEESCAPECLAUSE = "LIKEESCAPECLAUSE";
    private static final String MULTIPLERESULTSETS = "MULTIPLERESULTSETS";
    private static final String MULTIPLETRANSACTIONS = "MULTIPLETRANSACTIONS";
    private static final String NONNULLABLECOLUMNS = "NONNULLABLECOLUMNS";
    private static final String SQLGRAMMAR = "SQLGRAMMAR";
    private static final String ANSI92LEVEL = "ANSI92LEVEL";
    private static final String INTEGRITYENHANCEMENT = "INTEGRITYENHANCEMENT";
    private static final String OUTERJOINS = "OUTERJOINS";
    private static final String SCHEMATERM = "SCHEMATERM";
    private static final String PROCEDURETERM = "PROCEDURETERM";
    private static final String CATALOGTERM = "CATALOGTERM";
    private static final String CATALOGSEPARATOR = "CATALOGSEPARATOR";
    private static final String CATALOGATSTART = "CATALOGATSTART";
    private static final String SCHEMASUPPORT = "SCHEMASUPPORT";
    private static final String CATALOGSUPPORT = "CATALOGSUPPORT";
    private static final String POSITIONEDDELETE = "POSITIONEDDELETE";
    private static final String POSITIONEDUPDATE = "POSITIONEDUPDATE";
    private static final String SELECTFORUPDATE = "SELECTFORUPDATE";
    private static final String STOREDPROCEDURES = "STOREDPROCEDURES";
    private static final String SUBQUERIES = "SUBQUERIES";
    private static final String UNIONSUPPORT = "UNIONSUPPORT";
    private static final String CURSORTRANSACTIONS = "CURSORTRANSACTIONS";
    private static final String STATEMENTTRANSACTIONS = "STATEMENTTRANSACTIONS";
    private static final String MAXBINARYLITERALLENGTH = "MAXBINARYLITERALLENGTH";
    private static final String MAXCHARLITERALLENGTH = "MAXCHARLITERALLENGTH";
    private static final String COLUMNINFO = "COLUMNINFO";
    private static final String MAXCONNECTIONS = "MAXCONNECTIONS";
    private static final String MAXINDEXLENGTH = "MAXINDEXLENGTH";
    private static final String MAXNAMELENGTHS = "MAXNAMELENGTHS";
    private static final String ROWINFO = "ROWINFO";
    private static final String STATEMENTINFO = "STATEMENTINFO";
    private static final String TABLEINFO = "TABLEINFO";
    private static final String TRANSACTIONSUPPORT = "TRANSACTIONSUPPORT";
    private static final String TRANSACTIONLEVELDEFAULT = "TRANSACTIONLEVELDEFAULT";
    private static final String TRANSACTIONLEVELS = "TRANSACTIONLEVELS";
    private static final String TRANSACTIONDATADEFINFO = "TRANSACTIONDATADEFINFO";
    private static final String PROCEDURES = "PROCEDURES";
    private static final String FUNCTIONS = "FUNCTIONS";
    private static final String PROCEDURECOLUMNS = "PROCEDURECOLUMNS";
    private static final String FUNCTIONCOLUMNS = "FUNCTIONCOLUMNS";
    private static final String SCHEMAS = "SCHEMAS";
    private static final String SCHEMAS_CTS = "SCHEMAS_CTS";
    private static final String CATALOGS = "CATALOGS";
    private static final String CATALOGS_CTS = "CATALOGS_CTS";
    private static final String TABLETYPES = "TABLETYPES";
    private static final String COLUMNPRIVILEGES = "COLUMNPRIVILEGES";
    private static final String TABLEPRIVILEGES = "TABLEPRIVILEGES";
    private static final String ROWIDENTIFIERS = "ROWIDENTIFIERS";
    private static final String VERSIONCOLUMNS = "VERSIONCOLUMNS";
    private static final String PRIMARYKEYS = "PRIMARYKEYS";
    private static final String IMPORTEDKEYS = "IMPORTEDKEYS";
    private static final String EXPORTEDKEYS = "EXPORTEDKEYS";
    private static final String KEYCROSSREFERENCE = "KEYCROSSREFERENCE";
    private static final String TYPEINFO = "TYPEINFO";
    private static final String TYPEINFO_CTS = "TYPEINFO_CTS";
    private static final String INDEXINFO = "INDEXINFO";
    private static final String OWNUPDATESAREVISIBLE = "OWNUPDATESAREVISIBLE";
    private static final String OWNDELETESAREVISIBLE = "OWNDELETESAREVISIBLE";
    private static final String OWNINSERTSAREVISIBLE = "OWNINSERTSAREVISIBLE";
    private static final String OTHERSUPDATESAREVISIBLE = "OTHERSUPDATESAREVISIBLE";
    private static final String OTHERSDELETESAREVISIBLE = "OTHERSDELETESAREVISIBLE";
    private static final String OTHERSINSERTSAREVISIBLE = "OTHERSINSERTSAREVISIBLE";
    private static final String UPDATESAREDETECTED = "UPDATESAREDETECTED";
    private static final String DELETESAREDETECTED = "DELETESAREDETECTED";
    private static final String INSERTSAREDETECTED = "INSERTSAREDETECTED";
    private static final String SUPPORTSBATCHUPDATES = "SUPPORTSBATCHUPDATES";
    private static final String SUPPORTSRESULTSETTYPE = "SUPPORTSRESULTSETTYPE";
    private static final String READONLYCONCURRENCY = "READONLYCONCURRENCY";
    private static final String UPDATABLECONCURRENCY = "UPDATABLECONCURRENCY";
    private static final String UDTS = "UDTS";
    private static final String SUPERTYPES = "SUPERTYPES";
    private static final String SUPERTABLES = "SUPERTABLES";
    private static final String ATTRIBUTES = "ATTRIBUTES";
    private static final String EXECBATCHUPDATESINLOOP = "EXECBATCHUPDATESINLOOP";
    private static final String EXECPARAMETERIZEDBATCHINLOOP = "EXECPARAMETERIZEDBATCHINLOOP";
    private static final String MAXBATCHPARAMS = "MAXBATCHPARAMS";
    private static final String ISCASESENSITIVE = "ISCASESENSITIVE";
    private static final String CLASSFORNAME = "CLASSFORNAME";
    private static final String JARFORCLASS = "JARFORCLASS";
    private static final String JARBYNAME = "JARBYNAME";
    private static final String CLASSESINJAR = "CLASSESINJAR";
    private static final String CANRETURNJARS = "CANRETURNJARS";
    private static final String XACOORDINATORTYPE = "XACOORDINATORTYPE";
    private static final String SAVEPOINTSUPPORT = "SAVEPOINTSUPPORT";
    private static final String JDBCMAJORVERSION = "JDBCMAJORVERSION";
    private static final String JDBCMINORVERSION = "JDBCMINORVERSION";
    public static final String IS_LOGGED_BCP_SUPPORTED = "IS_LOGGED_BCP_SUPPORTED";
    public static final String GETCLIENTINFOPROPERTIES = "GETCLIENTINFOPROPERTIES";
    private int _execBatchInLoop = -1;
    private int _execParameterizedBatchInLoop = -1;
    private int _batchSupport = -1;
    private int _maxParamsPerBatch = -1;
    private Boolean _isFastLoggedBCPSupported = null;

    SybDatabaseMetaData(String string, SybConnection sybConnection) throws SQLException {
        this._logId = string + "_Db" + _logIdCounter++;
        this._conn = sybConnection;
        this._mda = sybConnection.getMDA(null);
        this._outerJoinEscapeSupport = -1;
        this._isCaseSensitive = -1;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " allProceduresAreCallable()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALLPROCSCALLABLE);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " allTablesAreSelectable()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALLTABLESSELECTABLE);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public String getURL() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getURL()");
        }
        return this._conn._url;
    }

    @Override
    public String getUserName() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getUserName()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(USERNAME);
        return this.returnString(preparedStatement);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isReadOnly()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ISREADONLY);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " nullsAreSortedHigh()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " nullsAreSortedLow()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " nullsAreSortedAtStart()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " nullsAreSortedAtEnd()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLSORTING);
        return this.returnBoolean(preparedStatement, 4);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDatabaseProductName()");
        }
        if (this._conn.getDatabaseProductName() == null) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(PRODUCTNAME);
            this._conn.setDatabaseProductName(this.returnString(preparedStatement));
        }
        return this._conn.getDatabaseProductName();
    }

    public String getIdentityQuery() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GET_IDENTITY);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDatabaseProductVersion()");
        }
        if (this._conn.getDatabaseProductVersion() == null) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(PRODUCTVERSION);
            this._conn.setDatabaseProductVersion(this.returnString(preparedStatement));
        }
        return this._conn.getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDriverName()");
        }
        return "jConnect (TM) for JDBC (TM)";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDriverVersion()");
        }
        return SybVersion.VERSION_STRING;
    }

    @Override
    public int getDriverMajorVersion() {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDriverMajorVersion()");
        }
        return SybVersion.MAJOR_VERSION;
    }

    public boolean execBatchUpdatesInLoop() throws SQLException {
        if (this._execBatchInLoop == -1) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(EXECBATCHUPDATESINLOOP);
                this._execBatchInLoop = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._execBatchInLoop = 0;
            }
        }
        return this._execBatchInLoop == 1;
    }

    public boolean execParameterizedBatchUpdatesInLoop() throws SQLException {
        if (this._execParameterizedBatchInLoop == -1) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(EXECPARAMETERIZEDBATCHINLOOP);
                this._execParameterizedBatchInLoop = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._execParameterizedBatchInLoop = 0;
            }
        }
        return this._execParameterizedBatchInLoop == 1;
    }

    protected boolean isFastLoggedBCPSupported() throws SQLException {
        if (this._isFastLoggedBCPSupported == null) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(IS_LOGGED_BCP_SUPPORTED);
                this._isFastLoggedBCPSupported = this.returnBoolean(preparedStatement, 1);
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._isFastLoggedBCPSupported = false;
            }
        }
        return this._isFastLoggedBCPSupported;
    }

    public int getMaxParamsPerBatch() throws SQLException {
        if (this._maxParamsPerBatch == -1) {
            try {
                PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXBATCHPARAMS);
                this._maxParamsPerBatch = this.returnInt(preparedStatement, 1);
            }
            catch (SQLException sQLException) {
                if (!"JZ0SJ".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
                this._maxParamsPerBatch = 255;
            }
        }
        return this._maxParamsPerBatch;
    }

    @Override
    public int getDriverMinorVersion() {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDriverMinorVersion()");
        }
        return SybVersion.MINOR_VERSION;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " usesLocalFiles()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(FILEUSAGE);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " usesLocalFilePerTable()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(FILEUSAGE);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsMixedCaseIdentifiers()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " storesUpperCaseIdentifiers()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " storesLowerCaseIdentifiers()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " storesMixedCaseIdentifiers()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 4);
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsMixedCaseQuotedIdentifiers()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 5);
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " storesUpperCaseQuotedIdentifiers()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 6);
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " storesLowerCaseQuotedIdentifiers()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 7);
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERCASES);
        return this.returnBoolean(preparedStatement, 8);
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getIdentifierQuoteString()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IDENTIFIERQUOTE);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getSQLKeywords()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLKEYWORDS);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getNumericFunctions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NUMERICFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getStringFunctions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STRINGFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getSystemFunctions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SYSTEMFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getTimeDateFunctions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TIMEDATEFUNCTIONLIST);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getSearchStringEscape()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SEARCHSTRING);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getExtraNameCharacters()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(EXTRANAMECHARS);
        return this.returnString(preparedStatement);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsAlterTableWithAddColumn()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALTERTABLESUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsAlterTableWithDropColumn()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ALTERTABLESUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsColumnAliasing()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNALIASING);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " nullPlusNonNullsNull()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NULLPLUSNONNULL);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsConvert()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CONVERTSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " supportsConvert(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " supportsConvert(int, int)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CONVERTMAP);
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsTableCorrelationNames()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CORRELATIONNAMES);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsDifferentTableCorrelationNames()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CORRELATIONNAMES);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsExpressionsInOrderBy()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ORDERBYSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsOrderByUnrelated()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ORDERBYSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsGroupBy()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsGroupByUnrelated()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsGroupByBeyondSelect()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GROUPBYSUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsLikeEscapeClause()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(LIKEESCAPECLAUSE);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsMultipleResultSets()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MULTIPLERESULTSETS);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsMultipleTransactions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MULTIPLETRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsNonNullableColumns()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(NONNULLABLECOLUMNS);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsMinimumSQLGrammar()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsCoreSQLGrammar()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsExtendedSQLGrammar()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SQLGRAMMAR);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsANSI92EntryLevelSQL()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsANSI92IntermediateSQL()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsANSI92FullSQL()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ANSI92LEVEL);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsIntegrityEnhancementFacility()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(INTEGRITYENHANCEMENT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsOuterJoins()");
        }
        if (this._outerJoinEscapeSupport == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
            this._outerJoinEscapeSupport = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
        }
        return this._outerJoinEscapeSupport == 1;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsFullOuterJoins()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsLimitedOuterJoins()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 3);
    }

    protected boolean supportsOuterJoinEscapeSyntax() throws SQLException {
        if (this._mda._version < 1) {
            return this.getDatabaseProductName().equals("Sybase SQL Anywhere");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(OUTERJOINS);
        return this.returnBoolean(preparedStatement, 4);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getSchemaTerm()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMATERM);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getProcedureTerm()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURETERM);
        return this.returnString(preparedStatement);
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getCatalogTerm()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGTERM);
        return this.returnString(preparedStatement);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isCatalogAtStart()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGATSTART);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getCatalogSeparator()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSEPARATOR);
        return this.returnString(preparedStatement);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSchemasInDataManipulation()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSchemasInProcedureCalls()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSchemasInTableDefinitions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSchemasInIndexDefinitions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 4);
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSchemasInPrivilegeDefinitions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SCHEMASUPPORT);
        return this.returnBoolean(preparedStatement, 5);
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsCatalogsInDataManipulation()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsCatalogsInProcedureCalls()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsCatalogsInTableDefinitions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsCatalogsInIndexDefinitions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 4);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsCatalogsInPrivilegeDefinitions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CATALOGSUPPORT);
        return this.returnBoolean(preparedStatement, 5);
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsPositionedDelete()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(POSITIONEDDELETE);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsPositionedUpdate()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(POSITIONEDUPDATE);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSelectForUpdate()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SELECTFORUPDATE);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsStoredProcedures()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STOREDPROCEDURES);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSubqueriesInComparisons()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSunqueriesInExists()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSubqueriesInIns()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsSubqueriesInQuantifieds()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 4);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsCorrelatedSubqueries()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUBQUERIES);
        return this.returnBoolean(preparedStatement, 5);
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsUnion()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UNIONSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsUnionAll()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UNIONSUPPORT);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsOpenCursorsAcrossCommit()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CURSORTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsOpenCursorsAcrossRollback()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CURSORTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsOpenStatementsAcrossCommit()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsOpenStatementsAcrossRollback()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTTRANSACTIONS);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxBinaryLiteralLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXBINARYLITERALLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxCharLiteralLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXCHARLITERALLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxColumnNameLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxColumnsInGroupBy()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 2);
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxColumnsInIndex()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 3);
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxColumnsInOrderBy()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 4);
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxColumnsInSelect()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 5);
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxColumnsInTable()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNINFO);
        return this.returnInt(preparedStatement, 6);
    }

    @Override
    public int getMaxConnections() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxConnections()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXCONNECTIONS);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxIndexLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXINDEXLENGTH);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxCursorNameLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxUserNameLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 2);
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxSchemaNameLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 3);
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxProcedureNameLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 4);
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxCatalogNameLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(MAXNAMELENGTHS);
        return this.returnInt(preparedStatement, 5);
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxRowSize()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWINFO);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " doesMaxRowSizeIncludeBlobs()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWINFO);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxStatementLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTINFO);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public int getMaxStatements() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxStatements()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(STATEMENTINFO);
        return this.returnInt(preparedStatement, 2);
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxTableNameLength()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEINFO);
        return this.returnInt(preparedStatement, 1);
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxTablesInSelect()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEINFO);
        return this.returnInt(preparedStatement, 2);
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsTransactions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDefaultTransactionIsolation()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONLEVELDEFAULT);
        return this.returnInt(preparedStatement, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        boolean bl;
        block11: {
            if (LogUtil.isLoggingEnabled(LOG)) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer(this._logId + " supportsTransactionIsolationLevel(int = [" + n + "])");
                } else if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(this._logId + " supportsTransactionIsolationLevel(int)");
                }
            }
            PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONLEVELS);
            ResultSet resultSet = preparedStatement.executeQuery();
            bl = false;
            SQLException sQLException = null;
            try {
                if (resultSet.next()) {
                    int n2 = resultSet.getMetaData().getColumnCount();
                    for (int i = 1; i <= n2; ++i) {
                        if (resultSet.getInt(i) != n) continue;
                        bl = true;
                    }
                }
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return (boolean)sQLException;
            }
            finally {
                resultSet.close();
                preparedStatement.close();
                if (sQLException == null) break block11;
                throw sQLException;
            }
        }
        return bl;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsDataDefinitionAndDataManipulationTransactions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsDataManipulationTransactionsOnly()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 2);
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " defaultDefinitionCausesTransactionCommit()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 3);
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " dataDefinitionIgnoredInTransactions()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TRANSACTIONDATADEFINFO);
        return this.returnBoolean(preparedStatement, 4);
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getProcedures(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getProcedures(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        if (((SybPreparedStatement)preparedStatement)._paramCount >= 4) {
            preparedStatement.setInt(4, 4);
        }
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getProcedureColumns(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "], String = [" + string4 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getProcedureColumns(String, String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PROCEDURECOLUMNS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        if (((SybPreparedStatement)preparedStatement)._paramCount >= 6) {
            preparedStatement.setInt(5, 0);
            preparedStatement.setInt(6, 4);
        }
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, "getTables", new Object[]{string, string2, string3, stringArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "getTables", new Object[]{string, string2, string3, stringArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTables(String, String, String, String[])");
            }
        }
        if (stringArray == null) {
            stringBuffer = null;
        } else {
            stringBuffer = new StringBuffer("\"");
            for (int i = 0; i < stringArray.length && stringArray[i] != null && !stringArray[i].equals("null"); ++i) {
                stringBuffer.append("'" + stringArray[i] + "'");
            }
            stringBuffer = stringBuffer.append("\"");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLES, string);
        this.setStringParam(preparedStatement, string3, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string, 3);
        this.setStringParam(preparedStatement, stringBuffer == null ? null : stringBuffer.toString(), 4);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getClassForName(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CLASSFORNAME);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getJarForClass(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(JARFORCLASS);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getJarByName(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(JARBYNAME);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getClassesInJar(String string) throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CLASSESINJAR);
        this.setStringParam(preparedStatement, string, 1);
        return this.returnResults(preparedStatement);
    }

    public boolean canReturnJars() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(CANRETURNJARS);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getSchemas()");
        }
        PreparedStatement preparedStatement = null;
        if (this._conn._props.getBoolean(64)) {
            preparedStatement = this.getMetaDataAccessor(SCHEMAS_CTS);
            return this.returnResults(preparedStatement);
        }
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getCatalogs()");
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = this._conn._props.getBoolean(64) ? this.getMetaDataAccessor(CATALOGS_CTS) : this.getMetaDataAccessor(CATALOGS);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getTableTypes()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLETYPES);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getColumns(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "], String = [" + string4 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getColumns(String, String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNS, string);
        this.setStringParam(preparedStatement, string3, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string, 3);
        this.setStringParam(preparedStatement, string4, 4);
        if (((SybPreparedStatement)preparedStatement)._paramCount >= 5) {
            preparedStatement.setInt(5, 4);
        }
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getColumnPrivileges(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "], String = [" + string4 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getColumnPrivileges(String, String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(COLUMNPRIVILEGES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getTablePrivileges(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTablePrivileges(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(TABLEPRIVILEGES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBestRowIdentifier(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "], int = [" + n + "], boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBestRowIdentifier(String, String, String, int, boolean)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ROWIDENTIFIERS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        preparedStatement.setInt(4, n);
        preparedStatement.setBoolean(5, bl);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getVersionColumns(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getVersionColumns(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(VERSIONCOLUMNS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getPrimaryKeys(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getPrimaryKeys(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(PRIMARYKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getImportedKeys(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getImportedKeys(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(IMPORTEDKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getExportedKeys(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getExportedKeys(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(EXPORTEDKEYS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getCrossReference(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "], String = [" + string4 + "], String = [" + string5 + "], String = [" + string6 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getCrossReference(String, String, String," + " String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(KEYCROSSREFERENCE, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        this.setStringParam(preparedStatement, string5, 5);
        this.setStringParam(preparedStatement, string6, 6);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getTypeInfo()");
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = this._conn._props.getBoolean(64) ? this.getMetaDataAccessor(TYPEINFO_CTS) : this.getMetaDataAccessor(TYPEINFO);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getIndexInfo(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "], boolean = [" + bl + "], boolean = [" + bl2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getIndexInfo(String, String, String, boolean, boolean)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(INDEXINFO, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        preparedStatement.setBoolean(4, bl);
        preparedStatement.setBoolean(5, bl2);
        return this.returnResults(preparedStatement);
    }

    public boolean isCaseSensitive() throws SQLException {
        if (this._isCaseSensitive == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(ISCASESENSITIVE);
            this._isCaseSensitive = this.returnBoolean(preparedStatement, 1) ? 1 : 0;
        }
        return this._isCaseSensitive == 1;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportSavepoints()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SAVEPOINTSUPPORT);
        return this.returnBoolean(preparedStatement, 1);
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsNamedParameters()");
        }
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsMultipleOpenResults()");
        }
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsGetGeneratedKeys()");
        }
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSuperTypes(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSuperTypes(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUPERTYPES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSuperTables(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSuperTables(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(SUPERTABLES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getAttributes(String = [" + string + "], String = [" + string2 + ", String = " + string3 + "], String = [" + string4 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getAttributes(String, String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(ATTRIBUTES, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultHoldability()");
        }
        return 1;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " supportsResultSetHoldability(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " supportsResultSetHoldability(int)");
            }
        }
        if (n != 1 && n != 2) {
            ErrorMessage.raiseError("JZ0SW", String.valueOf(n));
        }
        return true;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getSQLStateType()");
        }
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDatabaseMajorVersion()");
        }
        if (this._dbMajorVersion == -1) {
            String string;
            String string2 = this.getDatabaseProductVersion();
            int n = string2.indexOf("/");
            if (n == -1) {
                string = string2;
                string2 = string2.substring(0, string2.indexOf("."));
                int n2 = (string = string.substring(string.indexOf(".") + 1, string.length())).indexOf(".");
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
            } else {
                string = string2 = string2.substring(string2.indexOf("/") + 1, string2.length());
                string2 = string2.substring(0, string2.indexOf("/")).substring(0, string2.indexOf("."));
                int n3 = (string = string.substring(string.indexOf(".") + 1, string.indexOf("/"))).indexOf(".");
                if (n3 >= 0) {
                    string = string.substring(0, n3);
                }
            }
            this._dbMajorVersion = Integer.valueOf(string2);
            this._dbMinorVersion = Integer.valueOf(string);
        }
        return this._dbMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getDatabaseMinorVersion()");
        }
        if (this._dbMinorVersion == -1) {
            this.getDatabaseMajorVersion();
        }
        return this._dbMinorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getJDBCMajorVersion()");
        }
        if (this._jdbcMajorVersion == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(JDBCMAJORVERSION);
            this._jdbcMajorVersion = this.returnInt(preparedStatement, 1);
        }
        return this._jdbcMajorVersion;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getJDBCMinorVersion()");
        }
        if (this._jdbcMinorVersion == -1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(JDBCMINORVERSION);
            this._jdbcMinorVersion = this.returnInt(preparedStatement, 1);
        }
        return this._jdbcMinorVersion;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " locatorsUpdateCopy()");
        }
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsStatementPooling()");
        }
        return false;
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " supportsResultSetType(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " supportsResultSetType(int)");
            }
        }
        return this.supportForResultSetType(SUPPORTSRESULTSETTYPE, n);
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " supportsResultSetConcurrency(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " supportsResultSetConcurrency(int, int)");
            }
        }
        switch (n2) {
            case 1007: {
                return this.supportForResultSetType(READONLYCONCURRENCY, n);
            }
            case 1008: {
                return this.supportForResultSetType(UPDATABLECONCURRENCY, n);
            }
        }
        ErrorMessage.raiseError("JZ0SO", "" + n2);
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " ownUpdatesAreVisible(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " ownUpdatesAreVisible(int)");
            }
        }
        return this.supportForResultSetType(OWNUPDATESAREVISIBLE, n);
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " ownDeletesAreVisible(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " ownDeletesAreVisible(int)");
            }
        }
        return this.supportForResultSetType(OWNDELETESAREVISIBLE, n);
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " ownInsertsAreVisible(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " ownInsertsAreVisible(int)");
            }
        }
        return this.supportForResultSetType(OWNINSERTSAREVISIBLE, n);
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " othersUpdatesAreVisible(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " othersUpdatesAreVisible(int)");
            }
        }
        return this.supportForResultSetType(OTHERSUPDATESAREVISIBLE, n);
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " othersDeletesAreVisible(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " othersDeletesAreVisible(int)");
            }
        }
        return this.supportForResultSetType(OTHERSDELETESAREVISIBLE, n);
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " othersInsertsAreVisible(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " othersInsertsAreVisible(int)");
            }
        }
        return this.supportForResultSetType(OTHERSINSERTSAREVISIBLE, n);
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updatesAreDetected(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updatesAreDetected(int)");
            }
        }
        return this.supportForResultSetType(UPDATESAREDETECTED, n);
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " deletesAreDetected(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " deletesAreDetected(int)");
            }
        }
        return this.supportForResultSetType(DELETESAREDETECTED, n);
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " insertsAreDetected(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " insertsAreDetected(int)");
            }
        }
        return this.supportForResultSetType(INSERTSAREDETECTED, n);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsBatchUpdates()");
        }
        if (this._batchSupport != 1) {
            PreparedStatement preparedStatement = this.getMetaDataAccessor(SUPPORTSBATCHUPDATES);
            boolean bl = this.returnBoolean(preparedStatement, 1);
            if (!bl) {
                this._batchSupport = 0;
                ErrorMessage.raiseError("JZ0BS");
            }
            this._batchSupport = 1;
        }
        return this._batchSupport == 1;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " getUDTs", new Object[]{string, string2, string3, nArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getUDTs", new Object[]{string, string2, string3, nArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getUDTs(String, String, String, int[])");
            }
        }
        String string4 = null;
        if (nArray != null) {
            string4 = "";
            block5: for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    string4 = string4 + ",";
                }
                switch (nArray[i]) {
                    case 2000: {
                        string4 = string4 + JAVA_OBJECT_NAME;
                        continue block5;
                    }
                    case 2002: {
                        string4 = string4 + STRUCT_NAME;
                        continue block5;
                    }
                    case 2001: {
                        string4 = string4 + DISTINCT_NAME;
                        continue block5;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0SQ", "" + nArray[i]);
                    }
                }
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(UDTS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    public ResultSet getXACoordinatorType() throws SQLException {
        PreparedStatement preparedStatement = this.getMetaDataAccessor(XACOORDINATORTYPE);
        return this.returnResults(preparedStatement);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getConnection()");
        }
        return this._conn;
    }

    public PreparedStatement getMetaDataAccessor(String string) throws SQLException {
        return this.getMetaDataAccessor(string, "", null);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2) throws SQLException {
        return this.getMetaDataAccessor(string, "", string2);
    }

    public PreparedStatement getMetaDataAccessor(String string, String string2, String string3) throws SQLException {
        return this._mda.getMetaDataAccessor(string, string2, string3, null);
    }

    private boolean supportForResultSetType(String string, int n) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = this.getMetaDataAccessor(string);
        switch (n) {
            case 1003: {
                bl = this.returnBoolean(preparedStatement, 1);
                break;
            }
            case 1004: {
                bl = this.returnBoolean(preparedStatement, 2);
                break;
            }
            case 1005: {
                bl = this.returnBoolean(preparedStatement, 3);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", "" + n);
            }
        }
        return bl;
    }

    private void setStringParam(PreparedStatement preparedStatement, String string, int n) throws SQLException {
        if (string == null) {
            preparedStatement.setNull(n, 12);
        } else {
            preparedStatement.setString(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet returnResults(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet;
        block6: {
            resultSet = null;
            SQLException sQLException = null;
            SQLWarning sQLWarning = null;
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                sQLWarning = preparedStatement.getWarnings();
                if (sQLWarning != null) {
                    this._conn.handleSQLE(sQLWarning);
                }
                preparedStatement.close();
            }
            finally {
                if (sQLException == null) break block6;
                throw sQLException;
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean returnBoolean(PreparedStatement preparedStatement, int n) throws SQLException {
        boolean bl;
        block5: {
            ResultSet resultSet = null;
            bl = false;
            SQLException sQLException = null;
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                bl = resultSet.getBoolean(n);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return (boolean)sQLException;
            }
            finally {
                preparedStatement.close();
                if (sQLException == null) break block5;
                throw sQLException;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int returnInt(PreparedStatement preparedStatement, int n) throws SQLException {
        int n2;
        block5: {
            ResultSet resultSet = null;
            n2 = -1;
            SQLException sQLException = null;
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                n2 = resultSet.getInt(n);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return (int)sQLException;
            }
            finally {
                preparedStatement.close();
                if (sQLException == null) break block5;
                throw sQLException;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String returnString(PreparedStatement preparedStatement) throws SQLException {
        String string;
        block5: {
            ResultSet resultSet = null;
            string = null;
            SQLException sQLException = null;
            try {
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                string = resultSet.getString(1);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                return sQLException;
            }
            finally {
                preparedStatement.close();
                if (sQLException == null) break block5;
                throw sQLException;
            }
        }
        return string;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getRowIdLifetime()");
        }
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " autoCommitFailureClosesAllResultSets()");
        }
        return false;
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getFunctions(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getFunctions(String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(FUNCTIONS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        if (((SybPreparedStatement)preparedStatement)._paramCount >= 5) {
            preparedStatement.setInt(4, 4);
            preparedStatement.setInt(5, 1);
        }
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getFunctionColumns(String = [" + string + "], String = [" + string2 + "], String = [" + string3 + "], String = [" + string4 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getFunctionColumns(String, String, String, String)");
            }
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(FUNCTIONCOLUMNS, string);
        this.setStringParam(preparedStatement, string, 1);
        this.setStringParam(preparedStatement, string2, 2);
        this.setStringParam(preparedStatement, string3, 3);
        this.setStringParam(preparedStatement, string4, 4);
        return this.returnResults(preparedStatement);
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSchemas(String = [" + string + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSchemas(String, String)");
            }
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = this.getMetaDataAccessor(SCHEMAS);
        if (((SybPreparedStatement)preparedStatement)._paramCount >= 2) {
            this.setStringParam(preparedStatement, string, 1);
            this.setStringParam(preparedStatement, string2, 2);
        }
        return this.returnResults(preparedStatement);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " supportsStoredFunctionsUsingCallSyntax()");
        }
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getClientInfoProperties()");
        }
        PreparedStatement preparedStatement = this.getMetaDataAccessor(GETCLIENTINFOPROPERTIES);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        return resultSet;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " isWrapperFor", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " isWrapperFor", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " isWrapperFor(Class<?>)");
            }
        }
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " unwrap", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " unwrap", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " unwrap(Class<T>)");
            }
        }
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName());
        }
        return t;
    }
}

