/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobClientInputStream;
import com.sybase.jdbc4.jdbc.LobClientOutputStream;
import com.sybase.jdbc4.jdbc.LobClientReader;
import com.sybase.jdbc4.jdbc.LobClientWriter;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybCharClientLob
extends SybLob
implements NClob {
    private static Logger LOG = Logger.getLogger(SybCharClientLob.class.getName());
    private static volatile long _logIdCounter = 0L;
    private StringBuilder data;

    public SybCharClientLob(String string, ProtocolContext protocolContext, StringBuilder stringBuilder, SybLob.LOB_TYPE lOB_TYPE) throws SQLException {
        this.data = stringBuilder;
        this._lobType = lOB_TYPE;
        this._logId = string + "_Cc" + _logIdCounter++;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getAsciiStream()");
        }
        this.checkClientLOBValidity();
        return new BufferedInputStream(new LobClientInputStream(this, 1L, this.length()), 16384);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getCharacterStream()");
        }
        this.checkClientLOBValidity();
        return new BufferedReader(new LobClientReader(this, 1L, this.length()), 16384);
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getCharacterStream(long = [" + l + "], long = [" + l2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getCharacterStream(long, long)");
            }
        }
        this.checkClientLOBValidity();
        long l3 = this.length();
        if (l < 1L || l > l3 || l + l2 > l3) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedReader(new LobClientReader(this, l, l2), 16384);
    }

    public StringBuilder getDataRef() {
        return this.data;
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSubString(long = [" + l + "], long = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSubString(long, int)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        } else if (n < 0) {
            ErrorMessage.raiseError("JZ038");
        }
        long l2 = this.length();
        if (this.data == null || l > l2) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        if (l + (long)n - 1L > l2) {
            n = (int)(l2 - l + 1L);
        }
        return this.data.substring((int)l - 1, (int)l + n - 1);
    }

    @Override
    public long position(String string, long l) throws SQLException {
        int n;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " position(String = [" + string + "], long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " position(String, long)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        n = (n = this.data.indexOf(string, (int)l - 1)) < 0 ? n : n + 1;
        return n;
    }

    private StringBuilder getData() {
        return this.data;
    }

    private void setData(StringBuilder stringBuilder) {
        this.data = stringBuilder;
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " position", new Object[]{clob, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " position(Clob, long)");
            }
        }
        this.checkClientLOBValidity();
        if (clob == null || this.data == null) {
            return -1L;
        }
        return this.position(((SybCharClientLob)clob).getString(), l);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setString(long = [" + l + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setString(long, String)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        if (string != null) {
            long l2 = this.length();
            if (l2 > 0L && l > l2 + 1L) {
                ErrorMessage.raiseError("JZ037");
            }
            if (this.data != null) {
                this.data.replace((int)l - 1, (int)l + string.length() - 1, string);
            }
            return string.length();
        }
        return 0;
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setString(long = [" + l + "], String = [" + string + "], int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setString(long, String, int, int)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        if (string != null) {
            return this.setString(l, string.substring(n - 1, n - 1 + n2));
        }
        return 0;
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setAsciiStream(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAsciiStream(long)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L || l > this.length()) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedOutputStream(new LobClientOutputStream(this, l), 16384);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setCharacterStream(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCharacterStream(long)");
            }
        }
        this.checkClientLOBValidity();
        if (l < 1L || l > this.length()) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedWriter(new LobClientWriter(this, l), 16384);
    }

    @Override
    public String getString() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getString()");
        }
        this.checkClientLOBValidity();
        if (this.data != null) {
            return this.data.toString();
        }
        return null;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    @Override
    public void free() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " free()");
        }
        if (!this._freeCalled) {
            this.data = null;
            this._freeCalled = true;
        }
    }

    private void checkClientLOBValidity() throws SQLException {
        if (this._freeCalled) {
            ErrorMessage.raiseError("JZ036");
        }
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getBytes()");
        }
        this.checkClientLOBValidity();
        return this.data.toString().getBytes();
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " truncate(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " truncate()");
            }
        }
        this.checkClientLOBValidity();
        if (l < 0L) {
            ErrorMessage.raiseError("JZ038");
        }
        this.data.setLength((int)l);
    }

    @Override
    public long length() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " length()");
        }
        this.checkClientLOBValidity();
        if (this.data == null) {
            return 0L;
        }
        return this.data.length();
    }
}

