/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.JdbcDataObject;
import com.sybase.jdbc4.jdbc.LobLocatorBufferedInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorBufferedReader;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybCallableStatement;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.tds.SybTimestamp;
import com.sybase.jdbc4.tds.TdsNumeric;
import com.sybase.jdbc4.tds.TdsParam;
import com.sybase.jdbc4.utils.CacheManager;
import com.sybase.jdbc4.utils.Cacheable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

public class ParamManager
implements Cacheable {
    public static final int PARAM_BY_NAME = 1;
    public static final int PARAM_BY_INDEX = 2;
    public Param[] _params;
    private int[] _prevParamType;
    protected int _next = -1;
    protected int _last = -1;
    private int _maxOutParam = -1;
    public int[] _rowUpdatedStatus;
    public SQLException[] _rowException;
    protected ArrayList _paramMdList = new ArrayList();
    protected SybStatement _stmt;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _stmtMgr;
    private CacheManager _mgr;
    private boolean _haveOutParam = false;
    private boolean _ignoreClear = false;
    private boolean _clearingParams = false;
    protected boolean _hasLiteralParam = false;
    protected boolean _paramMarkersHaveBeenParsed = false;
    protected boolean _dontProcessParamMarkers = false;
    protected boolean _setHasBeenCalled = false;
    private String _savedParsedQuery = null;
    private boolean _templateHoldsParsedNoLiteralQuery = false;
    private ParamManager _copiedFrom = null;
    protected int _paramSetType = 0;
    private static final int PARAM_MODE_IN = 1;
    private static final int PARAM_MODE_OUT = 2;
    private static final int PARAM_MODE_RETURN = 4;
    private static final String PARAM_NAME_RETURN = "RETURN_VALUE";
    private boolean _ignoreWarnings = false;

    public ParamManager(int n, int[] nArray, SybStatement sybStatement) throws SQLException {
        int n2;
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(this._context, n);
        this._ignoreWarnings = this._context._conn.isPropertySet(74);
        for (n2 = 0; n2 < n; n2 += 1) {
            this._params[n2]._paramMarkerOffset = nArray[n2];
        }
        this._mgr = new CacheManager(this._context._is);
        n2 = this._context._conn._props.getBoolean(14) ? 1 : 0;
        this._mgr.setReReadable(n2 != 0);
        int n3 = this._context._conn._props.getInteger(13);
        if (n2) {
            n3 = -1;
        }
        this._mgr.setCacheSize(n3);
        this._mgr.setChunkSize(256);
        this._mgr.setAbortOnCacheOverflow(true);
    }

    public ParamManager(ParamManager paramManager, SybStatement sybStatement) throws SQLException {
        int n;
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        int n2 = paramManager._params.length;
        this._params = this._protocol.paramArray(this._context, n2);
        this._ignoreWarnings = this._context._conn._props.getBoolean(74);
        for (n = 0; n < n2; n += 1) {
            this._params[n]._paramMarkerOffset = paramManager._params[n]._paramMarkerOffset;
        }
        this._mgr = this._context._conn.getSharedCacheManager();
        if (this._mgr == null) {
            this._mgr = new CacheManager(this._context._is);
            n = this._context._conn._props.getBoolean(14) ? 1 : 0;
            this._mgr.setReReadable(n != 0);
            int n3 = this._context._conn._props.getInteger(13);
            if (n) {
                n3 = -1;
            }
            this._mgr.setCacheSize(n3);
            this._mgr.setChunkSize(256);
            this._mgr.setAbortOnCacheOverflow(true);
            this._context._conn.setSharedCacheManager(this._mgr);
        }
        if (paramManager._templateHoldsParsedNoLiteralQuery) {
            this._hasLiteralParam = paramManager._hasLiteralParam;
            this._savedParsedQuery = paramManager._savedParsedQuery;
            this._paramMarkersHaveBeenParsed = true;
        }
        this._copiedFrom = paramManager;
    }

    public ParamManager(int n, SybStatement sybStatement) throws SQLException {
        this(n, sybStatement._context);
        this._stmt = sybStatement;
    }

    public ParamManager(int n, ProtocolContext protocolContext) throws SQLException {
        this._context = protocolContext;
        this._protocol = this._context._protocol;
        this._ignoreWarnings = this._context._conn._props.getBoolean(74);
        this._params = this._protocol.paramArray(n, this._mgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        if (this._ignoreClear) {
            return;
        }
        try {
            if (this._haveOutParam) {
                if (this._maxOutParam >= 0 && this._params[this._maxOutParam]._outValue == null) {
                    this.getOutValueAt(this._maxOutParam + 1);
                }
                if (!this._clearingParams) {
                    this.clearParams(false);
                }
            }
            this._mgr.clear();
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
        finally {
            this._stmtMgr.dead(this);
        }
    }

    @Override
    public void setManager(CacheManager cacheManager) {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void resetInputStream(InputStream inputStream) {
    }

    @Override
    public void cache() throws IOException {
        if (this._ignoreClear) {
            return;
        }
        this._ignoreClear = true;
        this._mgr.register(this);
        this._mgr.open(this);
        this._mgr.doneReading();
        this._mgr.dead(this);
        this._ignoreClear = false;
        this._stmtMgr.doneReading();
    }

    @Override
    public void open(boolean bl) {
    }

    @Override
    public int getState() {
        return 1;
    }

    public int getNext() {
        return this._next;
    }

    public Param[] getParams() {
        return this._params;
    }

    public ProtocolContext getContext() {
        return this._context;
    }

    protected synchronized void clearParams(boolean bl) throws IOException {
        if (this._clearingParams) {
            return;
        }
        if (this._haveOutParam) {
            this._clearingParams = true;
            this._stmtMgr.open(this);
            this.cache();
            this._clearingParams = false;
            this._haveOutParam = false;
        }
        this.clearParamArray(bl);
        this._mgr.clear();
        this._mgr.allDead();
    }

    protected synchronized void clearParamArray(boolean bl) throws IOException {
        int n = 0;
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            n = 1;
            this._params[0].clear(false);
        }
        for (int i = n; i < this._params.length; ++i) {
            this._params[i].clear(bl);
        }
        this._next = -1;
        this._last = -1;
    }

    private void checkIndex(int n) throws SQLException {
        if (n < 1 || n > this._params.length) {
            ErrorMessage.raiseError("JZ0SB", "" + n);
        }
    }

    private void checkType(int n) throws SQLException {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: {
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SL", "" + n);
            }
        }
    }

    public void setParamMd(ResultSet resultSet) throws SQLException {
        int n = 0;
        int n2 = 0;
        while (resultSet.next()) {
            if (PARAM_NAME_RETURN.equalsIgnoreCase(resultSet.getString("COLUMN_NAME")) && resultSet.getInt("COLUMN_TYPE") == 0) {
                if (!this._stmt._sendAsRpc) {
                    ((SybCallableStatement)this._stmt).extractParams();
                }
                if (n == 0 && !this._stmt._hasReturn) {
                    ++n;
                    continue;
                }
            } else if (this._stmt._rowFmtIdxList != null && this._stmt._rowFmtIdxList.size() > 0) {
                int n3;
                try {
                    n3 = (Integer)this._stmt._rowFmtIdxList.get(n2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
                if (n3 != n) continue;
                ++n2;
            }
            Param param = this._protocol.getParam();
            param._sqlType = resultSet.getInt("DATA_TYPE");
            param._sqlTypeName = resultSet.getString("TYPE_NAME");
            switch (resultSet.getInt("COLUMN_TYPE")) {
                case 1: {
                    param._regType = 1;
                    break;
                }
                case 2: {
                    param._regType = 2;
                    break;
                }
                case 4: {
                    param._regType = 4;
                    break;
                }
                default: {
                    param._regType = 0;
                }
            }
            param._precision = resultSet.getInt("PRECISION");
            param._scale = resultSet.getInt("SCALE");
            switch (resultSet.getInt("NULLABLE")) {
                case 0: {
                    param._isNullable = 0;
                    break;
                }
                case 1: {
                    param._isNullable = 1;
                    break;
                }
                default: {
                    param._isNullable = 2;
                }
            }
            switch (resultSet.getInt("SS_DATA_TYPE")) {
                case 38: 
                case 48: 
                case 52: 
                case 56: 
                case 59: 
                case 60: 
                case 62: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 122: 
                case 191: {
                    param._isSigned = true;
                    break;
                }
                default: {
                    param._isSigned = false;
                }
            }
            for (String string : Param.UNICODE_SQLTYPES) {
                if (!string.equalsIgnoreCase(param._sqlTypeName)) continue;
                param._isUnicodeType = true;
                break;
            }
            this._paramMdList.add(param);
            ++n;
        }
    }

    public void setParamMd(ResultSetMetaData resultSetMetaData, boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl) break block2;
                Vector vector = this._stmt._rowFmtIdxList;
                if (vector == null || vector.size() <= 0) break block3;
                for (int i = 0; i < vector.size(); ++i) {
                    int n = (Integer)vector.get(i);
                    this._paramMdList.add(i, this.fillParamFromRSMD(resultSetMetaData, n, bl));
                }
                break block3;
            }
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                this._paramMdList.add(this.fillParamFromRSMD(resultSetMetaData, i, bl));
            }
        }
    }

    private int getTargetType(int n, boolean bl) {
        int n2 = n;
        switch (n) {
            case -5: {
                if (bl) break;
                n2 = 2;
                break;
            }
            case 4: {
                if (bl) break;
                n2 = -5;
                break;
            }
            case 5: {
                if (bl) break;
                n2 = 4;
                break;
            }
            case 12: {
                n2 = -1;
            }
        }
        return n2;
    }

    private Param fillParamFromRSMD(ResultSetMetaData resultSetMetaData, int n, boolean bl) throws SQLException {
        Param param = this._protocol.getParam();
        param._sqlType = resultSetMetaData.getColumnType(n);
        param._sqlTypeName = resultSetMetaData.getColumnTypeName(n);
        param._regType = 1;
        param._precision = resultSetMetaData.getPrecision(n);
        param._scale = resultSetMetaData.getScale(n);
        param._isSigned = resultSetMetaData.isSigned(n);
        param._isNullable = bl ? 2 : (resultSetMetaData.isNullable(n) == 1 ? 1 : 0);
        this._params[n - 1]._targetType = param._targetType = this.getTargetType(param._sqlType, param._isSigned);
        for (String string : Param.UNICODE_SQLTYPES) {
            if (!string.equalsIgnoreCase(param._sqlTypeName)) continue;
            param._isUnicodeType = true;
            break;
        }
        return param;
    }

    public void setParam(String string, int n, Object object, int n2) throws SQLException {
        this.useParamByName();
        int n3 = this.getParamIndexByName(string);
        this.doSetParam(n3, n, object, n2);
        this._params[n3 - 1]._name = string;
    }

    public void setParam(int n, int n2, Object object, int n3) throws SQLException {
        this.useParamByIndex();
        this.doSetParam(n, n - 1, n2, object, n3);
    }

    public void setParam(int n, int n2, int n3, Object object, int n4) throws SQLException {
        this.useParamByIndex();
        this.doSetParam(n, n2, n3, object, n4);
    }

    public void doSetParam(int n, int n2, int n3, Object object, int n4) throws SQLException {
        this.doSetParam(n, n3, object, n4);
        this.checkIndex(n);
        Param param = this._params[n - 1];
        param._colId = n2;
    }

    public void doSetParam(int n, int n2, Object object, int n3) throws SQLException {
        this.checkIndex(n);
        Param param = this._params[--n];
        if (param._sqlType == -998) {
            ErrorMessage.raiseError("JZ0SC");
        }
        try {
            param.clear(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        switch (n2) {
            case 2: {
                if (!(object instanceof BigDecimal)) break;
                TdsNumeric.checkRange((BigDecimal)object, n3);
                break;
            }
        }
        param._sqlType = n2;
        param._inValue = object;
        param._scale = n3;
        this._setHasBeenCalled = true;
    }

    public void registerParam(String string, int n, int n2) throws SQLException {
        this.useParamByName();
        int n3 = this.getParamIndexByName(string);
        this.doRegisterParam(n3, n);
        this._params[n3 - 1]._name = string;
        this._params[n3 - 1]._scale = n2;
    }

    public void registerParam(int n, int n2, int n3) throws SQLException {
        this.registerParam(n, n2);
        this._params[n - 1]._scale = n3;
    }

    public void registerParam(String string, int n) throws SQLException {
        this.useParamByName();
        int n2 = this.getParamIndexByName(string);
        this.doRegisterParam(n2, n);
        this._params[n2 - 1]._name = string;
    }

    public void registerParam(int n, int n2) throws SQLException {
        this.useParamByIndex();
        this.doRegisterParam(n, n2);
    }

    protected void doRegisterParam(int n, int n2) throws SQLException {
        this.checkIndex(n);
        this.checkType(n2);
        if (--n > this._maxOutParam) {
            this._maxOutParam = n;
        }
        this._params[n]._regType = n2;
        if (this._stmt._hasReturn && n == 0) {
            this._stmt._returnHasBeenRegistered = true;
        }
    }

    public void registerParam(String string, int n, String string2) throws SQLException {
        this.useParamByName();
        int n2 = this.getParamIndexByName(string);
        this.doRegisterParam(n2, n);
        this._params[n2 - 1]._name = string;
        this._params[n2 - 1]._outParamClassName = string2;
    }

    public void registerParam(int n, int n2, String string) throws SQLException {
        this.registerParam(n, n2);
        this._params[--n]._outParamClassName = string;
    }

    private void checkReceive() throws SQLException {
        if (this._next < 0) {
            ErrorMessage.raiseError("JZ0SF");
        }
    }

    public JdbcDataObject getOutValueAt(String string) throws SQLException {
        this.useParamByName();
        int n = this.getParamIndexByName(string);
        return this.doGetOutValueAt(n);
    }

    public JdbcDataObject getOutValueAt(int n) throws SQLException {
        this.useParamByIndex();
        return this.doGetOutValueAt(n);
    }

    protected JdbcDataObject doGetOutValueAt(int n) throws SQLException {
        this.checkReceive();
        this.checkIndex(n);
        if (this._params[--n]._regType == -999 || this._stmt._hasReturn && n == 0 && !this._stmt._returnHasBeenRegistered) {
            ErrorMessage.raiseError("JZ0SB", "" + n);
        }
        while (this._params[n]._outValue == null) {
            this.nextOutParam();
            while (this._params[n]._outValue == null) {
                this.nextResult();
            }
        }
        this._last = n;
        return this._params[n]._outValue;
    }

    public Object getOutObjectAt(String string) throws SQLException {
        this.useParamByName();
        int n = this.getParamIndexByName(string);
        return this.doGetOutObjectAt(n);
    }

    public Object getOutObjectAt(int n) throws SQLException {
        this.useParamByIndex();
        return this.doGetOutObjectAt(n);
    }

    protected Object doGetOutObjectAt(int n) throws SQLException {
        Object object = null;
        JdbcDataObject jdbcDataObject = this.doGetOutValueAt(n);
        switch (this._params[--n]._regType) {
            case -6: 
            case 5: {
                object = Convert.objectToShort(jdbcDataObject.getObject());
                break;
            }
            case -5: {
                Object object2 = jdbcDataObject.getObject();
                if (object2 == null) {
                    object = null;
                    break;
                }
                if (object2 instanceof Integer) {
                    object = new Long(((Integer)object2).longValue());
                    break;
                }
                if (object2 instanceof BigDecimal) {
                    object = new Long(((BigDecimal)object2).longValue());
                    break;
                }
                if (!(object2 instanceof Long)) break;
                object = object2;
                break;
            }
            case 2: 
            case 3: {
                if (this._params[n]._scale != -999) {
                    object = jdbcDataObject.getBigDecimal(this._params[n]._scale);
                    break;
                }
                object = jdbcDataObject.getBigDecimal(-1);
                break;
            }
            case 6: {
                object = Convert.objectToDouble(jdbcDataObject.getObject());
                break;
            }
            case 91: {
                object = Convert.objectToDate(jdbcDataObject.getDateObject(91, null));
                break;
            }
            case 92: {
                object = Convert.objectToTime(jdbcDataObject.getDateObject(92, null));
                break;
            }
            case 93: {
                object = Convert.objectToTimestamp(jdbcDataObject.getDateObject(93, null));
                break;
            }
            default: {
                object = jdbcDataObject.getObject();
            }
        }
        return object;
    }

    public boolean hasInParams() {
        if (this._params.length == 0) {
            return false;
        }
        return this._params.length > 1 || this._params[0]._sqlType != -998;
    }

    protected boolean wasNull() throws SQLException {
        this.checkReceive();
        if (this._last < 0 || this._params[this._last]._outValue == null) {
            ErrorMessage.raiseError("JZ0SD");
        }
        return this._params[this._last]._outValue.isNull();
    }

    protected void getParameter() throws SQLException {
        this.checkReceive();
        this._protocol.param(this);
    }

    public int nextOutParam(String string) {
        for (int i = 0; i < this._params.length; ++i) {
            if (this._params[i]._name == null || !this._params[i]._name.equalsIgnoreCase(string) || this._params[i]._regType == -999) continue;
            return i;
        }
        return -1;
    }

    public int nextOutParam() {
        if (this._next < this._params.length && this._params[this._next]._outValue != null) {
            ++this._next;
        }
        while (this._next < this._params.length && this._params[this._next]._regType == -999) {
            ++this._next;
        }
        return this._next;
    }

    public void registerParam(Cacheable cacheable) throws SQLException {
        this.nextOutParam();
        try {
            this._haveOutParam = true;
            this._mgr.register(cacheable);
            this._mgr.open(cacheable);
            this._stmtMgr.register(this);
            this._stmtMgr.open(this);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    public void registerStatus(Cacheable cacheable) throws SQLException {
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            this.registerParam(cacheable);
        } else {
            try {
                cacheable.clear();
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    private int nextResult() throws SQLException {
        int n = this._next;
        while (true) {
            try {
                while (true) {
                    int n2 = this._stmt.nextResult();
                    switch (n2) {
                        case 3: {
                            return n2;
                        }
                        case 0: {
                            ErrorMessage.raiseError("JZ0SG");
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                this._stmt.handleSQLE(sQLException);
                continue;
            }
            break;
        }
    }

    public boolean checkParams(Protocol protocol, boolean bl, boolean bl2, int n) throws SQLException {
        boolean bl3 = true;
        boolean bl4 = false;
        for (int i = 0; i < this._params.length; ++i) {
            if (!this._ignoreWarnings) {
                this.checkForNanos(i);
            }
            if (bl2) {
                try {
                    this._params[i].normalizeForSend(i);
                }
                catch (SQLException sQLException) {
                    if (this._context._conn._props.getBoolean(80)) {
                        if (this._rowUpdatedStatus == null && this._rowException == null) {
                            this._rowUpdatedStatus = new int[this._stmt._batchCmds.size()];
                            this._rowException = new SQLException[this._stmt._batchCmds.size()];
                        }
                        this._rowUpdatedStatus[n] = -3;
                        this._rowException[n] = sQLException;
                        bl3 = false;
                    }
                    throw sQLException;
                }
            } else {
                this._params[i].prepareForSend(protocol, i, bl);
            }
            bl4 |= this._params[i]._sendAsLiteral;
        }
        if (this._paramMarkersHaveBeenParsed) {
            if (!this._setHasBeenCalled) {
                this._dontProcessParamMarkers = true;
            } else if (!bl4 && !this._hasLiteralParam) {
                this._dontProcessParamMarkers = true;
            }
        }
        this._hasLiteralParam = bl4;
        return bl3;
    }

    public void parseParamsAgain() {
        this._paramMarkersHaveBeenParsed = false;
    }

    public void send(OutputStream outputStream) throws IOException, SQLException {
        this._next = 0;
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i].send(outputStream, this._context._maxFieldSize);
        }
    }

    public int getLength() {
        int n = 0;
        for (int i = 0; i < this._params.length; ++i) {
            n += this._params[i].getLength();
        }
        return n;
    }

    public void adjustOffsets(int n) {
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i]._paramMarkerOffset += n;
        }
    }

    protected void literalizeAll() {
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i]._sendAsLiteral = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processParamMarkers(String string) throws SQLException {
        if (this._params.length == 0) {
            return null;
        }
        if (this._dontProcessParamMarkers) {
            this._dontProcessParamMarkers = false;
            this._setHasBeenCalled = false;
            return this._savedParsedQuery;
        }
        int n = 0;
        if (this._params[n]._sqlType == -998) {
            ++n;
        }
        if (n == this._params.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        try {
            while (n < this._params.length) {
                if (this._params[n]._sqlType != -998) {
                    stringBuffer.append(string.substring(n2, this._params[n]._paramMarkerOffset));
                    stringBuffer.append(this._params[n].literalValue(this._protocol, n, this._context._maxFieldSize));
                    n2 = this._params[n]._paramMarkerOffset + 1;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        this._savedParsedQuery = stringBuffer.toString();
        if (!this._hasLiteralParam && this._copiedFrom != null && !this._copiedFrom._templateHoldsParsedNoLiteralQuery) {
            ParamManager paramManager = this._copiedFrom;
            synchronized (paramManager) {
                if (!this._copiedFrom._templateHoldsParsedNoLiteralQuery) {
                    this._copiedFrom._savedParsedQuery = this._savedParsedQuery;
                    this._copiedFrom._hasLiteralParam = this._hasLiteralParam;
                    this._copiedFrom._templateHoldsParsedNoLiteralQuery = true;
                }
            }
        }
        this._dontProcessParamMarkers = false;
        this._setHasBeenCalled = false;
        this._paramMarkersHaveBeenParsed = true;
        return this._savedParsedQuery;
    }

    public int makeFormats(boolean bl) throws IOException {
        int n = 0;
        IConstants.STATEMENT_EXECUTION_MODE sTATEMENT_EXECUTION_MODE = IConstants.STATEMENT_EXECUTION_MODE.UNDEFINED;
        if (this._stmt != null && this._protocol.isLOBSupportedAsParameterToSproc()) {
            sTATEMENT_EXECUTION_MODE = this._stmt.getExecutionMode();
        }
        for (int i = 0; i < this._params.length; ++i) {
            if (!this._params[i].makeFormat(this._protocol, sTATEMENT_EXECUTION_MODE)) continue;
            if (bl && (((TdsParam)this._params[i])._sqlType == 2 || ((TdsParam)this._params[i])._sqlType == 3)) {
                ((TdsParam)this._params[i]).setPrecision(this.getParamMD((int)i)._precision);
            }
            ++n;
        }
        return n;
    }

    public void sendFormats(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i].sendFormat(dataOutput);
        }
    }

    public int getParamIndexByName(String string) {
        for (int i = 0; i < this._params.length; ++i) {
            if (this._params[i]._name != null && !this._params[i]._name.equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        return 0;
    }

    public int getParamSetType() {
        return this._paramSetType;
    }

    private void useParamByName() throws SQLException {
        if (this._paramSetType == 2) {
            ErrorMessage.raiseError("JZ0SV");
        }
        if (this._paramSetType != 1) {
            this._paramSetType = 1;
        }
    }

    private void useParamByIndex() throws SQLException {
        if (this._paramSetType == 1) {
            ErrorMessage.raiseError("JZ0SV");
        } else if (this._paramSetType != 2) {
            this._paramSetType = 2;
        }
    }

    private void checkForNanos(int n) throws SQLException {
        if (this._params[n]._sqlType == 93) {
            try {
                if (this._params[n]._inValue != null && !this._protocol.serverAcceptsBigDateTimeData()) {
                    SybTimestamp.checkNanos((DateObject)this._params[n]._inValue);
                }
            }
            catch (SQLException sQLException) {
                this._stmt.handleSQLE(sQLException);
            }
        }
    }

    protected String getColumnNames() {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < this._params.length; ++i) {
            if (this._stmt._hasReturn && i == 0 || this._params[i]._name == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append("'");
            stringBuffer.append(this._params[i]._name);
            stringBuffer.append("',");
        }
        if (stringBuffer != null) {
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return null;
    }

    protected String drainReader(Reader reader, int n) throws SQLException {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        if (this._stmt instanceof SybPreparedStatement) {
            bl = ((SybPreparedStatement)this._stmt)._batchInitialized;
        }
        if (!bl && this._context._conn.canUseLocators() && reader instanceof LobLocatorBufferedReader) {
            stringBuilder = new StringBuilder();
            try {
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                int n2 = -1;
                while (n-- > 0 && (n2 = reader.read()) != -1) {
                    stringBuilder.append((char)n2);
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    protected byte[] drainStreams(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = null;
        boolean bl = false;
        int n2 = -1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this._stmt instanceof SybPreparedStatement) {
            bl = ((SybPreparedStatement)this._stmt)._batchInitialized;
        }
        if (!bl && this._context._conn.canUseLocators() && inputStream instanceof LobLocatorBufferedInputStream) {
            try {
                if (n == -1) {
                    n = inputStream.available();
                }
                byArray = new byte[n];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
        return byArray == null ? null : byteArrayOutputStream.toByteArray();
    }

    public Param getParamMD(int n) {
        return (Param)this._paramMdList.get(n);
    }

    public void initParamTypesArray() {
        this._prevParamType = new int[this._params.length];
    }

    public void copyCurIntoPrevParamTypes() {
        for (int i = 0; i < this._params.length; ++i) {
            this._prevParamType[i] = this._params[i]._sqlType;
        }
    }

    public boolean hasParamsNotChanged() {
        for (int i = 0; i < this._params.length; ++i) {
            if (this._prevParamType[i] == this._params[i]._sqlType) continue;
            return false;
        }
        return true;
    }
}

