/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import net.snowflake.client.log.ArgSupplier;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.util.SecretDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogger
implements SFLogger {
    private Logger slf4jLogger;
    private boolean isLocationAwareLogger;
    private static final String FQCN = SLF4JLogger.class.getName();

    public SLF4JLogger(Class<?> clazz) {
        this.slf4jLogger = LoggerFactory.getLogger(clazz);
        this.isLocationAwareLogger = this.slf4jLogger instanceof LocationAwareLogger;
    }

    public SLF4JLogger(String name) {
        this.slf4jLogger = LoggerFactory.getLogger(name);
        this.isLocationAwareLogger = this.slf4jLogger instanceof LocationAwareLogger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.slf4jLogger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.slf4jLogger.isErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.slf4jLogger.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.slf4jLogger.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.slf4jLogger.isWarnEnabled();
    }

    @Override
    public void debug(String msg) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 10, msg, null, null);
        } else {
            this.slf4jLogger.debug(msg);
        }
    }

    @Override
    public void debugNoMask(String msg) {
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 10, msg, null, null);
        } else {
            this.slf4jLogger.debug(msg);
        }
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, SLF4JLogger.evaluateLambdaArgs(arguments));
            this.debug(SecretDetector.maskSecrets(ft.getMessage()));
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 10, msg, null, t);
        } else {
            this.slf4jLogger.debug(msg, t);
        }
    }

    @Override
    public void error(String msg) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 40, msg, null, null);
        } else {
            this.slf4jLogger.error(msg);
        }
    }

    @Override
    public void error(String msg, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, SLF4JLogger.evaluateLambdaArgs(arguments));
            this.error(SecretDetector.maskSecrets(ft.getMessage()));
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 40, msg, null, t);
        } else {
            this.slf4jLogger.error(msg, t);
        }
    }

    @Override
    public void info(String msg) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 20, msg, null, null);
        } else {
            this.slf4jLogger.info(msg);
        }
    }

    @Override
    public void info(String msg, Object ... arguments) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, SLF4JLogger.evaluateLambdaArgs(arguments));
            this.info(SecretDetector.maskSecrets(ft.getMessage()));
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 20, msg, null, t);
        } else {
            this.slf4jLogger.error(msg, t);
        }
    }

    @Override
    public void trace(String msg) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 0, msg, null, null);
        } else {
            this.slf4jLogger.trace(msg);
        }
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, SLF4JLogger.evaluateLambdaArgs(arguments));
            this.trace(SecretDetector.maskSecrets(ft.getMessage()));
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 0, msg, null, t);
        } else {
            this.slf4jLogger.trace(msg, t);
        }
    }

    @Override
    public void warn(String msg) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 30, msg, null, null);
        } else {
            this.slf4jLogger.error(msg);
        }
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, SLF4JLogger.evaluateLambdaArgs(arguments));
            this.warn(SecretDetector.maskSecrets(ft.getMessage()));
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        msg = SecretDetector.maskSecrets(msg);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.slf4jLogger).log(null, FQCN, 30, msg, null, t);
        } else {
            this.slf4jLogger.error(msg, t);
        }
    }

    private static Object[] evaluateLambdaArgs(Object ... args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = args[i] instanceof ArgSupplier ? ((ArgSupplier)args[i]).get() : args[i];
        }
        return result;
    }
}

