package com.bonc.xcloud.sp_procedure.message;

import java.util.ArrayList;
import java.util.List;

/**
 * 消息处理器
 */
public class MessageHandler {
	
	private Message message;//消息
	
	private List<MessageListener> listeners;//消息监听器集合
	
	 public MessageHandler()
	 {
		 this.listeners = new ArrayList<MessageListener>();
	 }
	
	/**
	 * 添加消息监听器
	 */
	public void addMessageListener(MessageListener listener){
		listeners.add(listener);
	}
	
	/**
	 * 移除消息监听器
	 */
	public void removeMessageListener(MessageListener listener){
		listeners.remove(listener);
	}
	
	/**
	 * 广播发送消息给消息监听器
	 */
	public void sendMessage(Message message){
		this.message = message;
		notifyListeners(message);
	}
	
	/**
	 * 广播发送消息给消息监听器的具体实现
	 */
	public void notifyListeners(Message message){
		
		for (MessageListener listener : listeners) {
            listener.messageReceived(message);
        }
	}

	public Message getMessage() {
		return message;
	}

	public void setMessage(Message message) {
		this.message = message;
	}

	public List<MessageListener> getListeners() {
		return listeners;
	}

	public void setListeners(List<MessageListener> listeners) {
		this.listeners = listeners;
	}
	
}
