package com.bonc.xcloud.sp_procedure.intermediate.typeimpl;

import java.util.HashMap;

import com.bonc.xcloud.sp_procedure.intermediate.SymTabEntry;
import com.bonc.xcloud.sp_procedure.intermediate.TypeForm;
import com.bonc.xcloud.sp_procedure.intermediate.TypeKey;
import com.bonc.xcloud.sp_procedure.intermediate.TypeSpec;

/**
 * 符号表说明实现类
 */
public class TypeSpecImpl
    extends HashMap<TypeKey, Object>
    implements TypeSpec
{

	private static final long serialVersionUID = 1L;
	private TypeForm form;           // 类型格式
    private SymTabEntry identifier;  // 符号表单元,类型说明的标识符

    
    public TypeSpecImpl(TypeForm form)
    {
        this.form = form;
        this.identifier = null;
    }

    /**
     * 获取类型格式
     */
    public TypeForm getForm()
    {
        return form;
    }

    /**
     * 设置类型的标识符
     */
    public void setIdentifier(SymTabEntry identifier)
    {
        this.identifier = identifier;
    }

    /**
     * 获取类型的标识符
     */
    public SymTabEntry getIdentifier()
    {
        return identifier;
    }

    /**
     * 设置属性
     */
    public void setAttribute(TypeKey key, Object value)
    {
        this.put(key, value);
    }

    /**
     * 获取属性
     */
    public Object getAttribute(TypeKey key)
    {
        return this.get(key);
    }

    
    @Override
    public boolean equals(Object o) {
    	
    	if(o == null) return false;
    	if(!(o instanceof TypeSpecImpl)) return false;
    	TypeSpecImpl type =(TypeSpecImpl) o ;
    	if(type.getForm()==null || this.form  == null) return false;
    	if(type.getIdentifier()==null || this.identifier == null) return false;
    	if(type.getForm().toString().equals(this.form.toString()) && 
    			type.getIdentifier().getName().equals(this.identifier.getName()))
    		return true;
    	return false;
    }
}
