package com.bonc.xcloud.sp_procedure.intermediate.typeimpl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

import com.bonc.xcloud.sp_procedure.intermediate.SymTab;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabEntry;
import com.bonc.xcloud.sp_procedure.intermediate.TypeForm;
import com.bonc.xcloud.sp_procedure.intermediate.TypeSpec;
import com.bonc.xcloud.sp_procedure.intermediate.symtabimpl.Predefined;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.Expression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.constantExpression.ConstantExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.variableExpression.VariableExpression;

public class TypeChecker {
	/**
	 * 检查类型是Integer
	 * 
	 * @param type
	 *            被检查类型说明
	 * @return true/false
	 */
	public static boolean isInteger(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.intType));
	}

	/**
	 * 检查二元操作符的两个类型都是否是整数
	 * 
	 * @param type1
	 *            第一个被检查的类型
	 * @param type2
	 *            第二个被检查的类型
	 * @return true/false
	 */
	public static boolean areBothInteger(TypeSpec type1, TypeSpec type2) {
		return isInteger(type1) && isInteger(type2);
	}
	
	/**
	 * 判断两个类型时候都为空
	 */
	public static boolean areBothNull(TypeSpec type1, TypeSpec type2) {
		return isNull(type1) && isNull(type2);
	}
	

//	/**
//	 * 检查二元操作符的两个类型都是否是record
//	 */
//	public static boolean areBothRecord(TypeSpec type1, TypeSpec type2) {
//		// 可以只根据格式确定是record
//		TypeForm t1 = type1.getForm();
//		TypeForm t2 = type2.getForm();
//		return t1.equals(t2);
//	}

	/**
	 * 检查类型是否一个实数，即计算机里面的浮点数
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isReal(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.doubleType));
	}

	/**
	 * 检查类型是否是整数或者实数，也就是一个实数系内的数
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isIntegerOrRealOrLong(TypeSpec type) {
		return isInteger(type) || isReal(type) || isLong(type);
	}

	/**
	 * 检查两个类型中至少有一个是实数，这个即计算机里面的数系扩大。比如INT+DOUBLE=DOUBLE
	 * 
	 * @param type1
	 *            第一个被检查类型
	 * @param type2
	 *            第二个被检查类型
	 * @return true/false
	 */

	public static boolean isAtLeastOneReal(TypeSpec type1, TypeSpec type2) {
		return (isReal(type1) && isReal(type2))
				|| (isReal(type1) && isInteger(type2))
				|| (isInteger(type1) && isReal(type2))
				|| (isLong(type1) && isReal(type2))
				|| (isReal(type1) && isLong(type2));
	}

	/**
	 * 检查类型是否布尔类型
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isBoolean(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.booleanType));
	}

	public static boolean isNull(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.nullType));
	}

	/**
	 * 对record记录进行判断
	 */
	public static boolean isRecord(TypeSpec type) {
		if(type == null) return false;
		TypeForm typeForm = type.getForm();
		return typeForm.equals(TypeFormImpl.RECORD);
	}
	
	//----------------------------------------------------------------------------
	/**
	 * 检查类型是否为游标类型(目前的判断逻辑与isRecord(TypeSpec type)一样)
	 */
	public static boolean isCursor(TypeSpec type) {
		TypeForm typeForm = type.getForm();
		return (type != null) && (typeForm.equals(TypeFormImpl.CURSOR));
	}
	//----------------------------------------------------------------------------
	
	

	/**
	 * 检查类型是LONG类型
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isLong(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.longType));
	}

	/**
	 * 检查类型是Date类型
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isDate(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.dateType));
	}

	/**
	 * 检查类型是IntervalDS类型
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isIntervalDS(TypeSpec type) {
		return (type != null) && (type == Predefined.intervalDSType);
	}

	/**
	 * 检查类型是IntervalYM类型
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isIntervalYM(TypeSpec type) {
		return (type != null) && (type == Predefined.intervalYMType);
	}

	/**
	 * 检查参加布尔二元运算如&&,|| 的两个类型是否都是布尔数。
	 * 
	 * @param type1
	 *            第一个被检查类型
	 * @param type2
	 *            第二个被检查类型
	 * @return true/false
	 */
	public static boolean areBothBoolean(TypeSpec type1, TypeSpec type2) {
		return isBoolean(type1) && isBoolean(type2);
	}

	/**
	 * 检查类型是否一个Char类型
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */

	/**
	 * 检查二元操作符的两个类型都是否是long
	 * 
	 * @param type1
	 *            第一个被检查的类型
	 * @param type2
	 *            第二个被检查的类型
	 * @return true/false
	 */
	public static boolean areBothLong(TypeSpec type1, TypeSpec type2) {
		return isLong(type1) && isLong(type2);
	}

	public static boolean isNumber(TypeSpec type) {
		return isInteger(type) || isLong(type) || isReal(type);
	}

	public static boolean isChar(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.charType));
	}

	/**
	 * 检查类型是否一个VarChar类型
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isVarChar(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.varcharType));
	}

	/**
	 * 检查类型是否一个TimeStamp类型
	 * 
	 * @param type
	 *            被检查类型
	 * @return true/false
	 */
	public static boolean isTimestamp(TypeSpec type) {
		return (type != null) && (type.equals(Predefined.timestampType));
	}

	public static boolean isString(TypeSpec type) {
		return isVarChar(type) || isChar(type);
	}

	/**
	 * 检查赋值两端的类型是否兼容，即左值是否能被右值兼容
	 * 
	 * @param targetType
	 *            左值类型
	 * @param valueType
	 *            右值类型
	 * @return true可以赋值/false不能赋值
	 */
	public static boolean areAssignmentCompatible(TypeSpec targetType,
			TypeSpec valueType) {
		if ((targetType == null) || (valueType == null)) {
			return false;
		}
		boolean compatible = false;

		// 类型一样，ok
		if (targetType.equals(valueType)) {
			compatible = true;
		}

		// 左实数，右整数，ok
		else if (isReal(targetType)
				&& (isInteger(valueType) || isLong(valueType) || isNull(valueType))) {
			compatible = true;
		}
		
//		else if(isDate(targetType) || isLong(valueType)) compatible = true;
		
		// 左long 右int ，ok
		else if (isLong(targetType)
				&& (isInteger(valueType) || isNull(valueType))) {
			compatible = true;
		} else if (isInteger(targetType) && isNull(valueType)) {
			compatible = true;
		} else if (isDate(targetType) && isNull(valueType)) {
			compatible = true;
		} else if (isTimestamp(targetType) && isNull(valueType)) {
			compatible = true;
		} else if (isIntervalDS(targetType)
				&& (isIntervalDS(valueType) || isNull(valueType))) {
			compatible = true;
		} else if (isIntervalYM(targetType)
				&& (isIntervalYM(valueType) || isNull(valueType))) {
			compatible = true;
		} 

			//left value is record and right value is null
		else if(isRecord(targetType) && isNull(valueType)){
			compatible = true;
		}
		
		//判断赋值号两边都是record的情况
		else if(isRecord(targetType) && isRecord(valueType)){
			//获取左边记录的符号表
			SymTab symTab_left = (SymTab) targetType
					.getAttribute(TypeKeyImpl.RECORD_SYMTAB);
			//获取右边记录的符号表
			SymTab symTab_right = (SymTab) valueType
					.getAttribute(TypeKeyImpl.RECORD_SYMTAB);
			//分别根据左右符号表获取符号表单元
			List<SymTabEntry> symTabEntrys_left = symTab_left.sortedEntries();
			List<SymTabEntry> symTabEntrys_right = symTab_right.sortedEntries();
			//记录之间赋值 字域数量必须相同
			if(symTabEntrys_left.size()!=symTabEntrys_right.size()){
				compatible = false;
			}else{
				boolean flag = true;
				for(int i=0;i<symTabEntrys_left.size();i++){
					SymTabEntry left = symTabEntrys_left.get(i);
					SymTabEntry right = symTabEntrys_right.get(i);
					TypeSpec type1 = left.getTypeSpec();
					TypeSpec type2 = right.getTypeSpec();
					if(!type1.equals(type2)){
						flag = false;
						break;
					}
				}
				if(flag){
					compatible = true;
				}else{
					compatible = false;
				}
				
			}
			
		}
		//判断cursor和record类型是否匹配
		else if(isCursor(targetType) && isRecord(valueType)){
			//获取左边记录的符号表
			SymTab symTab_left = (SymTab) targetType
					.getAttribute(TypeKeyImpl.RECORD_SYMTAB);
			//获取右边记录的符号表
			SymTab symTab_right = (SymTab) valueType
					.getAttribute(TypeKeyImpl.RECORD_SYMTAB);
			//分别根据左右符号表获取符号表单元
			List<SymTabEntry> symTabEntrys_left = symTab_left.sortedEntries();
			List<SymTabEntry> symTabEntrys_right = symTab_right.sortedEntries();
			//记录之间赋值 字域数量必须相同
			if(symTabEntrys_left.size()!=symTabEntrys_right.size()){
				compatible = false;
			}else{
				boolean flag = true;
				for(int i=0;i<symTabEntrys_left.size();i++){
					SymTabEntry left = symTabEntrys_left.get(i);
					SymTabEntry right = symTabEntrys_right.get(i);
					TypeSpec type1 = left.getTypeSpec();
					TypeSpec type2 = right.getTypeSpec();
					if(!type1.equals(type2)){
						flag = false;
						break;
					}
				}
				if(flag){
					compatible = true;
				}else{
					compatible = false;
				}
				
			}
			
		}

		// 字符串对字符串，赋值没问题
		else {
			compatible = (isChar(targetType) || isVarChar(targetType))
					&& (isChar(valueType) || isVarChar(valueType) || isNull(valueType));
		}

		return compatible;
	}
	
	public static boolean checkIntoCompatible(String dataType,TypeSpec intoType){
		
		if(dataType == null || intoType == null) return false;
		if(dataType.equals("")) return false;
		
		dataType = dataType.trim().toUpperCase();
		//int
		if(isInteger(intoType)){
			if("INTEGER".equals(dataType)) return true;
			if("LONG".equals(dataType)) return true;
			if("DOUBLE".equals(dataType)) return true;
		}
		
		//long
		if(isLong(intoType)){
			if("INTEGER".equals(dataType)) return true;
			if("LONG".equals(dataType)) return true;
			if("DOUBLE".equals(dataType)) return true;
		}
		//double
		if(isReal(intoType)){
			if("INTEGER".equals(dataType)) return true;
			if("LONG".equals(dataType)) return true;
			if("DOUBLE".equals(dataType)) return true;
		}
		
		//char,varchar
		if(isChar(intoType)||isVarChar(intoType)){
			if("CHAR".equals(dataType)) return true;
			if("VARCHAR".equals(dataType)) return true;
			if("OTHER".equals(dataType)) return true;
		}
		
		//date,timestamp暂时不区分
		if(isDate(intoType)||isTimestamp(intoType)){
			if("DATE".equals(dataType)) return true;
			if("TIMESTAMP".equals(dataType)) return true;
		}
		//intervalYM
		if(isIntervalYM(intoType)){
			if("INTERVALYM".equals(dataType))return true;
		}
		//intervalDS
		if(isIntervalDS(intoType)){
			if("INTERVALDS".equals(dataType))return true;
		}
		
		return false;
	}
	
	
	
	
	
	
	
	
	
	
	/**
	 * 检查是否为相同类型
	 */
	public static boolean areSameType(TypeSpec targetType,
			TypeSpec valueType){
		
		//int
		if(isInteger(targetType) && isInteger(valueType)) 
			return true;
		
		//long
		if(isLong(targetType) && isLong(valueType))
			return true;
		
		//double
		if(isReal(targetType) && isReal(valueType))
			return true;
		
		//boolean
		if(isBoolean(targetType) && isBoolean(valueType))
			return true;
		
		//date
		if(isDate(targetType) && isDate(valueType))
			return true;
		
		//char
		if(isChar(targetType) && isChar(valueType))
			return true;
		
		//varchar
		if(isVarChar(targetType) && isVarChar(valueType))
			return true;
		
		//Timestamp
		if(isTimestamp(targetType) && isTimestamp(valueType))
			return true;
		
		//IntervalYM
		if(isIntervalYM(targetType) && isIntervalYM(valueType))
			return true;
		
		//IntervalDS
		if(isIntervalDS(targetType) && isIntervalDS(valueType))
			return true;
		
		//null
		if(isNull(targetType) && isNull(valueType))
			return true;
		
		return false;		
	}
	
	/**
	 * 检查in_out参数是否匹配
	 * 
	 * @param targetType
	 * @param valueType
	 * @return
	 */
	public static boolean areInOutParameterCom(TypeSpec targetType,
			TypeSpec valueType) {
		if (targetType == null || valueType == null)
			return false;

		if (targetType.equals(valueType))
			return true;

		return (isChar(targetType) || isVarChar(targetType))
				&& (isChar(valueType) || isVarChar(valueType));

	}

	/**
	 * 检查out参数是否匹配
	 * 
	 * @param targetType
	 * @param valueType
	 * @return
	 */
	public static boolean areOutParameterCom(TypeSpec targetType,
			TypeSpec valueType) {

		if (targetType == null || valueType == null)
			return false;

		// 与assign相反
		return areAssignmentCompatible(valueType, targetType);
	}

	/**
	 * 专门用来判断varchar和char的长度是否兼容
	 */
	public static boolean areStringAssignmentCompatible(
			Expression targetExpression, Expression valueExpression) {
//		if ((targetExpression.getTypeSpec() == null)
//				|| (valueExpression.getTypeSpec() == null)) {
//			return false;
//		}
//
//		/*
//		 * targetExpression = targetExpression instanceof
//		 * VariableVarcharExpression ?
//		 * (VariableVarcharExpression)targetExpression :
//		 * (VariableCharExpression)targetExpression; valueExpression =
//		 * valueExpression instanceof VariableVarcharExpression ?
//		 * (VariableVarcharExpression)valueExpression :
//		 * (VariableCharExpression)valueExpression;
//		 */
//
//		boolean compatible = false;
//
//		compatible = (isChar(targetExpression.getTypeSpec()) || isVarChar(targetExpression
//				.getTypeSpec()))
//				&& (isChar(valueExpression.getTypeSpec()) || isVarChar(valueExpression
//						.getTypeSpec()));
//
//		if (compatible) {
//			if (targetExpression instanceof VariableVarcharExpression
//					&& valueExpression instanceof VariableVarcharExpression) {
//				compatible = ((VariableVarcharExpression) targetExpression)
//						.getLength() >= ((VariableVarcharExpression) valueExpression)
//						.getLength();
//			}
//			if (targetExpression instanceof VariableVarcharExpression
//					&& valueExpression instanceof VariableCharExpression) {
//				compatible = ((VariableVarcharExpression) targetExpression)
//						.getLength() >= ((VariableCharExpression) valueExpression)
//						.getLength();
//			}
//			if (targetExpression instanceof VariableCharExpression
//					&& valueExpression instanceof VariableCharExpression) {
//				compatible = ((VariableCharExpression) targetExpression)
//						.getLength() >= ((VariableCharExpression) valueExpression)
//						.getLength();
//			}
//			if (targetExpression instanceof VariableCharExpression
//					&& valueExpression instanceof VariableVarcharExpression) {
//				compatible = ((VariableCharExpression) targetExpression)
//						.getLength() >= ((VariableVarcharExpression) valueExpression)
//						.getLength();
//			}
//			if (targetExpression instanceof VariableVarcharExpression
//					&& valueExpression instanceof ConstantVarcharExpression) {
//				compatible = ((VariableVarcharExpression) targetExpression)
//						.getLength() >= ((ConstantVarcharExpression) valueExpression)
//						.getLength();
//			}
//			if (targetExpression instanceof VariableVarcharExpression
//					&& valueExpression instanceof ConstantCharExpression) {
//				compatible = ((VariableVarcharExpression) targetExpression)
//						.getLength() >= ((ConstantCharExpression) valueExpression)
//						.getLength();
//			}
//			if (targetExpression instanceof VariableCharExpression
//					&& valueExpression instanceof ConstantVarcharExpression) {
//				compatible = ((VariableCharExpression) targetExpression)
//						.getLength() >= ((ConstantVarcharExpression) valueExpression)
//						.getLength();
//			}
//			if (targetExpression instanceof VariableCharExpression
//					&& valueExpression instanceof ConstantCharExpression) {
//				compatible = ((VariableCharExpression) targetExpression)
//						.getLength() >= ((ConstantCharExpression) valueExpression)
//						.getLength();
//			}
//		}
//		return compatible;
		return true;
	}

	/**
	 * 检查两个类型是否能做到比较兼容，即a < b中的a/b可以兼容，如果a是INT，而b是String，这个就是不兼容的。
	 * 
	 * @param type1
	 *            比较操作符左端的类型
	 * @param type2
	 *            比较操作符右端的类型
	 * @return true/false
	 */
	public static boolean areComparisonCompatible(TypeSpec type1, TypeSpec type2) {
		if ((type1 == null) || (type2 == null)) {
			return false;
		}

		TypeForm form = type1.getForm();

		boolean compatible = false;

		// 两个标量或者枚举类型
		if ((type1.equals(type2))
				&& ((form == TypeFormImpl.SCALAR) || (form == TypeFormImpl.ENUMERATION))) {
			compatible = true;
		}

		// 至少有一个是实数，另一个整数，没问题
		else if (isAtLeastOneReal(type1, type2)) {
			compatible = true;
		}

		// 两个字符串也可以比较
		else {
			compatible = (isChar(type1) || isVarChar(type1))
					&& (isChar(type2) || isVarChar(type2));
		}

		return compatible;

	}

	/**
	 * 判断plsql中类型是否兼容java的类型(in参数是否可赋值)
	 * 
	 * @param type
	 * @param javaType
	 *            为java.long.下的字符串
	 * @return
	 */
	public static boolean isPL_TypeCompatibleJType(TypeSpec type,
			String javaType) {

		/*// 整数只兼容整数
		if (type.equals(Predefined.intType)) {
			if (javaType.equals(Integer.class.getName()))
				return true;
		}
		// long兼容int和long
		else if (type.equals(Predefined.longType)) {
			if (javaType.equals(Long.class.getName()))
				return true;
			if (javaType.equals(Integer.class.getName()))
				return true;
		}
		// double兼容int,long,double
		else if (type.equals(Predefined.doubleType)) {
			if (javaType.equals(Double.class.getName()))
				return true;
			if (javaType.equals(Long.class.getName()))
				return true;
			if (javaType.equals(Integer.class.getName()))
				return true;
		}

		else if (type.equals(Predefined.charType)) {
			if (javaType.equals(String.class.getName()))
				return true;
		} else if (type.equals(Predefined.varcharType)) {
			if (javaType.equals(String.class.getName()))
				return true;
		} else if (type.equals(Predefined.dateType)) {
			if (javaType.equals(Timestamp.class.getName()))
				return true;
			if (javaType.equals(Date.class.getName()))
				return true;
		} else if (type == Predefined.intervalDSType) {
			if (javaType.equals(DispatchParameter.INTERVALDS_JAVATYPE))
				return true;
			if (javaType.equals(String.class.getName()))
				return true;
		} else if (type == Predefined.intervalYMType) {
			if (javaType.equals(DispatchParameter.INTERVALYM_JAVATYPE))
				return true;
			if (javaType.equals(String.class.getName()))
				return true;
		} else if (type == (Predefined.timestampType)) {
			if (javaType.equals(Timestamp.class.getName()))
				return true;
			if (javaType.equals(String.class.getName()))
				return true;
		}*/

		return false;
	}

	/**
	 * 判断plsql中类型是否可以转换成java的类型(计算后的out参数能否传出)
	 * 
	 * @param type
	 * @param javaType
	 *            为java.sql.types.下的数字
	 * @return
	 */
	public static boolean isPL_TypeCastJType(TypeSpec type, String javaType) {

		/*// 整数可转为int,long,double
		if (type.equals(Predefined.intType)) {
			if (javaType.equals(java.sql.Types.INTEGER + ""))
				return true;
			if (javaType.equals(java.sql.Types.BIGINT + ""))
				return true;
			if (javaType.equals(java.sql.Types.DOUBLE + ""))
				return true;
			// if(javaType.equals(java.sql.Types.REAL+""))return true;
		}
		// long可转为long,double
		else if (type.equals(Predefined.longType)) {
			if (javaType.equals(java.sql.Types.BIGINT + ""))
				return true;
			if (javaType.equals(java.sql.Types.DOUBLE + ""))
				return true;
			// if(javaType.equals(java.sql.Types.REAL+""))return true;

		}
		// double可转为double
		else if (type.equals(Predefined.doubleType)) {
			if (javaType.equals(java.sql.Types.DOUBLE + ""))
				return true;
			// if(javaType.equals(java.sql.Types.REAL+"")) return true;

		}
		// char可转为char,varchar
		else if (type.equals(Predefined.charType)) {
			if (javaType.equals(java.sql.Types.CHAR + ""))
				return true;
			if (javaType.equals(java.sql.Types.VARCHAR + ""))
				return true;
		}
		// varchar可转为char,varchar
		else if (type.equals(Predefined.varcharType)) {
			if (javaType.equals(java.sql.Types.CHAR + ""))
				return true;
			if (javaType.equals(java.sql.Types.VARCHAR + ""))
				return true;
		}

		else if (type.equals(Predefined.dateType)) {
			if (javaType.equals(java.sql.Types.DATE + ""))
				return true;
			if (javaType.equals(java.sql.Types.TIMESTAMP + ""))
				return true;
		} else if (type.equals(Predefined.timestampType)) {
			if (javaType.equals(java.sql.Types.TIMESTAMP + ""))
				return true;
			if (javaType.equals(java.sql.Types.CHAR + ""))
				return true;
			if (javaType.equals(java.sql.Types.VARCHAR + ""))
				return true;
		} else if (type == Predefined.intervalDSType) {
			if (javaType.equals(DispatchParameter.INTERVALDS_TYPEID + ""))
				return true;
			if (javaType.equals(java.sql.Types.CHAR + ""))
				return true;
			if (javaType.equals(java.sql.Types.VARCHAR + ""))
				return true;
		} else if (type == Predefined.intervalYMType) {
			if (javaType.equals(DispatchParameter.INTERVALYM_TYPEID + ""))
				return true;
			if (javaType.equals(java.sql.Types.CHAR + ""))
				return true;
			if (javaType.equals(java.sql.Types.VARCHAR + ""))
				return true;
		}*/

		return false;
	}

	/**
	 * 判断plsql中类型是否兼容value类型
	 */
	// public static boolean isPL_TypeCompatibleValue(TypeSpec type,String
	// value){
	//
	// try{
	//
	// //整数
	// if(type.equals(Predefined.intType)){
	// Integer.parseInt(value);
	// return true;
	// }
	// //long
	// else if(type.equals(Predefined.longType)){
	// Long.parseLong(value);
	// return true;
	// }
	// //double
	// else if(type.equals(Predefined.doubleType)){
	// Double.parseDouble(value);
	// return true;
	// }
	// //字符串
	// else
	// if(type.equals(Predefined.charType)||(type.equals(Predefined.varcharType))){
	//
	// return true;
	// }else{
	// return false;
	// }
	//
	// }catch(Exception e){
	// return false;
	// }
	// }

	public static void main(String[] args) {
		System.out.println(Integer.class.getName());
	}

	public static boolean addComplianceType(TypeSpec type0, TypeSpec type1) {
		if (isInteger(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isDate(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isReal(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isDate(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isLong(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isDate(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isNull(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isDate(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isTimestamp(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}
		if (isDate(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}

		if (isTimestamp(type0)) {
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}

		if (isIntervalDS(type0)) {
			if (isIntervalDS(type1))
				return true;
			if (isNull(type1))
				return true;
			if(isDate(type1))
				return true;
			if(isTimestamp(type1))
				return true;
		}
		if (isIntervalYM(type0)) {
			if (isIntervalYM(type1))
				return true;
			if (isNull(type1))
				return true;
			if(isDate(type1))
				return true;
			if(isTimestamp(type1))
				return true;
		}

		return false;
	}

	public static boolean subComplianceType(TypeSpec type0, TypeSpec type1) {
		if (isInteger(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isReal(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isLong(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isNull(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
			if (isTimestamp(type1))
				return true;
		}
		if (isDate(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isDate(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isTimestamp(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}

		if (isTimestamp(type0)) {
			if (isTimestamp(type1))
				return true;
			if (isDate(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}

		if (isIntervalDS(type0)) {
			if (isIntervalDS(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isIntervalYM(type0)) {
			if (isIntervalYM(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		return false;
	}

	public static boolean concatComplianceType(TypeSpec type0, TypeSpec type1) {
		if (isChar(type0)) {
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isVarChar(type0)) {
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isNull(type0)) {
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		return false;
	}

	public static boolean MulComplianceType(TypeSpec type0, TypeSpec type1) {
		if (isInteger(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}
		if (isReal(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}
		if (isLong(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}
		if (isNull(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;

		}
		if (isIntervalDS(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isIntervalYM(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		return false;
	}

	public static boolean DivComplianceType(TypeSpec type0, TypeSpec type1) {
		if (isInteger(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isReal(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isLong(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isNull(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
			if (isIntervalYM(type1))
				return true;

		}
		if (isIntervalDS(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isIntervalYM(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		return false;
	}

	public static boolean ModComplianceType(TypeSpec type0, TypeSpec type1) {
		if (isInteger(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isReal(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isLong(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isNull(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;

		}

		return false;
	}

	public static boolean checkGreaterExpressionType(TypeSpec type0,
			TypeSpec type1) {
		return checkRelationExpressionType(type0, type1);
	}

	public static boolean checkGreaterEqualExpressionType(TypeSpec type0,
			TypeSpec type1) {
		return checkRelationExpressionType(type0, type1);
	}

	public static boolean checkLessExpressionType(TypeSpec type0, TypeSpec type1) {
		return checkRelationExpressionType(type0, type1);
	}

	public static boolean checkLessEqualExpressionType(TypeSpec type0,
			TypeSpec type1) {
		return checkRelationExpressionType(type0, type1);
	}

	public static boolean checkRelationExpressionType(TypeSpec type0,
			TypeSpec type1) {

		if (isInteger(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isReal(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isLong(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isChar(type0)) {
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isVarChar(type0)) {
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isDate(type0)) {
			if (isDate(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isNull(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
			if (isDate(type1))
				return true;
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isBoolean(type1))
				return true;
			if (isTimestamp(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
			if (isIntervalDS(type1))
				return true;
		}
		if (isBoolean(type0)) {
			if (isBoolean(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isIntervalYM(type0)) {
			if (isNull(type1))
				return true;
			if (isIntervalYM(type1))
				return true;
		}
		if (isIntervalDS(type0)) {
			if (isIntervalDS(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		if (isTimestamp(type0)) {
			if (isTimestamp(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		return false;
	}

	public static boolean checkAndExpressionType(TypeSpec type0, TypeSpec type1) {

		if (isNull(type0)) {
			if (isNull(type1))
				return true;
			if (isBoolean(type1))
				return true;
		}
		if (isBoolean(type0)) {
			if (isBoolean(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		return false;
	}

	public static boolean checkOrExpressionType(TypeSpec type0, TypeSpec type1) {

		if (isNull(type0)) {
			if (isNull(type1))
				return true;
			if (isBoolean(type1))
				return true;
		}
		if (isBoolean(type0)) {
			if (isBoolean(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		return false;
	}

	public static boolean checkNegateExpressionType(TypeSpec type0) {
		if (isNull(type0) || isReal(type0) || isInteger(type0) || isLong(type0))
			return true;

		return false;
	}

	public static boolean equalComplianceType(TypeSpec type1, TypeSpec type2) {
		return checkRelationExpressionType(type1, type2);
	}

	public static boolean notEqualComplianceType(TypeSpec type1, TypeSpec type2) {
		return checkRelationExpressionType(type1, type2);
	}

	public static boolean inCompatible(TypeSpec type1, TypeSpec type2) {

		if (isReal(type1)) {
			if (isNull(type2))
				return true;
			if (isInteger(type2))
				return true;
			if (isReal(type2))
				return true;
			if (isLong(type2))
				return true;
		}
		if (isInteger(type1)) {
			if (isReal(type2))
				return true;
			if (isLong(type2))
				return true;
			if (isInteger(type2))
				return true;
			if (isNull(type2))
				return true;
		}
		if (isLong(type1)) {
			if (isReal(type2))
				return true;
			if (isInteger(type2))
				return true;
			if (isLong(type2))
				return true;
			if (isNull(type2))
				return true;
		}
		if (isNull(type1)) {
			if (isReal(type2))
				return true;
			if (isInteger(type2))
				return true;
			if (isLong(type2))
				return true;
			if (isNull(type2))
				return true;
			if (isDate(type2))
				return true;
			if (isChar(type2))
				return true;
			if (isVarChar(type2))
				return true;
			if (isBoolean(type2))
				return true;
			if (isTimestamp(type2))
				return true;
			if (isIntervalYM(type2))
				return true;
			if (isIntervalDS(type2))
				return true;
		}
		if (isDate(type1)) {
			if (isDate(type2))
				return true;
			if (isNull(type2))
				return true;
		}
		if (isChar(type1)) {
			if (isNull(type2))
				return true;
			if (isChar(type2))
				return true;
			if (isVarChar(type2))
				return true;
		}
		if (isVarChar(type1)) {
			if (isNull(type2))
				return true;
			if (isChar(type2))
				return true;
			if (isVarChar(type2))
				return true;
		}
		if (isBoolean(type1)) {
			if (isNull(type2))
				return true;
			if (isBoolean(type2))
				return true;
		}

		if (isTimestamp(type1)) {
			if (isNull(type2))
				return true;
			if (isTimestamp(type2))
				return true;
		}

		if (isIntervalYM(type1)) {
			if (isNull(type2))
				return true;
			if (isIntervalYM(type2))
				return true;
		}

		if (isIntervalDS(type1)) {
			if (isNull(type2))
				return true;
			if (isIntervalDS(type2))
				return true;
		}

		return false;

	}

	public static boolean compareCaseWhenExpression(
			ConstantExpression caseExpression, ConstantExpression whenExpression)
			throws Exception {
		/*TypeSpec caseType = caseExpression != null ? caseExpression
				.getTypeSpec() : Predefined.undefinedType;
		TypeSpec whenType = whenExpression != null ? whenExpression
				.getTypeSpec() : Predefined.undefinedType;

		if (caseExpression.getConstValue() == null
				|| whenExpression.getConstValue() == null)
			return false;
		if (isInteger(caseType)) {
			if (isInteger(whenType)) {
				int caseValue = (int) caseExpression.getConstValue();
				int whenValue = (int) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isReal(whenType)) {
				int caseValue = (int) caseExpression.getConstValue();
				double whenValue = (double) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isLong(whenType)) {
				int caseValue = (int) caseExpression.getConstValue();
				long whenValue = (long) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isNull(whenType)) {
				return false;
			}
		}
		if (isReal(caseType)) {
			if (isInteger(whenType)) {
				double caseValue = (double) caseExpression.getConstValue();
				int whenValue = (int) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isReal(whenType)) {
				double caseValue = (double) caseExpression.getConstValue();
				double whenValue = (double) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isLong(whenType)) {
				double caseValue = (double) caseExpression.getConstValue();
				long whenValue = (long) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isNull(whenType)) {
				return false;
			}
		}
		if (isLong(caseType)) {
			if (isInteger(whenType)) {
				long caseValue = (long) caseExpression.getConstValue();
				int whenValue = (int) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isReal(whenType)) {
				long caseValue = (long) caseExpression.getConstValue();
				double whenValue = (double) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isLong(whenType)) {
				long caseValue = (long) caseExpression.getConstValue();
				long whenValue = (long) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isNull(whenType)) {
				return false;
			}
		}
		if (isChar(caseType)) {
			if (isChar(whenType)) {
				// try {
				Boolean compare = StringCompareUtil.compare(caseExpression,
						whenExpression, StringCompareUtil.EQUAL);
				return compare;
				// } catch (Exception e) {
				// // TODO 自动生成的 catch 块
				// e.printStackTrace();
				// }
			}
			if (isVarChar(whenType)) {
				// try {
				Boolean compare = StringCompareUtil.compare(caseExpression,
						whenExpression, StringCompareUtil.EQUAL);
				return compare;
				// } catch (Exception e) {
				// // TODO 自动生成的 catch 块
				// e.printStackTrace();
				// }
			}
			if (isNull(whenType)) {
				return false;
			}
		}

		if (isVarChar(caseType)) {
			if (isChar(whenType)) {
				// try {
				Boolean compare = StringCompareUtil.compare(caseExpression,
						whenExpression, StringCompareUtil.EQUAL);
				return compare;
				// } catch (Exception e) {
				// // TODO 自动生成的 catch 块
				// e.printStackTrace();
				// }
			}
			if (isVarChar(whenType)) {
				// try {
				Boolean compare = StringCompareUtil.compare(caseExpression,
						whenExpression, StringCompareUtil.EQUAL);
				return compare;
				// } catch (Exception e) {
				// // TODO 自动生成的 catch 块
				// e.printStackTrace();
				// }
			}
			if (isNull(whenType)) {
				return false;
			}
		}

		if (isDate(caseType)) {
			if (isDate(whenType)) {
				long caseValue = (long) caseExpression.getConstValue();
				long whenValue = (long) whenExpression.getConstValue();
				return caseValue == whenValue;
			}
			if (isNull(whenType)) {
				return false;
			}
		}
		if (isNull(caseType)) {
			return false;
		}
		if (isBoolean(caseType)) {
			if (isBoolean(whenType)) {
				BooleanValue caseValue = (BooleanValue) caseExpression
						.getConstValue();
				BooleanValue whenValue = (BooleanValue) whenExpression
						.getConstValue();
				if (caseValue.equals(BooleanValue.TRUE)
						&& whenValue.equals(BooleanValue.FALSE)) {
					return false;
				}
				if (caseValue.equals(BooleanValue.TRUE)
						&& whenValue.equals(BooleanValue.TRUE)) {
					return true;
				}
				if (caseValue.equals(BooleanValue.FALSE)
						&& whenValue.equals(BooleanValue.TRUE)) {
					return false;
				}
				if (caseValue.equals(BooleanValue.FALSE)
						&& whenValue.equals(BooleanValue.FALSE)) {
					return true;
				}
			}
			if (isNull(whenType)) {
				return false;
			}
		}
		if (isTimestamp(caseType)) {

			if (isTimestamp(whenType)) {

				JTimestampValue lhs = SysFunctionAdapter
						.toJTimestampValue((ConstantExpression) caseExpression);
				JTimestampValue rhs = SysFunctionAdapter
						.toJTimestampValue((ConstantExpression) whenExpression);
				JBooleanValue retVal = new JBooleanValue();
				SysFunctionAdapter service = new SysFunctionAdapter();
				service.ts_relational_op(lhs, rhs, OperatorValue.OP_EQUAL,
						retVal);
				return retVal.getValue();
			}
			if (isNull(whenType)) {
				return false;
			}
		}
		if (isIntervalDS(caseType)) {
			if (isIntervalDS(whenType)) {
				JIntervalDSValue lhs = SysFunctionAdapter
						.toJIntervalDSValue((ConstantExpression) caseExpression);
				JIntervalDSValue rhs = SysFunctionAdapter
						.toJIntervalDSValue((ConstantExpression) caseExpression);
				JBooleanValue retVal = new JBooleanValue();
				SysFunctionAdapter service = new SysFunctionAdapter();
				service.dsi_relational_op(lhs, rhs, OperatorValue.OP_EQUAL,
						retVal);
				return retVal.getValue();
			}
			if (isNull(whenType)) {
				return false;
			}
		}
		if (isIntervalYM(caseType)) {
			if (isIntervalYM(whenType)) {
				JIntervalYMValue lhs = SysFunctionAdapter
						.toJIntervalYMValue((ConstantExpression) caseExpression);
				JIntervalYMValue rhs = SysFunctionAdapter
						.toJIntervalYMValue((ConstantExpression) caseExpression);
				JBooleanValue retVal = new JBooleanValue();
				SysFunctionAdapter service = new SysFunctionAdapter();
				service.ymi_relational_op(lhs, rhs, OperatorValue.OP_EQUAL,
						retVal);
				return retVal.getValue();
			}
			if (isNull(whenType)) {
				return false;
			}
		}*/
		return false;

	}

	public static boolean checkCaseWhenExpressionType(TypeSpec type0,
			TypeSpec type1) {

		if (isInteger(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		if (isReal(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		if (isLong(type0)) {
			if (isInteger(type1))
				return true;
			if (isReal(type1))
				return true;
			if (isLong(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		if (isChar(type0)) {
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		if (isVarChar(type0)) {
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		if (isDate(type0)) {
			if (isDate(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		if (isNull(type0)) {
			if (isNull(type1))
				return true;
			if (isDate(type1))
				return true;
			if (isChar(type1))
				return true;
			if (isVarChar(type1))
				return true;
			if (isBoolean(type1))
				return true;
		}
		if (isTimestamp(type0)) {
			if (isTimestamp(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isIntervalDS(type0)) {
			if (isIntervalDS(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isIntervalYM(type0)) {
			if (isIntervalYM(type1))
				return true;
			if (isNull(type1))
				return true;
		}
		if (isBoolean(type0)) {
			if (isBoolean(type1))
				return true;
			if (isNull(type1))
				return true;
		}

		return false;
	}

	// 根据thenExpression和elseExpression的类型 判断caseWhen表达式最后的返回结果
	public static TypeSpec getCaseWhenExpressionType(
			List<Expression> thenExpression) {
		// (1)如果所有的thenExpression表达式的类型都一致,则任意找一个then表达式的类型作为返回值
		// (2)如果是混合int、long、double则返回结果为double,
		// (3)如果是varchar和char混合返回varchar
		// (4)如果数值类型（int、long、double）和字符类型(char、varchar)或者null类型混合则报错(暂时返回Predefined.undefinedType)

		int intNum = 0; // 记录thenExpression表达式中类型是interger的个数
		int longNum = 0; // 记录thenExpression表达式中类型是long的个数
		int doubleNum = 0; // 记录thenExpression表达式中类型是double的个数
		int charNum = 0; // 记录thenExpression表达式中类型是char的个数
		int varcharNum = 0; // 记录thenExpression表达式中类型是varchar的个数
		int timestampNum = 0;// 记录thenExpression表达式中类型是ts的个数
		int intervaldsNum = 0;// 记录thenExpression表达式中类型是ids的个数
		int intervalymNum = 0;// 记录thenExpression表达式中类型是iym的个数
		int nullNum = 0; // 记录thenExpression表达式中类型是null的个数
		int dateNum = 0; // 记录thenExpression表达式中类型是date的个数
		for (int i = 0; i < thenExpression.size(); i++) {
			Expression expression = thenExpression.get(i);
			if (TypeChecker.isInteger(expression.getTypeSpec())) {
				intNum++;
			}
			if (TypeChecker.isLong(expression.getTypeSpec())) {
				longNum++;
			}
			if (TypeChecker.isReal(expression.getTypeSpec())) {
				doubleNum++;
			}
			if (TypeChecker.isChar(expression.getTypeSpec())) {
				charNum++;
			}
			if (TypeChecker.isVarChar(expression.getTypeSpec())) {
				varcharNum++;
			}
			if (TypeChecker.isTimestamp(expression.getTypeSpec())) {
				timestampNum++;
			}
			if (TypeChecker.isIntervalDS(expression.getTypeSpec())) {
				intervaldsNum++;
			}
			if (TypeChecker.isIntervalYM(expression.getTypeSpec())) {
				intervalymNum++;
			}
			if (TypeChecker.isNull(expression.getTypeSpec())) {
				nullNum++;
			}
			if (TypeChecker.isDate(expression.getTypeSpec())) {
				dateNum++;
			}
		}
		// 如果所有的thenExpression表达式的类型都一致
		if (intNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是Interger
				longNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是long
				doubleNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是double
				charNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是char
				varcharNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是varchar
				timestampNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是timestamp
				intervaldsNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是intervalds
				intervalymNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是intervalym
				dateNum == thenExpression.size() || // 所有的thenExpression表达式的类型都是date
				nullNum == thenExpression.size() // 所有的thenExpression表达式的类型都是null
		) {
			Expression expression = thenExpression.get(0);// 任意找一个then表达式的类型作为返回值
			return expression.getTypeSpec();
		}
		// 如果只有null和其他一个类型，则为其他类型
		if (nullNum != 0) {
			int other = thenExpression.size() - nullNum;
			if (intNum == other || // 所有的thenExpression表达式的类型都是Interger
					longNum == other || // 所有的thenExpression表达式的类型都是long
					doubleNum == other || // 所有的thenExpression表达式的类型都是double
					charNum == other || // 所有的thenExpression表达式的类型都是char
					dateNum == other || // 所有的thenExpression表达式的类型都是date
					timestampNum == other || // 所有的thenExpression表达式的类型都是timestamp
					intervaldsNum == other || // 所有的thenExpression表达式的类型都是intervalds
					intervalymNum == other || varcharNum == other) { // 所有的thenExpression表达式的类型都是varchar
				// 任意找一个非null的then表达式的类型作为返回值
				for (Expression expression : thenExpression) {
					if (!isNull(expression.getTypeSpec())) {
						return expression.getTypeSpec();
					}
				}
			}
		}

		// (2)如果是混合int、long、double,null则返回结果为:
		// long int => long
		// long double => double
		// int double => double
		// int long double => double
		if (charNum == 0 && varcharNum == 0 && dateNum == 0
				&& timestampNum == 0 && intervaldsNum == 0
				&& intervalymNum == 0) {
			if (longNum != 0 && intNum != 0 && doubleNum == 0) { // long int =>
																	// long
				return Predefined.longType;
			}
			if (longNum != 0 && doubleNum != 0 && intNum == 0) { // long double
																	// => double
				return Predefined.doubleType;
			}
			if (intNum != 0 && doubleNum != 0 && longNum == 0) { // int double
																	// => double
				return Predefined.doubleType;
			}
			if (longNum != 0 && intNum != 0 && doubleNum != 0) { // int long
																	// double =>
																	// double
				return Predefined.doubleType;
			}
		}

		// (3)如果是varchar和char混合返回varchar
		if (longNum == 0 && intNum == 0 && doubleNum == 0 && timestampNum == 0
				&& intervaldsNum == 0 && intervalymNum == 0 && dateNum == 0) {
			return Predefined.varcharType;
		}

		// //(4)如果数值类型（int、long、double）和字符类型(char、varchar)或者null或timestamp或intervalds或intervalym类型混合则报错(暂时返回Predefined.undefinedType)
		// if((longNum!=0 || intNum!=0 || doubleNum!=0) && (charNum!=0 ||
		// varcharNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((longNum!=0 || intNum!=0 || doubleNum!=0) && (dateNum!=0)){
		// return Predefined.undefinedType;
		// }
		// // if((longNum!=0 || intNum!=0 || doubleNum!=0) && (nullNum!=0)){
		// // return Predefined.undefinedType;
		// // }
		// if((longNum!=0 || intNum!=0 || doubleNum!=0) && (timestampNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((longNum!=0 || intNum!=0 || doubleNum!=0) && (intervaldsNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((longNum!=0 || intNum!=0 || doubleNum!=0) && (intervalymNum!=0)){
		// return Predefined.undefinedType;
		// }
		// // if((nullNum!=0) && (charNum!=0 || varcharNum!=0)){
		// // return Predefined.undefinedType;
		// // }
		// if((timestampNum!=0) && (charNum!=0 || varcharNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((intervaldsNum!=0) && (charNum!=0 || varcharNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((intervalymNum!=0) && (charNum!=0 || varcharNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((dateNum!=0) && (charNum!=0 || varcharNum!=0)){
		// return Predefined.undefinedType;
		// }
		// // if((timestampNum!=0) && (nullNum!=0)){
		// // return Predefined.undefinedType;
		// // }
		// // if((intervaldsNum!=0) && (nullNum!=0)){
		// // return Predefined.undefinedType;
		// // }
		// // if((intervalymNum!=0) && (nullNum!=0)){
		// // return Predefined.undefinedType;
		// // }
		// if((intervaldsNum!=0) && (timestampNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((intervalymNum!=0) && (timestampNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((dateNum!=0) && (timestampNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((dateNum!=0) && (intervaldsNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((dateNum!=0) && (intervalymNum!=0)){
		// return Predefined.undefinedType;
		// }
		// if((intervalymNum!=0) && (intervaldsNum!=0)){
		// return Predefined.undefinedType;
		// }
		// (4)如果数值类型（int、long、double）和字符类型(char、varchar)混合则报错(暂时返回Predefined.undefinedType)
		// if((longNum!=0 || intNum!=0 || doubleNum!=0) && (charNum!=0 ||
		// varcharNum!=0)){
		// return Predefined.undefinedType;
		// }

		return Predefined.undefinedType;

	}

	public static boolean likeCompatible(TypeSpec type1, TypeSpec type2) {

		if(isNull(type1)){
	 		if(isNull(type2)) return true;
	 		if(isChar(type2)) return true;
	 		if(isVarChar(type2)) return true;
	 	}
	 	if(isChar(type1)){
	 		if(isNull(type2)) return true;
	 		if(isChar(type2)) return true;
	 		if(isVarChar(type2)) return true;
	 	}
	 	if(isVarChar(type1)){
	 		if(isNull(type2)) return true;
	 		if(isChar(type2)) return true;
	 		if(isVarChar(type2)) return true;
	 	}
	    	
		return false;
	}

	public static boolean betweenAndCompatible(TypeSpec type1, TypeSpec type2) {
		if (isReal(type1)) {
			if (isNull(type2))
				return true;
			if (isInteger(type2))
				return true;
			if (isReal(type2))
				return true;
			if (isLong(type2))
				return true;
		}
		if (isInteger(type1)) {
			if (isReal(type2))
				return true;
			if (isLong(type2))
				return true;
			if (isInteger(type2))
				return true;
			if (isNull(type2))
				return true;
		}
		if (isLong(type1)) {
			if (isReal(type2))
				return true;
			if (isInteger(type2))
				return true;
			if (isLong(type2))
				return true;
			if (isNull(type2))
				return true;
		}
		if (isDate(type1)) {
			if (isDate(type2))
				return true;
			if (isNull(type2))
				return true;
		}
		if (isNull(type1)) {
			if (isNull(type2))
				return true;
			if (isChar(type2))
				return true;
			if (isVarChar(type2))
				return true;
			if (isReal(type2))
				return true;
			if (isInteger(type2))
				return true;
			if (isLong(type2))
				return true;
			if (isDate(type2))
				return true;
		}
		if (isChar(type1)) {
			if (isNull(type2))
				return true;
			if (isChar(type2))
				return true;
			if (isVarChar(type2))
				return true;
		}
		if (isVarChar(type1)) {
			if (isNull(type2))
				return true;
			if (isChar(type2))
				return true;
			if (isVarChar(type2))
				return true;
		}

		if (isTimestamp(type1)) {
			if (isNull(type2))
				return true;
			if (isTimestamp(type2))
				return true;
		}

		if (isIntervalYM(type1)) {
			if (isNull(type2))
				return true;
			if (isIntervalYM(type2))
				return true;
		}
		if (isIntervalDS(type1)) {
			if (isNull(type2))
				return true;
			if (isIntervalDS(type2))
				return true;
		}

		return false;

	}

	public static boolean checkNotExpressionType(TypeSpec type) {

		if (isBoolean(type))
			return true;
		if (isNull(type))
			return true;
		return false;
	}

	public static boolean checkCastFunctionType(TypeSpec type, TypeSpec toType) {

		/**
		 * type为数字,toType为字符串/数字
		 * type为字符串,toType为数字/字符串/date/timestamp/yminterval/dsinterval
		 * type为date,toType为字符串/date/timestamp
		 * type为YMInterval,toType为字符串/YMInterval
		 * type为YMInterval,toType为字符串/YMInterval type可为null,toType不能为null
		 */
		if (type == null || toType == null)
			return false;

		// type为数字,toType为字符串/数字
		if (isInteger(type) || isLong(type) || isReal(type)) {
			if (isInteger(toType) || isLong(toType) || isReal(toType)
					|| isChar(toType) || isVarChar(toType))
				return true;
		}

		// type为字符串,toType为数字/字符串/date/timestamp/yminterval/dsinterval
		if (isChar(type)) {
			if (isInteger(toType) || isLong(toType) || isReal(toType)
					|| isChar(toType) || isVarChar(toType) || isDate(toType)
					|| isTimestamp(toType) || isIntervalYM(toType)
					|| isIntervalDS(toType))
				return true;
		}

		if (isVarChar(type)) {
			if (isInteger(toType) || isLong(toType) || isReal(toType)
					|| isChar(toType) || isVarChar(toType) || isDate(toType)
					|| isTimestamp(toType) || isIntervalYM(toType)
					|| isIntervalDS(toType))
				return true;
		}

		// type为date,toType为字符串/date/timestamp
		if (isDate(type)) {
			if (isChar(toType) || isVarChar(toType) || isDate(toType)
					|| isTimestamp(toType))
				return true;
		}

		if (isTimestamp(type)) {
			if (isChar(toType) || isVarChar(toType) || isDate(toType)
					|| isTimestamp(toType)) {
				return true;
			}
		}

		// type为YMInterval,toType为字符串/YMInterval
		if (isIntervalYM(type)) {
			if (isChar(toType) || isVarChar(toType) || isIntervalYM(toType))
				return true;
		}

		// type为YMInterval,toType为字符串/YMInterval
		if (isIntervalDS(type)) {
			if (isChar(toType) || isVarChar(toType) || isIntervalDS(toType))
				return true;
		}

		// type可为null,toType不能为null
		if (isNull(type)) {
			if (!isNull(toType))
				return true;
		}

		return false;
	}
	
	public static boolean matchCursorAndIntoList(TypeSpec type , List<VariableExpression> intoList){

		//获取左边记录的符号表
		SymTab symTab_left = (SymTab) type.getAttribute(TypeKeyImpl.RECORD_SYMTAB);
		List<SymTabEntry> symTabEntrys_left = symTab_left.sortedEntries();
		//记录之间赋值 字域数量必须相同
		if(symTabEntrys_left.size()!=intoList.size()){
			return false;
		}else{
			boolean flag = true;
			for(int i=0;i<symTabEntrys_left.size();i++){
				SymTabEntry left = symTabEntrys_left.get(i);
				TypeSpec type1 = left.getTypeSpec();
				TypeSpec type2 = intoList.get(i).getTypeSpec();
				if(!type1.equals(type2)){
					flag = false;
					break;
				}
			}
			if(flag){
				return true;
			}else{
				return false;
			}
			
		}
	}

}
