package com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.statement;

import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.CallStack;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.FunctionCallContext;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.RuntimeStatementPointer;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;

/**
 * 存储过程程序语句的父类
 */
public abstract class Statement extends SyntaxTree{
	private static final long serialVersionUID = 1L;
	protected Integer size;
	
//	protected StatementStatus status;

//	public StatementStatus getStatus() {
//		return status;
//	}
//
//	public void setStatus(StatementStatus status) {
//		this.status = status;
//	}

	public Integer getSize() {
		return size;
	}

	public void setSize(Integer size) {
		this.size = size;
	}
	
//	public void clearStatus(){
//		this.status = null;
//	}
	
	/**
	 * 进入语句时,将语句压入callStack,
	 * 若已为栈顶语句,返回false
	 */
	public boolean onEnteringStatement(FunctionCallContext ctx, CallStack callStack)throws Exception{
		
		RuntimeStatementPointer ptr = callStack.peek();
		
//		Statement stmt = ptr == null ? null : ptr.getStatement();
		
		//进入callStack
//		if(stmt == null){//栈中无元素,为根语句且初次调用
//			
//			RuntimeStatementPointer newptr = 
//					new RuntimeStatementPointer(this,0);
//			
//			callStack.push(newptr);
//			
//			return true;
//			
//		}else 
			if(ptr == null || ptr.getStatement() != this ){//栈顶不是自己,为父语句初次调用
			
			RuntimeStatementPointer newptr = 
					new RuntimeStatementPointer(this,0);
			
			callStack.push(newptr);
			
			return true;
			
		}
		return false;
		
	}
	
	/**
	 * 语句执行结束并退出时,
	 * 弹出自己并给上层语句index+1,
	 * 若上一层同时结束调用其退出方法
	 */
	public boolean onExitingStatement(FunctionCallContext ctx, CallStack callStack)throws Exception{
		
		RuntimeStatementPointer ptr = callStack.peek();
		
		Statement stmt = ptr.getStatement();
		
		//在栈顶则语句出栈,并给上层语句index+1
		//若上层也结束则调用上层语句的退出方法
		if(stmt!=null && stmt == this){
	
			callStack.pop();
			Statement top = callStack.getTopStatement();
			
//			if(!(top instanceof WhileStatement)){
			if(top == null) return true;
			boolean canNext = top.nextSubStatement(ctx, callStack);
			if(!canNext){
				top.onExitingStatement(ctx, callStack);
			}
//			}
			
			return true;
		}
		
		return false;
	}
	
	/**
	 * 下一个子语句入栈,
	 * 先给stmt的index+1,再调用其stepExec方法将对应子语句入栈,
	 * 若不能 index+1,则返回false
	 */
	public boolean nextSubStatement(FunctionCallContext ctx, CallStack callStack)throws Exception{
		
		RuntimeStatementPointer ptr = callStack.peek();
//		
		Statement stmt = ptr.getStatement();
//		
//		//在栈顶则语句+1
		if(stmt!=null && stmt == this){
			
			int index = ptr.getCurrentIndex();
			
			if(index < stmt.getSize()-1){
				index++;
				ptr.setCurrentIndex(index);
				
				//复合语句的stepExec实际上是将语句压入栈中
				stmt.stepExecute(ctx, callStack);
				
				return true;
			}else{
				return false;
			}
		}
		return false;
	}
	
	public void exitStatementImmediately(FunctionCallContext ctx, CallStack callStack)throws Exception{
		
		callStack.pop();
	}
	
	
//	@Override
//	public void exceptionHandle(FunctionCallContext ctx, CallStack callStack,
//			Exception e) throws Exception {
//		
//		ProcedureException procedureException = null;
//		
//		//第一次抛出
//		if(!(e instanceof ProcedureException)){
//			procedureException = ProcedureException.createInstance(e);
//			//追加异常记录
//			procedureException.appendExceptionRecord(null, 
//					(Integer)this.getAttribute(SyntaxTreeKeyImpl.LINE), 
//					(Integer)this.getAttribute(SyntaxTreeKeyImpl.POSITION));
//			//异常保存在ctx中
//			ctx.setException(procedureException);
//		}else{
//			procedureException = (ProcedureException)e;
//		}
//		
//		//如果为不可恢复异常,退出并调用父语句的退出
//		if(!procedureException.isRecoverable()){
//			
//			this.exitStatementImmediately(ctx, callStack);
//			
//			Statement top = callStack.getTopStatement();
//			
//			if(top != null){
//				top.exceptionHandle(ctx, callStack, procedureException);
//			}else{
//				throw procedureException;
//			}
//			
//		}
//		
//	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
}
