package com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression;

import java.lang.reflect.Field;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.CallStack;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.FunctionCallContext;
import com.bonc.xcloud.sp_procedure.intermediate.TypeSpec;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.constantExpression.ConstantExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.variableExpression.VariableExpression;


/**
 * 存储过程程序表达式的父类
 */
public abstract class Expression extends SyntaxTree{
	private static final long serialVersionUID = 1L;
	protected TypeSpec type;//类型
	
//	protected ConstantExpression value;
	
	/**
	 * set类型
	 */
	public void setTypeSpec(TypeSpec type) {
		
		this.type = type;
	}

	/**
	 * get类型
	 */
	public TypeSpec getTypeSpec() {
		
		return type;
	}
	
//	public ConstantExpression getValue() {
//		return value;
//	}
//
//	public void setValue(ConstantExpression value) {
//		this.value = value;
//	}
	
//	public void clearValue(){
//		this.value = null;
//	}
	
//	public void clearIntermerdiaValue(CallStack callStack)throws Exception{
//		this.value = null;
//	}
	

	@Override
	public abstract ConstantExpression execute(FunctionCallContext ctx);
	
	
	@Override
	public void exceptionHandle(FunctionCallContext ctx, CallStack callStack,
			Exception e) throws Exception {
		
		/*//第一次抛出
		if(!(e instanceof ProcedureException)){
			ExceptionUtil.throwProcedureException(
					null, this, null,e);
		}else{
			throw e;
		}*/
	}
	
   /** 
    * 此方法只能检查Expression表达式的（Expression）类型的子域，不能对集合泛型进行检查，并且严重依赖Field的getter，setter方法
    * 返回true代表非法，返回false 代表正常
    * @author: 武喜亮
    * @throws Exception
    */
   public boolean cycleCounterCheck(String counter) throws Exception{
	   //表达式是否合法标识
	   boolean illegal = false;
	   if(VariableExpression.class.isAssignableFrom(this.getClass())){
		   VariableExpression exp = (VariableExpression) this;
		   if(exp.getVarName().equalsIgnoreCase(counter)) return true;
	   }
	   
	   //返回此Class对象的全部成员变量，与成员变量的访问权限无关
	   Field[] fields =  this.getClass().getDeclaredFields();
	   for (int i = 0; i < fields.length; i++) {
		   Field field = fields[i];
		   //设置通过反射访问该成员变量时，取消访问权限检查
		   field.setAccessible(true);
		   
		   //判断此Field的类型是否为Expression或其子类
		   boolean isSubClass = Expression.class.isAssignableFrom(field.getType());
		   if(!isSubClass){
			   continue;
		   }else{
			  //判断此表达式类型是否为不可分割的元表达式类型
			  if(VariableExpression.class.isAssignableFrom(field.getType())){
				  VariableExpression exp = (VariableExpression) field.get(this);
				  if(exp == null){
					  continue;
				  } else if(exp.getVarName().equalsIgnoreCase(counter)) {
					  return true;
				  }
			  }else if(ConstantExpression.class.isAssignableFrom(field.getType())){
				  continue;
			  }else{
				  Expression exp = (Expression) field.get(this);
				  if(exp == null){
					  continue;
				  }else{
					  illegal = exp.cycleCounterCheck(counter);
					  if(illegal) return true;
				  }
			  } 
		   }
	   }
	   return illegal;
   }
	
}
