package com.bonc.xcloud.sp_procedure.intermediate.syntax.sql;

import java.util.List;

import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.CallStack;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.FunctionCallContext;

/**
 * 实时数仓新增语法
 * UPSERT [schema_name.]table_name[(col_name [, ...n])] [ON PARTITION(condition [, ...n])] VALUES(? [, ...n])
 */
public class UpsertValueStatement extends SqlStatement{

	private static final long serialVersionUID = -2997417943537012208L;
	private String hint;
	private List<String> conditions;
	private List<List<String>> valueExpression;
	 
	//upsert 前的注释
	private String annotation;
	//upsert的schemaName
	private String schemaName;
	//upsert的tableName
	private String tableName;
	//upsert的Table的Columns
	private List<String> columnList;
	//upsert的tableName后面的dblink
	private String dblink;
	
	public UpsertValueStatement() {
		
	}

	public UpsertValueStatement(String schemaName,String tableName,List<String> columnList,
			String hint,List<String> conditions,List<List<String>> valueExpression) {
		this.hint=hint;
		this.schemaName=schemaName;
		this.tableName=tableName;
		this.columnList=columnList;
		this.conditions=conditions;
		this.valueExpression = valueExpression;
	}

	@Override
	protected Object stepExec(FunctionCallContext ctx, CallStack callStack)
			throws Exception {
		// TODO 自动生成的方法存根
		return super.stepExec(ctx, callStack);
	}

	@Override
	public String toSql(FunctionCallContext ctx) {
		StringBuffer stb=new StringBuffer();
		if(annotation!=null)
			stb.append(" "+annotation+" ");
		stb.append("UPSERT ");
		if(hint!=null){
			stb.append(hint);
		}
		if(schemaName!=null)
			stb.append(schemaName+".");
		if(tableName!=null)
			stb.append(tableName);
		if(dblink != null)
			stb.append("@"+dblink);
		if(columnList!=null){
			stb.append("(");
			for (int i = 0; i < columnList.size(); i++) {
				stb.append(columnList.get(i));
				if(i!=columnList.size()-1)stb.append(",");
			}
			stb.append(") ");
		}
		if(conditions!=null){
			stb.append(" PARTITION ON (");
			for (int i = 0; i < conditions.size(); i++) {
				stb.append(conditions.get(i));
				if(i!=conditions.size()-1)stb.append(",");
			}
			stb.append(") ");
		}
		stb.append(" values ");
		for (int i = 0; i < valueExpression.size(); i++) {
			List<String> list = valueExpression.get(i);
			stb.append("(");
			for (int j = 0; j < list.size(); j++) {
				stb.append(list.get(j));
				if(j!=list.size()-1)stb.append(",");
			}
			stb.append(")");
			if(i!=valueExpression.size()-1)stb.append(",");
		}
		String sqlStr = stb.toString();
		return sqlStr;
	}

	
	public String getAnnotation() {
		return annotation;
	}

	public void setAnnotation(String annotation) {
		this.annotation = annotation;
	}

	public String getSchemaName() {
		return schemaName;
	}

	public void setSchemaName(String schemaName) {
		this.schemaName = schemaName;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public List<String> getColumnList() {
		return columnList;
	}

	public void setColumnList(List<String> columnList) {
		this.columnList = columnList;
	}

	public String getHint() {
		return hint;
	}

	public void setHint(String hint) {
		this.hint = hint;
	}

	public List<String> getConditions() {
		return conditions;
	}

	public void setConditions(List<String> conditions) {
		this.conditions = conditions;
	}

	public List<List<String>> getValueExpression() {
		return valueExpression;
	}

	public void setValueExpression(List<List<String>> valueExpression) {
		this.valueExpression = valueExpression;
	}

	public String getDblink() {
		return dblink;
	}

	public void setDblink(String dblink) {
		this.dblink = dblink;
	}

}
