package com.bonc.xcloud.sp_procedure.intermediate.syntax.sql;

import java.util.List;

import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.CallStack;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.FunctionCallContext;

/**
 * 由数据库插入到行云<br/>
 * 1.从远端数据库加载数据<br/>
 * INSERT INTO [/</>*+IGNORE_ERR_LINE*</>/] [schema_name.]table_name [(col_name, …)] [PARTITION ON（Condition,…）]{Select…/with as} @DBLINK<br/>
 * 2.从本地数据库加载数据<br/>
 * INSERT INTO [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name [(col_name, …)] [PARTITION ON（Condition,…）] Select子句/with as 
 */
public class InsertIntoFromDB extends InsertIntoStatement{

	private static final long serialVersionUID = -3655522289468452041L;
	private String hint;
	private List<String> conditions;
    private String sel;
	private String dblinkName;
	
	public InsertIntoFromDB() {
	}

	
	public InsertIntoFromDB(String schemaName,String tableName,List<String> columnList,
			 String hint,List<String> conditions, String sel,String dblinkName) {
		this.schemaName=schemaName;
		this.tableName=tableName;
		this.columnList=columnList;
		this.hint=hint;
		this.conditions = conditions;
		this.sel = sel;
		this.dblinkName = dblinkName;
	}

	public String getHint() {
		return hint;
	}

	public void setHint(String hint) {
		this.hint = hint;
	}

	public List<String> getConditions() {
		return conditions;
	}


	public void setConditions(List<String> conditions) {
		this.conditions = conditions;
	}


	public String getSel() {
		return sel;
	}


	public void setSel(String sel) {
		this.sel = sel;
	}


	public String getDblinkName() {
		return dblinkName;
	}

	public void setDblinkName(String dblinkName) {
		this.dblinkName = dblinkName;
	}

	@Override
	public String toSql(FunctionCallContext ctx) {
		StringBuffer stb=new StringBuffer();
		if(annotation!=null)
			stb.append(" "+annotation+" ");
		stb.append("INSERT ");
		if(pocHint!=null)
		stb.append(" "+pocHint+" ");
		stb.append(" INTO ");
		if(hint!=null){
			stb.append(hint);
		}
		if(schemaName!=null)
			stb.append(schemaName+".");
		if(tableName!=null)
			stb.append(tableName);
		if(dblink != null)
			stb.append("@"+dblink);
		if(columnList!=null){
			stb.append(" (");
			for (int i = 0; i < columnList.size(); i++) {
				stb.append(columnList.get(i));
				if(i!=columnList.size()-1)stb.append(",");
			}
			stb.append(") ");
		}
		if(conditions!=null){
			stb.append(" PARTITION ON (");
			for (int i = 0; i < conditions.size(); i++) {
				stb.append(conditions.get(i));
				if(i!=conditions.size()-1)stb.append(",");
			}
			stb.append(") ");
		}
		if(dblinkName!=null){
			stb.append(" {").append(sel).append("} ").append("@"+dblinkName);
		}else{
			stb.append(sel);
		}
		String sqlStr = stb.toString();
		return sqlStr;
	}

	@Override
	protected Object stepExec(FunctionCallContext ctx, CallStack callStack)
			throws Exception {
		// TODO 自动生成的方法存根
		return super.stepExec(ctx, callStack);
	}


}
