package com.bonc.xcloud.sp_procedure.intermediate.syntax.sql;

import java.util.List;

import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.CallStack;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.FunctionCallContext;

/**
 * 由CSV插入到行云<br/>
 * 语法1：<br/>
 * INSERT [/</>*+IGNORE_ERR_LINE*</>/] INTO [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name [(col_name, …)]
 * [PARTITION ON（Condition,…）] ‘clinet_path’ 
 * [[Encode 'char'] [SEPARATOR 'char' [QUOTED|UNQUOTED]] [LINEFEED 'chars']]<br/>
 * 语法2：<br/>
 * INSERT [/</>*+IGNORE_ERR_LINE*</>/] INTO [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name [(col_name, …)] 
 * [PARTITION ON（Condition,…）] ‘clinet_path’ 
 * [[Encode 'char'] [SEPARATOR 'char' [DELIMITER  'char'[ESCAPE 'char']]]]
 */
public class InsertIntoFromCsv extends InsertIntoStatement{
	
	private static final long serialVersionUID = -943737126190052763L;
    private String hint;
    private List<String> conditions;
    private String filePath;
    private String encodeChar;
    private String separatorChar;
    private String quotenKey;
    private String delimiterChar;
	private String escapeChar;
	private String linefeedChar;
    
    
	public InsertIntoFromCsv() {
		
	}

	public InsertIntoFromCsv(String schemaName,String tableName,List<String> columnList,
			String hint, List<String> conditions,
			String filePath, String encodeChar, String separatorChar,
			String quotenKey, String delimiterChar, String escapeChar,String linefeedChar) {
		this.schemaName=schemaName;
		this.tableName=tableName;
		this.columnList=columnList;
		this.hint = hint;
		this.conditions = conditions;
		this.filePath = filePath;
		this.encodeChar = encodeChar;
		this.separatorChar = separatorChar;
		this.quotenKey = quotenKey;
		this.delimiterChar = delimiterChar;
		this.escapeChar = escapeChar;
		this.linefeedChar =linefeedChar;
	}

	public String getHint() {
		return hint;
	}

	public void setHint(String hint) {
		this.hint = hint;
	}

	public List<String> getConditions() {
		return conditions;
	}

	public void setConditions(List<String> conditions) {
		this.conditions = conditions;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getEncodeChar() {
		return encodeChar;
	}

	public void setEncodeChar(String encodeChar) {
		this.encodeChar = encodeChar;
	}

	public String getSeparatorChar() {
		return separatorChar;
	}

	public void setSeparatorChar(String separatorChar) {
		this.separatorChar = separatorChar;
	}

	public void setDelimiterChar(String delimiterChar) {
		this.delimiterChar = delimiterChar;
	}

	public void setEscapeChar(String escapeChar) {
		this.escapeChar = escapeChar;
	}

	public String getQuotenKey() {
		return quotenKey;
	}

	public void setQuotenKey(String quotenKey) {
		this.quotenKey = quotenKey;
	}

	public String getDelimiterChar() {
		return delimiterChar;
	}

	public String getEscapeChar() {
		return escapeChar;
	}

	
	public String getLinefeedChar() {
		return linefeedChar;
	}

	public void setLinefeedChar(String linefeedChar) {
		this.linefeedChar = linefeedChar;
	}

	@Override
	public String toSql(FunctionCallContext ctx) {
		StringBuffer stb=new StringBuffer();
		if(annotation!=null)
			stb.append(" "+annotation+" ");
		stb.append("INSERT ");
		if(pocHint!=null)
		stb.append(" "+pocHint+" ");
		stb.append(" INTO ");
		if(hint!=null){
			stb.append(hint);
		}
		if(schemaName!=null)
			stb.append(schemaName+".");
		if(tableName!=null)
			stb.append(tableName);
		if(dblink != null)
			stb.append("@"+dblink);
		if(columnList!=null){
			stb.append(" (");
			for (int i = 0; i < columnList.size(); i++) {
				stb.append(columnList.get(i));
				if(i!=columnList.size()-1)stb.append(",");
			}
			stb.append(") ");
		}
		if(conditions!=null){
			stb.append(" PARTITION ON (");
			for (int i = 0; i < conditions.size(); i++) {
				stb.append(conditions.get(i));
				if(i!=conditions.size()-1)stb.append(",");
			}
			stb.append(") ");
		}
		stb.append(" '"+filePath+"' ");
		if(encodeChar!=null)
			stb.append(" Encode "+encodeChar);
		if(separatorChar!=null)
			stb.append(" SEPARATOR "+separatorChar);
		if(quotenKey!=null){
			stb.append(" "+quotenKey+" ");
		}else{
			if(delimiterChar!=null)
				stb.append(" DELIMITER "+delimiterChar);
			if(escapeChar!=null)
			    stb.append(" ESCAPE "+escapeChar);
		}
		if(linefeedChar!=null)
			stb.append(" LINEFEED "+linefeedChar);
		String sqlStr = stb.toString();
		return sqlStr;
	}

	@Override
	protected Object stepExec(FunctionCallContext ctx, CallStack callStack)
			throws Exception {
		// TODO 自动生成的方法存根
		return super.stepExec(ctx, callStack);
	}


}
