package com.bonc.xcloud.sp_procedure.intermediate.syntax.sql;

import java.util.List;

import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.CallStack;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.FunctionCallContext;

/**
 * 由客户端本地插入到行云<br/>
 * 语法：@Client 'File_Path' INSERT INTO [schema_name].table_name (col_name, …)
 */
public class InsertIntoFromClient extends InsertIntoStatement{

	private static final long serialVersionUID = 696665363787766015L;
	
	//文件路径
	private String filePath;

	public InsertIntoFromClient() {
		
	}
	
	public InsertIntoFromClient(String schemaName,String tableName,List<String> columnList,String filePath) {
		this.schemaName=schemaName;
		this.tableName=tableName;
		this.columnList=columnList;
		this.filePath = filePath;
	}

	@Override
	public String toSql(FunctionCallContext ctx) {
		StringBuffer stb=new StringBuffer();
		if(annotation!=null)
			stb.append(" "+annotation+" ");
//		stb.append("@Client ").append(filePath).
		stb.append("INSERT INTO ");
		if(schemaName!=null)
			stb.append(schemaName+".");
		if(tableName != null) 
			stb.append(tableName+" ");
		if(columnList!=null){
			stb.append(" (");
			for (int i = 0; i < columnList.size(); i++) {
				stb.append(columnList.get(i));
				if(i!=columnList.size()-1)stb.append(",");
			}
			stb.append(") ");
		}
		String sqlStr = stb.toString();
		return sqlStr;
	}

	@Override
	protected Object stepExec(FunctionCallContext ctx, CallStack callStack)
			throws Exception {
		// TODO 自动生成的方法存根
		return super.stepExec(ctx, callStack);
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

//	@Override
//	public Object semanticCheck(DBConfiguration dbConfiguration,
//			List<List<ITableItem>> list) throws SqlSemanticCheckException {
//		// TODO 自动生成的方法存根
//		return super.semanticCheck(dbConfiguration, list);
//	}

	
	
}
