package com.bonc.xcloud.sp_procedure.intermediate.syntax;

import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.CallStack;
import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.FunctionCallContext;

/**
 * 语法树接口
 */
public interface ISyntaxTree {

	/**
	 * 执行
	 */
	public Object execute(FunctionCallContext ctx);
	
	/**
	 * 单步执行
	 */
	public abstract Object stepExecute(FunctionCallContext ctx, CallStack callStack)throws Exception;
	
	/**
	 * 转换为脚本
	 */
	public String generateScript();
	
	/**
	 * set属性
	 */
	public void setAttribute(ISyntaxTreeKey key, Object value);
	
	/**
	 * get属性
	 */
	public Object getAttribute(ISyntaxTreeKey key);
	
	public String toString();
	
	public String toSql(FunctionCallContext ctx);
	
}
