package com.bonc.xcloud.sp_procedure.intermediate.symtabimpl;

import java.util.ArrayList;

import com.bonc.xcloud.sp_procedure.intermediate.SymTab;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabEntry;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabFactory;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabStack;

/**
 * 符号表栈,为一个list集合
 * @author Administrator
 *
 */
public class SymTabStackImpl 
	extends ArrayList<SymTab> implements SymTabStack {
	
	private int currentNestingLevel; //当前嵌套层级
	private SymTabEntry programId;    // entry for the main program id
	
	/**
	 * 构造方法,由工厂类生成一个符号表实例加入到栈中
	 * @param currentNestingLevel
	 */
	public SymTabStackImpl() {
		
		this.currentNestingLevel = 0;
		add(SymTabFactory.createSymTab(currentNestingLevel));
	}

	@Override
	public int getCurrentNestingLevel() {
		
		return currentNestingLevel;
	}

	@Override
	public SymTab getLocalSymTab() {
		
		return get(currentNestingLevel);
	}

	@Override
	public SymTabEntry enterLocal(String name) {
		
		return get(currentNestingLevel).enter(name.toLowerCase());
	}
	
	public SymTabEntry enterLocal(SymTabEntry entry){
		
		return get(currentNestingLevel).enter(entry);
	}

	@Override
	public SymTabEntry lookupLocal(String name) {
		
		return get(currentNestingLevel).lookup(name.toLowerCase());
	}

	/**
     * 在所有等级的符号表中查找一个符号单元
     */
	public SymTabEntry lookup(String name) {
		
		SymTabEntry foundEntry = null;
		
		for(int i = currentNestingLevel;
				(i>=0) && (foundEntry == null);--i){
			foundEntry = get(i).lookup(name.toLowerCase());
			
		}
		return foundEntry;
	}

	@Override
	public void setProgramId(SymTabEntry id)
    {
        this.programId = id;
    }

	@Override
	public SymTabEntry getProgramId()
    {
        return programId;
    }

	/**
     * 向符号表栈顶层加入一个符号表
     */
	public SymTab push() {
		SymTab symTab = SymTabFactory.createSymTab(++currentNestingLevel);
		add(symTab);
		
		return symTab;
	}

	/**
     * 在所有等级的符号表中查找一个符号单元
     */
	public SymTab push(SymTab symTab) {
		
		++currentNestingLevel;
		add(symTab);
		
		return symTab;
		
	}

	 /**
     * 在所有等级的符号表中查找一个符号单元
     */
	public SymTab pop() {
		 
		SymTab symTab = get(currentNestingLevel);
		remove(currentNestingLevel--);
		
		return symTab;
		
	}
	
	public SymTab getIndexSymTab(int index){
		return get(index);
	}

}
