package com.bonc.xcloud.sp_procedure.intermediate.symtabimpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;

import com.bonc.xcloud.sp_procedure.intermediate.SymTab;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabEntry;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabFactory;

/**
 * 符号表的实现类,为一个treemap
 */
public class SymTabImpl 
	//extends Hashtable<String, SymTabEntry>
	extends LinkedHashMap<String, SymTabEntry>
	implements SymTab {
	
	private static final long serialVersionUID = 1L;
	private int nestingLevel;// 嵌套等级
	
	public SymTabImpl(int nestingLevel) {
		
		this.nestingLevel = nestingLevel;
	}

	@Override
	public int getNestingLevel() {
		
		return nestingLevel;
	}

	@Override
	public SymTabEntry enter(String name) {
		
		SymTabEntry entry = SymTabFactory.createSymTabEntry(name.toLowerCase(), this);
		put(name.toLowerCase(), entry);
		return entry;
	}
	
	public SymTabEntry enter(SymTabEntry entry){
		
		if(entry!=null){
			
			put(entry.getName().toLowerCase(),entry);
		}
		return entry;
	}

	@Override
	public SymTabEntry lookup(String name) {
		
		return get(name.toLowerCase());
	}

	@Override
	public ArrayList<SymTabEntry> sortedEntries() {
		
		Collection<SymTabEntry> entries = values();
		Iterator<SymTabEntry> iter = entries.iterator();
		ArrayList<SymTabEntry> list = new ArrayList<SymTabEntry>();
		while(iter.hasNext()){
			list.add(iter.next());
		}
		return list;
	}

}
