package com.bonc.xcloud.sp_procedure.intermediate.symtabimpl;

import java.util.ArrayList;
import java.util.Hashtable;

import com.bonc.xcloud.sp_procedure.frontend.xcloud.Position;
import com.bonc.xcloud.sp_procedure.intermediate.Definition;
import com.bonc.xcloud.sp_procedure.intermediate.SymTab;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabEntry;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabkey;
import com.bonc.xcloud.sp_procedure.intermediate.TypeSpec;

/**
 * 符号表单元实现类,为一个hashmap,存放属性值
 */
public class SymTabEntryImpl 
	extends Hashtable<SymTabkey, Object>
	implements SymTabEntry {
	
	private static final long serialVersionUID = 1L;

	private String name; // 符号单元名称
	
	private SymTab symTab;// 所属符号表
	
	private ArrayList<Position> positionRecords;// 符号单元出现的位置集合
	
	private Definition definition;           
    private TypeSpec typeSpec;               // 类型说明
	
    public SymTabEntryImpl(String name){
    	
    	this.name = name;
		this.positionRecords = new ArrayList<Position>();
    }
    
	public SymTabEntryImpl(String name, SymTab symTab) {
		
		this.name = name;
		this.symTab = symTab;
		this.positionRecords = new ArrayList<Position>();
		
	}
	
	@Override
	public String getName() {
		
		return name;
	}

	@Override
	public SymTab getSymTab() {
		
		return symTab;
	}
//
//	@Override
//	public void appendLineNumber(int lineNumber) {
//		
//		lineNumbers.add(lineNumber);
//		
//	}
//
//	@Override
//	public ArrayList<Integer> getLineNumbers() {
//		
//		return lineNumbers;
//	}

	@Override
	public void setAttribute(SymTabkey key, Object value) {
		
		put(key,value);
	}

	@Override
	public Object getAttribute(SymTabkey key) {
		
		return get(key);
	}

	public Definition getDefinition() {
		return definition;
	}

	public void setDefinition(Definition definition) {
		this.definition = definition;
	}

	public TypeSpec getTypeSpec() {
		return typeSpec;
	}

	public void setTypeSpec(TypeSpec typeSpec) {
		this.typeSpec = typeSpec;
	}

	@Override
	public void appendPositionRecord(Position position) {
		
		positionRecords.add(position);
	}

	@Override
	public ArrayList<Position> getPositionRecords() {
		
		return positionRecords;
	}

	@Override
	public int hashCode() {
		
		if(this.name!=null) return name.hashCode();
		return 0;
	}
}
