package com.bonc.xcloud.sp_procedure.intermediate.symtabimpl;

import static com.bonc.xcloud.sp_procedure.intermediate.symtabimpl.SymTabkeyImpl.CONSTANT_VALUE;
//import static com.bonc.xcloud.sp_procedure.intermediate.symtabimpl.SymTabkeyImpl.SYS_FUNCTION_AGUMENTS_TYPE;
import static com.bonc.xcloud.sp_procedure.intermediate.typeimpl.TypeFormImpl.ENUMERATION;
import static com.bonc.xcloud.sp_procedure.intermediate.typeimpl.TypeFormImpl.SCALAR;
import static com.bonc.xcloud.sp_procedure.intermediate.typeimpl.TypeKeyImpl.ENUMERATION_CONSTANTS;

import java.util.ArrayList;
//import java.util.Hashtable;
//import java.util.List;
//import java.util.Map;

import com.bonc.xcloud.sp_procedure.intermediate.SymTabEntry;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabStack;
import com.bonc.xcloud.sp_procedure.intermediate.TypeFactory;
import com.bonc.xcloud.sp_procedure.intermediate.TypeSpec;
/*import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.expression.FunctionCallExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_AcosExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_AsinExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_AtanExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_BitandExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_BitorExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_CeilExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_ConcatExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_CosExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_DabsExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Date_Add_MonthExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Date_DayExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Date_LastDayExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Date_MonthExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Date_Months_BetweenExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Date_ToDateExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Date_YearExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_FloorExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_InitCapExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_LTrimExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_LeftExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_LengthExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_LnExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_LogExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_LowerExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_ModExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Num_To_IntervalDSExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_Num_To_IntervalYMExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_PowerExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_RTrimExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_RegexpLikeExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_RegexpSubstrExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_ReplaceExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_RightExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_RoundExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_SignExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_SinExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_SqrtExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_SubStringExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_ToCharExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_ToDSIntervalExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_ToSingleByteExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_ToYMIntervalExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_TrimExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_TruncExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_UpperExpression;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sysfunction.Sys_ts_TotimestampExpression;
*/
/**
 * 预定义基本类型及其符号表单元
 */
public class Predefined {
	// plsql中类型与行云类型对应关系
	// public static Map<TypeSpec,JDataType> pTypeToJType = new
	// HashMap<TypeSpec,JDataType>();

	// Predefined types.
	public static TypeSpec intType;
	public static TypeSpec doubleType;
	public static TypeSpec booleanType;
	public static TypeSpec charType;
	public static TypeSpec varcharType;
	public static TypeSpec longType;
	public static TypeSpec dateType;
	public static TypeSpec nullType;
	public static TypeSpec intervalYMType;// 无id，不写入符号表第0层，解析单独设置类型
	public static TypeSpec intervalDSType;// 无id，不写入符号表第0层，解析单独设置类型
	public static TypeSpec timestampType;
	public static TypeSpec undefinedType;
	// public static TypeSpec cursorType;

	// Predefined identifiers.
	public static SymTabEntry intId;
	public static SymTabEntry doubleId;
	public static SymTabEntry booleanId;
	public static SymTabEntry charId;
	public static SymTabEntry varcharId;
	public static SymTabEntry longId;
	public static SymTabEntry dateId;
	public static SymTabEntry timestampId;
	public static SymTabEntry intervalYMId;
	public static SymTabEntry intervalDSId;
	public static SymTabEntry falseId;
	public static SymTabEntry trueId;
	public static SymTabEntry nullId;
	// public static SymTabEntry cursorId;
	// Predefined system_function.

	// id对应系统函数对象的集合
//	public static Map<SymTabEntry, FunctionCallExpression> id_sysFuntionMap = new Hashtable<SymTabEntry, FunctionCallExpression>();
	public static SymTabEntry lengthId;
	public static SymTabEntry lowerId;
	public static SymTabEntry upperId;
	public static SymTabEntry subStringId;
	public static SymTabEntry concatId;
	public static SymTabEntry replaceId;
	public static SymTabEntry trimId;
	public static SymTabEntry ltrimId;
	public static SymTabEntry rtrimId;
	public static SymTabEntry initCapId;
	public static SymTabEntry leftId;
	public static SymTabEntry rightId;
	public static SymTabEntry tosinglebyteId;
	public static SymTabEntry regexpsubstrId;
	public static SymTabEntry regexplikeId;
	public static SymTabEntry floorId;
	public static SymTabEntry ceilId;
	public static SymTabEntry lnId;
	public static SymTabEntry logId;
	public static SymTabEntry powerId;
	public static SymTabEntry absId;
	public static SymTabEntry sqrtId;
	public static SymTabEntry sinId;
	public static SymTabEntry roundId;
	public static SymTabEntry cosId;
	public static SymTabEntry asinId;
	public static SymTabEntry acosId;
	public static SymTabEntry atanId;
	public static SymTabEntry signId;
	public static SymTabEntry modId;
	public static SymTabEntry truncId;
	public static SymTabEntry bitandId;
	public static SymTabEntry bitorId;
	
	

	// 日期函数
	public static SymTabEntry lastday;
	// public static SymTabEntry round;
	// public static SymTabEntry trunc;
	public static SymTabEntry to_date;
	public static SymTabEntry to_char;
	public static SymTabEntry months_between;
	public static SymTabEntry add_month;
	public static SymTabEntry sub_var;
	public static SymTabEntry date_sub_date;
	public static SymTabEntry year;
	public static SymTabEntry month;
	public static SymTabEntry day;

	// timestamp函数
	public static SymTabEntry to_timestamp;

	// intervalDS函数
	public static SymTabEntry to_dsinterval;
	public static SymTabEntry num_to_dsinterval;

	// numToYMInterval函数
	public static SymTabEntry numtoymintervalId;

	// to_yminterval函数
	public static SymTabEntry to_ymintervalId;

	// sql系统函数
	public static SymTabEntry count;
	public static SymTabEntry sum;
	public static SymTabEntry decode;
	public static SymTabEntry min;
	public static SymTabEntry max;
	public static SymTabEntry avg;
	public static SymTabEntry row_number;
	public static SymTabEntry rank;
	public static SymTabEntry dense_rank;
	public static SymTabEntry ntile;
	public static SymTabEntry stddev_samp;

	// 其他系统函数
	public static SymTabEntry cast;
	public static SymTabEntry nvl;
	public static SymTabEntry coalesce;
	public static SymTabEntry extract;

	/**
	 * 先将类型,系统函数信息创建出来,再将其加入到不同的符号表中
	 */
	static {
		initializeTypes();

		initializeConstants();

		initializeSysFunction();
	}

	private static void initializeTypes() {

		// Type integer.
		intId = new SymTabEntryImpl("int");
		intType = TypeFactory.createType(SCALAR);
		intType.setIdentifier(intId);
		intId.setDefinition(DefinitionImpl.TYPE);
		intId.setTypeSpec(intType);

		// Type real.
		doubleId = new SymTabEntryImpl("double");
		doubleType = TypeFactory.createType(SCALAR);
		doubleType.setIdentifier(doubleId);
		doubleId.setDefinition(DefinitionImpl.TYPE);
		doubleId.setTypeSpec(doubleType);

		// Type boolean.
		booleanId = new SymTabEntryImpl("boolean");
		booleanType = TypeFactory.createType(ENUMERATION);
		booleanType.setIdentifier(booleanId);
		booleanId.setDefinition(DefinitionImpl.TYPE);
		booleanId.setTypeSpec(booleanType);

		// Type char.
		charId = new SymTabEntryImpl("char");
		charType = TypeFactory.createType(SCALAR);
		charType.setIdentifier(charId);
		charId.setDefinition(DefinitionImpl.TYPE);
		charId.setTypeSpec(charType);

		// Type varchar
		varcharId = new SymTabEntryImpl("varchar");
		varcharType = TypeFactory.createType(SCALAR);
		varcharType.setIdentifier(varcharId);
		varcharId.setDefinition(DefinitionImpl.TYPE);
		varcharId.setTypeSpec(varcharType);

		// Type long
		longId = new SymTabEntryImpl("long");
		longType = TypeFactory.createType(SCALAR);
		longType.setIdentifier(longId);
		longId.setDefinition(DefinitionImpl.TYPE);
		longId.setTypeSpec(longType);

		// Type date
		dateId = new SymTabEntryImpl("date");
		dateType = TypeFactory.createType(SCALAR);
		dateType.setIdentifier(dateId);
		dateId.setDefinition(DefinitionImpl.TYPE);
		dateId.setTypeSpec(dateType);

		// Type timestamp
		timestampId = new SymTabEntryImpl("timestamp");
		timestampType = TypeFactory.createType(SCALAR);
		timestampType.setIdentifier(timestampId);
		timestampId.setDefinition(DefinitionImpl.TYPE);
		timestampId.setTypeSpec(timestampType);

		// Type cursor
		// cursorId = new SymTabEntryImpl("cursor");
		// cursorType = TypeFactory.createType(TypeFormImpl.CURSOR);
		// cursorType.setIdentifier(cursorId);
		// cursorId.setDefinition(DefinitionImpl.TYPE);
		// cursorId.setTypeSpec(cursorType);

		// Type intervalYM
		intervalYMId = new SymTabEntryImpl("interval year to month");
		intervalYMType = TypeFactory.createType(SCALAR);
		intervalYMType.setIdentifier(intervalYMId);
		intervalYMId.setDefinition(DefinitionImpl.TYPE);
		intervalYMId.setTypeSpec(intervalYMType);

		// Type intervalDS
		intervalDSId = new SymTabEntryImpl("interval day to second");
		intervalDSType = TypeFactory.createType(SCALAR);
		intervalDSType.setIdentifier(intervalDSId);
		intervalDSId.setDefinition(DefinitionImpl.TYPE);
		intervalDSId.setTypeSpec(intervalDSType);

		// Type null
		nullId = new SymTabEntryImpl("null");
		nullType = TypeFactory.createType(ENUMERATION);
		nullType.setIdentifier(nullId);
		nullId.setDefinition(DefinitionImpl.ENUMERATION_CONSTANT);
		nullId.setTypeSpec(nullType);

		// Undefined type.
		undefinedType = TypeFactory.createType(SCALAR);
	}

	private static void initializeConstants() {
		// Boolean enumeration constant false.
		falseId = new SymTabEntryImpl("false");
		falseId.setDefinition(DefinitionImpl.ENUMERATION_CONSTANT);
		falseId.setTypeSpec(booleanType);
		falseId.setAttribute(CONSTANT_VALUE, new Integer(0));

		// Boolean enumeration constant true.
		trueId = new SymTabEntryImpl("true");
		trueId.setDefinition(DefinitionImpl.ENUMERATION_CONSTANT);
		trueId.setTypeSpec(booleanType);
		trueId.setAttribute(CONSTANT_VALUE, new Integer(1));

		// Add false and true to the boolean enumeration type.
		ArrayList<SymTabEntry> constants = new ArrayList<SymTabEntry>();
		constants.add(falseId);
		constants.add(trueId);
		booleanType.setAttribute(ENUMERATION_CONSTANTS, constants);

		// sysdateId = new SymTabEntryImpl("sysdate");
		// sysdateId.setDefinition(DefinitionImpl.ENUMERATION_CONSTANT);
		// sysdateId.setTypeSpec(dateType);
		//
		// ArrayList<SymTabEntry> dateConstants = new ArrayList<SymTabEntry>();
		// dateConstants.add(sysdateId);
		// dateType.setAttribute(ENUMERATION_CONSTANTS, dateConstants);
	}

	private static void initializeSysFunction() {
		initializeStringFunction();
		initializeMathFunction();
		initializeDateFunction();
		initializeTimestampFunction();
		initializeSqlSystemFunction();
		initializeOtherSystemFunction();
		initializeDSInervalFunction();
		initializeYMIntervalFunction();
	}

	private static void initializeYMIntervalFunction() {
		numtoymintervalId = new SymTabEntryImpl("numtoyminterval");
		numtoymintervalId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*List<List<TypeSpec>> argumentsType_numtoymintervalId = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> argument_numtoymintervalId1 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId1.add(intType);
		argument_numtoymintervalId1.add(varcharType);
		argument_numtoymintervalId1.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId1);

		List<TypeSpec> argument_numtoymintervalId2 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId2.add(longType);
		argument_numtoymintervalId2.add(varcharType);
		argument_numtoymintervalId2.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId2);

		List<TypeSpec> argument_numtoymintervalId3 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId3.add(doubleType);
		argument_numtoymintervalId3.add(varcharType);
		argument_numtoymintervalId3.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId3);
		
		List<TypeSpec> argument_numtoymintervalId4 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId4.add(nullType);
		argument_numtoymintervalId4.add(varcharType);
		argument_numtoymintervalId4.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId4);
		
		List<TypeSpec> argument_numtoymintervalId5 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId5.add(intType);
		argument_numtoymintervalId5.add(charType);
		argument_numtoymintervalId5.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId5);
		
		List<TypeSpec> argument_numtoymintervalId6 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId6.add(longType);
		argument_numtoymintervalId6.add(charType);
		argument_numtoymintervalId6.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId6);
		
		List<TypeSpec> argument_numtoymintervalId7 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId7.add(doubleType);
		argument_numtoymintervalId7.add(charType);
		argument_numtoymintervalId7.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId7);
		
		List<TypeSpec> argument_numtoymintervalId8 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId8.add(nullType);
		argument_numtoymintervalId8.add(charType);
		argument_numtoymintervalId8.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId8);
		
		
		List<TypeSpec> argument_numtoymintervalId9 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId9.add(intType);
		argument_numtoymintervalId9.add(nullType);
		argument_numtoymintervalId9.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId9);
		
		
		List<TypeSpec> argument_numtoymintervalId10 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId10.add(longType);
		argument_numtoymintervalId10.add(nullType);
		argument_numtoymintervalId10.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId10);
		
		List<TypeSpec> argument_numtoymintervalId11 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId11.add(doubleType);
		argument_numtoymintervalId11.add(nullType);
		argument_numtoymintervalId11.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId11);
		
		List<TypeSpec> argument_numtoymintervalId12 = new ArrayList<TypeSpec>();
		argument_numtoymintervalId12.add(nullType);
		argument_numtoymintervalId12.add(nullType);
		argument_numtoymintervalId12.add(intervalYMType);
		argumentsType_numtoymintervalId.add(argument_numtoymintervalId12);
		
		numtoymintervalId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				argumentsType_numtoymintervalId);
		id_sysFuntionMap.put(numtoymintervalId,
				new Sys_Num_To_IntervalYMExpression());*/

		// -------------//
		to_ymintervalId = new SymTabEntryImpl("to_yminterval");
		to_ymintervalId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*List<List<TypeSpec>> argumentsType_to_ymintervalId = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> argument_to_ymintervalId = new ArrayList<TypeSpec>();
		argument_to_ymintervalId.add(varcharType);
		argument_to_ymintervalId.add(intervalYMType);
		argumentsType_to_ymintervalId.add(argument_to_ymintervalId);
		
		List<TypeSpec> argument_to_ymintervalId1 = new ArrayList<TypeSpec>();
		argument_to_ymintervalId1.add(charType);
		argument_to_ymintervalId1.add(intervalYMType);
		argumentsType_to_ymintervalId.add(argument_to_ymintervalId1);
		
		List<TypeSpec> argument_to_ymintervalId2 = new ArrayList<TypeSpec>();
		argument_to_ymintervalId2.add(nullType);
		argument_to_ymintervalId2.add(intervalYMType);
		argumentsType_to_ymintervalId.add(argument_to_ymintervalId2);
		
		
		to_ymintervalId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				argumentsType_to_ymintervalId);
		id_sysFuntionMap.put(to_ymintervalId, new Sys_ToYMIntervalExpression());*/

	}

	private static void initializeDSInervalFunction() {

		// to_dsinterval
		to_dsinterval = new SymTabEntryImpl("to_dsinterval");
		to_dsinterval.setDefinition(DefinitionImpl.SYS_FUNCTION);

		/*List<List<TypeSpec>> argumentsType_tointervalDS = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> argument_tointervalDS = new ArrayList<TypeSpec>();
		argument_tointervalDS.add(varcharType);
		argument_tointervalDS.add(intervalDSType);
		argumentsType_tointervalDS.add(argument_tointervalDS);
		
		List<TypeSpec> argument_tointervalDS1 = new ArrayList<TypeSpec>();
		argument_tointervalDS1.add(charType);
		argument_tointervalDS1.add(intervalDSType);
		argumentsType_tointervalDS.add(argument_tointervalDS1);
		
		List<TypeSpec> argument_tointervalDS2 = new ArrayList<TypeSpec>();
		argument_tointervalDS2.add(nullType);
		argument_tointervalDS2.add(intervalDSType);
		argumentsType_tointervalDS.add(argument_tointervalDS2);
		
		to_dsinterval.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				argumentsType_tointervalDS);
		id_sysFuntionMap.put(to_dsinterval, new Sys_ToDSIntervalExpression());*/

		// num_to_dsinterval
		num_to_dsinterval = new SymTabEntryImpl("numtodsinterval");
		num_to_dsinterval.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*List<List<TypeSpec>> argumentsType_numtointervalDS = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> argument_numtointervalDS0 = new ArrayList<TypeSpec>();
		argument_numtointervalDS0.add(intType);
		argument_numtointervalDS0.add(charType);
		argument_numtointervalDS0.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS0);
		
		List<TypeSpec> argument_numtointervalDS = new ArrayList<TypeSpec>();
		argument_numtointervalDS.add(longType);
		argument_numtointervalDS.add(charType);
		argument_numtointervalDS.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS);

		List<TypeSpec> argument_numtointervalDS1 = new ArrayList<TypeSpec>();
		argument_numtointervalDS1.add(doubleType);
		argument_numtointervalDS1.add(charType);
		argument_numtointervalDS1.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS1);
		
		List<TypeSpec> argument_numtointervalDS2 = new ArrayList<TypeSpec>();
		argument_numtointervalDS2.add(nullType);
		argument_numtointervalDS2.add(charType);
		argument_numtointervalDS2.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS2);
		
		List<TypeSpec> argument_numtointervalDS3 = new ArrayList<TypeSpec>();
		argument_numtointervalDS3.add(intType);
		argument_numtointervalDS3.add(varcharType);
		argument_numtointervalDS3.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS3);
		
		List<TypeSpec> argument_numtointervalDS4 = new ArrayList<TypeSpec>();
		argument_numtointervalDS4.add(longType);
		argument_numtointervalDS4.add(varcharType);
		argument_numtointervalDS4.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS4);
		
		List<TypeSpec> argument_numtointervalDS5 = new ArrayList<TypeSpec>();
		argument_numtointervalDS5.add(doubleType);
		argument_numtointervalDS5.add(varcharType);
		argument_numtointervalDS5.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS5);
		
		List<TypeSpec> argument_numtointervalDS6 = new ArrayList<TypeSpec>();
		argument_numtointervalDS6.add(nullType);
		argument_numtointervalDS6.add(varcharType);
		argument_numtointervalDS6.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS6);
		
		List<TypeSpec> argument_numtointervalDS7 = new ArrayList<TypeSpec>();
		argument_numtointervalDS7.add(intType);
		argument_numtointervalDS7.add(nullType);
		argument_numtointervalDS7.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS7);
		
		List<TypeSpec> argument_numtointervalDS8 = new ArrayList<TypeSpec>();
		argument_numtointervalDS8.add(longType);
		argument_numtointervalDS8.add(nullType);
		argument_numtointervalDS8.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS8);
		
		List<TypeSpec> argument_numtointervalDS9 = new ArrayList<TypeSpec>();
		argument_numtointervalDS9.add(doubleType);
		argument_numtointervalDS9.add(nullType);
		argument_numtointervalDS9.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS9);
		
		
		List<TypeSpec> argument_numtointervalDS10 = new ArrayList<TypeSpec>();
		argument_numtointervalDS10.add(nullType);
		argument_numtointervalDS10.add(nullType);
		argument_numtointervalDS10.add(intervalDSType);
		argumentsType_numtointervalDS.add(argument_numtointervalDS10);
		
		
		num_to_dsinterval.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				argumentsType_numtointervalDS);
		id_sysFuntionMap.put(num_to_dsinterval,
				new Sys_Num_To_IntervalDSExpression());
*/
	}

	private static void initializeStringFunction() {

		// To_Char
		to_char = new SymTabEntryImpl("to_char");
		to_char.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// to_char.setTypeSpec(varcharType);
		List<List<TypeSpec>> argumentsTypeTo_Char = new ArrayList<List<TypeSpec>>();
		// 第一个参数可以传入所有类型,第二个参数可有可无也可以是Null,如有为字符串
		// 第1类参数
		// List<TypeSpec> argumentTo_Char1=new ArrayList<TypeSpec>();
		// argumentTo_Char1.add(charType);
		// argumentTo_Char1.add(charType);
		// 第2类参数 int--->varchar
		List<TypeSpec> argumentTo_Char2 = new ArrayList<TypeSpec>();
		argumentTo_Char2.add(intType);
		argumentTo_Char2.add(varcharType);
		// 第3类参数 long--->varchar
		List<TypeSpec> argumentTo_Char3 = new ArrayList<TypeSpec>();
		argumentTo_Char3.add(longType);
		argumentTo_Char3.add(varcharType);
		// 第4类参数
		List<TypeSpec> argumentTo_Char4 = new ArrayList<TypeSpec>();
		argumentTo_Char4.add(doubleType);
		argumentTo_Char4.add(varcharType);

		// yminterval 单入参
		List<TypeSpec> argumentTo_Char5 = new ArrayList<TypeSpec>();
		argumentTo_Char5.add(intervalYMType);
		argumentTo_Char5.add(varcharType);

		// yminterval 双入参
		List<TypeSpec> argumentTo_Char6 = new ArrayList<TypeSpec>();
		argumentTo_Char6.add(intervalYMType);
		argumentTo_Char6.add(varcharType);
		argumentTo_Char6.add(varcharType);

		// timestamp 单入参
		List<TypeSpec> argumentTo_Char_ts1 = new ArrayList<TypeSpec>();
		argumentTo_Char_ts1.add(timestampType);
		argumentTo_Char_ts1.add(varcharType);

		// timestamp 双入参
		List<TypeSpec> argumentTo_Char_ts2 = new ArrayList<TypeSpec>();
		argumentTo_Char_ts2.add(timestampType);
		argumentTo_Char_ts2.add(varcharType);
		argumentTo_Char_ts2.add(varcharType);

		// 第5类参数
		// List<TypeSpec> argumentTo_Char5=new ArrayList<TypeSpec>();
		// argumentTo_Char5.add(dateType);
		// argumentTo_Char5.add(varcharType);
		// 第6类参数
		// List<TypeSpec> argumentTo_Char6=new ArrayList<TypeSpec>();
		// argumentTo_Char6.add(varcharType);
		// argumentTo_Char6.add(varcharType);
		// 第7类参数
		List<TypeSpec> argumentTo_Char7 = new ArrayList<TypeSpec>();
		argumentTo_Char7.add(dateType);
		argumentTo_Char7.add(charType);
		argumentTo_Char7.add(varcharType);
		// 第8类参数
		List<TypeSpec> argumentTo_Char8 = new ArrayList<TypeSpec>();
		argumentTo_Char8.add(intType);
		argumentTo_Char8.add(charType);
		argumentTo_Char8.add(varcharType);
		// 第9类参数
		List<TypeSpec> argumentTo_Char9 = new ArrayList<TypeSpec>();
		argumentTo_Char9.add(longType);
		argumentTo_Char9.add(charType);
		argumentTo_Char9.add(varcharType);
		// 第10类参数
		List<TypeSpec> argumentTo_Char10 = new ArrayList<TypeSpec>();
		argumentTo_Char10.add(doubleType);
		argumentTo_Char10.add(charType);
		argumentTo_Char10.add(varcharType);

		// intervalDS单入参
		List<TypeSpec> argumentTo_char_ids1 = new ArrayList<TypeSpec>();
		argumentTo_char_ids1.add(intervalDSType);
		argumentTo_char_ids1.add(varcharType);

		// intervalDS单入参
		List<TypeSpec> argumentTo_char_ids2 = new ArrayList<TypeSpec>();
		argumentTo_char_ids2.add(intervalDSType);
		argumentTo_char_ids2.add(charType);
		argumentTo_char_ids2.add(varcharType);

		// 第11类参数
		List<TypeSpec> argumentTo_Char11 = new ArrayList<TypeSpec>();
		argumentTo_Char11.add(nullType);
		argumentTo_Char11.add(nullType);

		// 第12类参数
		List<TypeSpec> argumentTo_Char12 = new ArrayList<TypeSpec>();
		argumentTo_Char12.add(intType);
		argumentTo_Char12.add(varcharType);
		argumentTo_Char12.add(varcharType);

		// 第13类参数
		List<TypeSpec> argumentTo_Char13 = new ArrayList<TypeSpec>();
		argumentTo_Char13.add(intType);
		argumentTo_Char13.add(nullType);
		argumentTo_Char13.add(nullType);

		// 第14类参数
		List<TypeSpec> argumentTo_Char14 = new ArrayList<TypeSpec>();
		argumentTo_Char14.add(longType);
		argumentTo_Char14.add(varcharType);
		argumentTo_Char14.add(varcharType);

		// 第15类参数
		List<TypeSpec> argumentTo_Char15 = new ArrayList<TypeSpec>();
		argumentTo_Char15.add(longType);
		argumentTo_Char15.add(nullType);
		argumentTo_Char15.add(nullType);

		// 第16类参数
		List<TypeSpec> argumentTo_Char16 = new ArrayList<TypeSpec>();
		argumentTo_Char16.add(doubleType);
		argumentTo_Char16.add(varcharType);
		argumentTo_Char16.add(varcharType);

		// 第17类参数
		List<TypeSpec> argumentTo_Char17 = new ArrayList<TypeSpec>();
		argumentTo_Char17.add(doubleType);
		argumentTo_Char17.add(nullType);
		argumentTo_Char17.add(nullType);

		// 第18类参数
		List<TypeSpec> argumentTo_Char18 = new ArrayList<TypeSpec>();
		argumentTo_Char18.add(dateType);
		argumentTo_Char18.add(nullType);
		argumentTo_Char18.add(nullType);

		// 第19类参数
		List<TypeSpec> argumentTo_Char19 = new ArrayList<TypeSpec>();
		argumentTo_Char19.add(dateType);
		argumentTo_Char19.add(varcharType);
		argumentTo_Char19.add(varcharType);

		// 第20类参数
		List<TypeSpec> argumentTo_Char20 = new ArrayList<TypeSpec>();
		argumentTo_Char20.add(nullType);
		argumentTo_Char20.add(varcharType);
		argumentTo_Char20.add(nullType);

		// 第21类参数
		List<TypeSpec> argumentTo_Char21 = new ArrayList<TypeSpec>();
		argumentTo_Char21.add(nullType);
		argumentTo_Char21.add(charType);
		argumentTo_Char21.add(nullType);

		// 第22类参数
		List<TypeSpec> argumentTo_Char22 = new ArrayList<TypeSpec>();
		argumentTo_Char22.add(nullType);
		argumentTo_Char22.add(nullType);
		argumentTo_Char22.add(nullType);

		// argumentsTypeTo_Char.add(argumentTo_Char1);
		argumentsTypeTo_Char.add(argumentTo_Char2);
		argumentsTypeTo_Char.add(argumentTo_Char3);
		argumentsTypeTo_Char.add(argumentTo_Char4);
		argumentsTypeTo_Char.add(argumentTo_Char5);
		argumentsTypeTo_Char.add(argumentTo_Char6);
		argumentsTypeTo_Char.add(argumentTo_Char7);
		argumentsTypeTo_Char.add(argumentTo_Char8);
		argumentsTypeTo_Char.add(argumentTo_Char9);
		argumentsTypeTo_Char.add(argumentTo_Char10);
		argumentsTypeTo_Char.add(argumentTo_Char_ts1);
		argumentsTypeTo_Char.add(argumentTo_Char_ts2);
		argumentsTypeTo_Char.add(argumentTo_char_ids1);
		argumentsTypeTo_Char.add(argumentTo_char_ids2);
		argumentsTypeTo_Char.add(argumentTo_Char11);
		argumentsTypeTo_Char.add(argumentTo_Char12);
		argumentsTypeTo_Char.add(argumentTo_Char13);
		argumentsTypeTo_Char.add(argumentTo_Char14);
		argumentsTypeTo_Char.add(argumentTo_Char15);
		argumentsTypeTo_Char.add(argumentTo_Char16);
		argumentsTypeTo_Char.add(argumentTo_Char17);
		argumentsTypeTo_Char.add(argumentTo_Char18);
		argumentsTypeTo_Char.add(argumentTo_Char19);
		argumentsTypeTo_Char.add(argumentTo_Char20);
		argumentsTypeTo_Char.add(argumentTo_Char21);
		argumentsTypeTo_Char.add(argumentTo_Char22);

		to_char.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, argumentsTypeTo_Char);
		id_sysFuntionMap.put(to_char, new Sys_ToCharExpression());*/

		// length
		// 名称
		lengthId = new SymTabEntryImpl("length");
		// 类型定义为系统函数
		lengthId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// lengthId.setTypeSpec(intType);

		// 设置形参类型
		List<List<TypeSpec>> length_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> length_arg = new ArrayList<TypeSpec>();
		length_arg.add(varcharType);
		length_arg.add(longType);
		length_argumentsType.add(length_arg);

		List<TypeSpec> length_arg1 = new ArrayList<TypeSpec>();
		length_arg1.add(charType);
		length_arg1.add(longType);
		length_argumentsType.add(length_arg1);

		List<TypeSpec> length_arg2 = new ArrayList<TypeSpec>();
		length_arg2.add(nullType);
		length_arg2.add(nullType);
		length_argumentsType.add(length_arg2);

		lengthId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, length_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(lengthId, new Sys_LengthExpression());

		// lower
		// 名称
		lowerId = new SymTabEntryImpl("lower");
		// 类型定义为系统函数
		lowerId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		// 类型描述即返回值类型
		// lowerId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> lower_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> lower_arg = new ArrayList<TypeSpec>();
		lower_arg.add(varcharType);
		lower_arg.add(varcharType);
		lower_argumentsType.add(lower_arg);

		List<TypeSpec> lower_arg1 = new ArrayList<TypeSpec>();
		lower_arg1.add(charType);
		lower_arg1.add(charType);
		lower_argumentsType.add(lower_arg1);

		List<TypeSpec> lower_arg2 = new ArrayList<TypeSpec>();
		lower_arg2.add(nullType);
		lower_arg2.add(nullType);
		lower_argumentsType.add(lower_arg2);

		lowerId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, lower_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(lowerId, new Sys_LowerExpression());*/

		// Upper
		// 名称
		upperId = new SymTabEntryImpl("upper");
		// 类型定义为系统函数
		upperId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// upperId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> upper_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> upper_arg1 = new ArrayList<TypeSpec>();
		upper_arg1.add(varcharType);
		upper_arg1.add(varcharType);
		upper_argumentsType.add(upper_arg1);

		List<TypeSpec> upper_arg2 = new ArrayList<TypeSpec>();
		upper_arg2.add(charType);
		upper_arg2.add(charType);
		upper_argumentsType.add(upper_arg2);

		List<TypeSpec> upper_arg3 = new ArrayList<TypeSpec>();
		upper_arg3.add(nullType);
		upper_arg3.add(nullType);
		upper_argumentsType.add(upper_arg3);

		upperId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, upper_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(upperId, new Sys_UpperExpression());*/

		// subString
		// 名称
		subStringId = new SymTabEntryImpl("substr");
		// 类型定义为系统函数
		subStringId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// subStringId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> subString_argumentsType = new ArrayList<List<TypeSpec>>();

		// 1 .substr(str, position, length) 参数类型分别为:varchar, int, int
		List<TypeSpec> subString_arg1 = new ArrayList<TypeSpec>();
		subString_arg1.add(varcharType);
		subString_arg1.add(intType);
		subString_arg1.add(intType);
		subString_arg1.add(varcharType);
		subString_argumentsType.add(subString_arg1);
		// a .substr(str, position, length) 参数类型分别为:varchar, int, long
		List<TypeSpec> subString_arga = new ArrayList<TypeSpec>();
		subString_arga.add(varcharType);
		subString_arga.add(intType);
		subString_arga.add(longType);
		subString_arga.add(varcharType);
		subString_argumentsType.add(subString_arga);
		// b .substr(str, position, length) 参数类型分别为:varchar, long, int
		List<TypeSpec> subString_argb = new ArrayList<TypeSpec>();
		subString_argb.add(varcharType);
		subString_argb.add(longType);
		subString_argb.add(intType);
		subString_argb.add(varcharType);
		subString_argumentsType.add(subString_argb);

		// 2 .substr(str, position, length) 参数类型分别为:varchar, int, null
		List<TypeSpec> subString_arg2 = new ArrayList<TypeSpec>();
		subString_arg2.add(varcharType);
		subString_arg2.add(intType);
		subString_arg2.add(nullType);
		subString_arg2.add(nullType);
		subString_argumentsType.add(subString_arg2);

		// 3 .substr(str, position, length) 参数类型分别为:varchar, null, int
		List<TypeSpec> subString_arg3 = new ArrayList<TypeSpec>();
		subString_arg3.add(varcharType);
		subString_arg3.add(nullType);
		subString_arg3.add(intType);
		subString_arg3.add(nullType);
		subString_argumentsType.add(subString_arg3);

		// 4 .substr(str, position, length) 参数类型分别为:varchar, null, null
		List<TypeSpec> subString_arg4 = new ArrayList<TypeSpec>();
		subString_arg4.add(varcharType);
		subString_arg4.add(nullType);
		subString_arg4.add(nullType);
		subString_arg4.add(nullType);
		subString_argumentsType.add(subString_arg4);

		// 5 .substr(str, position, length) 参数类型分别为:char, int, int
		List<TypeSpec> subString_arg5 = new ArrayList<TypeSpec>();
		subString_arg5.add(charType);
		subString_arg5.add(intType);
		subString_arg5.add(intType);
		subString_arg5.add(varcharType);
		subString_argumentsType.add(subString_arg5);

		// 6 .substr(str, position, length) 参数类型分别为:char, int, null
		List<TypeSpec> subString_arg6 = new ArrayList<TypeSpec>();
		subString_arg6.add(charType);
		subString_arg6.add(intType);
		subString_arg6.add(nullType);
		subString_arg6.add(nullType);
		subString_argumentsType.add(subString_arg6);

		// 7 .substr(str, position, length) 参数类型分别为:char, null, int
		List<TypeSpec> subString_arg7 = new ArrayList<TypeSpec>();
		subString_arg7.add(charType);
		subString_arg7.add(nullType);
		subString_arg7.add(intType);
		subString_arg7.add(nullType);
		subString_argumentsType.add(subString_arg7);

		// 8 .substr(str, position, length) 参数类型分别为:char, null, null
		List<TypeSpec> subString_arg8 = new ArrayList<TypeSpec>();
		subString_arg8.add(charType);
		subString_arg8.add(nullType);
		subString_arg8.add(nullType);
		subString_arg8.add(nullType);
		subString_argumentsType.add(subString_arg8);

		// 9 .substr(str, position, length) 参数类型分别为:null, int, int
		List<TypeSpec> subString_arg9 = new ArrayList<TypeSpec>();
		subString_arg9.add(nullType);
		subString_arg9.add(intType);
		subString_arg9.add(intType);
		subString_arg9.add(nullType);
		subString_argumentsType.add(subString_arg9);
		// c .substr(str, position, length) 参数类型分别为:null, int, long
		List<TypeSpec> subString_argc = new ArrayList<TypeSpec>();
		subString_argc.add(nullType);
		subString_argc.add(intType);
		subString_argc.add(longType);
		subString_argc.add(nullType);
		subString_argumentsType.add(subString_arg9);
		// d .substr(str, position, length) 参数类型分别为:null, long, int
		List<TypeSpec> subString_argd = new ArrayList<TypeSpec>();
		subString_argd.add(nullType);
		subString_argd.add(longType);
		subString_argd.add(intType);
		subString_argd.add(nullType);
		subString_argumentsType.add(subString_argd);

		// 10.substr(str, position, length) 参数类型分别为:null, int, null
		List<TypeSpec> subString_arg10 = new ArrayList<TypeSpec>();
		subString_arg10.add(nullType);
		subString_arg10.add(intType);
		subString_arg10.add(nullType);
		subString_arg10.add(nullType);
		subString_argumentsType.add(subString_arg10);

		// 11.substr(str, position, length) 参数类型分别为:null, null, int
		List<TypeSpec> subString_arg11 = new ArrayList<TypeSpec>();
		subString_arg11.add(nullType);
		subString_arg11.add(nullType);
		subString_arg11.add(intType);
		subString_arg11.add(nullType);
		subString_argumentsType.add(subString_arg11);

		// 12.substr(str, position, length) 参数类型分别为:null, null, null
		List<TypeSpec> subString_arg12 = new ArrayList<TypeSpec>();
		subString_arg12.add(nullType);
		subString_arg12.add(nullType);
		subString_arg12.add(nullType);
		subString_arg12.add(nullType);
		subString_argumentsType.add(subString_arg12);

		// *******************************************************************************
		// 13 .substr(str, position) 参数类型分别为:varchar int
		List<TypeSpec> subString_arg13 = new ArrayList<TypeSpec>();
		subString_arg13.add(varcharType);
		subString_arg13.add(intType);
		subString_arg13.add(varcharType);
		subString_argumentsType.add(subString_arg13);

		// 14 .substr(str, position) 参数类型分别为:varchar null
		List<TypeSpec> subString_arg14 = new ArrayList<TypeSpec>();
		subString_arg14.add(varcharType);
		subString_arg14.add(nullType);
		subString_arg14.add(nullType);
		subString_argumentsType.add(subString_arg14);

		// 15 .substr(str, position) 参数类型分别为:char int
		List<TypeSpec> subString_arg15 = new ArrayList<TypeSpec>();
		subString_arg15.add(charType);
		subString_arg15.add(intType);
		subString_arg15.add(varcharType);
		subString_argumentsType.add(subString_arg15);

		// 16 .substr(str, position) 参数类型分别为:char null
		List<TypeSpec> subString_arg16 = new ArrayList<TypeSpec>();
		subString_arg16.add(charType);
		subString_arg16.add(nullType);
		subString_arg16.add(nullType);
		subString_argumentsType.add(subString_arg16);

		// 17 .substr(str, position) 参数类型分别为:null int
		List<TypeSpec> subString_arg17 = new ArrayList<TypeSpec>();
		subString_arg17.add(nullType);
		subString_arg17.add(intType);
		subString_arg17.add(nullType);
		subString_argumentsType.add(subString_arg17);

		// 18 .substr(str, position) 参数类型分别为:null null
		List<TypeSpec> subString_arg18 = new ArrayList<TypeSpec>();
		subString_arg18.add(nullType);
		subString_arg18.add(nullType);
		subString_arg18.add(nullType);
		subString_argumentsType.add(subString_arg18);
		// 19 .substr(str, position, length) 参数类型分别为:varchar,long, long
		List<TypeSpec> subString_arg19 = new ArrayList<TypeSpec>();
		subString_arg19.add(varcharType);
		subString_arg19.add(longType);
		subString_arg19.add(longType);
		subString_arg19.add(varcharType);
		subString_argumentsType.add(subString_arg19);

		// 20 .substr(str, position, length) 参数类型分别为:varchar, long, null
		List<TypeSpec> subString_arg20 = new ArrayList<TypeSpec>();
		subString_arg20.add(varcharType);
		subString_arg20.add(longType);
		subString_arg20.add(nullType);
		subString_arg20.add(nullType);
		subString_argumentsType.add(subString_arg20);

		// 21 .substr(str, position, length) 参数类型分别为:varchar, null, long
		List<TypeSpec> subString_arg21 = new ArrayList<TypeSpec>();
		subString_arg21.add(varcharType);
		subString_arg21.add(nullType);
		subString_arg21.add(longType);
		subString_arg21.add(nullType);
		subString_argumentsType.add(subString_arg21);

		// 22 .substr(str, position, length) 参数类型分别为:char, long, long
		List<TypeSpec> subString_arg22 = new ArrayList<TypeSpec>();
		subString_arg22.add(charType);
		subString_arg22.add(longType);
		subString_arg22.add(longType);
		subString_arg22.add(varcharType);
		subString_argumentsType.add(subString_arg22);

		// 23 .substr(str, position, length) 参数类型分别为:char, long, null
		List<TypeSpec> subString_arg23 = new ArrayList<TypeSpec>();
		subString_arg23.add(charType);
		subString_arg23.add(longType);
		subString_arg23.add(nullType);
		subString_arg23.add(nullType);
		subString_argumentsType.add(subString_arg23);

		// 24 .substr(str, position, length) 参数类型分别为:char, null, long
		List<TypeSpec> subString_arg24 = new ArrayList<TypeSpec>();
		subString_arg24.add(charType);
		subString_arg24.add(nullType);
		subString_arg24.add(longType);
		subString_arg24.add(nullType);
		subString_argumentsType.add(subString_arg24);

		// 25 .substr(str, position, length) 参数类型分别为:null,long, long
		List<TypeSpec> subString_arg25 = new ArrayList<TypeSpec>();
		subString_arg25.add(nullType);
		subString_arg25.add(longType);
		subString_arg25.add(longType);
		subString_arg25.add(nullType);
		subString_argumentsType.add(subString_arg25);

		// 26.substr(str, position, length) 参数类型分别为:null, long, null
		List<TypeSpec> subString_arg26 = new ArrayList<TypeSpec>();
		subString_arg26.add(nullType);
		subString_arg26.add(longType);
		subString_arg26.add(nullType);
		subString_arg26.add(nullType);
		subString_argumentsType.add(subString_arg26);

		// 27.substr(str, position, length) 参数类型分别为:null, null, long
		List<TypeSpec> subString_arg27 = new ArrayList<TypeSpec>();
		subString_arg27.add(nullType);
		subString_arg27.add(nullType);
		subString_arg27.add(longType);
		subString_arg27.add(nullType);
		subString_argumentsType.add(subString_arg27);

		// 28 .substr(str, position) 参数类型分别为:varchar long
		List<TypeSpec> subString_arg28 = new ArrayList<TypeSpec>();
		subString_arg28.add(varcharType);
		subString_arg28.add(longType);
		subString_arg28.add(varcharType);
		subString_argumentsType.add(subString_arg28);

		// 29 .substr(str, position) 参数类型分别为:char long
		List<TypeSpec> subString_arg29 = new ArrayList<TypeSpec>();
		subString_arg29.add(charType);
		subString_arg29.add(longType);
		subString_arg29.add(varcharType);
		subString_argumentsType.add(subString_arg29);

		// 30 .substr(str, position) 参数类型分别为:null long
		List<TypeSpec> subString_arg30 = new ArrayList<TypeSpec>();
		subString_arg30.add(nullType);
		subString_arg30.add(longType);
		subString_arg30.add(nullType);
		subString_argumentsType.add(subString_arg30);

		subStringId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				subString_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(subStringId, new Sys_SubStringExpression());*/

		// concat
		// 名称
		concatId = new SymTabEntryImpl("concat");
		// 类型定义为系统函数
		concatId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// concatId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> concat_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> concat_arg1 = new ArrayList<TypeSpec>();
		concat_arg1.add(varcharType);
		concat_arg1.add(varcharType);
		concat_arg1.add(varcharType);
		concat_argumentsType.add(concat_arg1);

		List<TypeSpec> concat_arg2 = new ArrayList<TypeSpec>();
		concat_arg2.add(charType);
		concat_arg2.add(varcharType);
		concat_arg2.add(varcharType);
		concat_argumentsType.add(concat_arg2);

		List<TypeSpec> concat_arg3 = new ArrayList<TypeSpec>();
		concat_arg3.add(varcharType);
		concat_arg3.add(charType);
		concat_arg3.add(varcharType);
		concat_argumentsType.add(concat_arg3);

		List<TypeSpec> concat_arg4 = new ArrayList<TypeSpec>();
		concat_arg4.add(charType);
		concat_arg4.add(charType);
		concat_arg4.add(charType);
		concat_argumentsType.add(concat_arg4);

		List<TypeSpec> concat_arg5 = new ArrayList<TypeSpec>();
		concat_arg5.add(nullType);
		concat_arg5.add(nullType);
		concat_arg5.add(nullType);
		concat_argumentsType.add(concat_arg5);

		List<TypeSpec> concat_arg6 = new ArrayList<TypeSpec>();
		concat_arg6.add(varcharType);
		concat_arg6.add(nullType);
		concat_arg6.add(varcharType);
		concat_argumentsType.add(concat_arg6);

		List<TypeSpec> concat_arg7 = new ArrayList<TypeSpec>();
		concat_arg7.add(nullType);
		concat_arg7.add(varcharType);
		concat_arg7.add(varcharType);
		concat_argumentsType.add(concat_arg7);

		List<TypeSpec> concat_arg8 = new ArrayList<TypeSpec>();
		concat_arg8.add(charType);
		concat_arg8.add(nullType);
		concat_arg8.add(varcharType);
		concat_argumentsType.add(concat_arg8);

		List<TypeSpec> concat_arg9 = new ArrayList<TypeSpec>();
		concat_arg9.add(nullType);
		concat_arg9.add(charType);
		concat_arg9.add(varcharType);
		concat_argumentsType.add(concat_arg9);

		concatId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, concat_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(concatId, new Sys_ConcatExpression());*/

		// Replace
		// 名称
		replaceId = new SymTabEntryImpl("replace");
		// 类型定义为系统函数
		replaceId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// replaceId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> replace_argumentsType = new ArrayList<List<TypeSpec>>();

		// 1.replace(str1, str2, str3) 参数类型分别为 varchar,varchar,varchar
		List<TypeSpec> replace_arg1 = new ArrayList<TypeSpec>();
		replace_arg1.add(varcharType);
		replace_arg1.add(varcharType);
		replace_arg1.add(varcharType);
		replace_arg1.add(varcharType);
		replace_argumentsType.add(replace_arg1);

		// 2.replace(str1, str2, str3) 参数类型分别为:varchar,varchar,char
		List<TypeSpec> replace_arg2 = new ArrayList<TypeSpec>();
		replace_arg2.add(varcharType);
		replace_arg2.add(varcharType);
		replace_arg2.add(charType);
		replace_arg2.add(varcharType);
		replace_argumentsType.add(replace_arg2);
		// 3.replace(str1, str2, str3) 参数类型分别为:varchar,varchar,null
		List<TypeSpec> replace_arg3 = new ArrayList<TypeSpec>();
		replace_arg3.add(varcharType);
		replace_arg3.add(varcharType);
		replace_arg3.add(nullType);
		replace_arg3.add(varcharType);
		replace_argumentsType.add(replace_arg3);
		// 4.replace(str1, str2, str3) 参数类型分别为:varchar,char,varchar
		List<TypeSpec> replace_arg4 = new ArrayList<TypeSpec>();
		replace_arg4.add(varcharType);
		replace_arg4.add(charType);
		replace_arg4.add(varcharType);
		replace_arg4.add(varcharType);
		replace_argumentsType.add(replace_arg4);
		// 5.replace(str1, str2, str3) 参数类型分别为:varchar,char,char
		List<TypeSpec> replace_arg5 = new ArrayList<TypeSpec>();
		replace_arg5.add(varcharType);
		replace_arg5.add(charType);
		replace_arg5.add(charType);
		replace_arg5.add(varcharType);
		replace_argumentsType.add(replace_arg5);
		// 6.replace(str1, str2, str3) 参数类型分别为:varchar,char,null
		List<TypeSpec> replace_arg6 = new ArrayList<TypeSpec>();
		replace_arg6.add(varcharType);
		replace_arg6.add(charType);
		replace_arg6.add(nullType);
		replace_arg6.add(varcharType);
		replace_argumentsType.add(replace_arg6);

		// 7.replace(str1, str2, str3) 参数类型分别为:varchar,null,varchar
		List<TypeSpec> replace_arg7 = new ArrayList<TypeSpec>();
		replace_arg7.add(varcharType);
		replace_arg7.add(nullType);
		replace_arg7.add(varcharType);
		replace_arg7.add(varcharType);
		replace_argumentsType.add(replace_arg7);

		// 8.replace(str1, str2, str3) 参数类型分别为:varchar,null,char
		List<TypeSpec> replace_arg8 = new ArrayList<TypeSpec>();
		replace_arg8.add(varcharType);
		replace_arg8.add(nullType);
		replace_arg8.add(charType);
		replace_arg8.add(varcharType);
		replace_argumentsType.add(replace_arg8);

		// 9.replace(str1, str2, str3) 参数类型分别为:varchar,null,null
		List<TypeSpec> replace_arg9 = new ArrayList<TypeSpec>();
		replace_arg9.add(varcharType);
		replace_arg9.add(nullType);
		replace_arg9.add(nullType);
		replace_arg9.add(varcharType);
		replace_argumentsType.add(replace_arg9);

		// 10.replace(str1, str2, str3) 参数类型分别为:char,varchar,varchar
		List<TypeSpec> replace_arg10 = new ArrayList<TypeSpec>();
		replace_arg10.add(charType);
		replace_arg10.add(varcharType);
		replace_arg10.add(varcharType);
		replace_arg10.add(varcharType);
		replace_argumentsType.add(replace_arg10);

		// 11.replace(str1, str2, str3) 参数类型分别为:char,varchar,char
		List<TypeSpec> replace_arg11 = new ArrayList<TypeSpec>();
		replace_arg11.add(charType);
		replace_arg11.add(varcharType);
		replace_arg11.add(charType);
		replace_arg11.add(varcharType);
		replace_argumentsType.add(replace_arg11);

		// 12.replace(str1, str2, str3) 参数类型分别为:char,varchar,null
		List<TypeSpec> replace_arg12 = new ArrayList<TypeSpec>();
		replace_arg12.add(charType);
		replace_arg12.add(varcharType);
		replace_arg12.add(nullType);
		replace_arg12.add(varcharType);
		replace_argumentsType.add(replace_arg12);

		// 13.replace(str1, str2, str3) 参数类型分别为:char,char,varchar
		List<TypeSpec> replace_arg13 = new ArrayList<TypeSpec>();
		replace_arg13.add(charType);
		replace_arg13.add(charType);
		replace_arg13.add(varcharType);
		replace_arg13.add(varcharType);
		replace_argumentsType.add(replace_arg13);

		// 14.replace(str1, str2, str3) 参数类型分别为:char,char,char
		List<TypeSpec> replace_arg14 = new ArrayList<TypeSpec>();
		replace_arg14.add(charType);
		replace_arg14.add(charType);
		replace_arg14.add(charType);
		replace_arg14.add(varcharType);
		replace_argumentsType.add(replace_arg14);

		// 15.replace(str1, str2, str3) 参数类型分别为:char,char,null
		List<TypeSpec> replace_arg15 = new ArrayList<TypeSpec>();
		replace_arg15.add(charType);
		replace_arg15.add(charType);
		replace_arg15.add(nullType);
		replace_arg15.add(varcharType);
		replace_argumentsType.add(replace_arg15);

		// 16.replace(str1, str2, str3) 参数类型分别为:char,null,varchar
		List<TypeSpec> replace_arg16 = new ArrayList<TypeSpec>();
		replace_arg16.add(charType);
		replace_arg16.add(nullType);
		replace_arg16.add(varcharType);
		replace_arg16.add(varcharType);
		replace_argumentsType.add(replace_arg16);

		// 17.replace(str1, str2, str3) 参数类型分别为:char,null,char
		List<TypeSpec> replace_arg17 = new ArrayList<TypeSpec>();
		replace_arg17.add(charType);
		replace_arg17.add(nullType);
		replace_arg17.add(charType);
		replace_arg17.add(varcharType);
		replace_argumentsType.add(replace_arg17);

		// 18.replace(str1, str2, str3) 参数类型分别为:char,null,null
		List<TypeSpec> replace_arg18 = new ArrayList<TypeSpec>();
		replace_arg18.add(charType);
		replace_arg18.add(nullType);
		replace_arg18.add(nullType);
		replace_arg18.add(varcharType);
		replace_argumentsType.add(replace_arg18);

		// 19.replace(str1, str2, str3) 参数类型分别为:null,varchar,varchar
		List<TypeSpec> replace_arg19 = new ArrayList<TypeSpec>();
		replace_arg19.add(nullType);
		replace_arg19.add(varcharType);
		replace_arg19.add(varcharType);
		replace_arg19.add(nullType);
		replace_argumentsType.add(replace_arg19);

		// 20.replace(str1, str2, str3) 参数类型分别为:null,varchar,char
		List<TypeSpec> replace_arg20 = new ArrayList<TypeSpec>();
		replace_arg20.add(nullType);
		replace_arg20.add(varcharType);
		replace_arg20.add(charType);
		replace_arg20.add(nullType);
		replace_argumentsType.add(replace_arg20);

		// 21.replace(str1, str2, str3) 参数类型分别为:null,varchar,null
		List<TypeSpec> replace_arg21 = new ArrayList<TypeSpec>();
		replace_arg21.add(nullType);
		replace_arg21.add(varcharType);
		replace_arg21.add(nullType);
		replace_arg21.add(nullType);
		replace_argumentsType.add(replace_arg21);

		// 22.replace(str1, str2, str3) 参数类型分别为:null,char,varchar
		List<TypeSpec> replace_arg22 = new ArrayList<TypeSpec>();
		replace_arg22.add(nullType);
		replace_arg22.add(charType);
		replace_arg22.add(varcharType);
		replace_arg22.add(nullType);
		replace_argumentsType.add(replace_arg22);

		// 23.replace(str1, str2, str3) 参数类型分别为:null,char,char
		List<TypeSpec> replace_arg23 = new ArrayList<TypeSpec>();
		replace_arg23.add(nullType);
		replace_arg23.add(charType);
		replace_arg23.add(charType);
		replace_arg23.add(nullType);
		replace_argumentsType.add(replace_arg23);

		// 24.replace(str1, str2, str3) 参数类型分别为:null,char,null
		List<TypeSpec> replace_arg24 = new ArrayList<TypeSpec>();
		replace_arg24.add(nullType);
		replace_arg24.add(charType);
		replace_arg24.add(nullType);
		replace_arg24.add(nullType);
		replace_argumentsType.add(replace_arg24);

		// 25.replace(str1, str2, str3) 参数类型分别为:null,null,varchar
		List<TypeSpec> replace_arg25 = new ArrayList<TypeSpec>();
		replace_arg25.add(nullType);
		replace_arg25.add(nullType);
		replace_arg25.add(varcharType);
		replace_arg25.add(nullType);
		replace_argumentsType.add(replace_arg25);

		// 26.replace(str1, str2, str3) 参数类型分别为:null,null,char
		List<TypeSpec> replace_arg26 = new ArrayList<TypeSpec>();
		replace_arg26.add(nullType);
		replace_arg26.add(nullType);
		replace_arg26.add(charType);
		replace_arg26.add(nullType);
		replace_argumentsType.add(replace_arg26);

		// 27.replace(str1, str2, str3) 参数类型分别为:null,null,null
		List<TypeSpec> replace_arg27 = new ArrayList<TypeSpec>();
		replace_arg27.add(nullType);
		replace_arg27.add(nullType);
		replace_arg27.add(nullType);
		replace_arg27.add(nullType);
		replace_argumentsType.add(replace_arg27);

		// 28.replace(str1, str2)参数类型分别为:varchar, varchar
		List<TypeSpec> replace_arg28 = new ArrayList<TypeSpec>();
		replace_arg28.add(varcharType);
		replace_arg28.add(varcharType);
		replace_arg28.add(varcharType);
		replace_argumentsType.add(replace_arg28);

		// 29.replace(str1, str2)参数类型分别为:varchar, char
		List<TypeSpec> replace_arg29 = new ArrayList<TypeSpec>();
		replace_arg29.add(varcharType);
		replace_arg29.add(charType);
		replace_arg29.add(varcharType);
		replace_argumentsType.add(replace_arg29);

		// 30.replace(str1, str2)参数类型分别为:varchar, null
		List<TypeSpec> replace_arg30 = new ArrayList<TypeSpec>();
		replace_arg30.add(varcharType);
		replace_arg30.add(nullType);
		replace_arg30.add(varcharType);
		replace_argumentsType.add(replace_arg30);

		// 31.replace(str1, str2)参数类型分别为:char, varchar
		List<TypeSpec> replace_arg31 = new ArrayList<TypeSpec>();
		replace_arg31.add(charType);
		replace_arg31.add(varcharType);
		replace_arg31.add(varcharType);
		replace_argumentsType.add(replace_arg31);

		// 32.replace(str1, str2)参数类型分别为:char, char
		List<TypeSpec> replace_arg32 = new ArrayList<TypeSpec>();
		replace_arg32.add(charType);
		replace_arg32.add(charType);
		replace_arg32.add(varcharType);
		replace_argumentsType.add(replace_arg32);

		// 33.replace(str1, str2)参数类型分别为:char, null
		List<TypeSpec> replace_arg33 = new ArrayList<TypeSpec>();
		replace_arg33.add(charType);
		replace_arg33.add(nullType);
		replace_arg33.add(varcharType);
		replace_argumentsType.add(replace_arg33);

		// 34.replace(str1, str2)参数类型分别为:null, varchar
		List<TypeSpec> replace_arg34 = new ArrayList<TypeSpec>();
		replace_arg34.add(nullType);
		replace_arg34.add(varcharType);
		replace_arg34.add(nullType);
		replace_argumentsType.add(replace_arg34);

		// 35.replace(str1, str2)参数类型分别为:null, char
		List<TypeSpec> replace_arg35 = new ArrayList<TypeSpec>();
		replace_arg35.add(nullType);
		replace_arg35.add(charType);
		replace_arg35.add(nullType);
		replace_argumentsType.add(replace_arg35);

		// 36.replace(str1, str2)参数类型分别为:null, null
		List<TypeSpec> replace_arg36 = new ArrayList<TypeSpec>();
		replace_arg36.add(nullType);
		replace_arg36.add(nullType);
		replace_arg36.add(nullType);
		replace_argumentsType.add(replace_arg36);

		replaceId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				replace_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(replaceId, new Sys_ReplaceExpression());*/

		// Trim
		// 名称
		trimId = new SymTabEntryImpl("trim");
		// 类型定义为系统函数
		trimId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// trimId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> trim_argumentsType = new ArrayList<List<TypeSpec>>();
		// 1.trim(str)参数类型为:varchar
		List<TypeSpec> trim_arg = new ArrayList<TypeSpec>();
		trim_arg.add(varcharType);
		trim_arg.add(varcharType);
		trim_argumentsType.add(trim_arg);

		// 2.trim(str)参数类型为:char
		List<TypeSpec> trim_arg2 = new ArrayList<TypeSpec>();
		trim_arg2.add(charType);
		trim_arg2.add(varcharType);
		trim_argumentsType.add(trim_arg2);

		// 3.trim(str)参数类型为:null
		List<TypeSpec> trim_arg3 = new ArrayList<TypeSpec>();
		trim_arg3.add(nullType);
		trim_arg3.add(nullType);
		trim_argumentsType.add(trim_arg3);

		trimId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, trim_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(trimId, new Sys_TrimExpression());
*/
		// LTrim
		// 名称
		ltrimId = new SymTabEntryImpl("ltrim");
		// 类型定义为系统函数
		ltrimId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// ltrimId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> ltrim_argumentsType = new ArrayList<List<TypeSpec>>();
		// 1.ltrim(str)参数类型为:varchar
		List<TypeSpec> ltrim_arg = new ArrayList<TypeSpec>();
		ltrim_arg.add(varcharType);
		ltrim_arg.add(varcharType);
		ltrim_argumentsType.add(ltrim_arg);
		// 2.ltrim(str)参数类型为:char
		List<TypeSpec> ltrim_arg2 = new ArrayList<TypeSpec>();
		ltrim_arg2.add(charType);
		ltrim_arg2.add(varcharType);
		ltrim_argumentsType.add(ltrim_arg2);

		// 3.ltrim(str)参数类型为:null
		List<TypeSpec> ltrim_arg3 = new ArrayList<TypeSpec>();
		ltrim_arg3.add(nullType);
		ltrim_arg3.add(nullType);
		ltrim_argumentsType.add(ltrim_arg3);

		ltrimId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, ltrim_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(ltrimId, new Sys_LTrimExpression());*/

		// RTrim
		// 名称
		rtrimId = new SymTabEntryImpl("rtrim");
		// 类型定义为系统函数
		rtrimId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// rtrimId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> rtrim_argumentsType = new ArrayList<List<TypeSpec>>();
		// 1.rtrim(str)参数类型为:varchar
		List<TypeSpec> rtrim_arg = new ArrayList<TypeSpec>();
		rtrim_arg.add(varcharType);
		rtrim_arg.add(varcharType);
		rtrim_argumentsType.add(rtrim_arg);
		// 2.rtrim(str)参数类型为:char
		List<TypeSpec> rtrim_arg2 = new ArrayList<TypeSpec>();
		rtrim_arg2.add(charType);
		rtrim_arg2.add(varcharType);
		rtrim_argumentsType.add(rtrim_arg2);

		// 3.rtrim(str)参数类型为:null
		List<TypeSpec> rtrim_arg3 = new ArrayList<TypeSpec>();
		rtrim_arg3.add(nullType);
		rtrim_arg3.add(nullType);
		rtrim_argumentsType.add(rtrim_arg3);

		rtrimId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, rtrim_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(rtrimId, new Sys_RTrimExpression());*/

		// initCap
		// 名称
		initCapId = new SymTabEntryImpl("initcap");
		// 类型定义为系统函数
		initCapId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// initCapId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> initCap_argumentsType = new ArrayList<List<TypeSpec>>();
		// 1.initCap(str)参数类型为:varchar
		List<TypeSpec> initCap_arg = new ArrayList<TypeSpec>();
		initCap_arg.add(varcharType);
		initCap_arg.add(varcharType);
		initCap_argumentsType.add(initCap_arg);

		// 2.initCap(str)参数类型为:char
		List<TypeSpec> initCap_arg2 = new ArrayList<TypeSpec>();
		initCap_arg2.add(charType);
		initCap_arg2.add(varcharType);
		initCap_argumentsType.add(initCap_arg2);

		// 3.initCap(str)参数类型为:null
		List<TypeSpec> initCap_arg3 = new ArrayList<TypeSpec>();
		initCap_arg3.add(nullType);
		initCap_arg3.add(nullType);
		initCap_argumentsType.add(initCap_arg3);

		initCapId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				initCap_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(initCapId, new Sys_InitCapExpression());*/

		// left
		// 名称
		leftId = new SymTabEntryImpl("left");
		// 类型定义为系统函数
		leftId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// leftId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> left_argumentsType = new ArrayList<List<TypeSpec>>();
		// 1.left(str1, position)参数类型分别为:varchar int
		List<TypeSpec> left_arg1 = new ArrayList<TypeSpec>();
		left_arg1.add(varcharType);
		left_arg1.add(intType);
		left_arg1.add(varcharType);
		left_argumentsType.add(left_arg1);

		// 2.left(str1, position)参数类型分别为:varchar null
		List<TypeSpec> left_arg2 = new ArrayList<TypeSpec>();
		left_arg2.add(varcharType);
		left_arg2.add(nullType);
		left_arg2.add(nullType);
		left_argumentsType.add(left_arg2);

		// 3.left(str1, position)参数类型分别为:char int
		List<TypeSpec> left_arg3 = new ArrayList<TypeSpec>();
		left_arg3.add(charType);
		left_arg3.add(intType);
		left_arg3.add(varcharType);
		left_argumentsType.add(left_arg3);

		// 4.left(str1, position)参数类型分别为:char null
		List<TypeSpec> left_arg4 = new ArrayList<TypeSpec>();
		left_arg4.add(charType);
		left_arg4.add(nullType);
		left_arg4.add(nullType);
		left_argumentsType.add(left_arg4);

		// 5.left(str1, position)参数类型分别为:null int
		List<TypeSpec> left_arg5 = new ArrayList<TypeSpec>();
		left_arg5.add(nullType);
		left_arg5.add(intType);
		left_arg5.add(nullType);
		left_argumentsType.add(left_arg5);

		// 6.left(str1, position)参数类型分别为:null null
		List<TypeSpec> left_arg6 = new ArrayList<TypeSpec>();
		left_arg6.add(nullType);
		left_arg6.add(nullType);
		left_arg6.add(nullType);
		left_argumentsType.add(left_arg6);

		leftId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, left_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(leftId, new Sys_LeftExpression());*/

		// right
		// 名称
		rightId = new SymTabEntryImpl("right");
		// 类型定义为系统函数
		rightId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// rightId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> right_argumentsType = new ArrayList<List<TypeSpec>>();
		// 1.right(str1, position)参数类型分别为:varchar int
		List<TypeSpec> right_arg1 = new ArrayList<TypeSpec>();
		right_arg1.add(varcharType);
		right_arg1.add(intType);
		right_arg1.add(varcharType);
		right_argumentsType.add(right_arg1);

		// 2.right(str1, position)参数类型分别为:varchar null
		List<TypeSpec> right_arg2 = new ArrayList<TypeSpec>();
		right_arg2.add(varcharType);
		right_arg2.add(nullType);
		right_arg2.add(nullType);
		right_argumentsType.add(right_arg2);

		// 3.right(str1, position)参数类型分别为:char int
		List<TypeSpec> right_arg3 = new ArrayList<TypeSpec>();
		right_arg3.add(charType);
		right_arg3.add(intType);
		right_arg3.add(varcharType);
		right_argumentsType.add(right_arg3);

		// 4.right(str1, position)参数类型分别为:char null
		List<TypeSpec> right_arg4 = new ArrayList<TypeSpec>();
		right_arg4.add(charType);
		right_arg4.add(nullType);
		right_arg4.add(nullType);
		right_argumentsType.add(right_arg4);

		// 5.right(str1, position)参数类型分别为:null int
		List<TypeSpec> right_arg5 = new ArrayList<TypeSpec>();
		right_arg5.add(nullType);
		right_arg5.add(intType);
		right_arg5.add(nullType);
		right_argumentsType.add(right_arg5);

		// 6.right(str1, position)参数类型分别为:null null
		List<TypeSpec> right_arg6 = new ArrayList<TypeSpec>();
		right_arg6.add(nullType);
		right_arg6.add(nullType);
		right_arg6.add(nullType);
		right_argumentsType.add(right_arg6);

		rightId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, right_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(rightId, new Sys_RightExpression());*/

		// right
		// 名称
		tosinglebyteId = new SymTabEntryImpl("to_single_byte");
		// 类型定义为系统函数
		tosinglebyteId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// rightId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> tosinglebyte_argumentsType = new ArrayList<List<TypeSpec>>();
		// 1.right(str1, position)参数类型分别为:varchar int
		List<TypeSpec> tosinglebyte_arg1 = new ArrayList<TypeSpec>();
		tosinglebyte_arg1.add(varcharType);
		tosinglebyte_arg1.add(varcharType);
		tosinglebyte_argumentsType.add(tosinglebyte_arg1);

		// 2.right(str1, position)参数类型分别为:varchar null
		List<TypeSpec> tosinglebyte_arg2 = new ArrayList<TypeSpec>();
		tosinglebyte_arg2.add(nullType);
		tosinglebyte_arg2.add(nullType);
		tosinglebyte_argumentsType.add(tosinglebyte_arg2);

		// 3.right(str1, position)参数类型分别为:char int
		List<TypeSpec> tosinglebyte_arg3 = new ArrayList<TypeSpec>();
		tosinglebyte_arg3.add(charType);
		tosinglebyte_arg3.add(charType);
		tosinglebyte_argumentsType.add(tosinglebyte_arg3);



		tosinglebyteId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, tosinglebyte_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(tosinglebyteId, new Sys_ToSingleByteExpression());*/
		
		// right
		// 名称
		regexpsubstrId = new SymTabEntryImpl("regexp_substr");
		// 类型定义为系统函数
		regexpsubstrId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// rightId.setTypeSpec(varcharType);

		// 设置形参类型
		List<List<TypeSpec>> regexpsubstr_argumentsType = new ArrayList<List<TypeSpec>>();
		// 1.right(str1, position)参数类型分别为:varchar int
		List<TypeSpec> regexpsubstr_arg1 = new ArrayList<TypeSpec>();
		regexpsubstr_arg1.add(varcharType);
		regexpsubstr_arg1.add(varcharType);
		regexpsubstr_arg1.add(varcharType);
		regexpsubstr_argumentsType.add(regexpsubstr_arg1);

		// 2.right(str1, position)参数类型分别为:varchar null
		List<TypeSpec> regexpsubstr_arg2 = new ArrayList<TypeSpec>();
		regexpsubstr_arg2.add(varcharType);
		regexpsubstr_arg2.add(nullType);
		regexpsubstr_arg2.add(nullType);
		regexpsubstr_argumentsType.add(regexpsubstr_arg2);

		// 3.right(str1, position)参数类型分别为:char int
		List<TypeSpec> regexpsubstr_arg3 = new ArrayList<TypeSpec>();
		regexpsubstr_arg3.add(charType);
		regexpsubstr_arg3.add(nullType);
		regexpsubstr_arg3.add(nullType);
		regexpsubstr_argumentsType.add(regexpsubstr_arg3);

		// 4.right(str1, position)参数类型分别为:char null
		List<TypeSpec> regexpsubstr_arg4 = new ArrayList<TypeSpec>();
		regexpsubstr_arg4.add(nullType);
		regexpsubstr_arg4.add(varcharType);
		regexpsubstr_arg4.add(nullType);
		regexpsubstr_argumentsType.add(regexpsubstr_arg4);

				// 5.right(str1, position)参数类型分别为:null int
				List<TypeSpec> regexpsubstr_arg5 = new ArrayList<TypeSpec>();
				regexpsubstr_arg5.add(nullType);
				regexpsubstr_arg5.add(charType);
				regexpsubstr_arg5.add(nullType);
				regexpsubstr_argumentsType.add(regexpsubstr_arg5);

				// 6.right(str1, position)参数类型分别为:null null
				List<TypeSpec> regexpsubstr_arg6 = new ArrayList<TypeSpec>();
				regexpsubstr_arg6.add(varcharType);
				regexpsubstr_arg6.add(charType);
				regexpsubstr_arg6.add(varcharType);
				regexpsubstr_argumentsType.add(regexpsubstr_arg6);
				
				List<TypeSpec> regexpsubstr_arg7 = new ArrayList<TypeSpec>();
				regexpsubstr_arg7.add(charType);
				regexpsubstr_arg7.add(varcharType);
				regexpsubstr_arg7.add(varcharType);
				regexpsubstr_argumentsType.add(regexpsubstr_arg7);
				
				List<TypeSpec> regexpsubstr_arg8 = new ArrayList<TypeSpec>();
				regexpsubstr_arg8.add(charType);
				regexpsubstr_arg8.add(charType);
				regexpsubstr_arg8.add(charType);
				regexpsubstr_argumentsType.add(regexpsubstr_arg8);
				
				List<TypeSpec> regexpsubstr_arg9 = new ArrayList<TypeSpec>();
				regexpsubstr_arg9.add(nullType);
				regexpsubstr_arg9.add(nullType);
				regexpsubstr_arg9.add(nullType);
				regexpsubstr_argumentsType.add(regexpsubstr_arg9);

				regexpsubstrId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, regexpsubstr_argumentsType);

				// 加入到id_functioncall的集合中
				id_sysFuntionMap.put(regexpsubstrId, new Sys_RegexpSubstrExpression());*/
				
				// right
				// 名称
				regexplikeId = new SymTabEntryImpl("regexp_like");
				// 类型定义为系统函数
				regexplikeId.setDefinition(DefinitionImpl.SYS_FUNCTION);
				/*// 类型描述即返回值类型
				// rightId.setTypeSpec(varcharType);

				// 设置形参类型
				List<List<TypeSpec>> regexplike_argumentsType = new ArrayList<List<TypeSpec>>();
				
				List<TypeSpec> regexplike_arg11 = new ArrayList<TypeSpec>();
				regexplike_arg11.add(varcharType);
				regexplike_arg11.add(varcharType);
				regexplike_arg11.add(varcharType);
				regexplike_arg11.add(booleanType);
				regexplike_argumentsType.add(regexplike_arg11);
							
				// 1.right(str1, position)参数类型分别为:varchar int
				List<TypeSpec> regexplike_arg1 = new ArrayList<TypeSpec>();
				regexplike_arg1.add(varcharType);
				regexplike_arg1.add(varcharType);
				regexplike_arg1.add(booleanType);
				regexplike_argumentsType.add(regexplike_arg1);

				// 2.right(str1, position)参数类型分别为:varchar null
				List<TypeSpec> regexplike_arg2 = new ArrayList<TypeSpec>();
				regexplike_arg2.add(varcharType);
				regexplike_arg2.add(nullType);
				regexplike_arg2.add(booleanType);
				regexplike_argumentsType.add(regexplike_arg2);

				// 3.right(str1, position)参数类型分别为:char int
				List<TypeSpec> regexplike_arg3 = new ArrayList<TypeSpec>();
				regexplike_arg3.add(charType);
				regexplike_arg3.add(nullType);
				regexplike_arg3.add(booleanType);
				regexplike_argumentsType.add(regexplike_arg3);

				// 4.right(str1, position)参数类型分别为:char null
				List<TypeSpec> regexplike_arg4 = new ArrayList<TypeSpec>();
				regexplike_arg4.add(nullType);
				regexplike_arg4.add(varcharType);
				regexplike_arg4.add(booleanType);
				regexplike_argumentsType.add(regexplike_arg4);

						// 5.right(str1, position)参数类型分别为:null int
						List<TypeSpec> regexplike_arg5 = new ArrayList<TypeSpec>();
						regexplike_arg5.add(nullType);
						regexplike_arg5.add(charType);
						regexplike_arg5.add(booleanType);
						regexplike_argumentsType.add(regexplike_arg5);

						// 6.right(str1, position)参数类型分别为:null null
						List<TypeSpec> regexplike_arg6 = new ArrayList<TypeSpec>();
						regexplike_arg6.add(varcharType);
						regexplike_arg6.add(charType);
						regexplike_arg6.add(booleanType);
						regexplike_argumentsType.add(regexplike_arg6);
						
						List<TypeSpec> regexplike_arg7 = new ArrayList<TypeSpec>();
						regexplike_arg7.add(charType);
						regexplike_arg7.add(varcharType);
						regexplike_arg7.add(booleanType);
						regexplike_argumentsType.add(regexplike_arg7);
						
						List<TypeSpec> regexplike_arg8 = new ArrayList<TypeSpec>();
						regexplike_arg8.add(charType);
						regexplike_arg8.add(charType);
						regexplike_arg8.add(booleanType);
						regexplike_argumentsType.add(regexplike_arg8);
						
						List<TypeSpec> regexplike_arg9 = new ArrayList<TypeSpec>();
						regexplike_arg9.add(nullType);
						regexplike_arg9.add(nullType);
						regexplike_arg9.add(booleanType);
						regexplike_argumentsType.add(regexplike_arg9);

						regexplikeId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, regexplike_argumentsType);

						// 加入到id_functioncall的集合中
						id_sysFuntionMap.put(regexplikeId, new Sys_RegexpLikeExpression());
*/
	}

	private static void initializeMathFunction() {

		// floor
		// 名称
		floorId = new SymTabEntryImpl("floor");
		// 类型定义为系统函数
		floorId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// floorId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> floor_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> floor_arg = new ArrayList<TypeSpec>();
		// String的先放varchar
		floor_arg.add(intType);
		floor_arg.add(longType);
		floor_argumentsType.add(floor_arg);
		List<TypeSpec> floor_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		floor_arg1.add(longType);
		floor_arg1.add(longType);
		floor_argumentsType.add(floor_arg1);
		List<TypeSpec> floor_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		floor_arg2.add(doubleType);
		floor_arg2.add(longType);
		floor_argumentsType.add(floor_arg2);
		List<TypeSpec> floor_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		floor_arg3.add(nullType);
		floor_arg3.add(nullType);
		floor_argumentsType.add(floor_arg3);

		floorId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, floor_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(floorId, new Sys_FloorExpression());*/

		// ceil
		// 名称
		ceilId = new SymTabEntryImpl("ceil");
		// 类型定义为系统函数
		ceilId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// ceilId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> ceil_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> ceil_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		ceil_arg1.add(intType);
		ceil_arg1.add(longType);
		ceil_argumentsType.add(ceil_arg1);
		List<TypeSpec> ceil_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		ceil_arg2.add(longType);
		ceil_arg2.add(longType);
		ceil_argumentsType.add(ceil_arg2);
		List<TypeSpec> ceil_arg = new ArrayList<TypeSpec>();
		// String的先放varchar
		ceil_arg.add(doubleType);
		ceil_arg.add(longType);
		ceil_argumentsType.add(ceil_arg);
		List<TypeSpec> ceil_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		ceil_arg3.add(nullType);
		ceil_arg3.add(nullType);
		ceil_argumentsType.add(ceil_arg3);

		ceilId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, ceil_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(ceilId, new Sys_CeilExpression());*/

		// ln
		// 名称
		lnId = new SymTabEntryImpl("ln");
		// 类型定义为系统函数
		lnId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// lnId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> ln_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> ln_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		ln_arg1.add(intType);
		ln_arg1.add(doubleType);
		ln_argumentsType.add(ln_arg1);
		List<TypeSpec> ln_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		ln_arg2.add(longType);
		ln_arg2.add(doubleType);
		ln_argumentsType.add(ln_arg2);
		List<TypeSpec> ln_arg = new ArrayList<TypeSpec>();
		// String的先放varchar
		ln_arg.add(doubleType);
		ln_arg.add(doubleType);
		ln_argumentsType.add(ln_arg);
		List<TypeSpec> ln_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		ln_arg3.add(nullType);
		ln_arg3.add(nullType);
		ln_argumentsType.add(ln_arg3);
		lnId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, ln_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(lnId, new Sys_LnExpression());*/

		// log
		// 名称
		logId = new SymTabEntryImpl("log");
		// 类型定义为系统函数
		logId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// logId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> log_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> log_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg1.add(intType);
		log_arg1.add(intType);
		log_arg1.add(doubleType);
		log_argumentsType.add(log_arg1);
		List<TypeSpec> log_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg2.add(intType);
		log_arg2.add(longType);
		log_arg2.add(doubleType);
		log_argumentsType.add(log_arg2);
		List<TypeSpec> log_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg3.add(intType);
		log_arg3.add(doubleType);
		log_arg3.add(doubleType);
		log_argumentsType.add(log_arg3);
		List<TypeSpec> log_arg4 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg4.add(longType);
		log_arg4.add(intType);
		log_arg4.add(doubleType);
		log_argumentsType.add(log_arg4);
		List<TypeSpec> log_arg5 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg5.add(longType);
		log_arg5.add(longType);
		log_arg5.add(doubleType);
		log_argumentsType.add(log_arg5);
		List<TypeSpec> log_arg6 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg6.add(longType);
		log_arg6.add(doubleType);
		log_arg6.add(doubleType);
		log_argumentsType.add(log_arg6);
		List<TypeSpec> log_arg7 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg7.add(doubleType);
		log_arg7.add(intType);
		log_arg7.add(doubleType);
		log_argumentsType.add(log_arg7);
		List<TypeSpec> log_arg8 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg8.add(doubleType);
		log_arg8.add(longType);
		log_arg8.add(doubleType);
		log_argumentsType.add(log_arg8);
		List<TypeSpec> log_arg9 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg9.add(doubleType);
		log_arg9.add(doubleType);
		log_arg9.add(doubleType);
		log_argumentsType.add(log_arg9);
		List<TypeSpec> log_arg10 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg10.add(nullType);
		log_arg10.add(intType);
		log_arg10.add(nullType);
		log_argumentsType.add(log_arg10);
		List<TypeSpec> log_arg11 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg11.add(nullType);
		log_arg11.add(longType);
		log_arg11.add(nullType);
		log_argumentsType.add(log_arg11);
		List<TypeSpec> log_arg12 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg12.add(nullType);
		log_arg12.add(doubleType);
		log_arg12.add(nullType);
		log_argumentsType.add(log_arg12);
		List<TypeSpec> log_arg13 = new ArrayList<TypeSpec>();
		// String的先放varchar
		log_arg13.add(nullType);
		log_arg13.add(nullType);
		log_arg13.add(nullType);
		log_argumentsType.add(log_arg13);
		logId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, log_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(logId, new Sys_LogExpression());*/

		// power
		// 名称
		powerId = new SymTabEntryImpl("power");
		// 类型定义为系统函数
		powerId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// powerId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> power_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> power_arg1 = new ArrayList<TypeSpec>();

		power_arg1.add(nullType);
		power_arg1.add(nullType);
		power_arg1.add(nullType);
		power_argumentsType.add(power_arg1);

		List<TypeSpec> power_arg2 = new ArrayList<TypeSpec>();

		power_arg2.add(intType);
		power_arg2.add(nullType);
		power_arg2.add(nullType);
		power_argumentsType.add(power_arg2);

		List<TypeSpec> power_arg3 = new ArrayList<TypeSpec>();

		power_arg3.add(longType);
		power_arg3.add(nullType);
		power_arg3.add(nullType);
		power_argumentsType.add(power_arg3);

		List<TypeSpec> power_arg4 = new ArrayList<TypeSpec>();

		power_arg4.add(doubleType);
		power_arg4.add(nullType);
		power_arg4.add(nullType);
		power_argumentsType.add(power_arg4);

		List<TypeSpec> power_arg5 = new ArrayList<TypeSpec>();

		power_arg5.add(nullType);
		power_arg5.add(intType);
		power_arg5.add(nullType);
		power_argumentsType.add(power_arg5);

		List<TypeSpec> power_arg6 = new ArrayList<TypeSpec>();

		power_arg6.add(nullType);
		power_arg6.add(longType);
		power_arg6.add(nullType);
		power_argumentsType.add(power_arg6);

		List<TypeSpec> power_arg7 = new ArrayList<TypeSpec>();

		power_arg7.add(nullType);
		power_arg7.add(doubleType);
		power_arg7.add(nullType);
		power_argumentsType.add(power_arg7);

		// List<TypeSpec> power_arg8 = new ArrayList<TypeSpec>();
		// power_arg8.add(nullType);
		// power_arg8.add(charType);
		// power_arg8.add(nullType);
		// power_argumentsType.add(power_arg8);
		//
		// List<TypeSpec> power_arg9 = new ArrayList<TypeSpec>();
		// power_arg9.add(nullType);
		// power_arg9.add(varcharType);
		// power_arg9.add(nullType);
		// power_argumentsType.add(power_arg9);

		List<TypeSpec> power_arg10 = new ArrayList<TypeSpec>();
		power_arg10.add(intType);
		power_arg10.add(intType);
		power_arg10.add(doubleType);
		power_argumentsType.add(power_arg10);

		List<TypeSpec> power_arg11 = new ArrayList<TypeSpec>();
		power_arg11.add(intType);
		power_arg11.add(longType);
		power_arg11.add(doubleType);
		power_argumentsType.add(power_arg11);

		List<TypeSpec> power_arg12 = new ArrayList<TypeSpec>();
		power_arg12.add(intType);
		power_arg12.add(doubleType);
		power_arg12.add(doubleType);
		power_argumentsType.add(power_arg12);

		List<TypeSpec> power_arg13 = new ArrayList<TypeSpec>();
		power_arg13.add(longType);
		power_arg13.add(intType);
		power_arg13.add(doubleType);
		power_argumentsType.add(power_arg13);

		List<TypeSpec> power_arg14 = new ArrayList<TypeSpec>();
		power_arg14.add(longType);
		power_arg14.add(longType);
		power_arg14.add(doubleType);
		power_argumentsType.add(power_arg14);

		List<TypeSpec> power_arg15 = new ArrayList<TypeSpec>();
		power_arg15.add(longType);
		power_arg15.add(doubleType);
		power_arg15.add(doubleType);
		power_argumentsType.add(power_arg15);

		List<TypeSpec> power_arg16 = new ArrayList<TypeSpec>();
		power_arg16.add(doubleType);
		power_arg16.add(intType);
		power_arg16.add(doubleType);
		power_argumentsType.add(power_arg16);

		List<TypeSpec> power_arg17 = new ArrayList<TypeSpec>();
		power_arg17.add(doubleType);
		power_arg17.add(longType);
		power_arg17.add(doubleType);
		power_argumentsType.add(power_arg17);

		List<TypeSpec> power_arg = new ArrayList<TypeSpec>();
		power_arg.add(doubleType);
		power_arg.add(doubleType);
		power_arg.add(doubleType);
		power_argumentsType.add(power_arg);

		powerId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, power_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(powerId, new Sys_PowerExpression());*/

		// dabs
		// 名称
		absId = new SymTabEntryImpl("abs");
		// 类型定义为系统函数
		absId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// dabsId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> dabs_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> dabs_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		dabs_arg1.add(intType);
		dabs_arg1.add(doubleType);
		dabs_argumentsType.add(dabs_arg1);
		List<TypeSpec> dabs_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		dabs_arg2.add(longType);
		dabs_arg2.add(doubleType);
		dabs_argumentsType.add(dabs_arg2);
		List<TypeSpec> dabs_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		dabs_arg3.add(doubleType);
		dabs_arg3.add(doubleType);
		dabs_argumentsType.add(dabs_arg3);
		List<TypeSpec> dabs_arg4 = new ArrayList<TypeSpec>();
		// String的先放varchar
		dabs_arg4.add(nullType);
		dabs_arg4.add(nullType);
		dabs_argumentsType.add(dabs_arg4);

		absId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, dabs_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(absId, new Sys_DabsExpression());*/
		// sqrt
		// 名称
		sqrtId = new SymTabEntryImpl("sqrt");
		// 类型定义为系统函数
		sqrtId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// sqrtId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> sqrt_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> sqrt_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sqrt_arg2.add(intType);
		sqrt_arg2.add(doubleType);
		sqrt_argumentsType.add(sqrt_arg2);

		List<TypeSpec> sqrt_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sqrt_arg3.add(longType);
		sqrt_arg3.add(doubleType);
		sqrt_argumentsType.add(sqrt_arg3);

		List<TypeSpec> sqrt_arg4 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sqrt_arg4.add(doubleType);
		sqrt_arg4.add(doubleType);
		sqrt_argumentsType.add(sqrt_arg4);

		List<TypeSpec> sqrt_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sqrt_arg1.add(nullType);
		sqrt_arg1.add(nullType);
		sqrt_argumentsType.add(sqrt_arg1);

		sqrtId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, sqrt_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(sqrtId, new Sys_SqrtExpression());*/

		// sin
		// 名称
		sinId = new SymTabEntryImpl("sin");
		// 类型定义为系统函数
		sinId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// sinId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> sin_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> sin_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sin_arg2.add(intType);
		sin_arg2.add(doubleType);
		sin_argumentsType.add(sin_arg2);

		List<TypeSpec> sin_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sin_arg3.add(longType);
		sin_arg3.add(doubleType);
		sin_argumentsType.add(sin_arg3);

		List<TypeSpec> sin_arg4 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sin_arg4.add(doubleType);
		sin_arg4.add(doubleType);
		sin_argumentsType.add(sin_arg4);

		List<TypeSpec> sin_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sin_arg1.add(nullType);
		sin_arg1.add(nullType);
		sin_argumentsType.add(sin_arg1);

		sinId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, sin_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(sinId, new Sys_SinExpression());*/

		// round
		// 名称
		roundId = new SymTabEntryImpl("round");
		// 类型定义为系统函数
		roundId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// roundId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> round_argumentsType = new ArrayList<List<TypeSpec>>();

		
		 * int int int long int double long int long long long double double int
		 * double long double double
		 
		List<TypeSpec> round_arg0 = new ArrayList<TypeSpec>();
		round_arg0.add(intType);
		round_arg0.add(intType);
		round_argumentsType.add(round_arg0);

		List<TypeSpec> round_arg01 = new ArrayList<TypeSpec>();
		round_arg01.add(nullType);
		round_arg01.add(nullType);
		round_argumentsType.add(round_arg01);

		List<TypeSpec> round_arg02 = new ArrayList<TypeSpec>();
		round_arg02.add(longType);
		round_arg02.add(longType);
		round_argumentsType.add(round_arg02);

		List<TypeSpec> round_arg03 = new ArrayList<TypeSpec>();
		round_arg03.add(doubleType);
		round_arg03.add(doubleType);
		round_argumentsType.add(round_arg03);

		List<TypeSpec> round_arg3 = new ArrayList<TypeSpec>();
		round_arg3.add(intType);
		round_arg3.add(intType);
		round_arg3.add(intType);
		round_argumentsType.add(round_arg3);

		List<TypeSpec> round_arg31 = new ArrayList<TypeSpec>();
		round_arg31.add(intType);
		round_arg31.add(longType);
		round_arg31.add(intType);
		round_argumentsType.add(round_arg31);

		List<TypeSpec> round_arg32 = new ArrayList<TypeSpec>();
		round_arg32.add(intType);
		round_arg32.add(doubleType);
		round_arg32.add(intType);
		round_argumentsType.add(round_arg32);

		List<TypeSpec> round_arg33 = new ArrayList<TypeSpec>();
		round_arg33.add(intType);
		round_arg33.add(nullType);
		round_arg33.add(nullType);
		round_argumentsType.add(round_arg33);

		List<TypeSpec> round_arg4 = new ArrayList<TypeSpec>();
		round_arg4.add(longType);
		round_arg4.add(intType);
		round_arg4.add(longType);
		round_argumentsType.add(round_arg4);

		List<TypeSpec> round_arg41 = new ArrayList<TypeSpec>();
		round_arg41.add(longType);
		round_arg41.add(longType);
		round_arg41.add(longType);
		round_argumentsType.add(round_arg41);

		List<TypeSpec> round_arg42 = new ArrayList<TypeSpec>();
		round_arg42.add(longType);
		round_arg42.add(doubleType);
		round_arg42.add(longType);
		round_argumentsType.add(round_arg42);

		List<TypeSpec> round_arg43 = new ArrayList<TypeSpec>();
		round_arg43.add(longType);
		round_arg43.add(nullType);
		round_arg43.add(nullType);
		round_argumentsType.add(round_arg43);

		List<TypeSpec> round_arg1 = new ArrayList<TypeSpec>();

		round_arg1.add(doubleType);
		round_arg1.add(intType);
		round_arg1.add(doubleType);
		round_argumentsType.add(round_arg1);

		List<TypeSpec> round_arg12 = new ArrayList<TypeSpec>();

		round_arg12.add(doubleType);
		round_arg12.add(longType);
		round_arg12.add(doubleType);
		round_argumentsType.add(round_arg12);

		List<TypeSpec> round_arg11 = new ArrayList<TypeSpec>();

		round_arg11.add(doubleType);
		round_arg11.add(doubleType);
		round_arg11.add(doubleType);
		round_argumentsType.add(round_arg11);

		List<TypeSpec> round_arg13 = new ArrayList<TypeSpec>();

		round_arg13.add(doubleType);
		round_arg13.add(nullType);
		round_arg13.add(nullType);
		round_argumentsType.add(round_arg13);

		List<TypeSpec> round_arg10 = new ArrayList<TypeSpec>();
		round_arg10.add(dateType);
		round_arg10.add(varcharType);
		round_arg10.add(dateType);
		round_argumentsType.add(round_arg10);

		List<TypeSpec> round_arg101 = new ArrayList<TypeSpec>();
		round_arg101.add(dateType);
		round_arg101.add(charType);
		round_arg101.add(dateType);
		round_argumentsType.add(round_arg101);

		List<TypeSpec> round_arg102 = new ArrayList<TypeSpec>();
		round_arg102.add(dateType);
		round_arg102.add(nullType);
		round_arg102.add(nullType);
		round_argumentsType.add(round_arg102);

		List<TypeSpec> round_arg103 = new ArrayList<TypeSpec>();
		round_arg103.add(nullType);
		round_arg103.add(intType);
		round_arg103.add(nullType);
		round_argumentsType.add(round_arg103);

		List<TypeSpec> round_arg104 = new ArrayList<TypeSpec>();
		round_arg104.add(nullType);
		round_arg104.add(longType);
		round_arg104.add(nullType);
		round_argumentsType.add(round_arg104);

		List<TypeSpec> round_arg105 = new ArrayList<TypeSpec>();
		round_arg105.add(nullType);
		round_arg105.add(doubleType);
		round_arg105.add(nullType);
		round_argumentsType.add(round_arg105);

		// List<TypeSpec> round_arg106=new ArrayList<TypeSpec>();
		// round_arg106.add(nullType);
		// round_arg106.add(varcharType);
		// round_arg106.add(nullType);
		// round_argumentsType.add(round_arg106);

		// List<TypeSpec> round_arg107=new ArrayList<TypeSpec>();
		// round_arg107.add(nullType);
		// round_arg107.add(charType);
		// round_arg107.add(nullType);
		// round_argumentsType.add(round_arg107);
		//
		// List<TypeSpec> round_arg108=new ArrayList<TypeSpec>();
		// round_arg108.add(nullType);
		// round_arg108.add(dateType);
		// round_arg108.add(nullType);
		// round_argumentsType.add(round_arg108);

		// List<TypeSpec> round_arg11=new ArrayList<TypeSpec>();
		// round_arg11.add(dateType);
		// round_arg11.add(dateType);
		// round_argumentsType.add(round_arg11);

		roundId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, round_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(roundId, new Sys_RoundExpression());*/

		// cos
		// 名称
		cosId = new SymTabEntryImpl("cos");
		// 类型定义为系统函数
		cosId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// cosId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> cos_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> cos_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		cos_arg2.add(intType);
		cos_arg2.add(doubleType);
		cos_argumentsType.add(cos_arg2);

		List<TypeSpec> cos_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		cos_arg3.add(longType);
		cos_arg3.add(doubleType);
		cos_argumentsType.add(cos_arg3);

		List<TypeSpec> cos_arg4 = new ArrayList<TypeSpec>();
		// String的先放varchar
		cos_arg4.add(doubleType);
		cos_arg4.add(doubleType);
		cos_argumentsType.add(cos_arg4);

		List<TypeSpec> cos_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		cos_arg1.add(nullType);
		cos_arg1.add(nullType);
		cos_argumentsType.add(cos_arg1);

		cosId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, cos_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(cosId, new Sys_CosExpression());*/

		// asin
		// 名称
		asinId = new SymTabEntryImpl("asin");
		// 类型定义为系统函数
		asinId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// asinId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> asin_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> asin_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		asin_arg1.add(intType);
		asin_arg1.add(doubleType);
		asin_argumentsType.add(asin_arg1);

		List<TypeSpec> asin_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		asin_arg2.add(longType);
		asin_arg2.add(doubleType);
		asin_argumentsType.add(asin_arg2);

		List<TypeSpec> asin_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		asin_arg3.add(doubleType);
		asin_arg3.add(doubleType);
		asin_argumentsType.add(asin_arg3);

		List<TypeSpec> asin_arg0 = new ArrayList<TypeSpec>();
		// String的先放varchar
		asin_arg0.add(nullType);
		asin_arg0.add(nullType);
		asin_argumentsType.add(asin_arg0);

		asinId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, asin_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(asinId, new Sys_AsinExpression());*/

		// acos
		// 名称
		acosId = new SymTabEntryImpl("acos");
		// 类型定义为系统函数
		acosId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// acosId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> acos_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> acos_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		acos_arg3.add(intType);
		acos_arg3.add(doubleType);
		acos_argumentsType.add(acos_arg3);

		List<TypeSpec> acos_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		acos_arg2.add(longType);
		acos_arg2.add(doubleType);
		acos_argumentsType.add(acos_arg2);

		List<TypeSpec> acos_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		acos_arg1.add(doubleType);
		acos_arg1.add(doubleType);
		acos_argumentsType.add(acos_arg1);

		List<TypeSpec> acos_arg4 = new ArrayList<TypeSpec>();
		// String的先放varchar
		acos_arg4.add(nullType);
		acos_arg4.add(nullType);
		acos_argumentsType.add(acos_arg4);

		acosId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, acos_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(acosId, new Sys_AcosExpression());*/

		// atan
		// 名称
		atanId = new SymTabEntryImpl("atan");
		// 类型定义为系统函数
		atanId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// atanId.setTypeSpec(doubleType);

		// 设置形参类型

		List<List<TypeSpec>> atan_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> atan_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		atan_arg2.add(intType);
		atan_arg2.add(doubleType);
		atan_argumentsType.add(atan_arg2);

		List<TypeSpec> atan_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		atan_arg3.add(longType);
		atan_arg3.add(doubleType);
		atan_argumentsType.add(atan_arg3);

		List<TypeSpec> atan_arg4 = new ArrayList<TypeSpec>();
		// String的先放varchar
		atan_arg4.add(doubleType);
		atan_arg4.add(doubleType);
		atan_argumentsType.add(atan_arg4);

		List<TypeSpec> atan_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		atan_arg1.add(nullType);
		atan_arg1.add(nullType);
		atan_argumentsType.add(atan_arg1);

		atanId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, atan_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(atanId, new Sys_AtanExpression());*/

		// sign
		// 名称
		signId = new SymTabEntryImpl("sign");
		// 类型定义为系统函数
		signId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// signId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> sign_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> sign_arg = new ArrayList<TypeSpec>();
		// String的先放varchar
		sign_arg.add(intType);
		sign_arg.add(intType);
		sign_argumentsType.add(sign_arg);
		List<TypeSpec> sign_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sign_arg1.add(longType);
		sign_arg1.add(intType);
		sign_argumentsType.add(sign_arg1);
		List<TypeSpec> sign_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sign_arg2.add(doubleType);
		sign_arg2.add(intType);
		sign_argumentsType.add(sign_arg2);
		List<TypeSpec> sign_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		sign_arg3.add(nullType);
		sign_arg3.add(nullType);
		sign_argumentsType.add(sign_arg3);
		signId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, sign_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(signId, new Sys_SignExpression());*/

		// mod
		// 名称
		modId = new SymTabEntryImpl("mod");
		// 类型定义为系统函数
		modId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// modId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> mod_argumentsType = new ArrayList<List<TypeSpec>>();
		List<TypeSpec> mod_arg1 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg1.add(intType);
		mod_arg1.add(intType);
		mod_arg1.add(doubleType);
		mod_argumentsType.add(mod_arg1);
		List<TypeSpec> mod_arg2 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg2.add(intType);
		mod_arg2.add(longType);
		mod_arg2.add(doubleType);
		mod_argumentsType.add(mod_arg2);

		List<TypeSpec> mod_arg3 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg3.add(intType);
		mod_arg3.add(doubleType);
		mod_arg3.add(doubleType);
		mod_argumentsType.add(mod_arg3);

		List<TypeSpec> mod_arg4 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg4.add(longType);
		mod_arg4.add(intType);
		mod_arg4.add(doubleType);
		mod_argumentsType.add(mod_arg4);

		List<TypeSpec> mod_arg5 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg5.add(longType);
		mod_arg5.add(longType);
		mod_arg5.add(doubleType);
		mod_argumentsType.add(mod_arg5);

		List<TypeSpec> mod_arg6 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg6.add(longType);
		mod_arg6.add(doubleType);
		mod_arg6.add(doubleType);
		mod_argumentsType.add(mod_arg6);

		List<TypeSpec> mod_arg7 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg7.add(doubleType);
		mod_arg7.add(intType);
		mod_arg7.add(doubleType);
		mod_argumentsType.add(mod_arg7);

		List<TypeSpec> mod_arg8 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg8.add(doubleType);
		mod_arg8.add(longType);
		mod_arg8.add(doubleType);
		mod_argumentsType.add(mod_arg8);

		List<TypeSpec> mod_arg9 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg9.add(doubleType);
		mod_arg9.add(doubleType);
		mod_arg9.add(doubleType);
		mod_argumentsType.add(mod_arg9);

		List<TypeSpec> mod_arg10 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg10.add(nullType);
		mod_arg10.add(intType);
		mod_arg10.add(nullType);
		mod_argumentsType.add(mod_arg10);
		List<TypeSpec> mod_arg11 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg11.add(nullType);
		mod_arg11.add(longType);
		mod_arg11.add(nullType);
		mod_argumentsType.add(mod_arg11);
		List<TypeSpec> mod_arg12 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg12.add(nullType);
		mod_arg12.add(doubleType);
		mod_arg12.add(nullType);
		mod_argumentsType.add(mod_arg12);
		List<TypeSpec> mod_arg15 = new ArrayList<TypeSpec>();
		// String的先放varchar
		mod_arg15.add(nullType);
		mod_arg15.add(nullType);
		mod_arg15.add(nullType);
		mod_argumentsType.add(mod_arg15);

		modId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, mod_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(modId, new Sys_ModExpression());*/

		// trunc
		// 名称
		truncId = new SymTabEntryImpl("trunc");
		// 类型定义为系统函数
		truncId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// 类型描述即返回值类型
		// truncId.setTypeSpec(doubleType);

		// 设置形参类型
		List<List<TypeSpec>> trunc_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> trunc_arg0 = new ArrayList<TypeSpec>();
		trunc_arg0.add(nullType);
		trunc_arg0.add(nullType);
		trunc_argumentsType.add(trunc_arg0);

		List<TypeSpec> trunc_arg6 = new ArrayList<TypeSpec>();
		trunc_arg6.add(doubleType);
		trunc_arg6.add(doubleType);
		trunc_argumentsType.add(trunc_arg6);

		List<TypeSpec> trunc_arg3 = new ArrayList<TypeSpec>();
		trunc_arg3.add(intType);
		trunc_arg3.add(intType);
		trunc_argumentsType.add(trunc_arg3);

		List<TypeSpec> trunc_arg5 = new ArrayList<TypeSpec>();
		trunc_arg5.add(longType);
		trunc_arg5.add(longType);
		trunc_argumentsType.add(trunc_arg5);

		List<TypeSpec> trunc_arg2 = new ArrayList<TypeSpec>();
		trunc_arg2.add(intType);
		trunc_arg2.add(intType);
		trunc_arg2.add(intType);
		trunc_argumentsType.add(trunc_arg2);

		List<TypeSpec> trunc_arg21 = new ArrayList<TypeSpec>();
		trunc_arg21.add(intType);
		trunc_arg21.add(longType);
		trunc_arg21.add(intType);
		trunc_argumentsType.add(trunc_arg21);

		List<TypeSpec> trunc_arg22 = new ArrayList<TypeSpec>();
		trunc_arg22.add(intType);
		trunc_arg22.add(doubleType);
		trunc_arg22.add(intType);
		trunc_argumentsType.add(trunc_arg22);

		List<TypeSpec> trunc_arg23 = new ArrayList<TypeSpec>();
		trunc_arg23.add(intType);
		trunc_arg23.add(nullType);
		trunc_arg23.add(nullType);
		trunc_argumentsType.add(trunc_arg23);

		List<TypeSpec> trunc_arg4 = new ArrayList<TypeSpec>();
		trunc_arg4.add(longType);
		trunc_arg4.add(intType);
		trunc_arg4.add(longType);
		trunc_argumentsType.add(trunc_arg4);

		List<TypeSpec> trunc_arg41 = new ArrayList<TypeSpec>();
		trunc_arg41.add(longType);
		trunc_arg41.add(longType);
		trunc_arg41.add(longType);
		trunc_argumentsType.add(trunc_arg41);

		List<TypeSpec> trunc_arg42 = new ArrayList<TypeSpec>();
		trunc_arg42.add(longType);
		trunc_arg42.add(doubleType);
		trunc_arg42.add(longType);
		trunc_argumentsType.add(trunc_arg42);

		List<TypeSpec> trunc_arg43 = new ArrayList<TypeSpec>();
		trunc_arg43.add(longType);
		trunc_arg43.add(nullType);
		trunc_arg43.add(nullType);
		trunc_argumentsType.add(trunc_arg43);

		List<TypeSpec> trunc_arg1 = new ArrayList<TypeSpec>();

		trunc_arg1.add(doubleType);
		trunc_arg1.add(intType);
		trunc_arg1.add(doubleType);
		trunc_argumentsType.add(trunc_arg1);

		List<TypeSpec> trunc_arg11 = new ArrayList<TypeSpec>();

		trunc_arg11.add(doubleType);
		trunc_arg11.add(longType);
		trunc_arg11.add(doubleType);
		trunc_argumentsType.add(trunc_arg11);

		List<TypeSpec> trunc_arg12 = new ArrayList<TypeSpec>();

		trunc_arg12.add(doubleType);
		trunc_arg12.add(doubleType);
		trunc_arg12.add(doubleType);
		trunc_argumentsType.add(trunc_arg12);

		List<TypeSpec> trunc_arg13 = new ArrayList<TypeSpec>();
		trunc_arg13.add(doubleType);
		trunc_arg13.add(nullType);
		trunc_arg13.add(nullType);
		trunc_argumentsType.add(trunc_arg13);

		List<TypeSpec> trunc_arg7 = new ArrayList<TypeSpec>();
		trunc_arg7.add(nullType);
		trunc_arg7.add(nullType);
		trunc_arg7.add(nullType);
		trunc_argumentsType.add(trunc_arg7);

		List<TypeSpec> trunc_arg71 = new ArrayList<TypeSpec>();
		trunc_arg71.add(nullType);
		trunc_arg71.add(intType);
		trunc_arg71.add(nullType);
		trunc_argumentsType.add(trunc_arg71);

		List<TypeSpec> trunc_arg72 = new ArrayList<TypeSpec>();
		trunc_arg72.add(nullType);
		trunc_arg72.add(longType);
		trunc_arg72.add(nullType);
		trunc_argumentsType.add(trunc_arg72);

		List<TypeSpec> trunc_arg73 = new ArrayList<TypeSpec>();
		trunc_arg73.add(nullType);
		trunc_arg73.add(doubleType);
		trunc_arg73.add(nullType);
		trunc_argumentsType.add(trunc_arg73);

		// List<TypeSpec> trunc_arg74 = new ArrayList<TypeSpec>();
		// trunc_arg74.add(nullType);
		// trunc_arg74.add(charType);
		// trunc_arg74.add(nullType);
		// trunc_argumentsType.add(trunc_arg74);
		//
		// List<TypeSpec> trunc_arg75 = new ArrayList<TypeSpec>();
		// trunc_arg75.add(nullType);
		// trunc_arg75.add(varcharType);
		// trunc_arg75.add(nullType);
		// trunc_argumentsType.add(trunc_arg75);
		//
		// List<TypeSpec> trunc_arg76 = new ArrayList<TypeSpec>();
		// trunc_arg76.add(nullType);
		// trunc_arg76.add(dateType);
		// trunc_arg76.add(nullType);
		// trunc_argumentsType.add(trunc_arg76);

		// 
		List<TypeSpec> trunc_arg101 = new ArrayList<TypeSpec>();
		trunc_arg101.add(dateType);
		trunc_arg101.add(nullType);
		trunc_arg101.add(nullType);
		trunc_argumentsType.add(trunc_arg101);

		List<TypeSpec> trunc_arg10 = new ArrayList<TypeSpec>();
		trunc_arg10.add(dateType);
		trunc_arg10.add(varcharType);
		trunc_arg10.add(dateType);
		trunc_argumentsType.add(trunc_arg10);

		List<TypeSpec> trunc_arg102 = new ArrayList<TypeSpec>();
		trunc_arg102.add(dateType);
		trunc_arg102.add(charType);
		trunc_arg102.add(dateType);
		trunc_argumentsType.add(trunc_arg102);

		truncId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, trunc_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(truncId, new Sys_TruncExpression());*/
		
		// 名称
		bitandId = new SymTabEntryImpl("bitand");
		// 类型定义为系统函数
		bitandId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		
		/*List<List<TypeSpec>> bitand_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> bitand_arg1 = new ArrayList<TypeSpec>();

		bitand_arg1.add(nullType);
		bitand_arg1.add(nullType);
		bitand_arg1.add(nullType);
		bitand_argumentsType.add(bitand_arg1);

		List<TypeSpec> bitand_arg2 = new ArrayList<TypeSpec>();

		bitand_arg2.add(intType);
		bitand_arg2.add(nullType);
		bitand_arg2.add(nullType);
		bitand_argumentsType.add(bitand_arg2);

		List<TypeSpec> bitand_arg3 = new ArrayList<TypeSpec>();

		bitand_arg3.add(longType);
		bitand_arg3.add(nullType);
		bitand_arg3.add(nullType);
		bitand_argumentsType.add(bitand_arg3);


		List<TypeSpec> bitand_arg4 = new ArrayList<TypeSpec>();

		bitand_arg4.add(nullType);
		bitand_arg4.add(intType);
		bitand_arg4.add(nullType);
		bitand_argumentsType.add(bitand_arg4);

		List<TypeSpec> bitand_arg5 = new ArrayList<TypeSpec>();

		bitand_arg5.add(nullType);
		bitand_arg5.add(longType);
		bitand_arg5.add(nullType);
		bitand_argumentsType.add(bitand_arg5);

		// List<TypeSpec> power_arg8 = new ArrayList<TypeSpec>();
		// power_arg8.add(nullType);
		// power_arg8.add(charType);
		// power_arg8.add(nullType);
		// power_argumentsType.add(power_arg8);
		//
		// List<TypeSpec> power_arg9 = new ArrayList<TypeSpec>();
		// power_arg9.add(nullType);
		// power_arg9.add(varcharType);
		// power_arg9.add(nullType);
		// power_argumentsType.add(power_arg9);

		List<TypeSpec> bitand_arg6 = new ArrayList<TypeSpec>();
		bitand_arg6.add(intType);
		bitand_arg6.add(intType);
		bitand_arg6.add(intType);
		bitand_argumentsType.add(bitand_arg6);

		List<TypeSpec> bitand_arg7 = new ArrayList<TypeSpec>();
		bitand_arg7.add(intType);
		bitand_arg7.add(longType);
		bitand_arg7.add(longType);
		bitand_argumentsType.add(bitand_arg7);

		List<TypeSpec> bitand_arg8 = new ArrayList<TypeSpec>();
		bitand_arg8.add(longType);
		bitand_arg8.add(intType);
		bitand_arg8.add(longType);
		bitand_argumentsType.add(bitand_arg8);

		List<TypeSpec> bitand_arg9 = new ArrayList<TypeSpec>();
		bitand_arg9.add(longType);
		bitand_arg9.add(longType);
		bitand_arg9.add(longType);
		bitand_argumentsType.add(bitand_arg9);



		bitandId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, bitand_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(bitandId, new Sys_BitandExpression());*/

		// 名称
		bitorId = new SymTabEntryImpl("bitor");
		// 类型定义为系统函数
		bitorId.setDefinition(DefinitionImpl.SYS_FUNCTION);
		
		/*List<List<TypeSpec>> bitor_argumentsType = new ArrayList<List<TypeSpec>>();

		List<TypeSpec> bitor_arg1 = new ArrayList<TypeSpec>();

		bitor_arg1.add(nullType);
		bitor_arg1.add(nullType);
		bitor_arg1.add(nullType);
		bitor_argumentsType.add(bitor_arg1);

		List<TypeSpec> bitor_arg2 = new ArrayList<TypeSpec>();

		bitor_arg2.add(intType);
		bitor_arg2.add(nullType);
		bitor_arg2.add(nullType);
		bitor_argumentsType.add(bitor_arg2);

		List<TypeSpec> bitor_arg3 = new ArrayList<TypeSpec>();

		bitor_arg3.add(longType);
		bitor_arg3.add(nullType);
		bitor_arg3.add(nullType);
		bitor_argumentsType.add(bitor_arg3);


		List<TypeSpec> bitor_arg4 = new ArrayList<TypeSpec>();

		bitor_arg4.add(nullType);
		bitor_arg4.add(intType);
		bitor_arg4.add(nullType);
		bitor_argumentsType.add(bitor_arg4);

		List<TypeSpec> bitor_arg5 = new ArrayList<TypeSpec>();

		bitor_arg5.add(nullType);
		bitor_arg5.add(longType);
		bitor_arg5.add(nullType);
		bitor_argumentsType.add(bitor_arg5);

		// List<TypeSpec> power_arg8 = new ArrayList<TypeSpec>();
		// power_arg8.add(nullType);
		// power_arg8.add(charType);
		// power_arg8.add(nullType);
		// power_argumentsType.add(power_arg8);
		//
		// List<TypeSpec> power_arg9 = new ArrayList<TypeSpec>();
		// power_arg9.add(nullType);
		// power_arg9.add(varcharType);
		// power_arg9.add(nullType);
		// power_argumentsType.add(power_arg9);

		List<TypeSpec> bitor_arg6 = new ArrayList<TypeSpec>();
		bitor_arg6.add(intType);
		bitor_arg6.add(intType);
		bitor_arg6.add(intType);
		bitor_argumentsType.add(bitor_arg6);

		List<TypeSpec> bitor_arg7 = new ArrayList<TypeSpec>();
		bitor_arg7.add(intType);
		bitor_arg7.add(longType);
		bitor_arg7.add(longType);
		bitor_argumentsType.add(bitor_arg7);

		List<TypeSpec> bitor_arg8 = new ArrayList<TypeSpec>();
		bitor_arg8.add(longType);
		bitor_arg8.add(intType);
		bitor_arg8.add(longType);
		bitor_argumentsType.add(bitor_arg8);

		List<TypeSpec> bitor_arg9 = new ArrayList<TypeSpec>();
		bitor_arg9.add(longType);
		bitor_arg9.add(longType);
		bitor_arg9.add(longType);
		bitor_argumentsType.add(bitor_arg9);



		bitorId.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, bitor_argumentsType);

		// 加入到id_functioncall的集合中
		id_sysFuntionMap.put(bitorId, new Sys_BitorExpression());*/
		
		
	}

	private static void initializeDateFunction() {
		// systemdate = new SymTabEntryImpl("systemdate");
		// systemdate.setDefinition(DefinitionImpl.SYS_FUNCTION);
		// List<List<TypeSpec>> argumentsTypeSystemDate = new
		// ArrayList<List<TypeSpec>>();
		// List<TypeSpec> argumentSystemDate1=new ArrayList<TypeSpec>();
		// argumentSystemDate1.add(dateType);
		// argumentsTypeSystemDate.add(argumentSystemDate1);
		// systemdate.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
		// argumentsTypeSystemDate);
		// id_sysFuntionMap.put(systemdate, new
		// Sys_Date_SystemDateExpression());

		// LastDay
		lastday = new SymTabEntryImpl("last_day");
		lastday.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// lastday.setTypeSpec(longType);
		List<List<TypeSpec>> argumentsTypeLastDay = new ArrayList<List<TypeSpec>>();
		// 第一类参数
		List<TypeSpec> argumentLastDay1 = new ArrayList<TypeSpec>();
		argumentLastDay1.add(dateType);
		argumentLastDay1.add(dateType);
		argumentsTypeLastDay.add(argumentLastDay1);

		// param:null
		// return :DateType null
		List<TypeSpec> argumentLastDay2 = new ArrayList<TypeSpec>();
		argumentLastDay2.add(nullType);
		argumentLastDay2.add(dateType);
		argumentsTypeLastDay.add(argumentLastDay2);

		lastday.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, argumentsTypeLastDay);
		id_sysFuntionMap.put(lastday, new Sys_Date_LastDayExpression());*/

		// ToDate
		to_date = new SymTabEntryImpl("to_date");
		to_date.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// todate.setTypeSpec(longType);
		List<List<TypeSpec>> argumentsTypeToDate = new ArrayList<List<TypeSpec>>();
		// 第一类参数
		List<TypeSpec> argumentToDate1 = new ArrayList<TypeSpec>();
		argumentToDate1.add(varcharType);
		argumentToDate1.add(varcharType);
		argumentToDate1.add(dateType);

		List<TypeSpec> argumentToDate2 = new ArrayList<TypeSpec>();
		argumentToDate2.add(charType);
		argumentToDate2.add(varcharType);
		argumentToDate2.add(dateType);

		List<TypeSpec> argumentToDate3 = new ArrayList<TypeSpec>();
		argumentToDate3.add(varcharType);
		argumentToDate3.add(charType);
		argumentToDate3.add(dateType);

		List<TypeSpec> argumentToDate4 = new ArrayList<TypeSpec>();
		argumentToDate4.add(charType);
		argumentToDate4.add(charType);
		argumentToDate4.add(dateType);

		List<TypeSpec> argumentToDate5 = new ArrayList<TypeSpec>();
		argumentToDate5.add(nullType);
		argumentToDate5.add(charType);
		argumentToDate5.add(dateType);

		List<TypeSpec> argumentToDate6 = new ArrayList<TypeSpec>();
		argumentToDate6.add(nullType);
		argumentToDate6.add(varcharType);
		argumentToDate6.add(dateType);

		List<TypeSpec> argumentToDate7 = new ArrayList<TypeSpec>();
		argumentToDate7.add(charType);
		argumentToDate7.add(nullType);
		argumentToDate7.add(dateType);

		List<TypeSpec> argumentToDate8 = new ArrayList<TypeSpec>();
		argumentToDate8.add(varcharType);
		argumentToDate8.add(nullType);
		argumentToDate8.add(dateType);

		List<TypeSpec> argumentToDate9 = new ArrayList<TypeSpec>();
		argumentToDate9.add(nullType);
		argumentToDate9.add(nullType);
		argumentToDate9.add(dateType);

		// argumentToDate1.add(longType);
		// 第二类参数
		// List<TypeSpec> argumentToDate2=new ArrayList<TypeSpec>();
		// argumentToDate2.add(varcharType);
		// argumentToDate2.add(varcharType);
		// argumentToDate2.add(longType);
		argumentsTypeToDate.add(argumentToDate1);
		argumentsTypeToDate.add(argumentToDate2);
		argumentsTypeToDate.add(argumentToDate3);
		argumentsTypeToDate.add(argumentToDate4);
		argumentsTypeToDate.add(argumentToDate5);
		argumentsTypeToDate.add(argumentToDate6);
		argumentsTypeToDate.add(argumentToDate7);
		argumentsTypeToDate.add(argumentToDate8);
		argumentsTypeToDate.add(argumentToDate9);
		// argumentsTypeToDate.add(argumentToDate2);
		to_date.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, argumentsTypeToDate);
		id_sysFuntionMap.put(to_date, new Sys_Date_ToDateExpression());*/

		// Months_Between
		months_between = new SymTabEntryImpl("months_between");
		months_between.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// month_between.setTypeSpec(doubleType);
		List<List<TypeSpec>> argumentsTypeMonths_Between = new ArrayList<List<TypeSpec>>();
		// 第一类参数
		List<TypeSpec> argumentMonths_Between1 = new ArrayList<TypeSpec>();
		argumentMonths_Between1.add(dateType);
		argumentMonths_Between1.add(dateType);
		argumentMonths_Between1.add(doubleType);

		List<TypeSpec> argumentMonths_Between2 = new ArrayList<TypeSpec>();
		argumentMonths_Between2.add(dateType);
		argumentMonths_Between2.add(nullType);
		argumentMonths_Between2.add(nullType);

		List<TypeSpec> argumentMonths_Between3 = new ArrayList<TypeSpec>();
		argumentMonths_Between3.add(nullType);
		argumentMonths_Between3.add(dateType);
		argumentMonths_Between3.add(nullType);

		List<TypeSpec> argumentMonths_Between4 = new ArrayList<TypeSpec>();
		argumentMonths_Between4.add(nullType);
		argumentMonths_Between4.add(nullType);
		argumentMonths_Between4.add(nullType);

		argumentsTypeMonths_Between.add(argumentMonths_Between1);
		argumentsTypeMonths_Between.add(argumentMonths_Between2);
		argumentsTypeMonths_Between.add(argumentMonths_Between3);
		argumentsTypeMonths_Between.add(argumentMonths_Between4);

		months_between.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				argumentsTypeMonths_Between);
		id_sysFuntionMap.put(months_between,
				new Sys_Date_Months_BetweenExpression());*/

		// Add_Month
		add_month = new SymTabEntryImpl("add_months");
		add_month.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// add_month.setTypeSpec(varcharType);
		List<List<TypeSpec>> argumentsTypeAdd_Month = new ArrayList<List<TypeSpec>>();
		// 第一类参数
		List<TypeSpec> argumentAdd_Month1 = new ArrayList<TypeSpec>();
		argumentAdd_Month1.add(dateType);
		argumentAdd_Month1.add(intType);
		argumentAdd_Month1.add(dateType);
		// 第二类参数
		List<TypeSpec> argumentAdd_Month2 = new ArrayList<TypeSpec>();
		argumentAdd_Month2.add(dateType);
		argumentAdd_Month2.add(doubleType);
		argumentAdd_Month2.add(dateType);
		// 第三类参数
		List<TypeSpec> argumentAdd_Month3 = new ArrayList<TypeSpec>();
		argumentAdd_Month3.add(dateType);
		argumentAdd_Month3.add(longType);
		argumentAdd_Month3.add(dateType);

		// param is date and return is null(type is date)
		List<TypeSpec> argumentAdd_Month4 = new ArrayList<TypeSpec>();
		argumentAdd_Month4.add(dateType);
		argumentAdd_Month4.add(nullType);
		argumentAdd_Month4.add(dateType);

		List<TypeSpec> argumentAdd_Month5 = new ArrayList<TypeSpec>();
		argumentAdd_Month5.add(nullType);
		argumentAdd_Month5.add(intType);
		argumentAdd_Month5.add(dateType);

		List<TypeSpec> argumentAdd_Month6 = new ArrayList<TypeSpec>();
		argumentAdd_Month6.add(nullType);
		argumentAdd_Month6.add(doubleType);
		argumentAdd_Month6.add(dateType);

		List<TypeSpec> argumentAdd_Month7 = new ArrayList<TypeSpec>();
		argumentAdd_Month7.add(nullType);
		argumentAdd_Month7.add(longType);
		argumentAdd_Month7.add(dateType);

		List<TypeSpec> argumentAdd_Month8 = new ArrayList<TypeSpec>();
		argumentAdd_Month8.add(nullType);
		argumentAdd_Month8.add(nullType);
		argumentAdd_Month8.add(dateType);

		argumentsTypeAdd_Month.add(argumentAdd_Month1);
		argumentsTypeAdd_Month.add(argumentAdd_Month2);
		argumentsTypeAdd_Month.add(argumentAdd_Month3);
		argumentsTypeAdd_Month.add(argumentAdd_Month4);
		argumentsTypeAdd_Month.add(argumentAdd_Month5);
		argumentsTypeAdd_Month.add(argumentAdd_Month6);
		argumentsTypeAdd_Month.add(argumentAdd_Month7);
		argumentsTypeAdd_Month.add(argumentAdd_Month8);

		add_month.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				argumentsTypeAdd_Month);
		id_sysFuntionMap.put(add_month, new Sys_Date_Add_MonthExpression());*/

		// Year
		year = new SymTabEntryImpl("year");
		year.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// year.setTypeSpec(intType);
		List<List<TypeSpec>> argumentsTypeYear = new ArrayList<List<TypeSpec>>();
		// 第一类参数
		List<TypeSpec> argumentYear1 = new ArrayList<TypeSpec>();
		argumentYear1.add(dateType);
		argumentYear1.add(intType);

		List<TypeSpec> argumentYear2 = new ArrayList<TypeSpec>();
		argumentYear2.add(nullType);
		argumentYear2.add(nullType);

		argumentsTypeYear.add(argumentYear1);
		argumentsTypeYear.add(argumentYear2);

		year.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, argumentsTypeYear);
		id_sysFuntionMap.put(year, new Sys_Date_YearExpression());*/

		// Month
		month = new SymTabEntryImpl("month");
		month.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// month.setTypeSpec(intType);
		List<List<TypeSpec>> argumentsTypeMonth = new ArrayList<List<TypeSpec>>();
		// 第一类参数
		List<TypeSpec> argumentMonth1 = new ArrayList<TypeSpec>();
		argumentMonth1.add(dateType);
		argumentMonth1.add(intType);

		List<TypeSpec> argumentMonth2 = new ArrayList<TypeSpec>();
		argumentMonth2.add(nullType);
		argumentMonth2.add(nullType);

		argumentsTypeMonth.add(argumentMonth1);
		argumentsTypeMonth.add(argumentMonth2);
		month.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, argumentsTypeMonth);
		id_sysFuntionMap.put(month, new Sys_Date_MonthExpression());*/

		// Day
		day = new SymTabEntryImpl("day");
		day.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*// day.setTypeSpec(intType);
		List<List<TypeSpec>> argumentsTypeDay = new ArrayList<List<TypeSpec>>();
		// 第一类参数
		List<TypeSpec> argumentDay1 = new ArrayList<TypeSpec>();
		argumentDay1.add(dateType);
		argumentDay1.add(intType);

		List<TypeSpec> argumentDay2 = new ArrayList<TypeSpec>();
		argumentDay2.add(nullType);
		argumentDay2.add(nullType);

		argumentsTypeDay.add(argumentDay1);
		argumentsTypeDay.add(argumentDay2);
		day.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE, argumentsTypeDay);
		id_sysFuntionMap.put(day, new Sys_Date_DayExpression());*/

		// Current_date
		// current_date = new SymTabEntryImpl("current_date");
		// current_date.setDefinition(DefinitionImpl.SYS_FUNCTION);
		// List<List<TypeSpec>> argumentsTypeCurrentDate = new
		// ArrayList<List<TypeSpec>>();
		// //第一类参数
		// List<TypeSpec> argumentCurrentDate=new ArrayList<TypeSpec>();
		// argumentCurrentDate.add(dateType);
		// argumentsTypeCurrentDate.add(argumentCurrentDate);
		// current_date.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
		// argumentsTypeCurrentDate);
		// id_sysFuntionMap.put(current_date, new
		// Sys_Date_CurrentDateExpression());

	}

	private static void initializeTimestampFunction() {

		to_timestamp = new SymTabEntryImpl("to_timestamp");
		to_timestamp.setDefinition(DefinitionImpl.SYS_FUNCTION);
		/*List<List<TypeSpec>> argumentsType_totimestamp = new ArrayList<List<TypeSpec>>();
		// 第一类参数
		List<TypeSpec> argument_totimestamp = new ArrayList<TypeSpec>();
		argument_totimestamp.add(varcharType);
		argument_totimestamp.add(varcharType);
		argument_totimestamp.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp);
		
		List<TypeSpec> argument_totimestamp1 = new ArrayList<TypeSpec>();
		argument_totimestamp1.add(varcharType);
		argument_totimestamp1.add(charType);
		argument_totimestamp1.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp1);
		
		List<TypeSpec> argument_totimestamp2 = new ArrayList<TypeSpec>();
		argument_totimestamp2.add(charType);
		argument_totimestamp2.add(varcharType);
		argument_totimestamp2.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp2);
		
		List<TypeSpec> argument_totimestamp3 = new ArrayList<TypeSpec>();
		argument_totimestamp3.add(charType);
		argument_totimestamp3.add(charType);
		argument_totimestamp3.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp3);
		
		List<TypeSpec> argument_totimestamp4 = new ArrayList<TypeSpec>();
		argument_totimestamp4.add(varcharType);
		argument_totimestamp4.add(nullType);
		argument_totimestamp4.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp4);
		
		List<TypeSpec> argument_totimestamp5 = new ArrayList<TypeSpec>();
		argument_totimestamp5.add(charType);
		argument_totimestamp5.add(nullType);
		argument_totimestamp5.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp5);
		
		
		List<TypeSpec> argument_totimestamp6 = new ArrayList<TypeSpec>();
		argument_totimestamp6.add(nullType);
		argument_totimestamp6.add(varcharType);
		argument_totimestamp6.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp6);
		
		List<TypeSpec> argument_totimestamp7 = new ArrayList<TypeSpec>();
		argument_totimestamp7.add(nullType);
		argument_totimestamp7.add(charType);
		argument_totimestamp7.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp7);
		
		List<TypeSpec> argument_totimestamp8 = new ArrayList<TypeSpec>();
		argument_totimestamp8.add(nullType);
		argument_totimestamp8.add(nullType);
		argument_totimestamp8.add(timestampType);
		argumentsType_totimestamp.add(argument_totimestamp8);
		
		
		to_timestamp.setAttribute(SYS_FUNCTION_AGUMENTS_TYPE,
				argumentsType_totimestamp);
		id_sysFuntionMap.put(to_timestamp, new Sys_ts_TotimestampExpression());*/

	}

	private static void initializeSqlSystemFunction() {
		// count()
		count = new SymTabEntryImpl("count");
		// 类型定义为系统函数
		count.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// sum()
		sum = new SymTabEntryImpl("sum");
		// 类型定义为系统函数
		sum.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// decode()
		decode = new SymTabEntryImpl("decode");
		// 类型定义为系统函数
		decode.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// min()
		min = new SymTabEntryImpl("min");
		// 类型定义为系统函数
		min.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// min()
		min = new SymTabEntryImpl("min");
		// 类型定义为系统函数
		min.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// max()
		max = new SymTabEntryImpl("max");
		// 类型定义为系统函数
		max.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// avg()
		avg = new SymTabEntryImpl("avg");
		// 类型定义为系统函数
		avg.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// row_number()
		row_number = new SymTabEntryImpl("row_number");
		// 类型定义为系统函数
		row_number.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// rank()
		rank = new SymTabEntryImpl("rank");
		// 类型定义为系统函数
		rank.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// dense_rank()
		dense_rank = new SymTabEntryImpl("dense_rank");
		// 类型定义为系统函数
		dense_rank.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// ntile()
		ntile = new SymTabEntryImpl("ntile");
		// 类型定义为系统函数
		ntile.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// stddev_samp()
		stddev_samp = new SymTabEntryImpl("stddev_samp");
		// 类型定义为系统函数
		stddev_samp.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// //REPLACE
		// replace = new SymTabEntryImpl("replace");
		// //类型定义为系统函数
		// replace.setDefinition(DefinitionImpl.SYS_FUNCTION);
		//
		// //substr
		// substr = new SymTabEntryImpl("substr");
		// //类型定义为系统函数
		// substr.setDefinition(DefinitionImpl.SYS_FUNCTION);
		// //to_date()
		// nvl = new SymTabEntryImpl("nvl");
		// //类型定义为系统函数
		// nvl.setDefinition(DefinitionImpl.SYS_FUNCTION);

	}

	private static void initializeOtherSystemFunction() {
		// nvl()
		nvl = new SymTabEntryImpl("nvl");
		// 类型定义为系统函数
		nvl.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// cast
		cast = new SymTabEntryImpl("cast");
		// 类型定义为系统函数
		cast.setDefinition(DefinitionImpl.SYS_FUNCTION);

		// coalesce()
		coalesce = new SymTabEntryImpl("coalesce");
		// 类型定义为系统函数
		coalesce.setDefinition(DefinitionImpl.SYS_FUNCTION);

		extract = new SymTabEntryImpl("extract");

		extract.setDefinition(DefinitionImpl.SYS_FUNCTION);
	}

	/**
	 * 初始化基本类型及其符号表单元
	 */
	public static void initialize(SymTabStack symTabStack) {
		initializeTypes(symTabStack);
		initializeConstants(symTabStack);
		// initializeTypeRelation();
		initializeSysFunction(symTabStack);
	}

	/**
	 * 初始化基本类型
	 */
	private static void initializeTypes(SymTabStack symTabStack) {
		// Type integer.
		symTabStack.enterLocal(intId);

		// Type real.
		symTabStack.enterLocal(doubleId);

		// Type boolean.
		symTabStack.enterLocal(booleanId);

		// Type char.
		symTabStack.enterLocal(charId);

		// Type varchar
		symTabStack.enterLocal(varcharId);

		// Type long
		symTabStack.enterLocal(longId);

		// Type date
		symTabStack.enterLocal(dateId);

		// Type timestamp
		symTabStack.enterLocal(timestampId);

		// Type null
		symTabStack.enterLocal(nullId);

	}

	/**
	 * 初始化boolean常量
	 */
	private static void initializeConstants(SymTabStack symTabStack) {
		// Boolean enumeration constant false.
		symTabStack.enterLocal(falseId);

		// Boolean enumeration constant true.
		symTabStack.enterLocal(trueId);
	}

	/**
	 * 初始化系统函数
	 */
	private static void initializeSysFunction(SymTabStack symTabStack) {

		initializeStringFunction(symTabStack);
		initializeMathFunction(symTabStack);
		initializeDateFunction(symTabStack);
		initializeTimestampFunction(symTabStack);
		initializeSqlSystemFunction(symTabStack);
		initializeOtherSystemFunction(symTabStack);
		initializeYMIntervalFunction(symTabStack);
		initializeDSIntervalSystemFunction(symTabStack);

	}

	private static void initializeYMIntervalFunction(SymTabStack symTabStack) {
		symTabStack.enterLocal(numtoymintervalId);
		symTabStack.enterLocal(to_ymintervalId);
	}

	private static void initializeDSIntervalSystemFunction(
			SymTabStack symTabStack) {
		symTabStack.enterLocal(to_dsinterval);
		symTabStack.enterLocal(num_to_dsinterval);

	}

	/**
	 * 初始sql系统函数
	 */
	private static void initializeSqlSystemFunction(SymTabStack symTabStack) {
		// count()
		symTabStack.enterLocal(count);

		// sum()
		symTabStack.enterLocal(sum);

		// decode()
		symTabStack.enterLocal(decode);

		// min()
		symTabStack.enterLocal(min);

		// max()
		symTabStack.enterLocal(max);

		// avg()
		symTabStack.enterLocal(avg);

		// row_number()
		symTabStack.enterLocal(row_number);

		// rank()
		symTabStack.enterLocal(rank);

		// dense_rank()
		symTabStack.enterLocal(dense_rank);

		// ntile()
		symTabStack.enterLocal(ntile);

		// stddev_samp()
		symTabStack.enterLocal(stddev_samp);

	}

	// 其他系统函数

	private static void initializeOtherSystemFunction(SymTabStack symTabStack) {
		// nvl()
		symTabStack.enterLocal(nvl);

		// cast
		symTabStack.enterLocal(cast);

		// coalesce()
		symTabStack.enterLocal(coalesce);

		symTabStack.enterLocal(extract);

	}

	/**
	 * 初始化字符串系统函数
	 */
	private static void initializeStringFunction(SymTabStack symTabStack) {

		// length
		symTabStack.enterLocal(lengthId);

		// lower
		symTabStack.enterLocal(lowerId);

		// Upper
		symTabStack.enterLocal(upperId);

		// subString
		symTabStack.enterLocal(subStringId);

		// concat
		symTabStack.enterLocal(concatId);

		// Replace
		symTabStack.enterLocal(replaceId);

		// Trim
		symTabStack.enterLocal(trimId);

		// LTrim
		symTabStack.enterLocal(ltrimId);

		// RTrim
		symTabStack.enterLocal(rtrimId);

		// initCap
		symTabStack.enterLocal(initCapId);

		// left
		symTabStack.enterLocal(leftId);

		// right
		symTabStack.enterLocal(rightId);
		
		symTabStack.enterLocal(tosinglebyteId);
		
		symTabStack.enterLocal(regexpsubstrId);
		
		symTabStack.enterLocal(regexplikeId);

	}

	/**
	 * 初始化数学系统函数
	 */
	private static void initializeMathFunction(SymTabStack symTabStack) {

		// floor
		symTabStack.enterLocal(floorId);

		// ceil
		symTabStack.enterLocal(ceilId);

		// ln
		symTabStack.enterLocal(lnId);

		// log
		symTabStack.enterLocal(logId);

		// power
		symTabStack.enterLocal(powerId);

		// dabs
		symTabStack.enterLocal(absId);

		// sqrt
		symTabStack.enterLocal(sqrtId);

		// sin
		symTabStack.enterLocal(sinId);

		// round
		symTabStack.enterLocal(roundId);

		// cos
		symTabStack.enterLocal(cosId);

		// asin
		symTabStack.enterLocal(asinId);

		// acos
		symTabStack.enterLocal(acosId);

		// atan
		symTabStack.enterLocal(atanId);

		// sign
		symTabStack.enterLocal(signId);

		// mod
		symTabStack.enterLocal(modId);

		// trunc
		symTabStack.enterLocal(truncId);
		
		symTabStack.enterLocal(bitandId);
		
		symTabStack.enterLocal(bitorId);
	}

	/**
	 * 初始化日期系统函数
	 */
	private static void initializeDateFunction(SymTabStack symTabStack) {

		// LastDay
		symTabStack.enterLocal(lastday);

		// ToDate
		symTabStack.enterLocal(to_date);

		// To_Char
		symTabStack.enterLocal(to_char);

		// Months_Between
		symTabStack.enterLocal(months_between);

		// Add_Month
		symTabStack.enterLocal(add_month);

		// Year
		symTabStack.enterLocal(year);

		// Month
		symTabStack.enterLocal(month);

		// Day
		symTabStack.enterLocal(day);
	}

	private static void initializeTimestampFunction(SymTabStack symTabStack) {

		symTabStack.enterLocal(to_timestamp);
	}

}
