package com.bonc.xcloud.sp_procedure.intermediate;




/**
 * 符号表栈
 */
public interface SymTabStack {
	
	/**
     * 设置程序ID
     */
    public void setProgramId(SymTabEntry entry);
	
    /**
     * 获取程序ID
     */
    public SymTabEntry getProgramId();
    
    /**
     * 向符号表栈顶层加入一个符号表
     */
    public SymTab push();

    /**
     * 向符号表栈顶层加入一个符号表
     */
    public SymTab push(SymTab symTab);

    /**
     * 弹出符号表栈顶层的符号表
     */
    public SymTab pop();
    
	/**
	 * 获取当前嵌套等级
	 */
	public abstract int getCurrentNestingLevel();
	
	/**
	 * 获取当前嵌套等级符号表
	 */
	public abstract SymTab getLocalSymTab();
	
	/**
	 * 向当前嵌套等级符号表添加一个符号单元
	 */
	public abstract SymTabEntry enterLocal(String name);
	
	public abstract SymTabEntry enterLocal(SymTabEntry entry);

	/**
	 * 在当前嵌套等级符号表中查找一个符号单元
	 */
	public abstract SymTabEntry lookupLocal(String name);

	/**
	 * 在所有等级的符号表中查找一个符号单元
	 */
	public abstract SymTabEntry lookup(String name);
	
	/**
	 * 获取指定层的symTab
	 */
	public abstract SymTab getIndexSymTab(int index);

}
