package com.bonc.xcloud.sp_procedure.intermediate;

import com.bonc.xcloud.sp_procedure.intermediate.symtabimpl.SymTabEntryImpl;
import com.bonc.xcloud.sp_procedure.intermediate.symtabimpl.SymTabImpl;
import com.bonc.xcloud.sp_procedure.intermediate.symtabimpl.SymTabStackImpl;

/**
 * 生成符号表栈,符号表,符号表单元的工厂类
 */
public class SymTabFactory {
	
	/**
	 * 生成符号表栈
	 * @return
	 */
	public static SymTabStack createSymTabStack(){
		
		return new SymTabStackImpl();
	}
	
	/**
	 * 生成符号表
	 * @param nestingLevel 嵌套等级
	 * @return
	 */
	public static SymTab createSymTab(int nestingLevel){
		
		return new SymTabImpl(nestingLevel);
	}
	
	/**
	 * 生成符号表单元
	 * @param name 符号表单元名称
	 * @param symTab 该符号表单元所属的符号表
	 * @return
	 */
	public static SymTabEntry createSymTabEntry(String name, SymTab symTab){
		return new SymTabEntryImpl(name, symTab);
	}
	

}
