package com.bonc.xcloud.sp_procedure.intermediate;

import java.util.ArrayList;

import com.bonc.xcloud.sp_procedure.frontend.xcloud.Position;

/**
 * 符号单元
 */
public interface SymTabEntry {

	/**
	 * 获取符号单元名称
	 */
	public abstract String getName();
	
	/**
	 * 获取所属符号表
	 */
	public abstract SymTab getSymTab();
	
//	/**
//	 * 获取符号单元所在的行号集合
//	 */
//	public abstract ArrayList<Integer> getLineNumbers();
//	
//	/**
//	 * 增加一个行号
//	 */
//	public abstract void appendLineNumber(int lineNumber);
	
	/**
	 * 增加一个位置记录
	 * @param position
	 */
	public abstract void appendPositionRecord(Position position);
	
	/**
	 * 获取符号单元所在的位置记录集合
	 * @return
	 */
	public abstract ArrayList<Position> getPositionRecords();

	/**
	 * 添加一个属性
	 */
	public abstract void setAttribute(SymTabkey key, Object value);

	/**
	 * 获取属性
	 */
	public abstract Object getAttribute(SymTabkey key);
	
	 /**
     * 设置符号表单元的定义类型
     */
    public void setDefinition(Definition definition);

    /**
     * 获取符号表单元的定义类型
     */
    public Definition getDefinition();

    /**
     * 设置符号表单元的类型说明
     */
    public void setTypeSpec(TypeSpec typeSpec);

    /**
     * 获取符号表单元的类型说明
     */
    public TypeSpec getTypeSpec();
}
