package com.bonc.xcloud.sp_procedure.intermediate;

import java.util.ArrayList;

/**
 * 符号表
 */
public interface SymTab {
	
	/**
	 * 获取嵌套等级
	 */
	public abstract int getNestingLevel();
	
	/**
	 * 获取符号表中符号单元的ArrayList集合
	 */
	public abstract ArrayList<SymTabEntry> sortedEntries();

	/**
	 * 添加一个符号单元
	 */
	public abstract SymTabEntry enter(String name);
	
	public abstract SymTabEntry enter(SymTabEntry entry);

	/**
	 * 查找符号单元
	 */
	public abstract SymTabEntry lookup(String name);
}
