package com.bonc.xcloud.sp_procedure.frontend.xcloud.sqlparser;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.bonc.xcloud.sp_procedure.frontend.EofToken;
import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.ParserErrorCode;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudParse;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers.FactorExpressionParser;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers.StatementParser;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sql.UpsertValueStatement;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTreeKeyImpl;
/**
 * 实时数仓新增语法：
 * UPSERT [schema_name.]table_name[(col_name [, ...n])] [ON PARTITION(condition [, ...n])] VALUES(? [, ...n])
 */
public class UpsertStatmentParser extends StatementParser {
	private static Logger logger = Logger.getLogger(UpsertStatmentParser.class);

	public UpsertStatmentParser(XcloudParse parent) {
		super(parent);
	}

	@Override
	public SyntaxTree parse(Token token) throws Exception {
		String hint=null;
		String schemaName = null;
		String tableName = null;
		String dblink=null;
		List<String> columnList = null;
		List<String> conditions = null;
		int line = token.getLineNum();
		int pos = token.getPosition();
		if (token.getType() == XcloudTokenType.UPSERT) {
			token = nextToken();
			//如果有hint的情况
			if(token.getType() == XcloudTokenType.SLASH){
				StringBuilder sqlBuilder = new StringBuilder();
				sqlBuilder.append("/");
				token = nextToken();  
				 if(token.getType()==XcloudTokenType.STAR){
					 sqlBuilder.append("*");
					 token = nextToken(); 
				 }
				 else {
			         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
			         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
			         skipToSemicolon();
			         return null;
				 }
				 token=currentToken();
				 if(token.getType()==XcloudTokenType.PLUS){
					 sqlBuilder.append("+");
					  token=nextToken();
					  //循环解析hint字符串
					  while(token.getType() != XcloudTokenType.STAR && !(token instanceof EofToken)){
							
							sqlBuilder.append(token.getText()+" ");
							
							token = nextToken();
						}
					  sqlBuilder.append("*");
					  token=nextToken();
					  if(token.getType()==XcloudTokenType.SLASH){
						  sqlBuilder.append("/");
						  token=nextToken();
					  }
					  else {
				         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
				         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
				         skipToSemicolon();
				         return null;
					  }
					  hint=sqlBuilder.toString();
				  }
		       else {
		         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
		         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
		         skipToSemicolon();
		         return null;
		       }
			}
			token=currentToken();

			//UPSERT [schema_name.]table_name[(col_name [, ...n])] [ON PARTITION(condition [, ...n])] VALUES(? [, ...n])
			tableName = token.getText();
			token = nextToken();
			if (token.getType() == XcloudTokenType.DOT) {
				token = nextToken();
				schemaName = tableName;
				tableName = token.getText();
				token = nextToken();
			}
			token = currentToken();
			if(token.getType() == XcloudTokenType.AT){
				token=nextToken();
				//解析dblink name
				if(token.getType()==XcloudTokenType.IDENTIFIER){
					dblink=(String) token.getText();
					token=nextToken();
				}else{
					 errorHandler.flag(token, ParserErrorCode.NOT_TYPE_IDENTIFIER, this);
				     logger.error(ParserErrorCode.NOT_TYPE_IDENTIFIER.toString());
				     skipToSemicolon();
				     return null;
				}
			}
			token = currentToken();
			if(token.getType()==XcloudTokenType.LEFT_PAREN){
				token=nextToken();
				columnList=new ArrayList<String>();
				for(int i=0;;i++){
					if(token.getType()==XcloudTokenType.COMMA)token=nextToken();
					columnList.add(token.getText());
					token=nextToken();
					if(token.getType() != XcloudTokenType.COMMA) break;
				}
				token=currentToken();
				if(token.getType()==XcloudTokenType.RIGHT_PAREN){
					token=nextToken();
				}else{
					errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
					logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
					skipToSemicolon();
					return null;
				}
				token=currentToken();
			}
			//是否有分区值
			if(token.getType()==XcloudTokenType.PARTITION){
				token=nextToken();
				if(token.getType()==XcloudTokenType.ON){
					token=nextToken();
					if(token.getType()==XcloudTokenType.LEFT_PAREN){
						conditions=new ArrayList<String>();
						token=nextToken();
						if(token.getType()==XcloudTokenType.RIGHT_PAREN){
							 errorHandler.flag(token, ParserErrorCode.INVALID_STATEMENT, this);
						     logger.error(ParserErrorCode.INVALID_STATEMENT.toString());
						     skipToSemicolon();
						     return null;
						}
						String pcondition = "";
						extractPartition(token, conditions,
								pcondition);
						token=currentToken();
						if(token.getType()==XcloudTokenType.RIGHT_PAREN){
							token=nextToken();
						}
						else{
							 errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
						     logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
						     skipToSemicolon();
						     return null;
						}
						token=currentToken();
					}else{
						errorHandler.flag(token, ParserErrorCode.MISSING_LEFT_PAREN, this);
					    logger.error(ParserErrorCode.MISSING_LEFT_PAREN.toString());
					    skipToSemicolon();
					    return null;
					}
				}else{
					errorHandler.flag(token, ParserErrorCode.MISSING_ON, this);
				     logger.error(ParserErrorCode.MISSING_ON.toString());
				     skipToSemicolon();
				     return null;
				}
			}
			token=currentToken();
			//后面跟的是values关键字
			if(token.getType()==XcloudTokenType.VALUES){
				return extractedFromValue(hint, schemaName, tableName,
						dblink,columnList,conditions, line, pos);
			}else{
				errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
			    logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
			    skipToSemicolon();
			    return null;
				
			}
		}

		return null;
	}
	/**
	 * 解析Values后面的部分
	 * @param schemaName
	 * @param tableName
	 * @param hint 
	 * @param columnList
	 * @param conditions 
	 * @param line
	 * @param pos
	 * @return
	 * @throws Exception
	 */
	private SyntaxTree extractedFromValue(String hint,String schemaName, String tableName,
			String dblink, List<String> columnList, List<String> conditions, int line, int pos) throws Exception {
		Token token;
		List<List<String>> valuesExpression =new ArrayList<List<String>>();;
		List<String> valueExpression;
		token =nextToken();
		for(int j=0;;j++){
			if(token.getType()==XcloudTokenType.COMMA)token=nextToken();
			if(token.getType()==XcloudTokenType.LEFT_PAREN){
				String value="";
				token=nextToken();
				Token errorToken=null;
				if(token.getType()==XcloudTokenType.RIGHT_PAREN){
					errorHandler.flag(token, ParserErrorCode.INVALID_STATEMENT, this);
					logger.error(ParserErrorCode.INVALID_STATEMENT.toString());
					skipToSemicolon();
					return null;
				}else{
					valueExpression=new ArrayList<String>();
					
					for(int i=0;;i++){
						if(token.getType()==XcloudTokenType.COMMA)token=nextToken();
						errorToken=token;
						while(token.getType()!=XcloudTokenType.COMMA &&
								!(token instanceof EofToken)){
							FactorExpressionParser factorExpressionParser=new FactorExpressionParser(this);
							String temp=factorExpressionParser.parseAsStrting(token);
							token =currentToken();
							value=value+temp+" ";
							//是否是函数
//							if(token.getType()==XcloudTokenType.LEFT_PAREN){
//								value=parserParen(token, value);
//							}

							token =currentToken();
							if(token.getType()==XcloudTokenType.RIGHT_PAREN || token instanceof EofToken)
								break;
						}
						valueExpression.add(value);
						//做(?,1,?)报错
						if("?".equals(valueExpression.get(0).trim())){
							if(!"?".equals(value.trim()) || valuesExpression.size()!=0){
								errorHandler.flag(errorToken, ParserErrorCode.INCOMPATIBLE_TYPES, this);
								logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
								skipToSemicolon();
								return null;
							}
						}else{
							if("?".equals(value.trim())){
								errorHandler.flag(errorToken, ParserErrorCode.INCOMPATIBLE_TYPES, this);
								logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
								skipToSemicolon();
								return null;
							}
							//做(?,?,?),(1,1,1)报错
							else if(valuesExpression.size()>0 && valuesExpression.get(0).get(0).trim().equals("?")){
								errorHandler.flag(errorToken, ParserErrorCode.INCOMPATIBLE_TYPES, this);
								logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
								skipToSemicolon();
								return null;
							}
						}
						
						value="";
						token=currentToken();
						if(token.getType() != XcloudTokenType.COMMA) break;
					}
					token=currentToken();
					if(token.getType()==XcloudTokenType.RIGHT_PAREN){
						token=nextToken();
						valuesExpression.add(valueExpression);
						if(token.getType() != XcloudTokenType.COMMA) break;
					}
					else{
						errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
						logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
						skipToSemicolon();
						return null;
					}
				}
				
			}else{
				errorHandler.flag(token, ParserErrorCode.MISSING_LEFT_PAREN, this);
				logger.error(ParserErrorCode.MISSING_LEFT_PAREN.toString());
				skipToSemicolon();
				return null;
			}
		}
		UpsertValueStatement upsertValueStatement=new UpsertValueStatement(schemaName, tableName, columnList, hint,conditions,valuesExpression);										
		upsertValueStatement.setAttribute(SyntaxTreeKeyImpl.LINE, line);
		upsertValueStatement.setAttribute(SyntaxTreeKeyImpl.POSITION, pos);
		upsertValueStatement.setDblink(dblink);
		return upsertValueStatement;
	}
	
	/**
	 * 解析partition条件
	 * @param token
	 * @param conditions
	 * @param pcondition
	 * @throws Exception
	 */
	private void extractPartition(Token token, List<String> conditions,
			String pcondition) throws Exception {
		
		
		while(token.getType() != XcloudTokenType.RIGHT_PAREN &&
				!(token instanceof EofToken)){
			if(token.getType()!=XcloudTokenType.COMMA){
				if(token.getType() == XcloudTokenType.INTERVAL){
					FactorExpressionParser factorExpressionParser=new FactorExpressionParser(this);
					String temp = factorExpressionParser.parseAsStrting(token);
					pcondition+=temp;
					token=currentToken();
				}else{
					pcondition+=token.getText();
					token=nextToken();
				}
			}else{
				conditions.add(pcondition);
				token=nextToken();
				pcondition="";
			}
			
		}
		conditions.add(pcondition);
	}
	

}
