package com.bonc.xcloud.sp_procedure.frontend.xcloud.sqlparser;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.bonc.xcloud.sp_procedure.frontend.EofToken;
import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.ParserErrorCode;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudParse;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers.FactorExpressionParser;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers.StatementParser;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sql.InsertIntoFromCsv;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sql.InsertIntoFromDB;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sql.InsertIntoFromValue;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTreeKeyImpl;
/**
 * 支持语法：
 * 
 * 由CSV插入到行云<br/>
 * 语法1：<br/>
 * INSERT [/</>*+IGNORE_ERR_LINE*</>/] INTO [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name [(col_name, …)] 
 * [PARTITION ON（Condition,…）] ‘clinet_path’ 
 * [[Encode 'char'] [SEPARATOR 'char' [QUOTED|UNQUOTED]] [LINEFEED 'chars']] <br/>
 * 语法2：<br/>
 * INSERT [/</>*+IGNORE_ERR_LINE*</>/] INTO [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name [(col_name, …)] 
 * [PARTITION ON（Condition,…）] ‘clinet_path’ 
 * [[Encode 'char'] [SEPARATOR 'char' [DELIMITER  'char'[ESCAPE 'char']]]]
 * 
 * 由数据库插入到行云<br/>
 * 1.从远端数据库加载数据<br/>
 * INSERT [/</>*+IGNORE_ERR_LINE*</>/] INTO [/</>*+IGNORE_ERR_LINE*</>/] [schema_name.]table_name [(col_name, …)] [PARTITION ON（Condition,…）]{Select…/with as} @DBLINK<br/>
 * 2.从本地数据库加载数据<br/>
 * INSERT [/</>*+IGNORE_ERR_LINE*</>/] INTO [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name [(col_name, …)] [PARTITION ON（Condition,…）] Select子句/with as
 *
 * * 由values插入到行云<br/>
 * 语法：1.Insert [/</>*+IGNORE_ERR_LINE*</>/] into [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name (col_name, …) values (value1, value2, …)<br/>
 * 其中为JDBC提供jar包value1，value2...可以为问号，即<br/>
 * 2.Insert [/</>*+IGNORE_ERR_LINE*</>/] into [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name [(col_name, …)] values (？, ？, …)
 * 3.新增insert语法
 * Insert [/</>*+IGNORE_ERR_LINE*</>/] into [/</>*+IGNORE_ERR_LINE*</>/] [schema_name].table_name [(col_name, …)]  [PARTITION ON（Condition,…）] values (value1, value2, …)[,(value1, value2, …)]
 * 4.实时数仓新增语法
 * INSERT [schema_name.]table_name[(col_name [, ...n])] [ON PARTITION(condition [, ...n])] VALUES(? [, ...n])
 */
public class InsertIntoStatmentParser extends StatementParser {
	private static Logger logger = Logger.getLogger(InsertIntoStatmentParser.class);
//	private static final EnumSet<XcloudTokenType> INSERT_INTO_SET = EnumSet.of(
//			XcloudTokenType.SELECT, XcloudTokenType.LEFT_BRACE,
//			XcloudTokenType.PARTITION, XcloudTokenType.STRING);
//	private static final EnumSet<XcloudTokenType> INSERT_INTO_SETS = EnumSet
//			.of(XcloudTokenType.SELECT, XcloudTokenType.LEFT_BRACE,
//					XcloudTokenType.STRING);
//	private static final EnumSet<XcloudTokenType> INSERT_INTO_AT = EnumSet
//			.of(XcloudTokenType.AT);
//	private static final EnumSet<XcloudTokenType> INSERT_INTO_STR = EnumSet
//			.of(XcloudTokenType.STRING);

	public InsertIntoStatmentParser(XcloudParse parent) {
		super(parent);
	}

	/*
	 * （非 Javadoc）
	 * 
	 * @see
	 * com.bonc.xcloud.procedure.frontend.xcloud.plparsers.StatementParser#parse
	 * (com.bonc.xcloud.procedure.frontend.Token)
	 */
	/*
	 * （非 Javadoc）
	 * 
	 * @see
	 * com.bonc.xcloud.procedure.frontend.xcloud.plparsers.StatementParser#parse
	 * (com.bonc.xcloud.procedure.frontend.Token)
	 */
	@Override
	public SyntaxTree parse(Token token) throws Exception {
//		InsertIntoStatement insertIntoStatement = null;
		String pocHint=null;
		String hint=null;
		String schemaName = null;
		String tableName = null;
		String dblink=null;
		List<String> columnList = null;
		List<String> conditions = null;
		String dblinkName=null;
		String filePath=null;
		String encodeChar=null;
		String separatorChar=null;
		String quotenKey=null;
		String delimiterChar=null;
		String escapeChar=null;
		String linefeedChar = null;
		boolean intoKeyWord = true;
		int line = token.getLineNum();
		int pos = token.getPosition();
		if (token.getType() == XcloudTokenType.INSERT) {
			token = nextToken();
			//如果有hint的情况
			if(token.getType() == XcloudTokenType.SLASH){
				StringBuilder sqlBuilder = new StringBuilder();
				sqlBuilder.append("/");
				token = nextToken();  
				 if(token.getType()==XcloudTokenType.STAR){
					 sqlBuilder.append("*");
					 token = nextToken(); 
				 }
				 else {
			         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
			         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
			         skipToSemicolon();
			         return null;
				 }
				 token=currentToken();
				 if(token.getType()==XcloudTokenType.PLUS){
					 sqlBuilder.append("+");
					  token=nextToken();
					  //循环解析hint字符串
					  while(token.getType() != XcloudTokenType.STAR && !(token instanceof EofToken)){
							
							sqlBuilder.append(token.getText()+" ");
							
							token = nextToken();
						}
					  sqlBuilder.append("*");
					  token=nextToken();
					  if(token.getType()==XcloudTokenType.SLASH){
						  sqlBuilder.append("/");
						  token=nextToken();
					  }
					  else {
				         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
				         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
				         skipToSemicolon();
				         return null;
					  }
					  pocHint=sqlBuilder.toString();
				  }
		       else {
		         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
		         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
		         skipToSemicolon();
		         return null;
		       }
			}
			token=currentToken();
			if (token.getType() == XcloudTokenType.OVERWRITE
					||token.getType() == XcloudTokenType.INTO) {
				if(token.getType() == XcloudTokenType.OVERWRITE){
					token = nextToken();
				}
				token = nextToken();
				//hint
				if(token.getType() == XcloudTokenType.SLASH){
					StringBuilder sqlBuilder = new StringBuilder();
					sqlBuilder.append("/");
					token = nextToken();  
					 if(token.getType()==XcloudTokenType.STAR){
						 sqlBuilder.append("*");
						 token = nextToken(); 
					 }
					 else {
				         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
				         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
				         skipToSemicolon();
				         return null;
					 }
					 token=currentToken();
					 if(token.getType()==XcloudTokenType.PLUS){
						 sqlBuilder.append("+");
						  token=nextToken();
						  //循环解析hint字符串
						  while(token.getType() != XcloudTokenType.STAR && !(token instanceof EofToken)){
								
								sqlBuilder.append(token.getText()+" ");
								
								token = nextToken();
							}
						  sqlBuilder.append("*");
						  token=nextToken();
						  if(token.getType()==XcloudTokenType.SLASH){
							  sqlBuilder.append("/");
							  token=nextToken();
						  }
						  else {
					         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
					         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
					         skipToSemicolon();
					         return null;
						  }
						  hint=sqlBuilder.toString();
					  }
				       else {
				         errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
				         logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
				         skipToSemicolon();
				         return null;
				     }
					token =currentToken();
				}
			    //[schema_name].table_name
				token =currentToken();
//				if (token.getType() == XcloudTokenType.IDENTIFIER) {

					tableName = token.getText();
					token = nextToken();
					if (token.getType() == XcloudTokenType.DOT) {
						token = nextToken();
						schemaName = tableName;
						tableName = token.getText();
						token = nextToken();
					}
					token = currentToken();
					if(token.getType() == XcloudTokenType.AT){
						token=nextToken();
						//解析dblink name
						if(token.getType()==XcloudTokenType.IDENTIFIER){
							dblink=(String) token.getText();
							token=nextToken();
						}else{
							 errorHandler.flag(token, ParserErrorCode.NOT_TYPE_IDENTIFIER, this);
						     logger.error(ParserErrorCode.NOT_TYPE_IDENTIFIER.toString());
						     skipToSemicolon();
						     return null;
						}
					}
					token = currentToken();
					boolean isSelect = false;
					//columnList或者(select)
					if(token.getType()==XcloudTokenType.LEFT_PAREN){
						Token temp_token = peekToken();
						int i=1;
						while(temp_token.getType() == XcloudTokenType.LEFT_PAREN && !(temp_token instanceof EofToken)){
							temp_token = peekToken(++i);
						}
						if(temp_token.getType() == XcloudTokenType.SELECT){
							isSelect = true;
						}
					}
					if(token.getType()==XcloudTokenType.LEFT_PAREN){
						if(!isSelect){
							token=nextToken();
							columnList=new ArrayList<String>();
							for(int i=0;;i++){
								if(token.getType()==XcloudTokenType.COMMA)token=nextToken();
//								if(token.getType()==XcloudTokenType.IDENTIFIER){
									columnList.add(token.getText());
//								}else{
//									errorHandler.flag(token, ParserErrorCode.INVALID_IDENTIFIER, this);
//								    logger.error(ParserErrorCode.INVALID_IDENTIFIER.toString());
//								    skipToSemicolon();
//								    return null;
//								}
								token=nextToken();
								if(token.getType() != XcloudTokenType.COMMA) break;
							}
							token=currentToken();
							if(token.getType()==XcloudTokenType.RIGHT_PAREN){
								token=nextToken();
							}else{
								errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
								logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
								skipToSemicolon();
								return null;
							}
						}
						token=currentToken();
					}
					//POC跳过nologging
					if(token.getType()==XcloudTokenType.NOLOGGING){
						token=nextToken();
					}
					//是否有分区值
					if(token.getType()==XcloudTokenType.PARTITION){
						token=nextToken();
						if(token.getType()==XcloudTokenType.ON){
							token=nextToken();
							if(token.getType()==XcloudTokenType.LEFT_PAREN){
								conditions=new ArrayList<String>();
								token=nextToken();
								if(token.getType()==XcloudTokenType.RIGHT_PAREN){
									 errorHandler.flag(token, ParserErrorCode.INVALID_STATEMENT, this);
								     logger.error(ParserErrorCode.INVALID_STATEMENT.toString());
								     skipToSemicolon();
								     return null;
								}
								String pcondition = "";
								extractPartition(token, conditions,
										pcondition);
								token=currentToken();
								if(token.getType()==XcloudTokenType.RIGHT_PAREN){
									token=nextToken();
								}
								else{
									 errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
								     logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
								     skipToSemicolon();
								     return null;
								}
								token=currentToken();
							}else{
								errorHandler.flag(token, ParserErrorCode.MISSING_LEFT_PAREN, this);
							    logger.error(ParserErrorCode.MISSING_LEFT_PAREN.toString());
							    skipToSemicolon();
							    return null;
							}
						}else{
							errorHandler.flag(token, ParserErrorCode.MISSING_ON, this);
						     logger.error(ParserErrorCode.MISSING_ON.toString());
						     skipToSemicolon();
						     return null;
						}
					}
					token=currentToken();
					//后面直接跟select语句,本地加载
					if(token.getType()==XcloudTokenType.SELECT || token.getType()==XcloudTokenType.WITH 
							|| token.getType()==XcloudTokenType.LEFT_PAREN){
						return extracted_LocationDB(pocHint,token, schemaName,
								tableName, dblink, columnList, conditions,
								dblinkName, line, pos,hint);
					}
					//后面是{select ...}@DBLink
					else if(token.getType()==XcloudTokenType.LEFT_BRACE){
						
						return extracted_DBlink(pocHint,schemaName, tableName,
								dblink,columnList, conditions, line, pos,hint);
					}
					//后面跟的是values关键字
					else if(token.getType()==XcloudTokenType.VALUES){
						return extractedFromValue(pocHint,hint,intoKeyWord,schemaName, tableName,
								dblink,columnList,conditions, line, pos);
					}
					else{
						//filePath(CSV)
						return extractedFromCSV(pocHint,token, hint,
								schemaName,tableName ,dblink,
								columnList,conditions,
								filePath, encodeChar,
								separatorChar, quotenKey,
								delimiterChar, escapeChar,linefeedChar,
								line,pos);
					}
					
//				}else{
//					errorHandler.flag(token, ParserErrorCode.INVALID_IDENTIFIER, this);
//				    logger.error(ParserErrorCode.INVALID_IDENTIFIER.toString());
//				    skipToSemicolon();
//				    return null;
//				}
			}else{
				//INSERT [schema_name.]table_name[(col_name [, ...n])] [ON PARTITION(condition [, ...n])] VALUES(? [, ...n])
				intoKeyWord = false;
				tableName = token.getText();
				token = nextToken();
				if (token.getType() == XcloudTokenType.DOT) {
					token = nextToken();
					schemaName = tableName;
					tableName = token.getText();
					token = nextToken();
				}
				token = currentToken();
				if(token.getType() == XcloudTokenType.AT){
					token=nextToken();
					//解析dblink name
					if(token.getType()==XcloudTokenType.IDENTIFIER){
						dblink=(String) token.getText();
						token=nextToken();
					}else{
						 errorHandler.flag(token, ParserErrorCode.NOT_TYPE_IDENTIFIER, this);
					     logger.error(ParserErrorCode.NOT_TYPE_IDENTIFIER.toString());
					     skipToSemicolon();
					     return null;
					}
				}
				token = currentToken();
				if(token.getType()==XcloudTokenType.LEFT_PAREN){
					token=nextToken();
					columnList=new ArrayList<String>();
					for(int i=0;;i++){
						if(token.getType()==XcloudTokenType.COMMA)token=nextToken();
						columnList.add(token.getText());
						token=nextToken();
						if(token.getType() != XcloudTokenType.COMMA) break;
					}
					token=currentToken();
					if(token.getType()==XcloudTokenType.RIGHT_PAREN){
						token=nextToken();
					}else{
						errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
						logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
						skipToSemicolon();
						return null;
					}
					token=currentToken();
				}
				//是否有分区值
				if(token.getType()==XcloudTokenType.PARTITION){
					token=nextToken();
					if(token.getType()==XcloudTokenType.ON){
						token=nextToken();
						if(token.getType()==XcloudTokenType.LEFT_PAREN){
							conditions=new ArrayList<String>();
							token=nextToken();
							if(token.getType()==XcloudTokenType.RIGHT_PAREN){
								 errorHandler.flag(token, ParserErrorCode.INVALID_STATEMENT, this);
							     logger.error(ParserErrorCode.INVALID_STATEMENT.toString());
							     skipToSemicolon();
							     return null;
							}
							String pcondition = "";
							extractPartition(token, conditions,
									pcondition);
							token=currentToken();
							if(token.getType()==XcloudTokenType.RIGHT_PAREN){
								token=nextToken();
							}
							else{
								 errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
							     logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
							     skipToSemicolon();
							     return null;
							}
							token=currentToken();
						}else{
							errorHandler.flag(token, ParserErrorCode.MISSING_LEFT_PAREN, this);
						    logger.error(ParserErrorCode.MISSING_LEFT_PAREN.toString());
						    skipToSemicolon();
						    return null;
						}
					}else{
						errorHandler.flag(token, ParserErrorCode.MISSING_ON, this);
					     logger.error(ParserErrorCode.MISSING_ON.toString());
					     skipToSemicolon();
					     return null;
					}
				}
				token=currentToken();
				//后面跟的是values关键字
				if(token.getType()==XcloudTokenType.VALUES){
					return extractedFromValue(pocHint,hint,intoKeyWord, schemaName, tableName,
							dblink,columnList,conditions, line, pos);
				}else{
					errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
				    logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
				    skipToSemicolon();
				    return null;
					
				}
				
			}
		}

		return null;
	}
	/**
	 * 解析Values后面的部分
	 * @param schemaName
	 * @param tableName
	 * @param hint 
	 * @param intoKeyWord 
	 * @param columnList
	 * @param conditions 
	 * @param line
	 * @param pos
	 * @return
	 * @throws Exception
	 */
	private SyntaxTree extractedFromValue(String pocHint,String hint,boolean intoKeyWord, String schemaName, String tableName,
			String dblink, List<String> columnList, List<String> conditions, int line, int pos) throws Exception {
		Token token;
		List<List<String>> valuesExpression =new ArrayList<List<String>>();;
		List<String> valueExpression;
		token =nextToken();
		for(int j=0;;j++){
			if(token.getType()==XcloudTokenType.COMMA)token=nextToken();
			if(token.getType()==XcloudTokenType.LEFT_PAREN){
				String value="";
				token=nextToken();
				Token errorToken=null;
				if(token.getType()==XcloudTokenType.RIGHT_PAREN){
					errorHandler.flag(token, ParserErrorCode.INVALID_STATEMENT, this);
					logger.error(ParserErrorCode.INVALID_STATEMENT.toString());
					skipToSemicolon();
					return null;
				}else{
					valueExpression=new ArrayList<String>();
					
					for(int i=0;;i++){
						if(token.getType()==XcloudTokenType.COMMA)token=nextToken();
						errorToken=token;
						while(token.getType()!=XcloudTokenType.COMMA &&
								!(token instanceof EofToken)){
							FactorExpressionParser factorExpressionParser=new FactorExpressionParser(this);
							String temp=factorExpressionParser.parseAsStrting(token);
							token =currentToken();
							value=value+temp+" ";
							//是否是函数
//							if(token.getType()==XcloudTokenType.LEFT_PAREN){
//								value=parserParen(token, value);
//							}

							token =currentToken();
							if(token.getType()==XcloudTokenType.RIGHT_PAREN || token instanceof EofToken)
								break;
						}
						valueExpression.add(value);
						//做(?,1,?)报错
						if("?".equals(valueExpression.get(0).trim())){
							if(!"?".equals(value.trim()) || valuesExpression.size()!=0){
								errorHandler.flag(errorToken, ParserErrorCode.INCOMPATIBLE_TYPES, this);
								logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
								skipToSemicolon();
								return null;
							}
						}else{
							if("?".equals(value.trim())){
								errorHandler.flag(errorToken, ParserErrorCode.INCOMPATIBLE_TYPES, this);
								logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
								skipToSemicolon();
								return null;
							}
							//做(?,?,?),(1,1,1)报错
							else if(valuesExpression.size()>0 && valuesExpression.get(0).get(0).trim().equals("?")){
								errorHandler.flag(errorToken, ParserErrorCode.INCOMPATIBLE_TYPES, this);
								logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
								skipToSemicolon();
								return null;
							}
						}
						
						value="";
						token=currentToken();
						if(token.getType() != XcloudTokenType.COMMA) break;
					}
					token=currentToken();
					if(token.getType()==XcloudTokenType.RIGHT_PAREN){
						token=nextToken();
						valuesExpression.add(valueExpression);
						if(token.getType() != XcloudTokenType.COMMA) break;
					}
					else{
						errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
						logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
						skipToSemicolon();
						return null;
					}
				}
				
			}else{
				errorHandler.flag(token, ParserErrorCode.MISSING_LEFT_PAREN, this);
				logger.error(ParserErrorCode.MISSING_LEFT_PAREN.toString());
				skipToSemicolon();
				return null;
			}
		}
		InsertIntoFromValue insertIntoFromValue=new InsertIntoFromValue(intoKeyWord,schemaName, tableName, columnList, hint,conditions,valuesExpression);										
		insertIntoFromValue.setAttribute(SyntaxTreeKeyImpl.LINE, line);
		insertIntoFromValue.setAttribute(SyntaxTreeKeyImpl.POSITION, pos);
		if(!intoKeyWord){
			insertIntoFromValue.setPocHint(pocHint);
		}
		insertIntoFromValue.setDblink(dblink);
		return insertIntoFromValue;
	}
	/**
	 * 解析函数
	 * @param token
	 * @param value
	 * @return
	 * @throws Exception
	 */
	private String parserParen(Token token,String value) throws Exception{
		if(token.getType()==XcloudTokenType.LEFT_PAREN){
			value =value+token.getText()+" ";
			token=nextToken();
			while(token.getType()!=XcloudTokenType.RIGHT_PAREN &&
					!(token instanceof EofToken)){
				FactorExpressionParser factorExpressionParser=new FactorExpressionParser(this);
				String temp=factorExpressionParser.parseAsStrting(token);
				value =value+temp+" ";
				token =currentToken();
				if(token.getType()==XcloudTokenType.LEFT_PAREN){
					value=parserParen(token, value);
					token=currentToken();
				}
				if(token instanceof EofToken ){
					break;
				}
			}
			value+=")";
			token=nextToken();
		}
		return value;
	}
	
	/**
	 * DBLink形式解析{Select…/with as} @DBLINK
	 * @param schemaName
	 * @param tableName
	 * @param columnList
	 * @param conditions
	 * @param line
	 * @param pos
	 * @param hint 
	 * @return
	 * @throws Exception
	 */
	private SyntaxTree extracted_DBlink(String pocHint,String schemaName, String tableName,String dblink,
			List<String> columnList, List<String> conditions, int line, int pos, String hint)
			throws Exception {
		Token token;
		String sel;
		String dblinkName;
		String condition = "";
		token=nextToken();
		while(!(token.getType() == XcloudTokenType.RIGHT_BRACE && peekToken().getType() == XcloudTokenType.AT) 
				&& !(token instanceof EofToken)){
			condition+=token.getText()+" ";
			token=nextToken();
		}
		sel=condition;
		token=currentToken();
		if(token.getType()==XcloudTokenType.RIGHT_BRACE){
			token=nextToken();
			if(token.getType()==XcloudTokenType.AT){
				token=nextToken();
				//解析dblink name
				if(token.getType()==XcloudTokenType.IDENTIFIER){
					dblinkName=(String) token.getText();
					token=nextToken();
					InsertIntoFromDB insertIntoFromDB=new InsertIntoFromDB(schemaName, tableName, columnList, hint, conditions, sel, dblinkName);
					insertIntoFromDB.setAttribute(SyntaxTreeKeyImpl.LINE, line);
					insertIntoFromDB.setAttribute(SyntaxTreeKeyImpl.POSITION, pos);
					insertIntoFromDB.setDblink(dblink);
//					insertIntoFromDB.setPocHint(pocHint);
					return insertIntoFromDB;
				}else{
					 errorHandler.flag(token, ParserErrorCode.NOT_TYPE_IDENTIFIER, this);
				     logger.error(ParserErrorCode.NOT_TYPE_IDENTIFIER.toString());
				     skipToSemicolon();
				     return null;
				}
			}else{
				 errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
			     logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
			     skipToSemicolon();
			     return null;
			}
			
		}else{
			 errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_BRACE, this);
		     logger.error(ParserErrorCode.MISSING_RIGHT_BRACE.toString());
		     skipToSemicolon();
		     return null;
		}
	}
	/**
	 * 本地加载解析 select/with as
	 * @param pocHint 
	 * @param token
	 * @param schemaName
	 * @param tableName
	 * @param columnList
	 * @param conditions
	 * @param dblinkName
	 * @param line
	 * @param pos
	 * @param hint 
	 * @return
	 * @throws Exception
	 */
	private SyntaxTree extracted_LocationDB(String pocHint, Token token, String schemaName,
			String tableName,String dblink, List<String> columnList, List<String> conditions,
			String dblinkName, int line, int pos, String hint) throws Exception {
		String sel;
		String condition = " "+token.getText()+" ";
		token=nextToken();
		while(token.getType() != XcloudTokenType.SEMICOLON &&
				!(token instanceof EofToken)){
			condition+=token.getText()+" ";
			token=nextToken();
		}
		sel=condition;
		token=currentToken();
		InsertIntoFromDB insertIntoFromDB=new InsertIntoFromDB(schemaName, tableName, columnList, hint, conditions, sel, dblinkName);
		insertIntoFromDB.setAttribute(SyntaxTreeKeyImpl.LINE, line);
		insertIntoFromDB.setAttribute(SyntaxTreeKeyImpl.POSITION, pos);
		insertIntoFromDB.setDblink(dblink);
//		insertIntoFromDB.setPocHint(pocHint);
		return insertIntoFromDB;
	}
	/**
	 * 解析partition条件
	 * @param token
	 * @param conditions
	 * @param pcondition
	 * @throws Exception
	 */
	private void extractPartition(Token token, List<String> conditions,
			String pcondition) throws Exception {
		
		
		while(token.getType() != XcloudTokenType.RIGHT_PAREN &&
				!(token instanceof EofToken)){
			if(token.getType()!=XcloudTokenType.COMMA){
				if(token.getType() == XcloudTokenType.INTERVAL){
					FactorExpressionParser factorExpressionParser=new FactorExpressionParser(this);
					String temp = factorExpressionParser.parseAsStrting(token);
					pcondition+=temp;
					token=currentToken();
				}else{
					pcondition+=token.getText();
					token=nextToken();
				}
			}else{
				conditions.add(pcondition);
				token=nextToken();
				pcondition="";
			}
			
		}
		conditions.add(pcondition);
	}
	/**
	 * 解析CSV导入数据的分区后面的公共部分
	 * @param pocHint 
	 * @param token
	 * @param hint
	 * @param dmlTableExpression
	 * @param columnList
	 * @param sqlEqualExpressionList
	 * @param filePath
	 * @param encodeChar
	 * @param separatorChar
	 * @param quotenKey
	 * @param delimiterChar
	 * @param escapeChar
	 * @param linefeedChar 
	 * @param line 
	 * @param pos 
	 * @return
	 * @throws Exception
	 */
	private SyntaxTree extractedFromCSV(String pocHint, Token token, String hint,
			String schemaName,String tableName,String dblink, List<String> columnList,
			List<String> conditions,
			String filePath, String encodeChar,
			String separatorChar, String quotenKey,
			String delimiterChar, String escapeChar, String linefeedChar, int line, int pos)
			throws Exception {
		//file路径
		if(token.getType()==XcloudTokenType.STRING){
			filePath=(String)token.getValue();
			token=nextToken();
			//Encode
			if(token.getType()==XcloudTokenType.ENCODE){
				token =nextToken();
				if(token.getType()==XcloudTokenType.STRING){
					encodeChar=token.getText();
					token=nextToken();
				}else{
					errorHandler.flag(token, ParserErrorCode.INCOMPATIBLE_TYPES, this);
					logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
					skipToSemicolon();
					return null;
				}
			}
			//SEPARATOR
			token=currentToken();
			if(token.getType()==XcloudTokenType.SEPARATOR){
				token=nextToken();
				if(token.getType()==XcloudTokenType.STRING){
					separatorChar=token.getText();
					token=nextToken();
				}else{
					errorHandler.flag(token, ParserErrorCode.INCOMPATIBLE_TYPES, this);
					logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
					skipToSemicolon();
					return null;
				}
			}
			//QUOTED关键字
			token=currentToken();
			if(token.getType()==XcloudTokenType.QUOTED ||token.getType()==XcloudTokenType.UNQUOTED){
				quotenKey=token.getText();
				token=nextToken();
			}else{
				if(token.getType()==XcloudTokenType.DELIMITER){
					token =nextToken();
					if(token.getType()==XcloudTokenType.STRING){
						delimiterChar=token.getText();
						token=nextToken();
					}else{
						errorHandler.flag(token, ParserErrorCode.INCOMPATIBLE_TYPES, this);
						logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
						skipToSemicolon();
						return null;
					}
				}
				token=currentToken();
				if(token.getType()==XcloudTokenType.ESCAPE){
					token =nextToken();
					if(token.getType()==XcloudTokenType.STRING){
						escapeChar=token.getText();
						token=nextToken();
					}else{
						errorHandler.flag(token, ParserErrorCode.INCOMPATIBLE_TYPES, this);
						logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
						skipToSemicolon();
						return null;
					}
				}
			}
			token=currentToken();
			if(token.getType()==XcloudTokenType.LINEFEED){
				token =nextToken();
				if(token.getType()==XcloudTokenType.STRING){
					linefeedChar=token.getText();
					token=nextToken();
				}else{
					errorHandler.flag(token, ParserErrorCode.INCOMPATIBLE_TYPES, this);
					logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
					skipToSemicolon();
					return null;
				}
			}
			
			InsertIntoFromCsv insertIntoFromCsv=new InsertIntoFromCsv(schemaName,tableName, columnList, hint, conditions, filePath, encodeChar, separatorChar, quotenKey, delimiterChar, escapeChar,linefeedChar);
			insertIntoFromCsv.setAttribute(SyntaxTreeKeyImpl.LINE, line);
			insertIntoFromCsv.setAttribute(SyntaxTreeKeyImpl.POSITION, pos);
//			insertIntoFromCsv.setPocHint(pocHint);
			insertIntoFromCsv.setDblink(dblink);
			return insertIntoFromCsv;
			
		}else{
			errorHandler.flag(token, ParserErrorCode.INVALID_IDENTIFIER, this);
			logger.error(ParserErrorCode.INVALID_IDENTIFIER.toString());
			skipToSemicolon();
			return null;
		}
		
	}

}
