package com.bonc.xcloud.sp_procedure.frontend.xcloud.sqlparser;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.ParserErrorCode;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudParse;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers.StatementParser;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.sql.InsertIntoFromClient;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTreeKeyImpl;
/**
 * 
 * 由客户端本地插入到行云<br/>
 * 解析语句语法：@Client 'File_Path' INSERT INTO [schema_name].table_name (col_name, …)
 *
 * 
 *
 */
public class InsertIntoFromClientParser extends StatementParser{
	private static Logger logger = Logger.getLogger(InsertIntoFromClientParser.class);
	public InsertIntoFromClientParser(XcloudParse parent) {
		super(parent);
	}
	@Override
	public SyntaxTree parse(Token token) throws Exception {
		List<String> columnList = null;
		String filePath=null;
		String schemaName = null;
		String tableName = null;
		int line = token.getLineNum();
		int pos = token.getPosition();
		if(token.getType()==XcloudTokenType.AT){
			token=nextToken();
			if(token.getType()==XcloudTokenType.CLIENT){
				token=nextToken();
				if(token.getType()==XcloudTokenType.STRING){
					filePath=(String)token.getValue();
					token=nextToken();
				}else{
					 errorHandler.flag(token, ParserErrorCode.INCOMPATIBLE_TYPES, this);
				     logger.error(ParserErrorCode.INCOMPATIBLE_TYPES.toString());
				     skipToSemicolon();
				     return null;
				}
					token=currentToken();
					if(token.getType()==XcloudTokenType.INSERT){
						token=nextToken();
						if(token.getType()==XcloudTokenType.INTO){
							token = nextToken();
							if (token.getType() == XcloudTokenType.IDENTIFIER) {
								
								tableName = token.getText();
								token = nextToken();
								if (token.getType() == XcloudTokenType.DOT) {
									token = nextToken();
									schemaName = tableName;
									tableName = token.getText();
									token = nextToken();
								}
								token = currentToken();
								//有column
								if(token.getType()==XcloudTokenType.LEFT_PAREN){
									token=nextToken();
									columnList=new ArrayList<String>();
									for(int i=0;;i++){
										if(token.getType()==XcloudTokenType.COMMA)token=nextToken();
										columnList.add(token.getText());
										token=nextToken();
										if(token.getType() != XcloudTokenType.COMMA) break;
									}
									token=currentToken();
									if(token.getType()==XcloudTokenType.RIGHT_PAREN){
										token=nextToken();
									}else{
										 errorHandler.flag(token, ParserErrorCode.MISSING_RIGHT_PAREN, this);
									     logger.error(ParserErrorCode.MISSING_RIGHT_PAREN.toString());
									     skipToSemicolon();
									     return null;
									}
								}else{
									 errorHandler.flag(token, ParserErrorCode.MISSING_LEFT_PAREN, this);
								     logger.error(ParserErrorCode.MISSING_LEFT_PAREN.toString());
								     skipToSemicolon();
								     return null;	
								}
								InsertIntoFromClient insertIntoFromClient=new InsertIntoFromClient(schemaName, tableName, columnList,filePath);
								insertIntoFromClient.setAttribute(SyntaxTreeKeyImpl.LINE, line);
								insertIntoFromClient.setAttribute(SyntaxTreeKeyImpl.POSITION, pos);
								return insertIntoFromClient;
							}else{
								 errorHandler.flag(token, ParserErrorCode.NOT_TYPE_IDENTIFIER, this);
							     logger.error(ParserErrorCode.NOT_TYPE_IDENTIFIER.toString());
							     skipToSemicolon();
							     return null;
							}
						}else{
							 errorHandler.flag(token, ParserErrorCode.MISSING_INTO, this);
						     logger.error(ParserErrorCode.MISSING_INTO.toString());
						     skipToSemicolon();
						     return null;
						}
					}else{
						 errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
					     logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
					     skipToSemicolon();
					     return null;
					}
					
			}
		}
		return null;
	}

}
