package com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers;


import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.BEGIN;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.CASE;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.DELETE;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.DOT;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.ELSE;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.END;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.EXECUTE;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.EXIT;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.FOR;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.IDENTIFIER;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.IF;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.INSERT;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.LOOP;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.SEMICOLON;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.UNTIL;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.UPDATE;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.WHEN;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.WHILE;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.log4j.Logger;
import com.bonc.xcloud.sp_procedure.frontend.EofToken;
import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.TokenType;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.ParserErrorCode;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudParse;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTreeKeyImpl;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.statement.Statement;


/**
 * statement 语句解析器
 */
public class StatementParser extends XcloudParse{

	private static Logger logger = Logger.getLogger(StatementParser.class);
	
    // Synchronization set for starting a statement.
    protected static final EnumSet<XcloudTokenType> STMT_START_SET =
        EnumSet.of(BEGIN,CASE,FOR, IF, LOOP, WHILE,
        		IDENTIFIER, SEMICOLON,INSERT,UPDATE,DELETE,EXECUTE,XcloudTokenType.RETURN,XcloudTokenType.SELECT);

    // Synchronization set for following a statement.
    protected static final EnumSet<XcloudTokenType> STMT_FOLLOW_SET =
        EnumSet.of(SEMICOLON, END, ELSE,UNTIL,DOT,EXIT,WHEN);
	
	
	public StatementParser(XcloudParse parent) {
		super(parent);
	}
	
	/**
	 * 解析一个statement语句
	 */
	public SyntaxTree parse(Token token) throws Exception{
//		
		SyntaxTree statement = null;
//		
//		switch((XcloudTokenType)token.getType()){
//		
//			//如果为 BEGIN,为一个复合语句
//			case BEGIN:{
//				BlockStatementParser compoundParser =
//					new BlockStatementParser(this);
//				statement = compoundParser.parse(token);
//				break;
//			}
//			
////			case DECLARE:{
////				ExecutableBlockStatementParser exeParser = new ExecutableBlockStatementParser(this);
////				statement = exeParser.parse(token);
////			}
//			
//			//如果为 IDENTIFIER,为一个赋值语句
//			case IDENTIFIER:{
//				
//				String targetName = token.getText().toLowerCase();
//				SymTabEntry targetId = symTabStack.lookup(targetName);
//				char c = this.lexer.currentChar();
//				String str = String.valueOf(c);
//				
//				//若下一个字符为括号,则为过程调用,否则为赋值语句
//				if(str.equals(XcloudTokenType.LEFT_PAREN.getText())){
//					
//					//在符号表第0层查找id(正在解析过程放在第0层)
//					targetId = symTabStack.getIndexSymTab(0).lookup(targetName);
//					
//					//若id为null,则一定是procedureCall,且为已声明的过程
//					if(targetId == null){
//						
//						SyntaxTree syntaxTree = null;
//						if(TaskNativeTest.isNativeProcedure){
//							//本地文件测试
////							String sourcePath = ProcedureDBUtil.searchProcedurePath(targetName);
////							if(sourcePath == null){
////								errorHandler.flag(token, ParserErrorCode.PROCEDURE_UNDEFINED, this);
////								logger.error(ParserErrorCode.PROCEDURE_UNDEFINED.toString());
////								skipToSemicolon();
////						        return null;
////							}
////							syntaxTree = XcloudParse.initializeAndParse(Source.fileSource, sourcePath, this);
//							
//							
//							//根据过程名字 查找对应的源码字符串
//							String source = ProcedureDBUtil.searchProcedureByName(targetName);
//							if(source == null){
//								errorHandler.flag(token, ParserErrorCode.PROCEDURE_UNDEFINED, this);
//								logger.error(ParserErrorCode.PROCEDURE_UNDEFINED.toString());
//								skipToSemicolon();
//						        return null;
//							}
//							syntaxTree = XcloudParse.initializeAndParse(Source.stringSource, source, this);
//							
//						}else{
//							//连接数据库测试
//							String procedureString = null;
//							try{
//								procedureString = DBUtil.searchProcedure(targetName, dbConfiguration);
//							}catch(Exception e){
//								ParserErrorCode code = ParserErrorCode.PARSERERROR;
//								if(e.getMessage()!= null && !e.getMessage().equals(""))code.setMessage(e.getMessage());
//								errorHandler.flag(token, code, this);
//								logger.error(code.toString());
//								skipToSemicolon();
//						        return null;
//							}
//							
//							if(procedureString == null){
//								errorHandler.flag(token, ParserErrorCode.PROCEDURE_UNDEFINED, this);
//								logger.error(ParserErrorCode.PROCEDURE_UNDEFINED.toString());
//								skipToSemicolon();
//						        return null;
//							}
//							syntaxTree = XcloudParse.initializeAndParse(Source.stringSource, procedureString, this);
//							
//						}
//						
//						if(syntaxTree == null){
//							errorHandler.flag(token, ParserErrorCode.PROCEDURE_ERROR, this);
//							logger.error(ParserErrorCode.PROCEDURE_ERROR.toString());
//							skipToSemicolon();
//							return null;
//						}
//						
//						if(!(syntaxTree instanceof ProcedureDeclareStatement)){
//							errorHandler.flag(token, ParserErrorCode.NOT_A_PROCEDURE, this);
//							logger.error(ParserErrorCode.NOT_A_PROCEDURE.toString());
//							skipToSemicolon();
//							return null;
//						}
//						ProcedureDeclareStatement procedure = (ProcedureDeclareStatement)syntaxTree;
//						ProcedureCallStatementParser callProcedure = new ProcedureCallStatementParser(this);
//						callProcedure.setProcedure(procedure);
//						statement = callProcedure.parse(token);
//						break;
//					}
//					//id不为null,则为正在解析的过程
//					else{
//					
//						if(!targetId.getDefinition().equals(DefinitionImpl.PROCEDURE)){
//							errorHandler.flag(token, ParserErrorCode.PROCEDURE_UNDEFINED, this);
//							logger.error(ParserErrorCode.PROCEDURE_UNDEFINED.toString());
//							skipToSemicolon();
//					        return null;
//						}
//						
//						ProcedureDeclareStatement procedure = 
//								(ProcedureDeclareStatement) targetId.getAttribute(SymTabkeyImpl.ROUTINE_CODE);
//						ProcedureCallStatementParser callProcedure = new ProcedureCallStatementParser(this);
//						callProcedure.setProcedure(procedure);
//						statement = callProcedure.parse(token);
//						break;
//					}
//				}else{
//					AssignmentStatementParser assignmentParser = 
//							new AssignmentStatementParser(this);
//						statement = assignmentParser.parse(token);
//						break;
//				}
//				
//			}
//			//如果为IF,w为一个判断语句
//			case IF:{
//				IfStatementParser ifStatementParser=
//						new IfStatementParser(this);
//				statement=ifStatementParser.parse(token);
//				break;
//			}
//			//如果为 WHILE,为一个while循环语句
//			case WHILE:{
//				WhileStatementParser whileParser = 
//					new WhileStatementParser(this);
//				statement = whileParser.parse(token);
//				break;
//			}
//			
//			//如果为 LOOP,为一个loop循环语句
//			case LOOP:{
//				LoopStatementParser loopParser = 
//					new LoopStatementParser(this);
//				statement = loopParser.parse(token);
//				break;
//			}
//			
//			//如果为 FOR,为一个for循环语句
//			case FOR:{
//				ForStatementParser forParser = 
//					new ForStatementParser(this);
//				statement = forParser.parse(token);
//				break;
//			}
//			//如果为 EXECUTE,为一个EXECUTE语句
//			case EXECUTE:{
//				ExecuteStatementParser execParser = 
//					new ExecuteStatementParser(this);
//				statement = execParser.parse(token);
//				break;
//			}
//			case RETURN:{
//				ReturnStatementParser returnStatement=
//						new ReturnStatementParser(this);
//				statement=returnStatement.parse(token);
//				break;
//			}
//			//如果为 INSERT/DELETE/UPDATE,为一个简单SQL语句
//			case INSERT:{
//				InsertIntoStatmentParser insertIntoStatmentParser=new InsertIntoStatmentParser(this);
//				statement=insertIntoStatmentParser.parse(token);
//				break;
//			}
//			case DELETE:
//			case UPDATE:{
////				DMLSQLStatementParser sqlParser = 
////					new DMLSQLStatementParser(this);
////				statement = sqlParser.parse(token);
////				break;
//			}
//			
//			case SELECT:{
//				
//				SelectIntoStatmentParser selectParser = new SelectIntoStatmentParser(this);
//				statement = selectParser.parse(token);
//				statement = (SelectIntoStatement)statement;
//				
//				//当设置开启语义检查时进行语义检查
//				if(statement != null && (ProcConfig.openAllSemanticCheck || ProcConfig.openSelectSemanticCheck)){
//					try {
//						statement = ((SelectIntoStatement)statement).semanticCheck(dbConfiguration, null);
//					} catch (Exception e) {
//						if(e instanceof SqlSemanticCheckException){
//							SqlSemanticCheckException sqlE = (SqlSemanticCheckException)e;
//							
//							Token token1 = sqlE.getToken();
//							ParserErrorCode code = sqlE.getErrorCode();
//							errorHandler.flag(token1, code, this);
//							logger.error(code.getMessage());
//							skipToSemicolon();
//			        		return null;
//						}else{
//							throw e;
//						}
//					}
//				}
//
//				break;
//			}
//			case WITH :{
//				SelectParser selectParser = new SelectParser(this);
//				statement = selectParser.parse(token);
////				SubQueryParser queryParser=new SubQueryParser(this);
////				statement=queryParser.parse(token);
//				break;
//			}
//			case CREATE:{
//				Token peek_token = peekToken();
//				if(peek_token.getType() == XcloudTokenType.TABLE) {
//					CreateTableStatementParser createParser = new CreateTableStatementParser(this);
//					statement = createParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.DATABASE) {
//					CreateDatabaseStatementParser createDatabaseStatementParser = 
//							new CreateDatabaseStatementParser(this);
//					statement = createDatabaseStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.PUBLIC) {
//					CreateDBLINKStatementParser createDBLINKStatementParser = 
//							new CreateDBLINKStatementParser(this);
//					statement = createDBLINKStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.VIEW) {
//					CreateViewStatementParser createViewStatementParser = 
//							new CreateViewStatementParser(this);
//					statement = createViewStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.OR) {
//					CreateOrReplaceViewStatementParser createOrReplaceViewStatementParser = 
//							new CreateOrReplaceViewStatementParser(this);
//					statement = createOrReplaceViewStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.MINMAX ||
//						peek_token.getType() == XcloudTokenType.SECTION) {
//					CreateIndexStatementParser createIndexStatementParser = 
//							new CreateIndexStatementParser(this);
//					statement = createIndexStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.USER) {
//					CreateUserStatementParser createUserStatementParser = new
//							CreateUserStatementParser(this);
//					statement = createUserStatementParser.parse(token);
//					break;
//				}
//			}
//			
//			case TRUNCATE: {
//				TruncateTableStatementParser truncateTableStatementParser = new 
//						TruncateTableStatementParser(this);
//				statement = truncateTableStatementParser.parse(token);
//				break;
//			}
//			
//			case GRANT: {
//				Token peek_token = peekToken();
//				Token peek_token2 = peekToken(2);
//				if(peek_token.getType() == XcloudTokenType.ANY || 
//						(peek_token.getType() == XcloudTokenType.CREATE && peek_token2.getType() ==XcloudTokenType.USER) ||
//						(peek_token.getType() == XcloudTokenType.CREATE && peek_token2.getType() ==XcloudTokenType.DATABASE)) {
//					GrantSystemPrivilegeStatementParser grantSystemPrivilegeStatementParser = new
//							GrantSystemPrivilegeStatementParser(this);
//					statement = grantSystemPrivilegeStatementParser.parse(token);
//					break;
//				}
//				
//				else {
//					GrantPrivilegeStatementParser grantPrivilegeStatementParser = 
//							new GrantPrivilegeStatementParser(this);
//					statement = grantPrivilegeStatementParser.parse(token);
//					break;
//				}
//			}
//			
//			case REVOKE: {
//				Token peek_token = peekToken();
//				Token peek_token2 = peekToken(2);
//				if(peek_token.getType() == XcloudTokenType.ANY || 
//						(peek_token.getType() == XcloudTokenType.CREATE && peek_token2.getType() ==XcloudTokenType.USER) ||
//						(peek_token.getType() == XcloudTokenType.CREATE && peek_token2.getType() ==XcloudTokenType.DATABASE)) {
//					RevokeSystemPrivilegeStatementParser revokeSystemPrivilegeStatementParser = new
//							RevokeSystemPrivilegeStatementParser(this);
//					statement = revokeSystemPrivilegeStatementParser.parse(token);
//					break;
//				}
//				
//				else {
//					RevokePrivilegeStatementParser revokePrivilegeStatementParser =
//							new RevokePrivilegeStatementParser(this);
//					statement = revokePrivilegeStatementParser.parse(token);
//					break;
//				}
//			}
//			
//			case ALTER: {
//				Token peek_token = peekToken();
//				if(peek_token.getType() == XcloudTokenType.TABLE) {
//					AlterTableStatementParser alterTableStatementParser = new
//							AlterTableStatementParser(this);
//					statement = alterTableStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.USER) {
//					AlterUserStatementParser alterUserStatementParser = new
//							AlterUserStatementParser(this);
//					statement = alterUserStatementParser.parse(token);
//					break;
//				}
//			}
//			
//			case DROP: {
//				Token peek_token = peekToken();
//				if(peek_token.getType() == XcloudTokenType.TABLE) {
//					DropTableStatementParser dropTableStatementParser = new
//							DropTableStatementParser(this);
//					statement = dropTableStatementParser.parse(token);
//					break;
//				}
//				
//				else if (peek_token.getType() == XcloudTokenType.DATABASE) {
//					DropDatabaseStatementParser databaseStatementParser = new 
//							DropDatabaseStatementParser(this);
//					statement = databaseStatementParser.parse(token);
//					break;
//				}
//				
//				else if (peek_token.getType() == XcloudTokenType.PUBLIC) {
//					DropDBLINKStatementParser dropDBLINKStatementParser = new
//							DropDBLINKStatementParser(this);
//					statement = dropDBLINKStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.VIEW) {
//					DropViewStatementParser dropViewStatementParser = new
//							DropViewStatementParser(this);
//					statement = dropViewStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.INDEX) {
//					DropIndexStatementParser dropIndexStatementParser = new
//							DropIndexStatementParser(this);
//					statement = dropIndexStatementParser.parse(token);
//					break;
//				}
//				
//				else if(peek_token.getType() == XcloudTokenType.USER) {
//					DropUserStatementParser dropUserStatementParser = new 
//							DropUserStatementParser(this);
//					statement = dropUserStatementParser.parse(token);
//					break;
//				}
//				
//			}
//			
//			case CASE: {
//				CaseStatementParser caseStatementParser = new CaseStatementParser(this);
//				statement = caseStatementParser.parse(token);
//				break;
//			}
//			case OPEN:{
//				CursorOpenStatementParser cursorOpenStatementParser = new CursorOpenStatementParser(this);
//				statement = cursorOpenStatementParser.parse(token);
//				break;
//			}
//			case FETCH:{
//				CursorFetchStatementParser cursorFetchStatementParser = new CursorFetchStatementParser(this);
//				statement = cursorFetchStatementParser.parse(token);
//				break;
//			}
//			case CLOSE:{
//				CursorClosestatementParser cursorCloseStatementParser = new CursorClosestatementParser(this);
//				statement = cursorCloseStatementParser.parse(token);
//				break;
//			}
//			
//			case ENGINE: {
//				MultiEngineParser multiEngineParser = new MultiEngineParser(this);
//				statement = multiEngineParser.parse(token);
//				break;
//			}
//			case AT:{
//				Token peek_token = peekToken();
//				if(peek_token.getType()==XcloudTokenType.CLIENT){
//					InsertIntoFromClientParser clientParser=new InsertIntoFromClientParser(this);
//					statement=clientParser.parse(token);
//					break;
//				}
//			}
//			default: {
////				statementNode = ICodeFactory.createICodeNode(ICodeTypeImpl.NO_OP);
//				if(token.getValue() != null && token.getValue() instanceof ParserErrorCode){
//					//为了弹出词法解析的错误
//					errorHandler.flag(token, (ParserErrorCode)(token.getValue()), this);
//					logger.error(((ParserErrorCode)(token.getValue())).toString());
//					skipToSemicolon();
//					return null;
//				}else{
//					errorHandler.flag(token, ParserErrorCode. UNKNOWNSTRUCTURE, this);
//					skipToSemicolon();
//					logger.error(ParserErrorCode. UNKNOWNSTRUCTURE.toString());
//					return null;
//				}
//				
//			}
//		}
//		//设置行号属性
//		if(statement != null){
//			setLineNumber(statement, token);
//		}
		return statement;
	}
	
	/**
	 * 给statement node 设置行号、列号属性
	 */
	public void setLineNumber(SyntaxTree item, Token token){
		
		if(item != null){
			int lineNum = token.getLineNum();
			int pos = token.getPosition();
			item.setAttribute(SyntaxTreeKeyImpl.LINE, lineNum);
			item.setAttribute(SyntaxTreeKeyImpl.POSITION, pos);
		}
	}
	
	/**
	 * 解析一个statement语句集合
	 * @param token 当前的token
	 * @param terminator 集合终止节点的token类型
	 * @param errorCode 终止符丢失时该返回到错误码
	 * @throws Exception 异常
	 * @return 语句集合
	 */
	public List<Statement> parseList(Token token,
			              List<XcloudTokenType> terminators,
			              ParserErrorCode errorCode)
		throws Exception{
		
		List<Statement> statements = new ArrayList<Statement>();
		// Synchronization set for the terminator.
		EnumSet<XcloudTokenType> terminatorSet = STMT_START_SET.clone();
        terminatorSet.addAll(terminators);
        
		while(!(token instanceof EofToken) &&
				(!terminators.contains(token.getType()))){
			
			//解析一个statement语句.
			Statement statementNode = (Statement)parse(token);
//			if(statementNode==null){
//				return null;
//			}
			if(statementNode!=null)
			statements.add(statementNode);
			
			token = currentToken();
			
			TokenType tokenType = token.getType();
			
			//查看是否为分号";",如果是读下一个字符
			if(tokenType == XcloudTokenType.SEMICOLON){
				token = nextToken();
			}
			else{
				errorHandler.flag(token, ParserErrorCode.MISSING_SEMICOLON, this);
				skipToSemicolon();
				logger.error(ParserErrorCode. MISSING_SEMICOLON.toString());
				return null;
			}
			
//			//如果当前token是一个语句开始的关键字,丢失了";"
//            else if (STMT_START_SET.contains(tokenType)) {
//                errorHandler.flag(token, ParserErrorCode.MISSING_SEMICOLON, this);
//                logger.error(ParserErrorCode. MISSING_SEMICOLON.toString());
//            }
			
			//同步下一条语句的首token或者是语句集合的终结符类型terminator
//            token = synchronize(terminatorSet);
//			token = nextToken();
            
		}
		
//		if(token.getType() == terminator){
////			token = nextToken();
//		}
//		
//		else{
//			errorHandler.flag(token, errorCode, this);
//		}
		return statements;
	}
	/**
	 * 解析一个statement语句集合
	 * @param token 当前的token
	 * @param terminator 集合终止节点的token类型
	 * @param unuseType 不支持的类型
	 * @param errorCode 终止符丢失时该返回到错误码
	 * @throws Exception 异常
	 * @return 语句集合
	 */
	public List<Statement> parseList(Token token,
			              List<XcloudTokenType> terminators,
			              List<XcloudTokenType> unuseType,
			              ParserErrorCode errorCode)
		throws Exception{
		
		List<Statement> statements = new ArrayList<Statement>();
		// Synchronization set for the terminator.
		EnumSet<XcloudTokenType> terminatorSet = STMT_START_SET.clone();
				terminatorSet.addAll(terminators);
	      terminatorSet.removeAll(unuseType); 
		while(!(token instanceof EofToken) &&
				(!terminators.contains(token.getType()))){
			
			//解析一个statement语句.
			Statement statementNode = (Statement)parse(token);

			if(statementNode!=null)
			statements.add(statementNode);
			
			token = currentToken();
			
			TokenType tokenType = token.getType();
			
			//查看是否为分号";",如果是读下一个字符
			if(tokenType == XcloudTokenType.SEMICOLON){
				token = nextToken();
			}
			else{
				errorHandler.flag(token, ParserErrorCode.MISSING_SEMICOLON, this);
				skipToSemicolon();
				logger.error(ParserErrorCode. MISSING_SEMICOLON.toString());
				return null;
			}
		}	
		return statements;
	}
	
}
