package com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers;

import org.apache.log4j.Logger;

import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.ParserErrorCode;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudParse;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;

public class IntervalYMParser extends StatementParser {
	
	private static Logger logger = Logger.getLogger(IntervalYMParser.class);

	public IntervalYMParser(XcloudParse parent) {
		super(parent);
		// TODO Auto-generated constructor stub
	}

	public String parseAsString(Token token) throws Exception {
		String intervalYMExpression = null;
		if(token.getType() == XcloudTokenType.INTERVAL) {
			token = nextToken();
			if(token.getType() == XcloudTokenType.STRING) {
				
				intervalYMExpression = "INTERVAL "+token.getText();
				token = nextToken();
				if(token.getText().toLowerCase().equals("year")) {
					if(token.getText().toLowerCase().equals("year")) 
						intervalYMExpression+=" year";
					token = nextToken();
					if(token.getType() == XcloudTokenType.LEFT_PAREN) {
						intervalYMExpression+="(";
		    			token = nextToken();
		    			if(token.getType() == XcloudTokenType.INTEGER) {
		    				intervalYMExpression+=" "+token.getText();
		    				token = nextToken();
		    				if(token.getType() == XcloudTokenType.RIGHT_PAREN) {
		    					intervalYMExpression+=")";
		    					token = nextToken();
		    				}
		    			}
		    		} else {
		    			intervalYMExpression+=" ";
		    		}
					
					if(token.getType() == XcloudTokenType.TO) {
						intervalYMExpression+=" to ";
						token = nextToken();
						if(token.getText().toLowerCase().equals("year") ||
								token.getText().toLowerCase().equals("month")) {
							if(token.getText().toLowerCase().equals("year")) {
								intervalYMExpression+=" year";
							}
							else if(token.getText().toLowerCase().equals("month")) {
								intervalYMExpression+=" month";
							}
							token = nextToken();
						} else{
							logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
							errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
							skipToSemicolon();
							return null;
						}
					}
				}else if(token.getText().toLowerCase().equals("month")){
					if(token.getText().toLowerCase().equals("month")) 
						intervalYMExpression+=" month";
					token = nextToken();
					if(token.getType() == XcloudTokenType.LEFT_PAREN) {
						intervalYMExpression+="(";
		    			token = nextToken();
		    			if(token.getType() == XcloudTokenType.INTEGER) {
		    				intervalYMExpression+=" "+token.getText();
		    				token = nextToken();
		    				if(token.getType() == XcloudTokenType.RIGHT_PAREN) {
		    					intervalYMExpression+=")";
		    					token = nextToken();
		    				}
		    			}
		    		} else {
		    			intervalYMExpression+=" ";
		    		}
					if(token.getType() == XcloudTokenType.TO) {
						intervalYMExpression+=" to ";
						token = nextToken();
						if(token.getText().toLowerCase().equals("month")) {
							if(token.getText().toLowerCase().equals("month")) 
								intervalYMExpression+=" month ";
							token = nextToken();
						} else{
							logger.error(ParserErrorCode.PARSERERROR.toString());
							errorHandler.flag(token, ParserErrorCode.PARSERERROR, this);
							skipToSemicolon();
							return null;
						}
					}
				} 
				else{
					logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
					errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
					skipToSemicolon();
					return null;
				}
			} else{
				logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
				errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
				skipToSemicolon();
				return null;
			}
			
		}
		return intervalYMExpression;
	}

	
}
