package com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers;

import org.apache.log4j.Logger;

import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.ParserErrorCode;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudParse;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;

public class IntervalDSParser extends StatementParser {
	
	private static Logger logger = Logger.getLogger(IntervalDSParser.class);

	public IntervalDSParser(XcloudParse parent) {
		super(parent);
		// TODO Auto-generated constructor stub
	}

	public String parseAsString(Token token) throws Exception {
		String intervalDSExpression = null;
		if(token.getType() == XcloudTokenType.INTERVAL) {
			token = nextToken();
			if(token.getType() == XcloudTokenType.STRING) {
				intervalDSExpression="INTERVAL "+token.getText();
				token = nextToken();
				if(token.getText().toLowerCase().equals("day") ||
						token.getText().toLowerCase().equals("hour") ||
						token.getText().toLowerCase().equals("minute")) {
					if(token.getText().toLowerCase().equals("day")){
						intervalDSExpression+=" day";
					}else if(token.getText().toLowerCase().equals("hour")){
						intervalDSExpression+=" hour";
					}else if(token.getText().toLowerCase().equals("minute")){
						intervalDSExpression+=" minute";
					}
					token = nextToken();
					if(token.getType() == XcloudTokenType.LEFT_PAREN) {
						intervalDSExpression+="(";
		    			token = nextToken();
		    			if(token.getType() == XcloudTokenType.INTEGER) {
		    				intervalDSExpression+=token.getText();
		    				token = nextToken();
		    				if(token.getType() == XcloudTokenType.RIGHT_PAREN) {
		    					intervalDSExpression+=")";
		    					token = nextToken();
		    				}
		    			}
		    		}else{
		    			intervalDSExpression+=" ";
		    		}
				}
				
				else if(token.getText().toLowerCase().equals("second")) {
					intervalDSExpression+=" second";
					token = nextToken();
					if(token.getType() == XcloudTokenType.LEFT_PAREN) {
						intervalDSExpression+="(";
						token = nextToken();
						if(token.getType() == XcloudTokenType.INTEGER) {
							intervalDSExpression+=token.getText();
		    				token = nextToken();
		    				if(token.getType() == XcloudTokenType.COMMA) {
		    					intervalDSExpression+=",";
		    					token = nextToken();
		    					if(token.getType() == XcloudTokenType.INTEGER) {
		    						intervalDSExpression+=token.getText();
				    				token = nextToken();
		    					}else{
		    						logger.error(ParserErrorCode.INTERVALDS_PRECISION_ERROR.toString());
		    						errorHandler.flag(token, ParserErrorCode.INTERVALDS_PRECISION_ERROR, this);
		    						skipToSemicolon();
		    						return null;
		    					}
		    				}
		    				
		    				if(token.getType() == XcloudTokenType.RIGHT_PAREN) {
		    					intervalDSExpression+=")";
		    					token = nextToken();
		    				}
		    			}else{
		    				logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
							errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
							skipToSemicolon();
							return null;
		    			}
					}else{
						intervalDSExpression+=" ";
					}
				} else{
					logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
					errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
					skipToSemicolon();
					return null;
				}
					
				if(token.getType() == XcloudTokenType.TO) {
					intervalDSExpression+=" to";
					token = nextToken();
					if(token.getText().toLowerCase().equals("day") ||
							token.getText().toLowerCase().equals("hour") ||
							token.getText().toLowerCase().equals("minute") 
							) {
						if(token.getText().toLowerCase().equals("day")){
							intervalDSExpression+=" day";
						}else if(token.getText().toLowerCase().equals("hour")){
							intervalDSExpression+=" hour";
						}else if(token.getText().toLowerCase().equals("minute")){
							intervalDSExpression+=" minute";
						}
						token = nextToken();
						if(token.getType() == XcloudTokenType.LEFT_PAREN) {
							logger.error(ParserErrorCode.PARSERERROR.toString());
							errorHandler.flag(token, ParserErrorCode.PARSERERROR, this);
							skipToSemicolon();
							return null;
			    		}
					}else if(token.getText().toLowerCase().equals("second")){
						intervalDSExpression+=" second";
						token = nextToken();
						if(token.getType() == XcloudTokenType.LEFT_PAREN) {
							intervalDSExpression+="(";
			    			token = nextToken();
			    			if(token.getType() == XcloudTokenType.INTEGER) {
			    				intervalDSExpression+=token.getText();
			    				token = nextToken();
			    				if(token.getType() == XcloudTokenType.RIGHT_PAREN) {
			    					intervalDSExpression+=")";
			    					token = nextToken();
			    				}
			    			}
			    		}
					} 
					else{
						logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
						errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
						skipToSemicolon();
						return null;
					}
				}
			
			} else{
				logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
				errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
				skipToSemicolon();
				return null;
			}
			
		}
		return intervalDSExpression;
	
	}
	

}
