package com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers;

import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.IDENTIFIER;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.INTEGER;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.LEFT_PAREN;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.MINUS;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.PLUS;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.REAL;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.RIGHT_PAREN;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.STRING;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;

import com.bonc.xcloud.sp_procedure.frontend.EofToken;
import com.bonc.xcloud.sp_procedure.frontend.Lexer;
import com.bonc.xcloud.sp_procedure.frontend.Source;
import com.bonc.xcloud.sp_procedure.frontend.StringSource;
import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.frontend.TokenType;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.ParserErrorCode;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudLexer;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudParse;
import com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType;
import com.bonc.xcloud.sp_procedure.message.MessageHandler;

public class FactorExpressionParser extends StatementParser{
     private static Logger logger=Logger.getLogger(FactorExpressionParser.class);
	//表达式开始 同步集合
	 static final EnumSet<XcloudTokenType> EXPR_START_SET =
		        EnumSet.of(PLUS, MINUS, IDENTIFIER, INTEGER, REAL, STRING,
		        		XcloudTokenType.NOT, LEFT_PAREN,XcloudTokenType.NULL);
	//右括号 同步集合;
	static final EnumSet<XcloudTokenType> RIGHT_PAREN_START_SET =
									        EnumSet.of(RIGHT_PAREN);
	public FactorExpressionParser(XcloudParse parent) {
		super(parent);
	}
	
	public String parseAsStrting(Token token) throws Exception {

		TokenType tokenType = token.getType();
		String syntaxTree = null;
//		int line=token.getLineNum();
//		int position =token.getPosition();
		switch((XcloudTokenType) tokenType){
			
		
//			case MINUS:{
//				
//				token = nextToken();
//				if(token.getType() == XcloudTokenType.LONG 
//						||token.getType() == XcloudTokenType.INTEGER
//						||token.getType() == XcloudTokenType.REAL
//						||token.getText().equals("9223372036854775808")){
//					syntaxTree = "-"+token.getText();
//					token = nextToken();
//					break;
//				}else{
//					errorHandler.flag(token, ParserErrorCode.UNEXPECTED_TOKEN, this);
//					logger.error(ParserErrorCode.UNEXPECTED_TOKEN.toString());
//					skipToSemicolon();
//					break;
//				}
//				
//			}
			case STRING:{
				String temp=(String) token.getValue();
				syntaxTree="'"+temp+"'";
				token = nextToken();
				break;
			}
			case LONG: 
			case INTEGER:
			case REAL:
			case QUESTION_MARK:
			case SYSDATE:
			case SYSTIMESTAMP:
			case CURRENT_DATE:
			case CURRENT_TIMESTAMP:
			{
				syntaxTree=token.getText();
				token = nextToken();
				break;
			}
			case NULL:{
				syntaxTree = "NULL";
				token = nextToken();
				break;
			}
			
			case INTERVAL: {
				Token peek_token = peekToken();
				if(peek_token.getType() == XcloudTokenType.STRING) {
					Token peek_token2 = peekToken(2); 
						if(peek_token2.getText().toLowerCase().equals("day") ||
								peek_token2.getText().toLowerCase().equals("hour") ||
								peek_token2.getText().toLowerCase().equals("minute") ||
								peek_token2.getText().toLowerCase().equals("second")) {
							IntervalDSParser intervalDSParser = new IntervalDSParser(this);
							syntaxTree = intervalDSParser.parseAsString(token);
							break;
						}
						else if(peek_token2.getText().toLowerCase().equals("year") ||
								peek_token2.getText().toLowerCase().equals("month")) {
							IntervalYMParser intervalYMParser = new IntervalYMParser(this);
							syntaxTree = intervalYMParser.parseAsString(token);
							break;
						}
				}
				
			}
			
			default: {
				
//				if(token.getValue() != null && token.getValue() instanceof ParserErrorCode){
//					//为了弹出词法解析的错误
//					errorHandler.flag(token, (ParserErrorCode)(token.getValue()), this);
//					logger.error(((ParserErrorCode)(token.getValue())).toString());
//					skipToSemicolon();
//					break;
//				}else{
//					errorHandler.flag(token, ParserErrorCode.UNEXPECTED_TOKEN, this);
//					logger.error(ParserErrorCode.UNEXPECTED_TOKEN.toString());
//					skipToSemicolon();
//					break;
//				}
				
				
//				syntaxTree=token.getText();
//				token = nextToken();
				syntaxTree =parseExp(token, ",");
				break;
			
			}
		}
		
		return syntaxTree;
	
	}
	
	
	public String parseExp(Token token,String terminator) throws Exception
	{
		if(token == null) return "";
		
		//没有终结符，按照原factor方式解析一个factor
		if(terminator == null || "".equals(terminator)){
			return parseAsStrting(token);
		}
		
		int startLine = token.getLineNum();
		int startPosition = token.getPosition();
		
		int bracketCount = 0; //括号的数量
		
		while(!(token instanceof EofToken)){
			String txt = token.getText();
			
			if("(".equals(txt)){
				bracketCount ++;
			}
			
			if(")".equals(txt)){
				bracketCount --;
				//若右括号多出现了一次，则认为已经到达表达式结尾
				if(bracketCount < 0) break;
			}
			
			//出现终止符号
			if(terminator.equals(txt)){
				//若括号次数正好为成对出现，则认为已经到达表达式结尾
				if(bracketCount == 0) break;
			}
			token = nextToken();
		}
		
		if(token instanceof EofToken){
			errorHandler.flag(token, ParserErrorCode.INVALID_STATEMENT, this);
			logger.error(ParserErrorCode.INVALID_STATEMENT.toString());
			skipToSemicolon();
			return null;
		}
		
		int endLine = token.getLineNum();
		int endPosition = token.getPosition();
		
		//截取字符串，并trim返回
		String str = this.lexer.getSource().getOriginalStr(
				startLine, startPosition, endLine, endPosition-1);
		
		return str.trim();
	}
	
	
	public static void main(String[] args) throws Exception{
		
		String sourStr = "1+abc(abc1,abc2(abcd,date 'afdf)efe')    ))";
		Source source = Source.newInstance(Source.stringSource, sourStr, new MessageHandler());
		Lexer lexer = new XcloudLexer(source);
		XcloudParse xp = new XcloudParse(lexer);
		xp.initialize();
		FactorExpressionParser fp = new FactorExpressionParser(xp);
		Token token = lexer.nextToken();
		System.out.print(fp.parseExp(token, ","));
	}
	
	
	
}
