package com.bonc.xcloud.sp_procedure.frontend.xcloud;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;

import com.bonc.xcloud.sp_procedure.frontend.TokenType;

/**
 * 行云Token类型
 */
public enum XcloudTokenType implements TokenType{
	
	//保留字
	AND, ARRAY, BEGIN, CASE, CONST, DELETE, DIV, DO, DOWNTO, ELSE,ELSIF, END,ENDIF,EXCEPTION, EXEC, EXECUTE, EXIT,CURRENT ,OVER,NOWAIT,WAIT,ADD,COLUMN,LINK,IDENTIFIED,ORACLE,DB2,MYSQL,
    FILE, FOR, FROM, FUNCTION, GOTO, IF, IMMEDIATE, IN, SELECT ,INSERT, INTO, LABEL, LOOP, MOD, NIL, NOT,UNBOUNDED ,PRECEDING,SKIP,LOCKED,DROP,TAG,DATABASE,MINMAX,SECTION,
    OF, OR, OUT, PACKED, PROCEDURE,PACKAGE,BODY, PROGRAM, RECORD, REPEAT, REVERSE, SET, LIKE,IS,BETWEEN,DISTINCT,UNIQUE,ALL,CONNECT,START,ROW,ALTER,MODIFY,RENAME,PUBLIC,GRANT,ANY,SOME,
    GROUP,BY,HAVING,ORDER,LIMIT,MODEL,THEN, TO, TYPE, UNTIL,TRUNCATE, UPDATE, USING, VALUE, VALUES, VAR, WHEN, WHERE, WHILE, WITH,NULL,SYSDATE,CURRENT_DATE,FOLLOWING,VIEW,INDEX,
    EXPORT,OBJECT,PRIVILEGES,ATTRIBUTE,LOCATION,EXECUTOR,MERGE,MATCHED,COMMIT,OVERWRITE,NOLOGGING,SQLCODE,SQLERRM,PUT_LINE,DBMS_OUTPUT,NEXTVAL,REF,USER,RAISE,
    
    ENGINE,INNER,JOIN,CROSS,NATURAL,PARTITION,FULL,LEFT,RIGHT,ON,OUTER,ONLY,SUBPARTITION,SAMPLE,KEEP,IGNORE,REFERENCE,RULES,UNION,INTERSECT,CASCADE,RESTRICT,REVOKE,EXISTS,NOCYCLE,INTERVAL,SYSTIMESTAMP,CURRENT_TIMESTAMP,LOCALTIMESTAMP,

    PRIMARY,KEY,COMMENT,PARTITIONED,SLICED,SLICES,ROWS,RANGE,DECLARE,VARIABLE,CREATE,REPLACE,DEFAULT,RETURN,TABLE,SIBLINGS,ROLLUP,CUBE,GROUPING,SETS,ASC,DESC,NULLS,FIRST,LAST,SEPARATOR,QUOTED,UNQUOTED,DELIMITER,ESCAPE,AS,ENCODE,CLIENT,
    GENERATED,ALWAYS,CONSTRAINT,ROCKSDB,PARQUET,LINEFEED,UPSERT,
    //游标
    CURSOR,OPEN,FETCH,CLOSE,
    //隐式游标
    SQL,NOTFOUND,FOUND,ROWCOUNT,ISOPEN,
    ROWTYPE,
    //分层查询中的伪列
    CONNECT_BY_ISCYCLE,CONNECT_BY_ISLEAF,LEVEL,
    //分层查询中的一元操作符PRIOR,CONNECT_BY_ROOT
    PRIOR,CONNECT_BY_ROOT,

	//特殊符号 
    PLUS("+"), MINUS("-"), STAR("*"),DOUBLE_STAR("**"), SLASH("/"), COLON_EQUALS(":="),
    DOT("."), COMMA(","), SEMICOLON(";"), COLON(":"), QUOTE("'"), EXCLAMATION_POINTS("!"),
    EQUALS("="), NOT_EQUALS("<>"), NOT_EQUALS1("!="),NOT_EQUALS2("^="), WAVE_LINE("~"),
    NOT_EQUALS3("~="), LESS_THAN("<"), LESS_EQUALS("<="),GREATER_EQUALS(">="),
    GREATER_THAN(">"), LEFT_PAREN("("), RIGHT_PAREN(")"),LEFT_BRACKET("["), DOUBLE_VERTICAL_LINE("||"),
    VERTICAL_LINE("|"),RIGHT_BRACKET("]"), LEFT_BRACE("{"), RIGHT_BRACE("}"),AT("@"),
    UP_ARROW("^"), DOT_DOT(".."),QUESTION_MARK("?"),
    PERCENT("%"),
    
	
    IDENTIFIER, INTEGER, REAL, LONG,STRING,DOUBLEQUOTE,
    ERROR, END_OF_FILE;
	
	//第一个保留字序号
	private static final int FIRST_RESERVED_INDEX = AND.ordinal();
	//最后一个保留字序号
	private static final int LAST_RESERVED_INDEX  = CONNECT_BY_ROOT.ordinal();
	
	//第一个特殊字符序号
	private static final int FIRST_SPECIAL_INDEX = PLUS.ordinal();
	private static final int LAST_SPECIAL_INDEX  = PERCENT.ordinal();
	
	private String text;  // token text(小写)
	
	XcloudTokenType() {
		
		this.text = this.toString().toLowerCase();
		
	}
    
	XcloudTokenType(String text) {
		
		this.text = text;
		
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}
   
	//保留字字符集合(小写)
	public static HashSet<String> RESERVED_WORDS = new HashSet<String>();
	
	static {
		XcloudTokenType values[] = XcloudTokenType.values();
		for(int i=FIRST_RESERVED_INDEX;i<=LAST_RESERVED_INDEX;i++){
			RESERVED_WORDS.add(values[i].getText().toLowerCase());
		}
	}
	
	//特殊符号字符对应特殊符号的hashtable集合
	public static Hashtable<String,XcloudTokenType> SPECIAL_SYMBOLS = 
		new Hashtable<String,XcloudTokenType>();
	static {
		XcloudTokenType values[] = XcloudTokenType.values();
		for(int i = FIRST_SPECIAL_INDEX;i<=LAST_SPECIAL_INDEX;i++){
			SPECIAL_SYMBOLS.put(values[i].getText(), values[i]);
		}
	}
	
	//关键字表达式map,包括类似replace函数，sysdate，null表达式等情况
	public static Map<String,XcloudTokenType> RESERVED_EXP_MAP = 
			new HashMap<String,XcloudTokenType>();
	
	static {
		RESERVED_EXP_MAP.put(XcloudTokenType.NOT.getText().toLowerCase(), XcloudTokenType.NOT);
		RESERVED_EXP_MAP.put(XcloudTokenType.REPLACE.getText().toLowerCase(), XcloudTokenType.REPLACE);
		RESERVED_EXP_MAP.put(XcloudTokenType.RIGHT.getText().toLowerCase(), XcloudTokenType.RIGHT);
		RESERVED_EXP_MAP.put(XcloudTokenType.LEFT.getText().toLowerCase(), XcloudTokenType.LEFT);
		RESERVED_EXP_MAP.put(XcloudTokenType.MOD.getText().toLowerCase(), XcloudTokenType.MOD);
		RESERVED_EXP_MAP.put(XcloudTokenType.NULL.getText().toLowerCase(), XcloudTokenType.NULL);
		RESERVED_EXP_MAP.put(XcloudTokenType.SYSDATE.getText().toLowerCase(), XcloudTokenType.SYSDATE);
		RESERVED_EXP_MAP.put(XcloudTokenType.CURRENT_DATE.getText().toLowerCase(), XcloudTokenType.CURRENT_DATE);
		RESERVED_EXP_MAP.put(XcloudTokenType.SYSTIMESTAMP.getText().toLowerCase(), XcloudTokenType.SYSTIMESTAMP);
		RESERVED_EXP_MAP.put(XcloudTokenType.CURRENT_TIMESTAMP.getText().toLowerCase(), XcloudTokenType.CURRENT_TIMESTAMP);
		RESERVED_EXP_MAP.put(XcloudTokenType.LOCALTIMESTAMP.getText().toLowerCase(), XcloudTokenType.LOCALTIMESTAMP);
//		RESERVED_EXP_MAP.put(XcloudTokenType.INTERVAL.getText().toLowerCase(), XcloudTokenType.INTERVAL);
		RESERVED_EXP_MAP.put(XcloudTokenType.SQL.getText().toLowerCase(), XcloudTokenType.SQL);
	}

}
