package com.bonc.xcloud.sp_procedure.frontend.xcloud;


import static com.bonc.xcloud.sp_procedure.frontend.xcloud.ParserErrorCode.UNEXPECTED_TOKEN;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.CREATE;
//import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.DECLARE;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.FUNCTION;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.OR;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.PROCEDURE;
import static com.bonc.xcloud.sp_procedure.frontend.xcloud.XcloudTokenType.REPLACE;

import java.util.EnumSet;

import org.apache.log4j.Logger;

//import com.bonc.xcloud.sp_procedure.backend.interpreter.executors.xcloud.TaskNativeTest;
import com.bonc.xcloud.sp_procedure.base.DBConfiguration;
//import com.bonc.xcloud.sp_procedure.dispatch.ProcConfig;
import com.bonc.xcloud.sp_procedure.frontend.EofToken;
import com.bonc.xcloud.sp_procedure.frontend.Lexer;
import com.bonc.xcloud.sp_procedure.frontend.Parser;
import com.bonc.xcloud.sp_procedure.frontend.Source;
import com.bonc.xcloud.sp_procedure.frontend.Token;
//import com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers.ExecutableBlockStatementParser;
//import com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers.FunctionDeclareStatementParser;
//import com.bonc.xcloud.sp_procedure.frontend.xcloud.plparsers.sp_procedureDeclareStatementParser;
import com.bonc.xcloud.sp_procedure.intermediate.SymTabFactory;
//import com.bonc.xcloud.sp_procedure.intermediate.symtabimpl.Predefined;
import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTree;
//import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.SyntaxTreeKeyImpl;
//import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.statement.FunctionDeclareStatement;
//import com.bonc.xcloud.sp_procedure.intermediate.syntax.syntaximpl.statement.sp_procedureDeclareStatement;
//import com.bonc.xcloud.sp_procedure.message.Message;
import com.bonc.xcloud.sp_procedure.message.MessageHandler;
//import com.bonc.xcloud.sp_procedure.message.MessageType;

public class XcloudParse extends Parser{
	private SyntaxTree tree;
	public SyntaxTree getTree() {
		return tree;
	}
	
	//错误处理器
	protected  ErrorHandler errorHandler;
	
	private static Logger logger = Logger.getLogger(XcloudParse.class);
	
	protected DBConfiguration dbConfiguration; //访问行云数据库连接

	protected static String createOperation = "CREATE";
	protected static String createOrReplaceOperation = "CREATE_OR_REPLACE";
	
//	private SymTabEntry routineId;  // name of the routine being parsed

	public XcloudParse(Lexer lexer) {
		super(lexer);
	}

	public XcloudParse(XcloudParse parent){
		
		super(parent.getLexer());
		this.dbConfiguration = parent.dbConfiguration;
		this.symTabStack = parent.symTabStack;
		this.messageHandler = parent.messageHandler;
		this.errorHandler = parent.errorHandler;
	}
	
//	public SymTabEntry getRoutineId()
//	{
//        return routineId;
//	}

	@Override
	public void parse() throws Exception {
//		
//		long start = System.currentTimeMillis();
//		
//		Predefined.initialize(symTabStack);
//		
//		try{
//			Token token = nextToken();
//			Object o = this.lexer;
//			
//			
//			//解析块
//			if(token.getType() == CREATE){
//				
//				//解析create开头
//				String operation = "";
////				String opration = parserCreateHeader(token);
//				operation = createOperation;
//				token = nextToken();
//				if(token.getType() == OR){
//					token = nextToken();
//					if(token.getType() == REPLACE){
//						operation = createOrReplaceOperation;
//						token = nextToken();
//					}else{
//						errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
//						logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
//						return ;
//					}
//				}else if(token.getType() !=PROCEDURE && token.getType() !=FUNCTION ){
//					errorHandler.flag(token, ParserErrorCode.MISSING_KEYWORD, this);
//					logger.error(ParserErrorCode.MISSING_KEYWORD.toString());
//					return ;
//				}
//				token = currentToken();
//				
//				if(token.getType() == PROCEDURE){
//					ProcedureDeclareStatementParser procedureParser = new ProcedureDeclareStatementParser(this);
//					ProcedureDeclareStatement procedure =  (ProcedureDeclareStatement)procedureParser.parse(token);
//					
//					//设置procedure的操作方式
//					if(procedure != null) 
//						procedure.setAttribute(SyntaxTreeKeyImpl.PROCDURE_OPERATION, operation);
//					tree =  procedure;
//				}else if(token.getType() == FUNCTION){
//					FunctionDeclareStatementParser functionParser = new FunctionDeclareStatementParser(this);
//					FunctionDeclareStatement function = (FunctionDeclareStatement) functionParser.parse(token);
//					
//					//设置procedure的操作方式
//					if(function != null) 
//						function.setAttribute(SyntaxTreeKeyImpl.PROCDURE_OPERATION, operation);
//					tree = function;
//				}else{
//					errorHandler.flag(token, ParserErrorCode.UNIMPLEMENTED, this);
//					logger.error(ParserErrorCode.UNIMPLEMENTED.toString());
//					return ;
//				}
//
//	            
//			}else if(token.getType() == DECLARE && TaskNativeTest.isNativeTest){
//				
//				ExecutableBlockStatementParser executeParser = new ExecutableBlockStatementParser(this);
//				
//				tree = executeParser.parse(token);
//				
//			}
//
//			else{
//				token = currentToken();
//				errorHandler.flag(token, ParserErrorCode.INVALID_SQL_STATEMENT, this);
//				logger.error(ParserErrorCode.INVALID_SQL_STATEMENT.toString());
//			}
//            
//		    token = currentToken();
//		    
//		    if(token.getType()!= XcloudTokenType.SEMICOLON){
//		    	errorHandler.flag(token, ParserErrorCode.MISSING_SEMICOLON, this);
//				skipToSemicolon();
//				logger.error(ParserErrorCode. MISSING_SEMICOLON.toString());
//		    }else{
//		    	token = nextToken();
//		    	if(!(token instanceof EofToken)){
//		    		errorHandler.flag(token, ParserErrorCode.OTHER_WORDS_WILL_BE_IGNORED, this);
//					skipToSemicolon();
//					logger.error(ParserErrorCode. OTHER_WORDS_WILL_BE_IGNORED.toString());
//		    	}
//		    }
//			
//		}catch(java.io.IOException ex){//IO异常,退出编译
//			errorHandler.abortTranslation(ParserErrorCode.IO_ERROR, this);
//		}catch(Exception e){
//			Token token = currentToken();
//			ParserErrorCode code = ParserErrorCode.PARSERERROR;
//			if(e.getMessage()!= null && !e.getMessage().equals(""))code.setMessage(e.getMessage());
//			errorHandler.flag(token, code , this);
//			logger.error(ParserErrorCode.PARSERERROR.toString());
//			logger.error(e.getMessage(),e);
//		}
//		
//		float elapsedTime = (System.currentTimeMillis() - start)/1000f;
//		
//		//发消息给消息监听器
//		sendMessage(new Message(MessageType.PARSER_SUMMARY,
//                new Number[] {currentToken().getLineNum(),
//                              getErrorCount(),
//                              elapsedTime}));
//		
	}
	
	
	public void initialize(){
		
		symTabStack = SymTabFactory.createSymTabStack();
		messageHandler = new MessageHandler();
		errorHandler = new ErrorHandler(); 
	}
	
	 /**
     * 同步解析器,解析到集合中包含的单词为止
     * (修改为同步到下一个分号)
     */
    public Token synchronize(EnumSet syncSet)
        throws Exception
    {
        Token token = currentToken();

        if (!syncSet.contains(token.getType())) {

            //不包含在集合中报错
            errorHandler.flag(token, UNEXPECTED_TOKEN, this);

            //循环解析到集合中包含的单词为止
            do {
                token = nextToken();
            } while (!(token instanceof EofToken) &&
                     !syncSet.contains(token.getType()));
       }

       return token;
    }

    /**
     * 跳到下一个分号
     * @throws Exception
     */
    public void skipToSemicolon() 
    	throws Exception
    {
    	Token token = currentToken();
    	
    	//空或文件结尾结束
    	if(token == null || token instanceof EofToken) return;
    	
    	while(!token.getType().equals(XcloudTokenType.SEMICOLON)&&!(token instanceof EofToken)){
    		
    		token = nextToken();
    	}
    	
    }
    
    /**
     * 检查子语句是否报错并跳到分号
     */
    public boolean isSubStmtSkiped(SyntaxTree tree){
    	
    	//syntaxtree为null,且当前token为分号或者文件末尾，认为子语句已经报错
    	if(tree == null){
    		Token token = currentToken();
    		if(token == null) return true;
    		if(token instanceof EofToken) return true;
    		if(token.getType() == XcloudTokenType.SEMICOLON) return true;
    	}
    	
    	return false;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    /**
	 * 解析语句开头,返回程序的操作信息
	 * @param token
	 * @return
	 */
	private String parserCreateHeader(Token token)throws Exception{
		
		String operation = "";
		
		//create,继续读取or replace
		if(token.getType() == CREATE){
			operation = createOperation;
			token = nextToken();
//			token = synchronize(PROCEDURE_OPERATION_SET);
			if(token.getType() == OR){
				token = nextToken();
//				token = synchronize(PROCEDURE_OPERATION_SET);
				if(token.getType() == REPLACE){
					operation = createOrReplaceOperation;
					token = nextToken();
				}else{
					skipToSemicolon();
					errorHandler.flag(token, ParserErrorCode.MISSING_OPERATION, this);
					logger.error(ParserErrorCode.MISSING_OPERATION.toString());
				}
			}else if(token.getType() !=PROCEDURE || token.getType() !=FUNCTION ){
				skipToSemicolon();
				errorHandler.flag(token, ParserErrorCode.MISSING_OPERATION, this);
				logger.error(ParserErrorCode.MISSING_OPERATION.toString());
				//token = nextToken();
			}
			
		}
		
		return operation;
	} 

	public DBConfiguration getDbConfiguration() {
		return dbConfiguration;
	}

	public void setDbConfiguration(DBConfiguration dbConfiguration) {
		this.dbConfiguration = dbConfiguration;
	}

	public ErrorHandler getErrorHandler() {
		return errorHandler;
	}

	public void setErrorHandler(ErrorHandler errorHandler) {
		this.errorHandler = errorHandler;
	}

	@Override
	public int getErrorCount() {
		// TODO 自动生成的方法存根
		return errorHandler.getErrorCount();
	}

//	public void initAdapter(boolean isPool, Integer status, String dbConfigurationString)throws Exception{
//		
//		ObjectMapper mapper=new ObjectMapper();
//   		mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
//   		DBConfiguration dbConfiguration = mapper.readValue(dbConfigurationString, DBConfiguration.class);
//		
//		this.dbConfiguration = new DBConfiguration();
//	}
	
	
	
	
	/**
	 * 初始化parser并解析
	 * @param sourceType 源文件类型
	 * @param sourceStr 源文件路径或内容
	 */
	public static SyntaxTree initializeAndParse(String sourceType,String sourceStr,XcloudParse parent)throws Exception{
		
		Source source = Source.newInstance( //message沿用parent
				sourceType, sourceStr,parent.getLexer().getSource().getMessageHandler());
		
		Lexer lexer = new XcloudLexer(source);
		
		XcloudParse parser = new XcloudParse(lexer);
		
		parser.setSymTabStack(SymTabFactory.createSymTabStack());//符号表要新建
		parser.setDbConfiguration(parent.dbConfiguration);//dbconfig沿用parent
		parser.setMessageHandler(parent.getMessageHandler());//messagehandler沿用parent
		parser.setErrorHandler(parent.getErrorHandler());//errorhandler沿用parent
		parser.parse();
		
		return parser.getTree();
	}
	
	
	
	
	

}
