package com.bonc.xcloud.sp_procedure.frontend.xcloud;

import com.bonc.xcloud.sp_procedure.frontend.EofToken;
import com.bonc.xcloud.sp_procedure.frontend.Lexer;
import com.bonc.xcloud.sp_procedure.frontend.Source;
import com.bonc.xcloud.sp_procedure.frontend.Token;
import com.bonc.xcloud.sp_procedure.message.MessageHandler;

public class XcloudLexer extends Lexer{

	public XcloudLexer(Source source) {
		super(source);
		// TODO 自动生成的构造函数存根
	}
	
	public XcloudLexer(String sourceText) throws Exception {
		 super(sourceText);
	}
	

	@Override
	public Token extractToken() throws Exception {
		
		//跳过空白符
		skipWhiteSpace();
		
		Token token;
		char currentChar = currentChar();
		
		if(currentChar == source.EOF){// 文件末尾
			token = new EofToken(source);
		}
		else if(Character.isLetter(currentChar) || currentChar == '_'){//单词Token,包括标识符和保留字
			token = new WordToken(source);
		}
		else if(Character.isDigit(currentChar)){//数字Token
			token = new NumberToken(source);
		}
		else if(currentChar == '\''){// 字符串Token
			token = new StringToken(source); 
		}
		else if(XcloudTokenType.SPECIAL_SYMBOLS// 特殊符号Token,如+,-
				.containsKey(Character.toString(currentChar))){
			token = new SpecialSymbolToken(source);
		}
		else if(currentChar =='"'){//新增""Token
			token =new DoubleQuoteToken(source);
		}
		else {// 错误的Token
			token = new ErrorToken(source, ParserErrorCode.INVALID_CHARACTER,
					Character.toString(currentChar));
			nextChar();
		}
		
		return token;
		
	}
	
	/**
	 * 跳过空白字符,注释部分还未实现
	 */
	private void skipWhiteSpace() throws Exception {
		
		char currentChar = currentChar();
		
		while(Character.isWhitespace(currentChar) || currentChar=='/' || currentChar == '-'){
			
			//可能是单行注释
			if(currentChar == '-'){
				char nextFirstChar = source.peekChar(1);
				//单行注释
				if(nextFirstChar == '-'){
					while(true){
						currentChar = nextChar();
						if(currentChar == Source.EOL){
							currentChar = nextChar();
							break;
						}
					}
				}else{
					break;
				}
			}
			//可能是多行注释
			else if(currentChar=='/'){
				
				char nextFirstChar = source.peekChar(1);
				
				if(nextFirstChar == '*'){
					
					char nextSecondChar = source.peekChar(2);
					
					//排除hint的可能,为多行注释
					if(nextSecondChar != '+'){
						//跳转到*后面的字母
						nextChar();
						while(true){
							currentChar = nextChar();
							if(currentChar == Source.EOF || (currentChar == '*'&&(source.peekChar(1)=='/'))){
								currentChar = nextChar();
								currentChar = nextChar();
								break;
							}
						}
					}else{
						break;
					}
				}else{
					break;
				}
			}else{
				currentChar = nextChar();
			}
		}
			
	}
	
	
	
	public static void main(String[] args) {
		char a = '\n';
		
		String ab = "abcdef";
		System.out.println(ab.charAt(0));
		System.out.println(Character.isWhitespace(a));
	}
	
	
	
	
	
	
	
	
	
	
	
}
