package com.bonc.xcloud.sp_procedure.frontend.xcloud;

import com.bonc.xcloud.sp_procedure.frontend.Source;

/**
 * 单词Token,包括标识符和保留字,为数字或者字母的组合,且以字母开头
 */
public class WordToken extends XcloudToken{

	public static int id_max_length = 200;
	public WordToken(Source source) throws Exception {
		super(source);
		
	}
	
	@Override
	public void extract() throws Exception {
		StringBuilder textBuffer = new StringBuilder();
		char currentChar = currentChar();
		
		//依次向后读取字符,直到读到不是字母或者数字位置
		while(Character.isLetterOrDigit(currentChar) || currentChar == '_' || currentChar == '$' || currentChar == '#'){
			textBuffer.append(currentChar);
			currentChar = nextChar();
		}
		text = textBuffer.toString();
		
		//判断是否为保留字,如果不是为标识符
		type = (XcloudTokenType.RESERVED_WORDS.contains(text.toLowerCase())
				? XcloudTokenType.valueOf(text.toUpperCase())
						:XcloudTokenType.IDENTIFIER);
		
		//检查命名是否超过最大长度
		if(type.equals(XcloudTokenType.IDENTIFIER)){
			int length = text.length();
			if(length > id_max_length){
				value = ParserErrorCode.BEYOND_NAMED_LENGTH;
				type = XcloudTokenType.ERROR;
			}
		}
	}
 
}
