package com.bonc.xcloud.sp_procedure.frontend.xcloud;


import com.bonc.xcloud.sp_procedure.frontend.Source;

/**
 * 字符串Token(无嵌套),text包含''号,value不包含
 */
public class StringToken extends XcloudToken{

	public static int maxLength = 4000;
	
	public StringToken(Source source) throws Exception {
		super(source);
		 
	}
	
	@Override
	public void extract() throws Exception {
		
		StringBuilder textBuffer = new StringBuilder();
		StringBuilder valueBuffer = new StringBuilder();
		 
		char currentChar = nextChar(); 
		textBuffer.append('\'');
		
		do{
			//处理空白符
			if(Character.isWhitespace(currentChar)){
				currentChar = ' ';
			}
			
			//处理普通字符
			if((currentChar !='\''&&(currentChar != Source.EOF))){
				 textBuffer.append(currentChar);
				 valueBuffer.append(currentChar);
				 currentChar = nextChar();
			}
			
			//处理字符串内含有'的情况   '88);'''->value:88);'  '88);'''''->value:88);''
			if(currentChar == '\''){//处理为'''的情况
				 while ((currentChar == '\'') && (peekChar() == '\'')) {
	                    textBuffer.append("''");
	                    valueBuffer.append("'"); // append single-quote
	                    currentChar = nextChar(); // consume pair of quotes
	                    currentChar = nextChar();
	             }
			}
		}while((currentChar != '\'') && (currentChar != Source.EOF));
		
		if(currentChar == '\''){
			nextChar();
			textBuffer.append('\'');
			type = XcloudTokenType.STRING;
			value = valueBuffer.toString();
		}
		else{
			type = XcloudTokenType.ERROR;
			value = ParserErrorCode.UNEXPECTED_EOF;
		}
		
		text = textBuffer.toString();
		
	}

}
