package com.bonc.xcloud.sp_procedure.frontend.xcloud;

import com.bonc.xcloud.sp_procedure.frontend.Source;

/**
 * 特殊字符Token,如 +,-,*,/,> 等
 */
public class SpecialSymbolToken extends XcloudToken{

	public SpecialSymbolToken(Source source) throws Exception {
		super(source);
		
	}
	 
	@Override
	public void extract() throws Exception {
		
		char currentChar = currentChar();
		text = Character.toString(currentChar);
		type = null;
		
		switch (currentChar) {
		
			// 单个字符的特殊符号
	        case '+':  case '-':  case '/':  case ',':
	        case ';':  case '\'': case '=':  case '(': 
	        case ')':  case '[':  case ']':  case '{': 
	        case '}': case '@':case '?':{
	            nextChar();  
	            break;
	        }
	        
	        case '|':{

	        	currentChar = nextChar(); 
	        	if(currentChar == '|'){
	        		text += currentChar;
	        		nextChar();
	        	}
	        	  break;
	        
	        }
	        
	        case '~':{

	        	currentChar = nextChar(); 
	        	if(currentChar == '='){
	        		text += currentChar;
	        		nextChar();
	        	}
	        	  break;
	        
	        }
	        
	        case '^':{

	        	currentChar = nextChar(); 
	        	if(currentChar == '='){
	        		text += currentChar;
	        		nextChar();
	        	}
	        	  break;
	        
	        }
	        
	        case '!':{

	        	currentChar = nextChar(); 
	        	if(currentChar == '='){
	        		text += currentChar;
	        		nextChar();
	        	}
	        	  break;
	        
	        }
	        
	        case '*':{

	        	currentChar = nextChar(); 
	        	if(currentChar == '*'){
	        		text += currentChar;
	        		nextChar();
	        	}
	        	  break;
	        
	        }
	        //: 或 :=
	        case ':':{
	        	currentChar = nextChar(); 
	        	if(currentChar == '='){
	        		text += currentChar;
	        		nextChar();
	        	}
	        	break;

	        }
	        
	        // < 或 <= 或 <>
            case '<': {
                currentChar = nextChar();  // consume '<';

                if (currentChar == '=') {
                    text += currentChar;
                    nextChar();  // consume '='
                }
                else if (currentChar == '>') {
                    text += currentChar;
                    nextChar();  // consume '>'
                }

                break;
            }
            
            // > 或 >=
            case '>': {
                currentChar = nextChar();  // consume '>';

                if (currentChar == '=') {
                    text += currentChar;
                    nextChar();  // consume '='
                }

                break;
            }
            
            // . 或 ..
            case '.': {
                currentChar = nextChar();  // consume '.';

                if (currentChar == '.') {
                    text += currentChar;
                    nextChar();  // consume '.'
                }

                break;
            }
		
            default: {
                nextChar();  // consume bad character
                type = XcloudTokenType.ERROR;
                value = ParserErrorCode.INVALID_CHARACTER;
            }
		}
		
		if (type == null) {
            type = XcloudTokenType.SPECIAL_SYMBOLS.get(text);
        }
		
	}
	
	
	
	

}
