package com.bonc.xcloud.sp_procedure.frontend.xcloud;

import com.bonc.xcloud.sp_procedure.frontend.Source;

/**
 * 数字Token,为无符号数字
 * int     : -2147483648 ~ 2147483647
 * long    : -9223372036854775808 ~ 9223372036854775807
 * double  :  1.7e-308 < |x| < 1.7e+308  (精度15位)
 * 但是目前没有负数,因此只对正数的最大值有判断
 */
public class NumberToken extends XcloudToken{
	
	public static Integer int_max = 2147483647;
	public static Integer int_min = -2147483648;//限定小1
	public static Long long_max = 9223372036854775807L;
	public static Long long_min = -9223372036854775808L;//限定小1
	public static Double double_max = 1.7e+308;//绝对值范围
	public static Double double_min = 1.7e-308;//绝对值范围
	public static int double_precision = 15; //未限定

	public NumberToken(Source source) throws Exception {
		super(source);
		   
	}
	
	@Override
	public void extract() throws Exception {
		
		StringBuilder textBuffer = new StringBuilder();
		extractNumber(textBuffer);
		text = textBuffer.toString();
		
	}
	
	protected void extractNumber(StringBuilder textBuffer)
			throws Exception
	{
		//首先作为string把所有数字都解析出来,然后利用java的数字的parse方法解析
		/**
		 * 读入所有为数字部分
		 */
		char currentChar = currentChar();
		
		//先解析小数点前的整数部分
		 String unsignedPart1 = parseUnsignedDigits();
		 textBuffer.append(unsignedPart1);
		 
		 boolean isReal = false;
		 
		 currentChar = currentChar();
		 //是否存在小数点
		 if(currentChar == '.'){
			 
			 char peekchar = peekChar();
			 if(peekchar != '.'){
				 isReal = true;
				 textBuffer.append(currentChar);
				 currentChar = nextChar();
				 String unsignedPart2 = parseUnsignedDigits();
				 textBuffer.append(unsignedPart2);
			 }
		 }
		 currentChar = currentChar();
		 
		 //是否存在指数部分
		 if(currentChar == 'e' || currentChar == 'E'){
			 isReal = true;
			 textBuffer.append(currentChar);
			 //指数部分可以为负数
			 currentChar = nextChar();
			 
			 //java解析1.2e报错,需要补0,即1.2e0
			 if(!Character.isDigit(currentChar)){
				 
				 if(currentChar == '+' || currentChar == '-'){
					 char peekchar = peekChar();
					 if(Character.isDigit(peekchar)){
						 textBuffer.append(currentChar);
						 currentChar = nextChar();
						 String unsignedPart3 = parseUnsignedDigits();
						 textBuffer.append(unsignedPart3);
					 }else{
						 textBuffer.append(0);
					 }
				 }else{
					 textBuffer.append(0);
				 }
				
			 }else{
				 String unsignedPart3 = parseUnsignedDigits();
				 textBuffer.append(unsignedPart3);
			 }
		 }
		 
		 /**
		  * 将字符串转换成数字
		  */
		 if(isReal){
			 String strPart = textBuffer.toString();
			 
			 try {
				value = Double.parseDouble(strPart);
				Double absValue = Math.abs((Double)value);
				if(absValue >= double_min && absValue <= double_max || absValue == 0){
					type = XcloudTokenType.REAL;
				}else{
					value = ParserErrorCode.RANGE_REAL;
					type = XcloudTokenType.ERROR;
				}
			} catch (NumberFormatException e) {
				value = ParserErrorCode.RANGE_REAL;
				type = XcloudTokenType.ERROR;
			}
		 }else{
			//可能为正数,可能为long
			String strPart = textBuffer.toString();
			try {
				value = Integer.parseInt(strPart);
				type = XcloudTokenType.INTEGER;
			} catch (NumberFormatException e) {
				try{
					value = Long.parseLong(strPart);
					type = XcloudTokenType.LONG;
				}catch (NumberFormatException e1){
					value = ParserErrorCode.RANGE_LONG;
					type = XcloudTokenType.ERROR;
				}
			}
		 }
	}
	
	/**
	 * 解析无符号数字部分
	 * @return
	 * @throws Exception
	 */
	private String parseUnsignedDigits()throws Exception{
		
		StringBuilder textBuffer = new StringBuilder();
		char currentChar = currentChar();
		while(Character.isDigit(currentChar)){
			 textBuffer.append(currentChar);
			 currentChar = nextChar();
		 }
		return textBuffer.toString();
	}
	
	
	protected void extractNumber1(StringBuilder textBuffer)
			throws Exception
	{
		String wholeDigits = null;    // 小数点前的数字
		String fractionDigits = null; // 小数点后的数字
		String exponentDigits = null; // 指数部分数字
		char exponentSign = '+' ;      //指数符号 '-'或'-',如31415.926e-4
		boolean sawDotDot = false;    //是否为 ..(表示数字范围) token
		char currentChar;             //当前字符
		
		//提取小数点前的整数部分(不包括正负数的符号)
		type = XcloudTokenType.INTEGER;
		wholeDigits = unsignedIntegerDigits(textBuffer);
		if(type == XcloudTokenType.ERROR){
			return;
		}
		
		currentChar = currentChar();
		
		//判断是否为..,若不是为real类型
		if(currentChar == '.'){
			if(peekChar()=='.'){
				sawDotDot = true;
			}
			else{
				type = XcloudTokenType.REAL;
				textBuffer.append(currentChar);
				currentChar = nextChar();
				//抽取小数点后的数字
				fractionDigits = unsignedIntegerDigits(textBuffer);
				if(type == XcloudTokenType.ERROR){
					return;
				}
			}
		}
		
		currentChar = currentChar();
		//判断是否有指数部分
		if(!sawDotDot && ((currentChar == 'E')||(currentChar == 'e'))){
			type = XcloudTokenType.REAL;
			textBuffer.append(currentChar);
			currentChar = nextChar();
			
			//指数部分是否有符号,'+'或者'-'
			if((currentChar == '+')||(currentChar == '-')){
				textBuffer.append(currentChar);
				exponentSign = currentChar;
				currentChar = nextChar();
			}
			
			//抽取指数部分的数字
			 exponentDigits = unsignedIntegerDigits(textBuffer);
		}
		
		//计算整数值
		if(type == XcloudTokenType.INTEGER){
			int integerValue = computeIntegerValue(wholeDigits);
			
			if(type != XcloudTokenType.ERROR){
				value = new Integer(integerValue);
			}else{
				if(value == ParserErrorCode.RANGE_INTEGER){
					type = XcloudTokenType.LONG;
					long longValue = computeLongValue(wholeDigits);
					
					if(type != XcloudTokenType.ERROR){
						value = new Long(longValue);
					}
//					currentChar=nextChar();
				}
			}
			
		}
		//计算实数的数值
		else if(type == XcloudTokenType.REAL){
			 float floatValue = computeFloatValue(wholeDigits, fractionDigits,
                     exponentDigits, exponentSign);
			 
			 if(type != XcloudTokenType.ERROR){
				 value = new Float(floatValue);
			 }
		}
	}
	
	/**
	 * 提取无符号整数
	 */
	private String unsignedIntegerDigits(StringBuilder textBuffer)
		throws Exception
	{
		 char currentChar = currentChar();
		 
		 if(!Character.isDigit(currentChar)){
			 type = XcloudTokenType.ERROR;
			 value = ParserErrorCode.INVALID_NUMBER;
			 return null;
		 }
		 
		 StringBuilder digits = new StringBuilder();
		 //循环提取,直到不是数字为止
		 while(Character.isDigit(currentChar)){
			 textBuffer.append(currentChar);
			 digits.append(currentChar);
			 currentChar = nextChar();
		 }
		 
		 return digits.toString();
	}
	
	/**
	 * 计算整数的值,并检查出超出整数常量最大值的错误
	 */
	private int computeIntegerValue(String digits){
		
		if(digits == null){
			return 0;
		}
		
		int integerValue = 0;
		int prevValue = -1;
		int index = 0;
		
		while((index < digits.length()) && (integerValue >= prevValue)){
			prevValue = integerValue;
			integerValue = 10*integerValue + 
					Character.getNumericValue(digits.charAt(index++));
		}
		
		//未超出最大值
		if(integerValue >= prevValue){
			return integerValue;
		}
		//超出最大值
		else{
			type = XcloudTokenType.ERROR;
			value = ParserErrorCode.RANGE_INTEGER;
			return 0;
		}
	}
	
	/**
	 * 计算Long的值,并检查出超出Long常量最大值的错误
	 */
	private long computeLongValue(String digits){
		
		if(digits == null){
			return 0;
		}
		
		long longValue = 0;
		long prevValue = -1;
		int index = 0;
		
		while((index < digits.length()) && (longValue >= prevValue)){
			prevValue = longValue;
			longValue = 10*longValue + 
					Character.getNumericValue(digits.charAt(index++));
		}
		
		//未超出最大值
		if(longValue >= prevValue){
			return longValue;
		}
		//超出最大值
		else{
			type = XcloudTokenType.ERROR;
			value = ParserErrorCode.RANGE_LONG;
			return 0;
		}
	}
	
	
	/**
	 * 计算实数的Float型数值
	 * @param wholeDigits      小数点前的数字
	 * @param fractionDigits   小数点后的数字
	 * @param exponentDigits   指数部分数字
	 * @param exponentSign     指数符号 '-'或'-',如31415.926e-4
	 * @return
	 */
	private float computeFloatValue(String wholeDigits, String fractionDigits,
             String exponentDigits, char exponentSign)
	{
		double floatValue = 0.0;
		//指数部分的值
		int exponentValue = computeIntegerValue(exponentDigits);
		String digits = wholeDigits;
		
		if(exponentSign == '-'){
			exponentValue = -exponentValue;
		}
		
		//后移小数点,把'E'之前的部分都化为整数,如314e-2
		if(fractionDigits != null){
			exponentValue -= fractionDigits.length();
            digits += fractionDigits;
		}
		//检查实数是否超出边界,整数部分位数与指数的大小之和不能超过MAX_EXPONENT
		if(Math.abs(exponentValue + digits.length())> 11){
			type = XcloudTokenType.ERROR;
			value = ParserErrorCode.RANGE_REAL;
			return 0.0f;
		}
		
		//计算变换后的整数部分的值,如 先计算314,再计算乘以10的-2次幂
		int index = 0;
		while (index < digits.length()){
			 floatValue = 10*floatValue +
                     Character.getNumericValue(digits.charAt(index++));
		}
		
		//计算加上指数后的值,如乘以10的-2次幂
		if(exponentValue != 0){
			floatValue *= Math.pow(10,exponentValue);
		}
		
		return (float) floatValue;
		
	}
	
	
	
	public static void main(String[] args) {
		Integer int_min = Integer.MIN_VALUE;
		Integer int_max = Integer.MAX_VALUE;
		Long long_min = Long.MIN_VALUE;
		Long long_max = Long.MAX_VALUE;
		Double double_min = Double.MIN_VALUE;
		Double double_max = Double.MAX_VALUE;
		System.out.println("--------------Java 边界值 ----------------");
		System.out.println("int min == " +int_min);
		System.out.println("int max == " +int_max);
		System.out.println("long min == " +long_min);
		System.out.println("long max == " +long_max);
		System.out.println("double min == " +double_min);
		System.out.println("double max == " +double_max);
		
		Long long1 = Long.parseLong("");
		Integer int1 = Integer.parseInt("92233");
		Double double1 = Double.parseDouble("1.e10");
		System.out.println(long1);
		System.out.println(int1);
		System.out.println(double1);
		
	}
	
	
	
	
	
}
